/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters required to set up a target for your pipe.
 * </p>
 * <p>
 * For more information about pipe target parameters, including how to use dynamic path parameters, see <a
 * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-event-target.html">Target parameters</a> in
 * the <i>Amazon EventBridge User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipeTargetParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<PipeTargetParameters.Builder, PipeTargetParameters> {
    private static final SdkField<String> INPUT_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputTemplate").getter(getter(PipeTargetParameters::inputTemplate))
            .setter(setter(Builder::inputTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputTemplate").build()).build();

    private static final SdkField<PipeTargetLambdaFunctionParameters> LAMBDA_FUNCTION_PARAMETERS_FIELD = SdkField
            .<PipeTargetLambdaFunctionParameters> builder(MarshallingType.SDK_POJO).memberName("LambdaFunctionParameters")
            .getter(getter(PipeTargetParameters::lambdaFunctionParameters)).setter(setter(Builder::lambdaFunctionParameters))
            .constructor(PipeTargetLambdaFunctionParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaFunctionParameters").build())
            .build();

    private static final SdkField<PipeTargetStateMachineParameters> STEP_FUNCTION_STATE_MACHINE_PARAMETERS_FIELD = SdkField
            .<PipeTargetStateMachineParameters> builder(MarshallingType.SDK_POJO)
            .memberName("StepFunctionStateMachineParameters")
            .getter(getter(PipeTargetParameters::stepFunctionStateMachineParameters))
            .setter(setter(Builder::stepFunctionStateMachineParameters))
            .constructor(PipeTargetStateMachineParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepFunctionStateMachineParameters")
                    .build()).build();

    private static final SdkField<PipeTargetKinesisStreamParameters> KINESIS_STREAM_PARAMETERS_FIELD = SdkField
            .<PipeTargetKinesisStreamParameters> builder(MarshallingType.SDK_POJO).memberName("KinesisStreamParameters")
            .getter(getter(PipeTargetParameters::kinesisStreamParameters)).setter(setter(Builder::kinesisStreamParameters))
            .constructor(PipeTargetKinesisStreamParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisStreamParameters").build())
            .build();

    private static final SdkField<PipeTargetEcsTaskParameters> ECS_TASK_PARAMETERS_FIELD = SdkField
            .<PipeTargetEcsTaskParameters> builder(MarshallingType.SDK_POJO).memberName("EcsTaskParameters")
            .getter(getter(PipeTargetParameters::ecsTaskParameters)).setter(setter(Builder::ecsTaskParameters))
            .constructor(PipeTargetEcsTaskParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EcsTaskParameters").build()).build();

    private static final SdkField<PipeTargetBatchJobParameters> BATCH_JOB_PARAMETERS_FIELD = SdkField
            .<PipeTargetBatchJobParameters> builder(MarshallingType.SDK_POJO).memberName("BatchJobParameters")
            .getter(getter(PipeTargetParameters::batchJobParameters)).setter(setter(Builder::batchJobParameters))
            .constructor(PipeTargetBatchJobParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchJobParameters").build())
            .build();

    private static final SdkField<PipeTargetSqsQueueParameters> SQS_QUEUE_PARAMETERS_FIELD = SdkField
            .<PipeTargetSqsQueueParameters> builder(MarshallingType.SDK_POJO).memberName("SqsQueueParameters")
            .getter(getter(PipeTargetParameters::sqsQueueParameters)).setter(setter(Builder::sqsQueueParameters))
            .constructor(PipeTargetSqsQueueParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqsQueueParameters").build())
            .build();

    private static final SdkField<PipeTargetHttpParameters> HTTP_PARAMETERS_FIELD = SdkField
            .<PipeTargetHttpParameters> builder(MarshallingType.SDK_POJO).memberName("HttpParameters")
            .getter(getter(PipeTargetParameters::httpParameters)).setter(setter(Builder::httpParameters))
            .constructor(PipeTargetHttpParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpParameters").build()).build();

    private static final SdkField<PipeTargetRedshiftDataParameters> REDSHIFT_DATA_PARAMETERS_FIELD = SdkField
            .<PipeTargetRedshiftDataParameters> builder(MarshallingType.SDK_POJO).memberName("RedshiftDataParameters")
            .getter(getter(PipeTargetParameters::redshiftDataParameters)).setter(setter(Builder::redshiftDataParameters))
            .constructor(PipeTargetRedshiftDataParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftDataParameters").build())
            .build();

    private static final SdkField<PipeTargetSageMakerPipelineParameters> SAGE_MAKER_PIPELINE_PARAMETERS_FIELD = SdkField
            .<PipeTargetSageMakerPipelineParameters> builder(MarshallingType.SDK_POJO)
            .memberName("SageMakerPipelineParameters")
            .getter(getter(PipeTargetParameters::sageMakerPipelineParameters))
            .setter(setter(Builder::sageMakerPipelineParameters))
            .constructor(PipeTargetSageMakerPipelineParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SageMakerPipelineParameters")
                    .build()).build();

    private static final SdkField<PipeTargetEventBridgeEventBusParameters> EVENT_BRIDGE_EVENT_BUS_PARAMETERS_FIELD = SdkField
            .<PipeTargetEventBridgeEventBusParameters> builder(MarshallingType.SDK_POJO)
            .memberName("EventBridgeEventBusParameters")
            .getter(getter(PipeTargetParameters::eventBridgeEventBusParameters))
            .setter(setter(Builder::eventBridgeEventBusParameters))
            .constructor(PipeTargetEventBridgeEventBusParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBridgeEventBusParameters")
                    .build()).build();

    private static final SdkField<PipeTargetCloudWatchLogsParameters> CLOUD_WATCH_LOGS_PARAMETERS_FIELD = SdkField
            .<PipeTargetCloudWatchLogsParameters> builder(MarshallingType.SDK_POJO).memberName("CloudWatchLogsParameters")
            .getter(getter(PipeTargetParameters::cloudWatchLogsParameters)).setter(setter(Builder::cloudWatchLogsParameters))
            .constructor(PipeTargetCloudWatchLogsParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogsParameters").build())
            .build();

    private static final SdkField<PipeTargetTimestreamParameters> TIMESTREAM_PARAMETERS_FIELD = SdkField
            .<PipeTargetTimestreamParameters> builder(MarshallingType.SDK_POJO).memberName("TimestreamParameters")
            .getter(getter(PipeTargetParameters::timestreamParameters)).setter(setter(Builder::timestreamParameters))
            .constructor(PipeTargetTimestreamParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestreamParameters").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_TEMPLATE_FIELD,
            LAMBDA_FUNCTION_PARAMETERS_FIELD, STEP_FUNCTION_STATE_MACHINE_PARAMETERS_FIELD, KINESIS_STREAM_PARAMETERS_FIELD,
            ECS_TASK_PARAMETERS_FIELD, BATCH_JOB_PARAMETERS_FIELD, SQS_QUEUE_PARAMETERS_FIELD, HTTP_PARAMETERS_FIELD,
            REDSHIFT_DATA_PARAMETERS_FIELD, SAGE_MAKER_PIPELINE_PARAMETERS_FIELD, EVENT_BRIDGE_EVENT_BUS_PARAMETERS_FIELD,
            CLOUD_WATCH_LOGS_PARAMETERS_FIELD, TIMESTREAM_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String inputTemplate;

    private final PipeTargetLambdaFunctionParameters lambdaFunctionParameters;

    private final PipeTargetStateMachineParameters stepFunctionStateMachineParameters;

    private final PipeTargetKinesisStreamParameters kinesisStreamParameters;

    private final PipeTargetEcsTaskParameters ecsTaskParameters;

    private final PipeTargetBatchJobParameters batchJobParameters;

    private final PipeTargetSqsQueueParameters sqsQueueParameters;

    private final PipeTargetHttpParameters httpParameters;

    private final PipeTargetRedshiftDataParameters redshiftDataParameters;

    private final PipeTargetSageMakerPipelineParameters sageMakerPipelineParameters;

    private final PipeTargetEventBridgeEventBusParameters eventBridgeEventBusParameters;

    private final PipeTargetCloudWatchLogsParameters cloudWatchLogsParameters;

    private final PipeTargetTimestreamParameters timestreamParameters;

    private PipeTargetParameters(BuilderImpl builder) {
        this.inputTemplate = builder.inputTemplate;
        this.lambdaFunctionParameters = builder.lambdaFunctionParameters;
        this.stepFunctionStateMachineParameters = builder.stepFunctionStateMachineParameters;
        this.kinesisStreamParameters = builder.kinesisStreamParameters;
        this.ecsTaskParameters = builder.ecsTaskParameters;
        this.batchJobParameters = builder.batchJobParameters;
        this.sqsQueueParameters = builder.sqsQueueParameters;
        this.httpParameters = builder.httpParameters;
        this.redshiftDataParameters = builder.redshiftDataParameters;
        this.sageMakerPipelineParameters = builder.sageMakerPipelineParameters;
        this.eventBridgeEventBusParameters = builder.eventBridgeEventBusParameters;
        this.cloudWatchLogsParameters = builder.cloudWatchLogsParameters;
        this.timestreamParameters = builder.timestreamParameters;
    }

    /**
     * <p>
     * Valid JSON text passed to the target. In this case, nothing from the event itself is passed to the target. For
     * more information, see <a href="http://www.rfc-editor.org/rfc/rfc7159.txt">The JavaScript Object Notation (JSON)
     * Data Interchange Format</a>.
     * </p>
     * <p>
     * To remove an input template, specify an empty string.
     * </p>
     * 
     * @return Valid JSON text passed to the target. In this case, nothing from the event itself is passed to the
     *         target. For more information, see <a href="http://www.rfc-editor.org/rfc/rfc7159.txt">The JavaScript
     *         Object Notation (JSON) Data Interchange Format</a>.</p>
     *         <p>
     *         To remove an input template, specify an empty string.
     */
    public final String inputTemplate() {
        return inputTemplate;
    }

    /**
     * <p>
     * The parameters for using a Lambda function as a target.
     * </p>
     * 
     * @return The parameters for using a Lambda function as a target.
     */
    public final PipeTargetLambdaFunctionParameters lambdaFunctionParameters() {
        return lambdaFunctionParameters;
    }

    /**
     * <p>
     * The parameters for using a Step Functions state machine as a target.
     * </p>
     * 
     * @return The parameters for using a Step Functions state machine as a target.
     */
    public final PipeTargetStateMachineParameters stepFunctionStateMachineParameters() {
        return stepFunctionStateMachineParameters;
    }

    /**
     * <p>
     * The parameters for using a Kinesis stream as a target.
     * </p>
     * 
     * @return The parameters for using a Kinesis stream as a target.
     */
    public final PipeTargetKinesisStreamParameters kinesisStreamParameters() {
        return kinesisStreamParameters;
    }

    /**
     * <p>
     * The parameters for using an Amazon ECS task as a target.
     * </p>
     * 
     * @return The parameters for using an Amazon ECS task as a target.
     */
    public final PipeTargetEcsTaskParameters ecsTaskParameters() {
        return ecsTaskParameters;
    }

    /**
     * <p>
     * The parameters for using an Batch job as a target.
     * </p>
     * 
     * @return The parameters for using an Batch job as a target.
     */
    public final PipeTargetBatchJobParameters batchJobParameters() {
        return batchJobParameters;
    }

    /**
     * <p>
     * The parameters for using a Amazon SQS stream as a target.
     * </p>
     * 
     * @return The parameters for using a Amazon SQS stream as a target.
     */
    public final PipeTargetSqsQueueParameters sqsQueueParameters() {
        return sqsQueueParameters;
    }

    /**
     * <p>
     * These are custom parameter to be used when the target is an API Gateway REST APIs or EventBridge ApiDestinations.
     * </p>
     * 
     * @return These are custom parameter to be used when the target is an API Gateway REST APIs or EventBridge
     *         ApiDestinations.
     */
    public final PipeTargetHttpParameters httpParameters() {
        return httpParameters;
    }

    /**
     * <p>
     * These are custom parameters to be used when the target is a Amazon Redshift cluster to invoke the Amazon Redshift
     * Data API BatchExecuteStatement.
     * </p>
     * 
     * @return These are custom parameters to be used when the target is a Amazon Redshift cluster to invoke the Amazon
     *         Redshift Data API BatchExecuteStatement.
     */
    public final PipeTargetRedshiftDataParameters redshiftDataParameters() {
        return redshiftDataParameters;
    }

    /**
     * <p>
     * The parameters for using a SageMaker pipeline as a target.
     * </p>
     * 
     * @return The parameters for using a SageMaker pipeline as a target.
     */
    public final PipeTargetSageMakerPipelineParameters sageMakerPipelineParameters() {
        return sageMakerPipelineParameters;
    }

    /**
     * <p>
     * The parameters for using an EventBridge event bus as a target.
     * </p>
     * 
     * @return The parameters for using an EventBridge event bus as a target.
     */
    public final PipeTargetEventBridgeEventBusParameters eventBridgeEventBusParameters() {
        return eventBridgeEventBusParameters;
    }

    /**
     * <p>
     * The parameters for using an CloudWatch Logs log stream as a target.
     * </p>
     * 
     * @return The parameters for using an CloudWatch Logs log stream as a target.
     */
    public final PipeTargetCloudWatchLogsParameters cloudWatchLogsParameters() {
        return cloudWatchLogsParameters;
    }

    /**
     * <p>
     * The parameters for using a Timestream for LiveAnalytics table as a target.
     * </p>
     * 
     * @return The parameters for using a Timestream for LiveAnalytics table as a target.
     */
    public final PipeTargetTimestreamParameters timestreamParameters() {
        return timestreamParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaFunctionParameters());
        hashCode = 31 * hashCode + Objects.hashCode(stepFunctionStateMachineParameters());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisStreamParameters());
        hashCode = 31 * hashCode + Objects.hashCode(ecsTaskParameters());
        hashCode = 31 * hashCode + Objects.hashCode(batchJobParameters());
        hashCode = 31 * hashCode + Objects.hashCode(sqsQueueParameters());
        hashCode = 31 * hashCode + Objects.hashCode(httpParameters());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftDataParameters());
        hashCode = 31 * hashCode + Objects.hashCode(sageMakerPipelineParameters());
        hashCode = 31 * hashCode + Objects.hashCode(eventBridgeEventBusParameters());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogsParameters());
        hashCode = 31 * hashCode + Objects.hashCode(timestreamParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipeTargetParameters)) {
            return false;
        }
        PipeTargetParameters other = (PipeTargetParameters) obj;
        return Objects.equals(inputTemplate(), other.inputTemplate())
                && Objects.equals(lambdaFunctionParameters(), other.lambdaFunctionParameters())
                && Objects.equals(stepFunctionStateMachineParameters(), other.stepFunctionStateMachineParameters())
                && Objects.equals(kinesisStreamParameters(), other.kinesisStreamParameters())
                && Objects.equals(ecsTaskParameters(), other.ecsTaskParameters())
                && Objects.equals(batchJobParameters(), other.batchJobParameters())
                && Objects.equals(sqsQueueParameters(), other.sqsQueueParameters())
                && Objects.equals(httpParameters(), other.httpParameters())
                && Objects.equals(redshiftDataParameters(), other.redshiftDataParameters())
                && Objects.equals(sageMakerPipelineParameters(), other.sageMakerPipelineParameters())
                && Objects.equals(eventBridgeEventBusParameters(), other.eventBridgeEventBusParameters())
                && Objects.equals(cloudWatchLogsParameters(), other.cloudWatchLogsParameters())
                && Objects.equals(timestreamParameters(), other.timestreamParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipeTargetParameters")
                .add("InputTemplate", inputTemplate() == null ? null : "*** Sensitive Data Redacted ***")
                .add("LambdaFunctionParameters", lambdaFunctionParameters())
                .add("StepFunctionStateMachineParameters", stepFunctionStateMachineParameters())
                .add("KinesisStreamParameters", kinesisStreamParameters()).add("EcsTaskParameters", ecsTaskParameters())
                .add("BatchJobParameters", batchJobParameters()).add("SqsQueueParameters", sqsQueueParameters())
                .add("HttpParameters", httpParameters()).add("RedshiftDataParameters", redshiftDataParameters())
                .add("SageMakerPipelineParameters", sageMakerPipelineParameters())
                .add("EventBridgeEventBusParameters", eventBridgeEventBusParameters())
                .add("CloudWatchLogsParameters", cloudWatchLogsParameters()).add("TimestreamParameters", timestreamParameters())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputTemplate":
            return Optional.ofNullable(clazz.cast(inputTemplate()));
        case "LambdaFunctionParameters":
            return Optional.ofNullable(clazz.cast(lambdaFunctionParameters()));
        case "StepFunctionStateMachineParameters":
            return Optional.ofNullable(clazz.cast(stepFunctionStateMachineParameters()));
        case "KinesisStreamParameters":
            return Optional.ofNullable(clazz.cast(kinesisStreamParameters()));
        case "EcsTaskParameters":
            return Optional.ofNullable(clazz.cast(ecsTaskParameters()));
        case "BatchJobParameters":
            return Optional.ofNullable(clazz.cast(batchJobParameters()));
        case "SqsQueueParameters":
            return Optional.ofNullable(clazz.cast(sqsQueueParameters()));
        case "HttpParameters":
            return Optional.ofNullable(clazz.cast(httpParameters()));
        case "RedshiftDataParameters":
            return Optional.ofNullable(clazz.cast(redshiftDataParameters()));
        case "SageMakerPipelineParameters":
            return Optional.ofNullable(clazz.cast(sageMakerPipelineParameters()));
        case "EventBridgeEventBusParameters":
            return Optional.ofNullable(clazz.cast(eventBridgeEventBusParameters()));
        case "CloudWatchLogsParameters":
            return Optional.ofNullable(clazz.cast(cloudWatchLogsParameters()));
        case "TimestreamParameters":
            return Optional.ofNullable(clazz.cast(timestreamParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InputTemplate", INPUT_TEMPLATE_FIELD);
        map.put("LambdaFunctionParameters", LAMBDA_FUNCTION_PARAMETERS_FIELD);
        map.put("StepFunctionStateMachineParameters", STEP_FUNCTION_STATE_MACHINE_PARAMETERS_FIELD);
        map.put("KinesisStreamParameters", KINESIS_STREAM_PARAMETERS_FIELD);
        map.put("EcsTaskParameters", ECS_TASK_PARAMETERS_FIELD);
        map.put("BatchJobParameters", BATCH_JOB_PARAMETERS_FIELD);
        map.put("SqsQueueParameters", SQS_QUEUE_PARAMETERS_FIELD);
        map.put("HttpParameters", HTTP_PARAMETERS_FIELD);
        map.put("RedshiftDataParameters", REDSHIFT_DATA_PARAMETERS_FIELD);
        map.put("SageMakerPipelineParameters", SAGE_MAKER_PIPELINE_PARAMETERS_FIELD);
        map.put("EventBridgeEventBusParameters", EVENT_BRIDGE_EVENT_BUS_PARAMETERS_FIELD);
        map.put("CloudWatchLogsParameters", CLOUD_WATCH_LOGS_PARAMETERS_FIELD);
        map.put("TimestreamParameters", TIMESTREAM_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PipeTargetParameters, T> g) {
        return obj -> g.apply((PipeTargetParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipeTargetParameters> {
        /**
         * <p>
         * Valid JSON text passed to the target. In this case, nothing from the event itself is passed to the target.
         * For more information, see <a href="http://www.rfc-editor.org/rfc/rfc7159.txt">The JavaScript Object Notation
         * (JSON) Data Interchange Format</a>.
         * </p>
         * <p>
         * To remove an input template, specify an empty string.
         * </p>
         * 
         * @param inputTemplate
         *        Valid JSON text passed to the target. In this case, nothing from the event itself is passed to the
         *        target. For more information, see <a href="http://www.rfc-editor.org/rfc/rfc7159.txt">The JavaScript
         *        Object Notation (JSON) Data Interchange Format</a>.</p>
         *        <p>
         *        To remove an input template, specify an empty string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputTemplate(String inputTemplate);

        /**
         * <p>
         * The parameters for using a Lambda function as a target.
         * </p>
         * 
         * @param lambdaFunctionParameters
         *        The parameters for using a Lambda function as a target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionParameters(PipeTargetLambdaFunctionParameters lambdaFunctionParameters);

        /**
         * <p>
         * The parameters for using a Lambda function as a target.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PipeTargetLambdaFunctionParameters.Builder} avoiding the need to create one manually via
         * {@link PipeTargetLambdaFunctionParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipeTargetLambdaFunctionParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #lambdaFunctionParameters(PipeTargetLambdaFunctionParameters)}.
         * 
         * @param lambdaFunctionParameters
         *        a consumer that will call methods on {@link PipeTargetLambdaFunctionParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaFunctionParameters(PipeTargetLambdaFunctionParameters)
         */
        default Builder lambdaFunctionParameters(Consumer<PipeTargetLambdaFunctionParameters.Builder> lambdaFunctionParameters) {
            return lambdaFunctionParameters(PipeTargetLambdaFunctionParameters.builder().applyMutation(lambdaFunctionParameters)
                    .build());
        }

        /**
         * <p>
         * The parameters for using a Step Functions state machine as a target.
         * </p>
         * 
         * @param stepFunctionStateMachineParameters
         *        The parameters for using a Step Functions state machine as a target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepFunctionStateMachineParameters(PipeTargetStateMachineParameters stepFunctionStateMachineParameters);

        /**
         * <p>
         * The parameters for using a Step Functions state machine as a target.
         * </p>
         * This is a convenience method that creates an instance of the {@link PipeTargetStateMachineParameters.Builder}
         * avoiding the need to create one manually via {@link PipeTargetStateMachineParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipeTargetStateMachineParameters.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #stepFunctionStateMachineParameters(PipeTargetStateMachineParameters)}.
         * 
         * @param stepFunctionStateMachineParameters
         *        a consumer that will call methods on {@link PipeTargetStateMachineParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stepFunctionStateMachineParameters(PipeTargetStateMachineParameters)
         */
        default Builder stepFunctionStateMachineParameters(
                Consumer<PipeTargetStateMachineParameters.Builder> stepFunctionStateMachineParameters) {
            return stepFunctionStateMachineParameters(PipeTargetStateMachineParameters.builder()
                    .applyMutation(stepFunctionStateMachineParameters).build());
        }

        /**
         * <p>
         * The parameters for using a Kinesis stream as a target.
         * </p>
         * 
         * @param kinesisStreamParameters
         *        The parameters for using a Kinesis stream as a target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisStreamParameters(PipeTargetKinesisStreamParameters kinesisStreamParameters);

        /**
         * <p>
         * The parameters for using a Kinesis stream as a target.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PipeTargetKinesisStreamParameters.Builder} avoiding the need to create one manually via
         * {@link PipeTargetKinesisStreamParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipeTargetKinesisStreamParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #kinesisStreamParameters(PipeTargetKinesisStreamParameters)}.
         * 
         * @param kinesisStreamParameters
         *        a consumer that will call methods on {@link PipeTargetKinesisStreamParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisStreamParameters(PipeTargetKinesisStreamParameters)
         */
        default Builder kinesisStreamParameters(Consumer<PipeTargetKinesisStreamParameters.Builder> kinesisStreamParameters) {
            return kinesisStreamParameters(PipeTargetKinesisStreamParameters.builder().applyMutation(kinesisStreamParameters)
                    .build());
        }

        /**
         * <p>
         * The parameters for using an Amazon ECS task as a target.
         * </p>
         * 
         * @param ecsTaskParameters
         *        The parameters for using an Amazon ECS task as a target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsTaskParameters(PipeTargetEcsTaskParameters ecsTaskParameters);

        /**
         * <p>
         * The parameters for using an Amazon ECS task as a target.
         * </p>
         * This is a convenience method that creates an instance of the {@link PipeTargetEcsTaskParameters.Builder}
         * avoiding the need to create one manually via {@link PipeTargetEcsTaskParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipeTargetEcsTaskParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #ecsTaskParameters(PipeTargetEcsTaskParameters)}.
         * 
         * @param ecsTaskParameters
         *        a consumer that will call methods on {@link PipeTargetEcsTaskParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecsTaskParameters(PipeTargetEcsTaskParameters)
         */
        default Builder ecsTaskParameters(Consumer<PipeTargetEcsTaskParameters.Builder> ecsTaskParameters) {
            return ecsTaskParameters(PipeTargetEcsTaskParameters.builder().applyMutation(ecsTaskParameters).build());
        }

        /**
         * <p>
         * The parameters for using an Batch job as a target.
         * </p>
         * 
         * @param batchJobParameters
         *        The parameters for using an Batch job as a target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchJobParameters(PipeTargetBatchJobParameters batchJobParameters);

        /**
         * <p>
         * The parameters for using an Batch job as a target.
         * </p>
         * This is a convenience method that creates an instance of the {@link PipeTargetBatchJobParameters.Builder}
         * avoiding the need to create one manually via {@link PipeTargetBatchJobParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipeTargetBatchJobParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #batchJobParameters(PipeTargetBatchJobParameters)}.
         * 
         * @param batchJobParameters
         *        a consumer that will call methods on {@link PipeTargetBatchJobParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #batchJobParameters(PipeTargetBatchJobParameters)
         */
        default Builder batchJobParameters(Consumer<PipeTargetBatchJobParameters.Builder> batchJobParameters) {
            return batchJobParameters(PipeTargetBatchJobParameters.builder().applyMutation(batchJobParameters).build());
        }

        /**
         * <p>
         * The parameters for using a Amazon SQS stream as a target.
         * </p>
         * 
         * @param sqsQueueParameters
         *        The parameters for using a Amazon SQS stream as a target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqsQueueParameters(PipeTargetSqsQueueParameters sqsQueueParameters);

        /**
         * <p>
         * The parameters for using a Amazon SQS stream as a target.
         * </p>
         * This is a convenience method that creates an instance of the {@link PipeTargetSqsQueueParameters.Builder}
         * avoiding the need to create one manually via {@link PipeTargetSqsQueueParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipeTargetSqsQueueParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #sqsQueueParameters(PipeTargetSqsQueueParameters)}.
         * 
         * @param sqsQueueParameters
         *        a consumer that will call methods on {@link PipeTargetSqsQueueParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sqsQueueParameters(PipeTargetSqsQueueParameters)
         */
        default Builder sqsQueueParameters(Consumer<PipeTargetSqsQueueParameters.Builder> sqsQueueParameters) {
            return sqsQueueParameters(PipeTargetSqsQueueParameters.builder().applyMutation(sqsQueueParameters).build());
        }

        /**
         * <p>
         * These are custom parameter to be used when the target is an API Gateway REST APIs or EventBridge
         * ApiDestinations.
         * </p>
         * 
         * @param httpParameters
         *        These are custom parameter to be used when the target is an API Gateway REST APIs or EventBridge
         *        ApiDestinations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpParameters(PipeTargetHttpParameters httpParameters);

        /**
         * <p>
         * These are custom parameter to be used when the target is an API Gateway REST APIs or EventBridge
         * ApiDestinations.
         * </p>
         * This is a convenience method that creates an instance of the {@link PipeTargetHttpParameters.Builder}
         * avoiding the need to create one manually via {@link PipeTargetHttpParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipeTargetHttpParameters.Builder#build()} is called immediately
         * and its result is passed to {@link #httpParameters(PipeTargetHttpParameters)}.
         * 
         * @param httpParameters
         *        a consumer that will call methods on {@link PipeTargetHttpParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #httpParameters(PipeTargetHttpParameters)
         */
        default Builder httpParameters(Consumer<PipeTargetHttpParameters.Builder> httpParameters) {
            return httpParameters(PipeTargetHttpParameters.builder().applyMutation(httpParameters).build());
        }

        /**
         * <p>
         * These are custom parameters to be used when the target is a Amazon Redshift cluster to invoke the Amazon
         * Redshift Data API BatchExecuteStatement.
         * </p>
         * 
         * @param redshiftDataParameters
         *        These are custom parameters to be used when the target is a Amazon Redshift cluster to invoke the
         *        Amazon Redshift Data API BatchExecuteStatement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftDataParameters(PipeTargetRedshiftDataParameters redshiftDataParameters);

        /**
         * <p>
         * These are custom parameters to be used when the target is a Amazon Redshift cluster to invoke the Amazon
         * Redshift Data API BatchExecuteStatement.
         * </p>
         * This is a convenience method that creates an instance of the {@link PipeTargetRedshiftDataParameters.Builder}
         * avoiding the need to create one manually via {@link PipeTargetRedshiftDataParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipeTargetRedshiftDataParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #redshiftDataParameters(PipeTargetRedshiftDataParameters)}.
         * 
         * @param redshiftDataParameters
         *        a consumer that will call methods on {@link PipeTargetRedshiftDataParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshiftDataParameters(PipeTargetRedshiftDataParameters)
         */
        default Builder redshiftDataParameters(Consumer<PipeTargetRedshiftDataParameters.Builder> redshiftDataParameters) {
            return redshiftDataParameters(PipeTargetRedshiftDataParameters.builder().applyMutation(redshiftDataParameters)
                    .build());
        }

        /**
         * <p>
         * The parameters for using a SageMaker pipeline as a target.
         * </p>
         * 
         * @param sageMakerPipelineParameters
         *        The parameters for using a SageMaker pipeline as a target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sageMakerPipelineParameters(PipeTargetSageMakerPipelineParameters sageMakerPipelineParameters);

        /**
         * <p>
         * The parameters for using a SageMaker pipeline as a target.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PipeTargetSageMakerPipelineParameters.Builder} avoiding the need to create one manually via
         * {@link PipeTargetSageMakerPipelineParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipeTargetSageMakerPipelineParameters.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #sageMakerPipelineParameters(PipeTargetSageMakerPipelineParameters)}.
         * 
         * @param sageMakerPipelineParameters
         *        a consumer that will call methods on {@link PipeTargetSageMakerPipelineParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sageMakerPipelineParameters(PipeTargetSageMakerPipelineParameters)
         */
        default Builder sageMakerPipelineParameters(
                Consumer<PipeTargetSageMakerPipelineParameters.Builder> sageMakerPipelineParameters) {
            return sageMakerPipelineParameters(PipeTargetSageMakerPipelineParameters.builder()
                    .applyMutation(sageMakerPipelineParameters).build());
        }

        /**
         * <p>
         * The parameters for using an EventBridge event bus as a target.
         * </p>
         * 
         * @param eventBridgeEventBusParameters
         *        The parameters for using an EventBridge event bus as a target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBridgeEventBusParameters(PipeTargetEventBridgeEventBusParameters eventBridgeEventBusParameters);

        /**
         * <p>
         * The parameters for using an EventBridge event bus as a target.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PipeTargetEventBridgeEventBusParameters.Builder} avoiding the need to create one manually via
         * {@link PipeTargetEventBridgeEventBusParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipeTargetEventBridgeEventBusParameters.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #eventBridgeEventBusParameters(PipeTargetEventBridgeEventBusParameters)}.
         * 
         * @param eventBridgeEventBusParameters
         *        a consumer that will call methods on {@link PipeTargetEventBridgeEventBusParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventBridgeEventBusParameters(PipeTargetEventBridgeEventBusParameters)
         */
        default Builder eventBridgeEventBusParameters(
                Consumer<PipeTargetEventBridgeEventBusParameters.Builder> eventBridgeEventBusParameters) {
            return eventBridgeEventBusParameters(PipeTargetEventBridgeEventBusParameters.builder()
                    .applyMutation(eventBridgeEventBusParameters).build());
        }

        /**
         * <p>
         * The parameters for using an CloudWatch Logs log stream as a target.
         * </p>
         * 
         * @param cloudWatchLogsParameters
         *        The parameters for using an CloudWatch Logs log stream as a target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogsParameters(PipeTargetCloudWatchLogsParameters cloudWatchLogsParameters);

        /**
         * <p>
         * The parameters for using an CloudWatch Logs log stream as a target.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PipeTargetCloudWatchLogsParameters.Builder} avoiding the need to create one manually via
         * {@link PipeTargetCloudWatchLogsParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipeTargetCloudWatchLogsParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #cloudWatchLogsParameters(PipeTargetCloudWatchLogsParameters)}.
         * 
         * @param cloudWatchLogsParameters
         *        a consumer that will call methods on {@link PipeTargetCloudWatchLogsParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLogsParameters(PipeTargetCloudWatchLogsParameters)
         */
        default Builder cloudWatchLogsParameters(Consumer<PipeTargetCloudWatchLogsParameters.Builder> cloudWatchLogsParameters) {
            return cloudWatchLogsParameters(PipeTargetCloudWatchLogsParameters.builder().applyMutation(cloudWatchLogsParameters)
                    .build());
        }

        /**
         * <p>
         * The parameters for using a Timestream for LiveAnalytics table as a target.
         * </p>
         * 
         * @param timestreamParameters
         *        The parameters for using a Timestream for LiveAnalytics table as a target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestreamParameters(PipeTargetTimestreamParameters timestreamParameters);

        /**
         * <p>
         * The parameters for using a Timestream for LiveAnalytics table as a target.
         * </p>
         * This is a convenience method that creates an instance of the {@link PipeTargetTimestreamParameters.Builder}
         * avoiding the need to create one manually via {@link PipeTargetTimestreamParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipeTargetTimestreamParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #timestreamParameters(PipeTargetTimestreamParameters)}.
         * 
         * @param timestreamParameters
         *        a consumer that will call methods on {@link PipeTargetTimestreamParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timestreamParameters(PipeTargetTimestreamParameters)
         */
        default Builder timestreamParameters(Consumer<PipeTargetTimestreamParameters.Builder> timestreamParameters) {
            return timestreamParameters(PipeTargetTimestreamParameters.builder().applyMutation(timestreamParameters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String inputTemplate;

        private PipeTargetLambdaFunctionParameters lambdaFunctionParameters;

        private PipeTargetStateMachineParameters stepFunctionStateMachineParameters;

        private PipeTargetKinesisStreamParameters kinesisStreamParameters;

        private PipeTargetEcsTaskParameters ecsTaskParameters;

        private PipeTargetBatchJobParameters batchJobParameters;

        private PipeTargetSqsQueueParameters sqsQueueParameters;

        private PipeTargetHttpParameters httpParameters;

        private PipeTargetRedshiftDataParameters redshiftDataParameters;

        private PipeTargetSageMakerPipelineParameters sageMakerPipelineParameters;

        private PipeTargetEventBridgeEventBusParameters eventBridgeEventBusParameters;

        private PipeTargetCloudWatchLogsParameters cloudWatchLogsParameters;

        private PipeTargetTimestreamParameters timestreamParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(PipeTargetParameters model) {
            inputTemplate(model.inputTemplate);
            lambdaFunctionParameters(model.lambdaFunctionParameters);
            stepFunctionStateMachineParameters(model.stepFunctionStateMachineParameters);
            kinesisStreamParameters(model.kinesisStreamParameters);
            ecsTaskParameters(model.ecsTaskParameters);
            batchJobParameters(model.batchJobParameters);
            sqsQueueParameters(model.sqsQueueParameters);
            httpParameters(model.httpParameters);
            redshiftDataParameters(model.redshiftDataParameters);
            sageMakerPipelineParameters(model.sageMakerPipelineParameters);
            eventBridgeEventBusParameters(model.eventBridgeEventBusParameters);
            cloudWatchLogsParameters(model.cloudWatchLogsParameters);
            timestreamParameters(model.timestreamParameters);
        }

        public final String getInputTemplate() {
            return inputTemplate;
        }

        public final void setInputTemplate(String inputTemplate) {
            this.inputTemplate = inputTemplate;
        }

        @Override
        public final Builder inputTemplate(String inputTemplate) {
            this.inputTemplate = inputTemplate;
            return this;
        }

        public final PipeTargetLambdaFunctionParameters.Builder getLambdaFunctionParameters() {
            return lambdaFunctionParameters != null ? lambdaFunctionParameters.toBuilder() : null;
        }

        public final void setLambdaFunctionParameters(PipeTargetLambdaFunctionParameters.BuilderImpl lambdaFunctionParameters) {
            this.lambdaFunctionParameters = lambdaFunctionParameters != null ? lambdaFunctionParameters.build() : null;
        }

        @Override
        public final Builder lambdaFunctionParameters(PipeTargetLambdaFunctionParameters lambdaFunctionParameters) {
            this.lambdaFunctionParameters = lambdaFunctionParameters;
            return this;
        }

        public final PipeTargetStateMachineParameters.Builder getStepFunctionStateMachineParameters() {
            return stepFunctionStateMachineParameters != null ? stepFunctionStateMachineParameters.toBuilder() : null;
        }

        public final void setStepFunctionStateMachineParameters(
                PipeTargetStateMachineParameters.BuilderImpl stepFunctionStateMachineParameters) {
            this.stepFunctionStateMachineParameters = stepFunctionStateMachineParameters != null ? stepFunctionStateMachineParameters
                    .build() : null;
        }

        @Override
        public final Builder stepFunctionStateMachineParameters(
                PipeTargetStateMachineParameters stepFunctionStateMachineParameters) {
            this.stepFunctionStateMachineParameters = stepFunctionStateMachineParameters;
            return this;
        }

        public final PipeTargetKinesisStreamParameters.Builder getKinesisStreamParameters() {
            return kinesisStreamParameters != null ? kinesisStreamParameters.toBuilder() : null;
        }

        public final void setKinesisStreamParameters(PipeTargetKinesisStreamParameters.BuilderImpl kinesisStreamParameters) {
            this.kinesisStreamParameters = kinesisStreamParameters != null ? kinesisStreamParameters.build() : null;
        }

        @Override
        public final Builder kinesisStreamParameters(PipeTargetKinesisStreamParameters kinesisStreamParameters) {
            this.kinesisStreamParameters = kinesisStreamParameters;
            return this;
        }

        public final PipeTargetEcsTaskParameters.Builder getEcsTaskParameters() {
            return ecsTaskParameters != null ? ecsTaskParameters.toBuilder() : null;
        }

        public final void setEcsTaskParameters(PipeTargetEcsTaskParameters.BuilderImpl ecsTaskParameters) {
            this.ecsTaskParameters = ecsTaskParameters != null ? ecsTaskParameters.build() : null;
        }

        @Override
        public final Builder ecsTaskParameters(PipeTargetEcsTaskParameters ecsTaskParameters) {
            this.ecsTaskParameters = ecsTaskParameters;
            return this;
        }

        public final PipeTargetBatchJobParameters.Builder getBatchJobParameters() {
            return batchJobParameters != null ? batchJobParameters.toBuilder() : null;
        }

        public final void setBatchJobParameters(PipeTargetBatchJobParameters.BuilderImpl batchJobParameters) {
            this.batchJobParameters = batchJobParameters != null ? batchJobParameters.build() : null;
        }

        @Override
        public final Builder batchJobParameters(PipeTargetBatchJobParameters batchJobParameters) {
            this.batchJobParameters = batchJobParameters;
            return this;
        }

        public final PipeTargetSqsQueueParameters.Builder getSqsQueueParameters() {
            return sqsQueueParameters != null ? sqsQueueParameters.toBuilder() : null;
        }

        public final void setSqsQueueParameters(PipeTargetSqsQueueParameters.BuilderImpl sqsQueueParameters) {
            this.sqsQueueParameters = sqsQueueParameters != null ? sqsQueueParameters.build() : null;
        }

        @Override
        public final Builder sqsQueueParameters(PipeTargetSqsQueueParameters sqsQueueParameters) {
            this.sqsQueueParameters = sqsQueueParameters;
            return this;
        }

        public final PipeTargetHttpParameters.Builder getHttpParameters() {
            return httpParameters != null ? httpParameters.toBuilder() : null;
        }

        public final void setHttpParameters(PipeTargetHttpParameters.BuilderImpl httpParameters) {
            this.httpParameters = httpParameters != null ? httpParameters.build() : null;
        }

        @Override
        public final Builder httpParameters(PipeTargetHttpParameters httpParameters) {
            this.httpParameters = httpParameters;
            return this;
        }

        public final PipeTargetRedshiftDataParameters.Builder getRedshiftDataParameters() {
            return redshiftDataParameters != null ? redshiftDataParameters.toBuilder() : null;
        }

        public final void setRedshiftDataParameters(PipeTargetRedshiftDataParameters.BuilderImpl redshiftDataParameters) {
            this.redshiftDataParameters = redshiftDataParameters != null ? redshiftDataParameters.build() : null;
        }

        @Override
        public final Builder redshiftDataParameters(PipeTargetRedshiftDataParameters redshiftDataParameters) {
            this.redshiftDataParameters = redshiftDataParameters;
            return this;
        }

        public final PipeTargetSageMakerPipelineParameters.Builder getSageMakerPipelineParameters() {
            return sageMakerPipelineParameters != null ? sageMakerPipelineParameters.toBuilder() : null;
        }

        public final void setSageMakerPipelineParameters(
                PipeTargetSageMakerPipelineParameters.BuilderImpl sageMakerPipelineParameters) {
            this.sageMakerPipelineParameters = sageMakerPipelineParameters != null ? sageMakerPipelineParameters.build() : null;
        }

        @Override
        public final Builder sageMakerPipelineParameters(PipeTargetSageMakerPipelineParameters sageMakerPipelineParameters) {
            this.sageMakerPipelineParameters = sageMakerPipelineParameters;
            return this;
        }

        public final PipeTargetEventBridgeEventBusParameters.Builder getEventBridgeEventBusParameters() {
            return eventBridgeEventBusParameters != null ? eventBridgeEventBusParameters.toBuilder() : null;
        }

        public final void setEventBridgeEventBusParameters(
                PipeTargetEventBridgeEventBusParameters.BuilderImpl eventBridgeEventBusParameters) {
            this.eventBridgeEventBusParameters = eventBridgeEventBusParameters != null ? eventBridgeEventBusParameters.build()
                    : null;
        }

        @Override
        public final Builder eventBridgeEventBusParameters(PipeTargetEventBridgeEventBusParameters eventBridgeEventBusParameters) {
            this.eventBridgeEventBusParameters = eventBridgeEventBusParameters;
            return this;
        }

        public final PipeTargetCloudWatchLogsParameters.Builder getCloudWatchLogsParameters() {
            return cloudWatchLogsParameters != null ? cloudWatchLogsParameters.toBuilder() : null;
        }

        public final void setCloudWatchLogsParameters(PipeTargetCloudWatchLogsParameters.BuilderImpl cloudWatchLogsParameters) {
            this.cloudWatchLogsParameters = cloudWatchLogsParameters != null ? cloudWatchLogsParameters.build() : null;
        }

        @Override
        public final Builder cloudWatchLogsParameters(PipeTargetCloudWatchLogsParameters cloudWatchLogsParameters) {
            this.cloudWatchLogsParameters = cloudWatchLogsParameters;
            return this;
        }

        public final PipeTargetTimestreamParameters.Builder getTimestreamParameters() {
            return timestreamParameters != null ? timestreamParameters.toBuilder() : null;
        }

        public final void setTimestreamParameters(PipeTargetTimestreamParameters.BuilderImpl timestreamParameters) {
            this.timestreamParameters = timestreamParameters != null ? timestreamParameters.build() : null;
        }

        @Override
        public final Builder timestreamParameters(PipeTargetTimestreamParameters timestreamParameters) {
            this.timestreamParameters = timestreamParameters;
            return this;
        }

        @Override
        public PipeTargetParameters build() {
            return new PipeTargetParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
