/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters for using a DynamoDB stream as a source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePipeSourceDynamoDBStreamParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdatePipeSourceDynamoDBStreamParameters.Builder, UpdatePipeSourceDynamoDBStreamParameters> {
    private static final SdkField<Integer> BATCH_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BatchSize").getter(getter(UpdatePipeSourceDynamoDBStreamParameters::batchSize))
            .setter(setter(Builder::batchSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchSize").build()).build();

    private static final SdkField<DeadLetterConfig> DEAD_LETTER_CONFIG_FIELD = SdkField
            .<DeadLetterConfig> builder(MarshallingType.SDK_POJO).memberName("DeadLetterConfig")
            .getter(getter(UpdatePipeSourceDynamoDBStreamParameters::deadLetterConfig)).setter(setter(Builder::deadLetterConfig))
            .constructor(DeadLetterConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeadLetterConfig").build()).build();

    private static final SdkField<String> ON_PARTIAL_BATCH_ITEM_FAILURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OnPartialBatchItemFailure")
            .getter(getter(UpdatePipeSourceDynamoDBStreamParameters::onPartialBatchItemFailureAsString))
            .setter(setter(Builder::onPartialBatchItemFailure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnPartialBatchItemFailure").build())
            .build();

    private static final SdkField<Integer> MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumBatchingWindowInSeconds")
            .getter(getter(UpdatePipeSourceDynamoDBStreamParameters::maximumBatchingWindowInSeconds))
            .setter(setter(Builder::maximumBatchingWindowInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumBatchingWindowInSeconds")
                    .build()).build();

    private static final SdkField<Integer> MAXIMUM_RECORD_AGE_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("MaximumRecordAgeInSeconds")
            .getter(getter(UpdatePipeSourceDynamoDBStreamParameters::maximumRecordAgeInSeconds))
            .setter(setter(Builder::maximumRecordAgeInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumRecordAgeInSeconds").build())
            .build();

    private static final SdkField<Integer> MAXIMUM_RETRY_ATTEMPTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumRetryAttempts").getter(getter(UpdatePipeSourceDynamoDBStreamParameters::maximumRetryAttempts))
            .setter(setter(Builder::maximumRetryAttempts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumRetryAttempts").build())
            .build();

    private static final SdkField<Integer> PARALLELIZATION_FACTOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ParallelizationFactor").getter(getter(UpdatePipeSourceDynamoDBStreamParameters::parallelizationFactor))
            .setter(setter(Builder::parallelizationFactor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelizationFactor").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_SIZE_FIELD,
            DEAD_LETTER_CONFIG_FIELD, ON_PARTIAL_BATCH_ITEM_FAILURE_FIELD, MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD,
            MAXIMUM_RECORD_AGE_IN_SECONDS_FIELD, MAXIMUM_RETRY_ATTEMPTS_FIELD, PARALLELIZATION_FACTOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer batchSize;

    private final DeadLetterConfig deadLetterConfig;

    private final String onPartialBatchItemFailure;

    private final Integer maximumBatchingWindowInSeconds;

    private final Integer maximumRecordAgeInSeconds;

    private final Integer maximumRetryAttempts;

    private final Integer parallelizationFactor;

    private UpdatePipeSourceDynamoDBStreamParameters(BuilderImpl builder) {
        this.batchSize = builder.batchSize;
        this.deadLetterConfig = builder.deadLetterConfig;
        this.onPartialBatchItemFailure = builder.onPartialBatchItemFailure;
        this.maximumBatchingWindowInSeconds = builder.maximumBatchingWindowInSeconds;
        this.maximumRecordAgeInSeconds = builder.maximumRecordAgeInSeconds;
        this.maximumRetryAttempts = builder.maximumRetryAttempts;
        this.parallelizationFactor = builder.parallelizationFactor;
    }

    /**
     * <p>
     * The maximum number of records to include in each batch.
     * </p>
     * 
     * @return The maximum number of records to include in each batch.
     */
    public final Integer batchSize() {
        return batchSize;
    }

    /**
     * <p>
     * Define the target queue to send dead-letter queue events to.
     * </p>
     * 
     * @return Define the target queue to send dead-letter queue events to.
     */
    public final DeadLetterConfig deadLetterConfig() {
        return deadLetterConfig;
    }

    /**
     * <p>
     * Define how to handle item process failures. <code>AUTOMATIC_BISECT</code> halves each batch and retry each half
     * until all the records are processed or there is one failed message left in the batch.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #onPartialBatchItemFailure} will return {@link OnPartialBatchItemFailureStreams#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #onPartialBatchItemFailureAsString}.
     * </p>
     * 
     * @return Define how to handle item process failures. <code>AUTOMATIC_BISECT</code> halves each batch and retry
     *         each half until all the records are processed or there is one failed message left in the batch.
     * @see OnPartialBatchItemFailureStreams
     */
    public final OnPartialBatchItemFailureStreams onPartialBatchItemFailure() {
        return OnPartialBatchItemFailureStreams.fromValue(onPartialBatchItemFailure);
    }

    /**
     * <p>
     * Define how to handle item process failures. <code>AUTOMATIC_BISECT</code> halves each batch and retry each half
     * until all the records are processed or there is one failed message left in the batch.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #onPartialBatchItemFailure} will return {@link OnPartialBatchItemFailureStreams#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #onPartialBatchItemFailureAsString}.
     * </p>
     * 
     * @return Define how to handle item process failures. <code>AUTOMATIC_BISECT</code> halves each batch and retry
     *         each half until all the records are processed or there is one failed message left in the batch.
     * @see OnPartialBatchItemFailureStreams
     */
    public final String onPartialBatchItemFailureAsString() {
        return onPartialBatchItemFailure;
    }

    /**
     * <p>
     * The maximum length of a time to wait for events.
     * </p>
     * 
     * @return The maximum length of a time to wait for events.
     */
    public final Integer maximumBatchingWindowInSeconds() {
        return maximumBatchingWindowInSeconds;
    }

    /**
     * <p>
     * Discard records older than the specified age. The default value is -1, which sets the maximum age to infinite.
     * When the value is set to infinite, EventBridge never discards old records.
     * </p>
     * 
     * @return Discard records older than the specified age. The default value is -1, which sets the maximum age to
     *         infinite. When the value is set to infinite, EventBridge never discards old records.
     */
    public final Integer maximumRecordAgeInSeconds() {
        return maximumRecordAgeInSeconds;
    }

    /**
     * <p>
     * Discard records after the specified number of retries. The default value is -1, which sets the maximum number of
     * retries to infinite. When MaximumRetryAttempts is infinite, EventBridge retries failed records until the record
     * expires in the event source.
     * </p>
     * 
     * @return Discard records after the specified number of retries. The default value is -1, which sets the maximum
     *         number of retries to infinite. When MaximumRetryAttempts is infinite, EventBridge retries failed records
     *         until the record expires in the event source.
     */
    public final Integer maximumRetryAttempts() {
        return maximumRetryAttempts;
    }

    /**
     * <p>
     * The number of batches to process concurrently from each shard. The default value is 1.
     * </p>
     * 
     * @return The number of batches to process concurrently from each shard. The default value is 1.
     */
    public final Integer parallelizationFactor() {
        return parallelizationFactor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(batchSize());
        hashCode = 31 * hashCode + Objects.hashCode(deadLetterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(onPartialBatchItemFailureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maximumBatchingWindowInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(maximumRecordAgeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(maximumRetryAttempts());
        hashCode = 31 * hashCode + Objects.hashCode(parallelizationFactor());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePipeSourceDynamoDBStreamParameters)) {
            return false;
        }
        UpdatePipeSourceDynamoDBStreamParameters other = (UpdatePipeSourceDynamoDBStreamParameters) obj;
        return Objects.equals(batchSize(), other.batchSize()) && Objects.equals(deadLetterConfig(), other.deadLetterConfig())
                && Objects.equals(onPartialBatchItemFailureAsString(), other.onPartialBatchItemFailureAsString())
                && Objects.equals(maximumBatchingWindowInSeconds(), other.maximumBatchingWindowInSeconds())
                && Objects.equals(maximumRecordAgeInSeconds(), other.maximumRecordAgeInSeconds())
                && Objects.equals(maximumRetryAttempts(), other.maximumRetryAttempts())
                && Objects.equals(parallelizationFactor(), other.parallelizationFactor());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePipeSourceDynamoDBStreamParameters").add("BatchSize", batchSize())
                .add("DeadLetterConfig", deadLetterConfig())
                .add("OnPartialBatchItemFailure", onPartialBatchItemFailureAsString())
                .add("MaximumBatchingWindowInSeconds", maximumBatchingWindowInSeconds())
                .add("MaximumRecordAgeInSeconds", maximumRecordAgeInSeconds())
                .add("MaximumRetryAttempts", maximumRetryAttempts()).add("ParallelizationFactor", parallelizationFactor())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BatchSize":
            return Optional.ofNullable(clazz.cast(batchSize()));
        case "DeadLetterConfig":
            return Optional.ofNullable(clazz.cast(deadLetterConfig()));
        case "OnPartialBatchItemFailure":
            return Optional.ofNullable(clazz.cast(onPartialBatchItemFailureAsString()));
        case "MaximumBatchingWindowInSeconds":
            return Optional.ofNullable(clazz.cast(maximumBatchingWindowInSeconds()));
        case "MaximumRecordAgeInSeconds":
            return Optional.ofNullable(clazz.cast(maximumRecordAgeInSeconds()));
        case "MaximumRetryAttempts":
            return Optional.ofNullable(clazz.cast(maximumRetryAttempts()));
        case "ParallelizationFactor":
            return Optional.ofNullable(clazz.cast(parallelizationFactor()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BatchSize", BATCH_SIZE_FIELD);
        map.put("DeadLetterConfig", DEAD_LETTER_CONFIG_FIELD);
        map.put("OnPartialBatchItemFailure", ON_PARTIAL_BATCH_ITEM_FAILURE_FIELD);
        map.put("MaximumBatchingWindowInSeconds", MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD);
        map.put("MaximumRecordAgeInSeconds", MAXIMUM_RECORD_AGE_IN_SECONDS_FIELD);
        map.put("MaximumRetryAttempts", MAXIMUM_RETRY_ATTEMPTS_FIELD);
        map.put("ParallelizationFactor", PARALLELIZATION_FACTOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePipeSourceDynamoDBStreamParameters, T> g) {
        return obj -> g.apply((UpdatePipeSourceDynamoDBStreamParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdatePipeSourceDynamoDBStreamParameters> {
        /**
         * <p>
         * The maximum number of records to include in each batch.
         * </p>
         * 
         * @param batchSize
         *        The maximum number of records to include in each batch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchSize(Integer batchSize);

        /**
         * <p>
         * Define the target queue to send dead-letter queue events to.
         * </p>
         * 
         * @param deadLetterConfig
         *        Define the target queue to send dead-letter queue events to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deadLetterConfig(DeadLetterConfig deadLetterConfig);

        /**
         * <p>
         * Define the target queue to send dead-letter queue events to.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeadLetterConfig.Builder} avoiding the
         * need to create one manually via {@link DeadLetterConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeadLetterConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #deadLetterConfig(DeadLetterConfig)}.
         * 
         * @param deadLetterConfig
         *        a consumer that will call methods on {@link DeadLetterConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deadLetterConfig(DeadLetterConfig)
         */
        default Builder deadLetterConfig(Consumer<DeadLetterConfig.Builder> deadLetterConfig) {
            return deadLetterConfig(DeadLetterConfig.builder().applyMutation(deadLetterConfig).build());
        }

        /**
         * <p>
         * Define how to handle item process failures. <code>AUTOMATIC_BISECT</code> halves each batch and retry each
         * half until all the records are processed or there is one failed message left in the batch.
         * </p>
         * 
         * @param onPartialBatchItemFailure
         *        Define how to handle item process failures. <code>AUTOMATIC_BISECT</code> halves each batch and retry
         *        each half until all the records are processed or there is one failed message left in the batch.
         * @see OnPartialBatchItemFailureStreams
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OnPartialBatchItemFailureStreams
         */
        Builder onPartialBatchItemFailure(String onPartialBatchItemFailure);

        /**
         * <p>
         * Define how to handle item process failures. <code>AUTOMATIC_BISECT</code> halves each batch and retry each
         * half until all the records are processed or there is one failed message left in the batch.
         * </p>
         * 
         * @param onPartialBatchItemFailure
         *        Define how to handle item process failures. <code>AUTOMATIC_BISECT</code> halves each batch and retry
         *        each half until all the records are processed or there is one failed message left in the batch.
         * @see OnPartialBatchItemFailureStreams
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OnPartialBatchItemFailureStreams
         */
        Builder onPartialBatchItemFailure(OnPartialBatchItemFailureStreams onPartialBatchItemFailure);

        /**
         * <p>
         * The maximum length of a time to wait for events.
         * </p>
         * 
         * @param maximumBatchingWindowInSeconds
         *        The maximum length of a time to wait for events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds);

        /**
         * <p>
         * Discard records older than the specified age. The default value is -1, which sets the maximum age to
         * infinite. When the value is set to infinite, EventBridge never discards old records.
         * </p>
         * 
         * @param maximumRecordAgeInSeconds
         *        Discard records older than the specified age. The default value is -1, which sets the maximum age to
         *        infinite. When the value is set to infinite, EventBridge never discards old records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumRecordAgeInSeconds(Integer maximumRecordAgeInSeconds);

        /**
         * <p>
         * Discard records after the specified number of retries. The default value is -1, which sets the maximum number
         * of retries to infinite. When MaximumRetryAttempts is infinite, EventBridge retries failed records until the
         * record expires in the event source.
         * </p>
         * 
         * @param maximumRetryAttempts
         *        Discard records after the specified number of retries. The default value is -1, which sets the maximum
         *        number of retries to infinite. When MaximumRetryAttempts is infinite, EventBridge retries failed
         *        records until the record expires in the event source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumRetryAttempts(Integer maximumRetryAttempts);

        /**
         * <p>
         * The number of batches to process concurrently from each shard. The default value is 1.
         * </p>
         * 
         * @param parallelizationFactor
         *        The number of batches to process concurrently from each shard. The default value is 1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parallelizationFactor(Integer parallelizationFactor);
    }

    static final class BuilderImpl implements Builder {
        private Integer batchSize;

        private DeadLetterConfig deadLetterConfig;

        private String onPartialBatchItemFailure;

        private Integer maximumBatchingWindowInSeconds;

        private Integer maximumRecordAgeInSeconds;

        private Integer maximumRetryAttempts;

        private Integer parallelizationFactor;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePipeSourceDynamoDBStreamParameters model) {
            batchSize(model.batchSize);
            deadLetterConfig(model.deadLetterConfig);
            onPartialBatchItemFailure(model.onPartialBatchItemFailure);
            maximumBatchingWindowInSeconds(model.maximumBatchingWindowInSeconds);
            maximumRecordAgeInSeconds(model.maximumRecordAgeInSeconds);
            maximumRetryAttempts(model.maximumRetryAttempts);
            parallelizationFactor(model.parallelizationFactor);
        }

        public final Integer getBatchSize() {
            return batchSize;
        }

        public final void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        @Override
        public final Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public final DeadLetterConfig.Builder getDeadLetterConfig() {
            return deadLetterConfig != null ? deadLetterConfig.toBuilder() : null;
        }

        public final void setDeadLetterConfig(DeadLetterConfig.BuilderImpl deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig != null ? deadLetterConfig.build() : null;
        }

        @Override
        public final Builder deadLetterConfig(DeadLetterConfig deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig;
            return this;
        }

        public final String getOnPartialBatchItemFailure() {
            return onPartialBatchItemFailure;
        }

        public final void setOnPartialBatchItemFailure(String onPartialBatchItemFailure) {
            this.onPartialBatchItemFailure = onPartialBatchItemFailure;
        }

        @Override
        public final Builder onPartialBatchItemFailure(String onPartialBatchItemFailure) {
            this.onPartialBatchItemFailure = onPartialBatchItemFailure;
            return this;
        }

        @Override
        public final Builder onPartialBatchItemFailure(OnPartialBatchItemFailureStreams onPartialBatchItemFailure) {
            this.onPartialBatchItemFailure(onPartialBatchItemFailure == null ? null : onPartialBatchItemFailure.toString());
            return this;
        }

        public final Integer getMaximumBatchingWindowInSeconds() {
            return maximumBatchingWindowInSeconds;
        }

        public final void setMaximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
        }

        @Override
        public final Builder maximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
            return this;
        }

        public final Integer getMaximumRecordAgeInSeconds() {
            return maximumRecordAgeInSeconds;
        }

        public final void setMaximumRecordAgeInSeconds(Integer maximumRecordAgeInSeconds) {
            this.maximumRecordAgeInSeconds = maximumRecordAgeInSeconds;
        }

        @Override
        public final Builder maximumRecordAgeInSeconds(Integer maximumRecordAgeInSeconds) {
            this.maximumRecordAgeInSeconds = maximumRecordAgeInSeconds;
            return this;
        }

        public final Integer getMaximumRetryAttempts() {
            return maximumRetryAttempts;
        }

        public final void setMaximumRetryAttempts(Integer maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
        }

        @Override
        public final Builder maximumRetryAttempts(Integer maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
            return this;
        }

        public final Integer getParallelizationFactor() {
            return parallelizationFactor;
        }

        public final void setParallelizationFactor(Integer parallelizationFactor) {
            this.parallelizationFactor = parallelizationFactor;
        }

        @Override
        public final Builder parallelizationFactor(Integer parallelizationFactor) {
            this.parallelizationFactor = parallelizationFactor;
            return this;
        }

        @Override
        public UpdatePipeSourceDynamoDBStreamParameters build() {
            return new UpdatePipeSourceDynamoDBStreamParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
