/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.polly.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartSpeechSynthesisTaskRequest extends PollyRequest implements
        ToCopyableBuilder<StartSpeechSynthesisTaskRequest.Builder, StartSpeechSynthesisTaskRequest> {
    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(StartSpeechSynthesisTaskRequest::engineAsString)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(StartSpeechSynthesisTaskRequest::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<List<String>> LEXICON_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LexiconNames")
            .getter(getter(StartSpeechSynthesisTaskRequest::lexiconNames))
            .setter(setter(Builder::lexiconNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LexiconNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OUTPUT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputFormat").getter(getter(StartSpeechSynthesisTaskRequest::outputFormatAsString))
            .setter(setter(Builder::outputFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputFormat").build()).build();

    private static final SdkField<String> OUTPUT_S3_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputS3BucketName").getter(getter(StartSpeechSynthesisTaskRequest::outputS3BucketName))
            .setter(setter(Builder::outputS3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputS3BucketName").build())
            .build();

    private static final SdkField<String> OUTPUT_S3_KEY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputS3KeyPrefix").getter(getter(StartSpeechSynthesisTaskRequest::outputS3KeyPrefix))
            .setter(setter(Builder::outputS3KeyPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputS3KeyPrefix").build()).build();

    private static final SdkField<String> SAMPLE_RATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SampleRate").getter(getter(StartSpeechSynthesisTaskRequest::sampleRate))
            .setter(setter(Builder::sampleRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleRate").build()).build();

    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnsTopicArn").getter(getter(StartSpeechSynthesisTaskRequest::snsTopicArn))
            .setter(setter(Builder::snsTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()).build();

    private static final SdkField<List<String>> SPEECH_MARK_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SpeechMarkTypes")
            .getter(getter(StartSpeechSynthesisTaskRequest::speechMarkTypesAsStrings))
            .setter(setter(Builder::speechMarkTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpeechMarkTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Text")
            .getter(getter(StartSpeechSynthesisTaskRequest::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()).build();

    private static final SdkField<String> TEXT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TextType").getter(getter(StartSpeechSynthesisTaskRequest::textTypeAsString))
            .setter(setter(Builder::textType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextType").build()).build();

    private static final SdkField<String> VOICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VoiceId").getter(getter(StartSpeechSynthesisTaskRequest::voiceIdAsString))
            .setter(setter(Builder::voiceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_FIELD,
            LANGUAGE_CODE_FIELD, LEXICON_NAMES_FIELD, OUTPUT_FORMAT_FIELD, OUTPUT_S3_BUCKET_NAME_FIELD,
            OUTPUT_S3_KEY_PREFIX_FIELD, SAMPLE_RATE_FIELD, SNS_TOPIC_ARN_FIELD, SPEECH_MARK_TYPES_FIELD, TEXT_FIELD,
            TEXT_TYPE_FIELD, VOICE_ID_FIELD));

    private final String engine;

    private final String languageCode;

    private final List<String> lexiconNames;

    private final String outputFormat;

    private final String outputS3BucketName;

    private final String outputS3KeyPrefix;

    private final String sampleRate;

    private final String snsTopicArn;

    private final List<String> speechMarkTypes;

    private final String text;

    private final String textType;

    private final String voiceId;

    private StartSpeechSynthesisTaskRequest(BuilderImpl builder) {
        super(builder);
        this.engine = builder.engine;
        this.languageCode = builder.languageCode;
        this.lexiconNames = builder.lexiconNames;
        this.outputFormat = builder.outputFormat;
        this.outputS3BucketName = builder.outputS3BucketName;
        this.outputS3KeyPrefix = builder.outputS3KeyPrefix;
        this.sampleRate = builder.sampleRate;
        this.snsTopicArn = builder.snsTopicArn;
        this.speechMarkTypes = builder.speechMarkTypes;
        this.text = builder.text;
        this.textType = builder.textType;
        this.voiceId = builder.voiceId;
    }

    /**
     * <p>
     * Specifies the engine (<code>standard</code> or <code>neural</code>) for Amazon Polly to use when processing input
     * text for speech synthesis. Using a voice that is not supported for the engine selected will result in an error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engine} will
     * return {@link Engine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineAsString}.
     * </p>
     * 
     * @return Specifies the engine (<code>standard</code> or <code>neural</code>) for Amazon Polly to use when
     *         processing input text for speech synthesis. Using a voice that is not supported for the engine selected
     *         will result in an error.
     * @see Engine
     */
    public final Engine engine() {
        return Engine.fromValue(engine);
    }

    /**
     * <p>
     * Specifies the engine (<code>standard</code> or <code>neural</code>) for Amazon Polly to use when processing input
     * text for speech synthesis. Using a voice that is not supported for the engine selected will result in an error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engine} will
     * return {@link Engine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineAsString}.
     * </p>
     * 
     * @return Specifies the engine (<code>standard</code> or <code>neural</code>) for Amazon Polly to use when
     *         processing input text for speech synthesis. Using a voice that is not supported for the engine selected
     *         will result in an error.
     * @see Engine
     */
    public final String engineAsString() {
        return engine;
    }

    /**
     * <p>
     * Optional language code for the Speech Synthesis request. This is only necessary if using a bilingual voice, such
     * as Aditi, which can be used for either Indian English (en-IN) or Hindi (hi-IN).
     * </p>
     * <p>
     * If a bilingual voice is used and no language code is specified, Amazon Polly will use the default language of the
     * bilingual voice. The default language for any voice is the one returned by the <a
     * href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation for the
     * <code>LanguageCode</code> parameter. For example, if no language code is specified, Aditi will use Indian English
     * rather than Hindi.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return Optional language code for the Speech Synthesis request. This is only necessary if using a bilingual
     *         voice, such as Aditi, which can be used for either Indian English (en-IN) or Hindi (hi-IN). </p>
     *         <p>
     *         If a bilingual voice is used and no language code is specified, Amazon Polly will use the default
     *         language of the bilingual voice. The default language for any voice is the one returned by the <a
     *         href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation
     *         for the <code>LanguageCode</code> parameter. For example, if no language code is specified, Aditi will
     *         use Indian English rather than Hindi.
     * @see LanguageCode
     */
    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * Optional language code for the Speech Synthesis request. This is only necessary if using a bilingual voice, such
     * as Aditi, which can be used for either Indian English (en-IN) or Hindi (hi-IN).
     * </p>
     * <p>
     * If a bilingual voice is used and no language code is specified, Amazon Polly will use the default language of the
     * bilingual voice. The default language for any voice is the one returned by the <a
     * href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation for the
     * <code>LanguageCode</code> parameter. For example, if no language code is specified, Aditi will use Indian English
     * rather than Hindi.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return Optional language code for the Speech Synthesis request. This is only necessary if using a bilingual
     *         voice, such as Aditi, which can be used for either Indian English (en-IN) or Hindi (hi-IN). </p>
     *         <p>
     *         If a bilingual voice is used and no language code is specified, Amazon Polly will use the default
     *         language of the bilingual voice. The default language for any voice is the one returned by the <a
     *         href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation
     *         for the <code>LanguageCode</code> parameter. For example, if no language code is specified, Aditi will
     *         use Indian English rather than Hindi.
     * @see LanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * Returns true if the LexiconNames property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasLexiconNames() {
        return lexiconNames != null && !(lexiconNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of one or more pronunciation lexicon names you want the service to apply during synthesis. Lexicons are
     * applied only if the language of the lexicon is the same as the language of the voice.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLexiconNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of one or more pronunciation lexicon names you want the service to apply during synthesis. Lexicons
     *         are applied only if the language of the lexicon is the same as the language of the voice.
     */
    public final List<String> lexiconNames() {
        return lexiconNames;
    }

    /**
     * <p>
     * The format in which the returned output will be encoded. For audio stream, this will be mp3, ogg_vorbis, or pcm.
     * For speech marks, this will be json.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputFormat} will
     * return {@link OutputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputFormatAsString}.
     * </p>
     * 
     * @return The format in which the returned output will be encoded. For audio stream, this will be mp3, ogg_vorbis,
     *         or pcm. For speech marks, this will be json.
     * @see OutputFormat
     */
    public final OutputFormat outputFormat() {
        return OutputFormat.fromValue(outputFormat);
    }

    /**
     * <p>
     * The format in which the returned output will be encoded. For audio stream, this will be mp3, ogg_vorbis, or pcm.
     * For speech marks, this will be json.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputFormat} will
     * return {@link OutputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputFormatAsString}.
     * </p>
     * 
     * @return The format in which the returned output will be encoded. For audio stream, this will be mp3, ogg_vorbis,
     *         or pcm. For speech marks, this will be json.
     * @see OutputFormat
     */
    public final String outputFormatAsString() {
        return outputFormat;
    }

    /**
     * <p>
     * Amazon S3 bucket name to which the output file will be saved.
     * </p>
     * 
     * @return Amazon S3 bucket name to which the output file will be saved.
     */
    public final String outputS3BucketName() {
        return outputS3BucketName;
    }

    /**
     * <p>
     * The Amazon S3 key prefix for the output speech file.
     * </p>
     * 
     * @return The Amazon S3 key prefix for the output speech file.
     */
    public final String outputS3KeyPrefix() {
        return outputS3KeyPrefix;
    }

    /**
     * <p>
     * The audio frequency specified in Hz.
     * </p>
     * <p>
     * The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050", and "24000". The default value for standard
     * voices is "22050". The default value for neural voices is "24000".
     * </p>
     * <p>
     * Valid values for pcm are "8000" and "16000" The default value is "16000".
     * </p>
     * 
     * @return The audio frequency specified in Hz.</p>
     *         <p>
     *         The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050", and "24000". The default value for
     *         standard voices is "22050". The default value for neural voices is "24000".
     *         </p>
     *         <p>
     *         Valid values for pcm are "8000" and "16000" The default value is "16000".
     */
    public final String sampleRate() {
        return sampleRate;
    }

    /**
     * <p>
     * ARN for the SNS topic optionally used for providing status notification for a speech synthesis task.
     * </p>
     * 
     * @return ARN for the SNS topic optionally used for providing status notification for a speech synthesis task.
     */
    public final String snsTopicArn() {
        return snsTopicArn;
    }

    /**
     * <p>
     * The type of speech marks returned for the input text.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSpeechMarkTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The type of speech marks returned for the input text.
     */
    public final List<SpeechMarkType> speechMarkTypes() {
        return SpeechMarkTypeListCopier.copyStringToEnum(speechMarkTypes);
    }

    /**
     * Returns true if the SpeechMarkTypes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSpeechMarkTypes() {
        return speechMarkTypes != null && !(speechMarkTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The type of speech marks returned for the input text.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSpeechMarkTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The type of speech marks returned for the input text.
     */
    public final List<String> speechMarkTypesAsStrings() {
        return speechMarkTypes;
    }

    /**
     * <p>
     * The input text to synthesize. If you specify ssml as the TextType, follow the SSML format for the input text.
     * </p>
     * 
     * @return The input text to synthesize. If you specify ssml as the TextType, follow the SSML format for the input
     *         text.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * Specifies whether the input text is plain text or SSML. The default value is plain text.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #textType} will
     * return {@link TextType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #textTypeAsString}.
     * </p>
     * 
     * @return Specifies whether the input text is plain text or SSML. The default value is plain text.
     * @see TextType
     */
    public final TextType textType() {
        return TextType.fromValue(textType);
    }

    /**
     * <p>
     * Specifies whether the input text is plain text or SSML. The default value is plain text.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #textType} will
     * return {@link TextType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #textTypeAsString}.
     * </p>
     * 
     * @return Specifies whether the input text is plain text or SSML. The default value is plain text.
     * @see TextType
     */
    public final String textTypeAsString() {
        return textType;
    }

    /**
     * <p>
     * Voice ID to use for the synthesis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #voiceId} will
     * return {@link VoiceId#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #voiceIdAsString}.
     * </p>
     * 
     * @return Voice ID to use for the synthesis.
     * @see VoiceId
     */
    public final VoiceId voiceId() {
        return VoiceId.fromValue(voiceId);
    }

    /**
     * <p>
     * Voice ID to use for the synthesis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #voiceId} will
     * return {@link VoiceId#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #voiceIdAsString}.
     * </p>
     * 
     * @return Voice ID to use for the synthesis.
     * @see VoiceId
     */
    public final String voiceIdAsString() {
        return voiceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(engineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasLexiconNames() ? lexiconNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(outputFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(outputS3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(outputS3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(sampleRate());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSpeechMarkTypes() ? speechMarkTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(textTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(voiceIdAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSpeechSynthesisTaskRequest)) {
            return false;
        }
        StartSpeechSynthesisTaskRequest other = (StartSpeechSynthesisTaskRequest) obj;
        return Objects.equals(engineAsString(), other.engineAsString())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && hasLexiconNames() == other.hasLexiconNames() && Objects.equals(lexiconNames(), other.lexiconNames())
                && Objects.equals(outputFormatAsString(), other.outputFormatAsString())
                && Objects.equals(outputS3BucketName(), other.outputS3BucketName())
                && Objects.equals(outputS3KeyPrefix(), other.outputS3KeyPrefix())
                && Objects.equals(sampleRate(), other.sampleRate()) && Objects.equals(snsTopicArn(), other.snsTopicArn())
                && hasSpeechMarkTypes() == other.hasSpeechMarkTypes()
                && Objects.equals(speechMarkTypesAsStrings(), other.speechMarkTypesAsStrings())
                && Objects.equals(text(), other.text()) && Objects.equals(textTypeAsString(), other.textTypeAsString())
                && Objects.equals(voiceIdAsString(), other.voiceIdAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartSpeechSynthesisTaskRequest").add("Engine", engineAsString())
                .add("LanguageCode", languageCodeAsString()).add("LexiconNames", hasLexiconNames() ? lexiconNames() : null)
                .add("OutputFormat", outputFormatAsString()).add("OutputS3BucketName", outputS3BucketName())
                .add("OutputS3KeyPrefix", outputS3KeyPrefix()).add("SampleRate", sampleRate()).add("SnsTopicArn", snsTopicArn())
                .add("SpeechMarkTypes", hasSpeechMarkTypes() ? speechMarkTypesAsStrings() : null).add("Text", text())
                .add("TextType", textTypeAsString()).add("VoiceId", voiceIdAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Engine":
            return Optional.ofNullable(clazz.cast(engineAsString()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "LexiconNames":
            return Optional.ofNullable(clazz.cast(lexiconNames()));
        case "OutputFormat":
            return Optional.ofNullable(clazz.cast(outputFormatAsString()));
        case "OutputS3BucketName":
            return Optional.ofNullable(clazz.cast(outputS3BucketName()));
        case "OutputS3KeyPrefix":
            return Optional.ofNullable(clazz.cast(outputS3KeyPrefix()));
        case "SampleRate":
            return Optional.ofNullable(clazz.cast(sampleRate()));
        case "SnsTopicArn":
            return Optional.ofNullable(clazz.cast(snsTopicArn()));
        case "SpeechMarkTypes":
            return Optional.ofNullable(clazz.cast(speechMarkTypesAsStrings()));
        case "Text":
            return Optional.ofNullable(clazz.cast(text()));
        case "TextType":
            return Optional.ofNullable(clazz.cast(textTypeAsString()));
        case "VoiceId":
            return Optional.ofNullable(clazz.cast(voiceIdAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartSpeechSynthesisTaskRequest, T> g) {
        return obj -> g.apply((StartSpeechSynthesisTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PollyRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartSpeechSynthesisTaskRequest> {
        /**
         * <p>
         * Specifies the engine (<code>standard</code> or <code>neural</code>) for Amazon Polly to use when processing
         * input text for speech synthesis. Using a voice that is not supported for the engine selected will result in
         * an error.
         * </p>
         * 
         * @param engine
         *        Specifies the engine (<code>standard</code> or <code>neural</code>) for Amazon Polly to use when
         *        processing input text for speech synthesis. Using a voice that is not supported for the engine
         *        selected will result in an error.
         * @see Engine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Engine
         */
        Builder engine(String engine);

        /**
         * <p>
         * Specifies the engine (<code>standard</code> or <code>neural</code>) for Amazon Polly to use when processing
         * input text for speech synthesis. Using a voice that is not supported for the engine selected will result in
         * an error.
         * </p>
         * 
         * @param engine
         *        Specifies the engine (<code>standard</code> or <code>neural</code>) for Amazon Polly to use when
         *        processing input text for speech synthesis. Using a voice that is not supported for the engine
         *        selected will result in an error.
         * @see Engine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Engine
         */
        Builder engine(Engine engine);

        /**
         * <p>
         * Optional language code for the Speech Synthesis request. This is only necessary if using a bilingual voice,
         * such as Aditi, which can be used for either Indian English (en-IN) or Hindi (hi-IN).
         * </p>
         * <p>
         * If a bilingual voice is used and no language code is specified, Amazon Polly will use the default language of
         * the bilingual voice. The default language for any voice is the one returned by the <a
         * href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation for
         * the <code>LanguageCode</code> parameter. For example, if no language code is specified, Aditi will use Indian
         * English rather than Hindi.
         * </p>
         * 
         * @param languageCode
         *        Optional language code for the Speech Synthesis request. This is only necessary if using a bilingual
         *        voice, such as Aditi, which can be used for either Indian English (en-IN) or Hindi (hi-IN). </p>
         *        <p>
         *        If a bilingual voice is used and no language code is specified, Amazon Polly will use the default
         *        language of the bilingual voice. The default language for any voice is the one returned by the <a
         *        href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a>
         *        operation for the <code>LanguageCode</code> parameter. For example, if no language code is specified,
         *        Aditi will use Indian English rather than Hindi.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * Optional language code for the Speech Synthesis request. This is only necessary if using a bilingual voice,
         * such as Aditi, which can be used for either Indian English (en-IN) or Hindi (hi-IN).
         * </p>
         * <p>
         * If a bilingual voice is used and no language code is specified, Amazon Polly will use the default language of
         * the bilingual voice. The default language for any voice is the one returned by the <a
         * href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation for
         * the <code>LanguageCode</code> parameter. For example, if no language code is specified, Aditi will use Indian
         * English rather than Hindi.
         * </p>
         * 
         * @param languageCode
         *        Optional language code for the Speech Synthesis request. This is only necessary if using a bilingual
         *        voice, such as Aditi, which can be used for either Indian English (en-IN) or Hindi (hi-IN). </p>
         *        <p>
         *        If a bilingual voice is used and no language code is specified, Amazon Polly will use the default
         *        language of the bilingual voice. The default language for any voice is the one returned by the <a
         *        href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a>
         *        operation for the <code>LanguageCode</code> parameter. For example, if no language code is specified,
         *        Aditi will use Indian English rather than Hindi.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * List of one or more pronunciation lexicon names you want the service to apply during synthesis. Lexicons are
         * applied only if the language of the lexicon is the same as the language of the voice.
         * </p>
         * 
         * @param lexiconNames
         *        List of one or more pronunciation lexicon names you want the service to apply during synthesis.
         *        Lexicons are applied only if the language of the lexicon is the same as the language of the voice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lexiconNames(Collection<String> lexiconNames);

        /**
         * <p>
         * List of one or more pronunciation lexicon names you want the service to apply during synthesis. Lexicons are
         * applied only if the language of the lexicon is the same as the language of the voice.
         * </p>
         * 
         * @param lexiconNames
         *        List of one or more pronunciation lexicon names you want the service to apply during synthesis.
         *        Lexicons are applied only if the language of the lexicon is the same as the language of the voice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lexiconNames(String... lexiconNames);

        /**
         * <p>
         * The format in which the returned output will be encoded. For audio stream, this will be mp3, ogg_vorbis, or
         * pcm. For speech marks, this will be json.
         * </p>
         * 
         * @param outputFormat
         *        The format in which the returned output will be encoded. For audio stream, this will be mp3,
         *        ogg_vorbis, or pcm. For speech marks, this will be json.
         * @see OutputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputFormat
         */
        Builder outputFormat(String outputFormat);

        /**
         * <p>
         * The format in which the returned output will be encoded. For audio stream, this will be mp3, ogg_vorbis, or
         * pcm. For speech marks, this will be json.
         * </p>
         * 
         * @param outputFormat
         *        The format in which the returned output will be encoded. For audio stream, this will be mp3,
         *        ogg_vorbis, or pcm. For speech marks, this will be json.
         * @see OutputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputFormat
         */
        Builder outputFormat(OutputFormat outputFormat);

        /**
         * <p>
         * Amazon S3 bucket name to which the output file will be saved.
         * </p>
         * 
         * @param outputS3BucketName
         *        Amazon S3 bucket name to which the output file will be saved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3BucketName(String outputS3BucketName);

        /**
         * <p>
         * The Amazon S3 key prefix for the output speech file.
         * </p>
         * 
         * @param outputS3KeyPrefix
         *        The Amazon S3 key prefix for the output speech file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3KeyPrefix(String outputS3KeyPrefix);

        /**
         * <p>
         * The audio frequency specified in Hz.
         * </p>
         * <p>
         * The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050", and "24000". The default value for
         * standard voices is "22050". The default value for neural voices is "24000".
         * </p>
         * <p>
         * Valid values for pcm are "8000" and "16000" The default value is "16000".
         * </p>
         * 
         * @param sampleRate
         *        The audio frequency specified in Hz.</p>
         *        <p>
         *        The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050", and "24000". The default value
         *        for standard voices is "22050". The default value for neural voices is "24000".
         *        </p>
         *        <p>
         *        Valid values for pcm are "8000" and "16000" The default value is "16000".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleRate(String sampleRate);

        /**
         * <p>
         * ARN for the SNS topic optionally used for providing status notification for a speech synthesis task.
         * </p>
         * 
         * @param snsTopicArn
         *        ARN for the SNS topic optionally used for providing status notification for a speech synthesis task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArn(String snsTopicArn);

        /**
         * <p>
         * The type of speech marks returned for the input text.
         * </p>
         * 
         * @param speechMarkTypes
         *        The type of speech marks returned for the input text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder speechMarkTypesWithStrings(Collection<String> speechMarkTypes);

        /**
         * <p>
         * The type of speech marks returned for the input text.
         * </p>
         * 
         * @param speechMarkTypes
         *        The type of speech marks returned for the input text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder speechMarkTypesWithStrings(String... speechMarkTypes);

        /**
         * <p>
         * The type of speech marks returned for the input text.
         * </p>
         * 
         * @param speechMarkTypes
         *        The type of speech marks returned for the input text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder speechMarkTypes(Collection<SpeechMarkType> speechMarkTypes);

        /**
         * <p>
         * The type of speech marks returned for the input text.
         * </p>
         * 
         * @param speechMarkTypes
         *        The type of speech marks returned for the input text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder speechMarkTypes(SpeechMarkType... speechMarkTypes);

        /**
         * <p>
         * The input text to synthesize. If you specify ssml as the TextType, follow the SSML format for the input text.
         * </p>
         * 
         * @param text
         *        The input text to synthesize. If you specify ssml as the TextType, follow the SSML format for the
         *        input text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * Specifies whether the input text is plain text or SSML. The default value is plain text.
         * </p>
         * 
         * @param textType
         *        Specifies whether the input text is plain text or SSML. The default value is plain text.
         * @see TextType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TextType
         */
        Builder textType(String textType);

        /**
         * <p>
         * Specifies whether the input text is plain text or SSML. The default value is plain text.
         * </p>
         * 
         * @param textType
         *        Specifies whether the input text is plain text or SSML. The default value is plain text.
         * @see TextType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TextType
         */
        Builder textType(TextType textType);

        /**
         * <p>
         * Voice ID to use for the synthesis.
         * </p>
         * 
         * @param voiceId
         *        Voice ID to use for the synthesis.
         * @see VoiceId
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VoiceId
         */
        Builder voiceId(String voiceId);

        /**
         * <p>
         * Voice ID to use for the synthesis.
         * </p>
         * 
         * @param voiceId
         *        Voice ID to use for the synthesis.
         * @see VoiceId
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VoiceId
         */
        Builder voiceId(VoiceId voiceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PollyRequest.BuilderImpl implements Builder {
        private String engine;

        private String languageCode;

        private List<String> lexiconNames = DefaultSdkAutoConstructList.getInstance();

        private String outputFormat;

        private String outputS3BucketName;

        private String outputS3KeyPrefix;

        private String sampleRate;

        private String snsTopicArn;

        private List<String> speechMarkTypes = DefaultSdkAutoConstructList.getInstance();

        private String text;

        private String textType;

        private String voiceId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSpeechSynthesisTaskRequest model) {
            super(model);
            engine(model.engine);
            languageCode(model.languageCode);
            lexiconNames(model.lexiconNames);
            outputFormat(model.outputFormat);
            outputS3BucketName(model.outputS3BucketName);
            outputS3KeyPrefix(model.outputS3KeyPrefix);
            sampleRate(model.sampleRate);
            snsTopicArn(model.snsTopicArn);
            speechMarkTypesWithStrings(model.speechMarkTypes);
            text(model.text);
            textType(model.textType);
            voiceId(model.voiceId);
        }

        public final String getEngine() {
            return engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        @Override
        public final Builder engine(Engine engine) {
            this.engine(engine == null ? null : engine.toString());
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final Collection<String> getLexiconNames() {
            if (lexiconNames instanceof SdkAutoConstructList) {
                return null;
            }
            return lexiconNames;
        }

        @Override
        public final Builder lexiconNames(Collection<String> lexiconNames) {
            this.lexiconNames = LexiconNameListCopier.copy(lexiconNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lexiconNames(String... lexiconNames) {
            lexiconNames(Arrays.asList(lexiconNames));
            return this;
        }

        public final void setLexiconNames(Collection<String> lexiconNames) {
            this.lexiconNames = LexiconNameListCopier.copy(lexiconNames);
        }

        public final String getOutputFormat() {
            return outputFormat;
        }

        @Override
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        @Override
        public final Builder outputFormat(OutputFormat outputFormat) {
            this.outputFormat(outputFormat == null ? null : outputFormat.toString());
            return this;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        public final String getOutputS3BucketName() {
            return outputS3BucketName;
        }

        @Override
        public final Builder outputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
            return this;
        }

        public final void setOutputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
        }

        public final String getOutputS3KeyPrefix() {
            return outputS3KeyPrefix;
        }

        @Override
        public final Builder outputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
            return this;
        }

        public final void setOutputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
        }

        public final String getSampleRate() {
            return sampleRate;
        }

        @Override
        public final Builder sampleRate(String sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final void setSampleRate(String sampleRate) {
            this.sampleRate = sampleRate;
        }

        public final String getSnsTopicArn() {
            return snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        public final Collection<String> getSpeechMarkTypes() {
            if (speechMarkTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return speechMarkTypes;
        }

        @Override
        public final Builder speechMarkTypesWithStrings(Collection<String> speechMarkTypes) {
            this.speechMarkTypes = SpeechMarkTypeListCopier.copy(speechMarkTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder speechMarkTypesWithStrings(String... speechMarkTypes) {
            speechMarkTypesWithStrings(Arrays.asList(speechMarkTypes));
            return this;
        }

        @Override
        public final Builder speechMarkTypes(Collection<SpeechMarkType> speechMarkTypes) {
            this.speechMarkTypes = SpeechMarkTypeListCopier.copyEnumToString(speechMarkTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder speechMarkTypes(SpeechMarkType... speechMarkTypes) {
            speechMarkTypes(Arrays.asList(speechMarkTypes));
            return this;
        }

        public final void setSpeechMarkTypes(Collection<String> speechMarkTypes) {
            this.speechMarkTypes = SpeechMarkTypeListCopier.copy(speechMarkTypes);
        }

        public final String getText() {
            return text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final void setText(String text) {
            this.text = text;
        }

        public final String getTextType() {
            return textType;
        }

        @Override
        public final Builder textType(String textType) {
            this.textType = textType;
            return this;
        }

        @Override
        public final Builder textType(TextType textType) {
            this.textType(textType == null ? null : textType.toString());
            return this;
        }

        public final void setTextType(String textType) {
            this.textType = textType;
        }

        public final String getVoiceId() {
            return voiceId;
        }

        @Override
        public final Builder voiceId(String voiceId) {
            this.voiceId = voiceId;
            return this;
        }

        @Override
        public final Builder voiceId(VoiceId voiceId) {
            this.voiceId(voiceId == null ? null : voiceId.toString());
            return this;
        }

        public final void setVoiceId(String voiceId) {
            this.voiceId = voiceId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartSpeechSynthesisTaskRequest build() {
            return new StartSpeechSynthesisTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
