/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.polly.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVoicesRequest extends PollyRequest implements
        ToCopyableBuilder<DescribeVoicesRequest.Builder, DescribeVoicesRequest> {
    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(DescribeVoicesRequest::engineAsString)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Engine").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(DescribeVoicesRequest::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("LanguageCode").build()).build();

    private static final SdkField<Boolean> INCLUDE_ADDITIONAL_LANGUAGE_CODES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeAdditionalLanguageCodes")
            .getter(getter(DescribeVoicesRequest::includeAdditionalLanguageCodes))
            .setter(setter(Builder::includeAdditionalLanguageCodes))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("IncludeAdditionalLanguageCodes")
                    .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeVoicesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_FIELD,
            LANGUAGE_CODE_FIELD, INCLUDE_ADDITIONAL_LANGUAGE_CODES_FIELD, NEXT_TOKEN_FIELD));

    private final String engine;

    private final String languageCode;

    private final Boolean includeAdditionalLanguageCodes;

    private final String nextToken;

    private DescribeVoicesRequest(BuilderImpl builder) {
        super(builder);
        this.engine = builder.engine;
        this.languageCode = builder.languageCode;
        this.includeAdditionalLanguageCodes = builder.includeAdditionalLanguageCodes;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Specifies the engine (<code>standard</code>, <code>neural</code>, <code>long-form</code> or
     * <code>generative</code>) used by Amazon Polly when processing input text for speech synthesis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engine} will
     * return {@link Engine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineAsString}.
     * </p>
     * 
     * @return Specifies the engine (<code>standard</code>, <code>neural</code>, <code>long-form</code> or
     *         <code>generative</code>) used by Amazon Polly when processing input text for speech synthesis.
     * @see Engine
     */
    public final Engine engine() {
        return Engine.fromValue(engine);
    }

    /**
     * <p>
     * Specifies the engine (<code>standard</code>, <code>neural</code>, <code>long-form</code> or
     * <code>generative</code>) used by Amazon Polly when processing input text for speech synthesis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engine} will
     * return {@link Engine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineAsString}.
     * </p>
     * 
     * @return Specifies the engine (<code>standard</code>, <code>neural</code>, <code>long-form</code> or
     *         <code>generative</code>) used by Amazon Polly when processing input text for speech synthesis.
     * @see Engine
     */
    public final String engineAsString() {
        return engine;
    }

    /**
     * <p>
     * The language identification tag (ISO 639 code for the language name-ISO 3166 country code) for filtering the list
     * of voices returned. If you don't specify this optional parameter, all available voices are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language identification tag (ISO 639 code for the language name-ISO 3166 country code) for filtering
     *         the list of voices returned. If you don't specify this optional parameter, all available voices are
     *         returned.
     * @see LanguageCode
     */
    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language identification tag (ISO 639 code for the language name-ISO 3166 country code) for filtering the list
     * of voices returned. If you don't specify this optional parameter, all available voices are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language identification tag (ISO 639 code for the language name-ISO 3166 country code) for filtering
     *         the list of voices returned. If you don't specify this optional parameter, all available voices are
     *         returned.
     * @see LanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * Boolean value indicating whether to return any bilingual voices that use the specified language as an additional
     * language. For instance, if you request all languages that use US English (es-US), and there is an Italian voice
     * that speaks both Italian (it-IT) and US English, that voice will be included if you specify <code>yes</code> but
     * not if you specify <code>no</code>.
     * </p>
     * 
     * @return Boolean value indicating whether to return any bilingual voices that use the specified language as an
     *         additional language. For instance, if you request all languages that use US English (es-US), and there is
     *         an Italian voice that speaks both Italian (it-IT) and US English, that voice will be included if you
     *         specify <code>yes</code> but not if you specify <code>no</code>.
     */
    public final Boolean includeAdditionalLanguageCodes() {
        return includeAdditionalLanguageCodes;
    }

    /**
     * <p>
     * An opaque pagination token returned from the previous <code>DescribeVoices</code> operation. If present, this
     * indicates where to continue the listing.
     * </p>
     * 
     * @return An opaque pagination token returned from the previous <code>DescribeVoices</code> operation. If present,
     *         this indicates where to continue the listing.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(engineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(includeAdditionalLanguageCodes());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVoicesRequest)) {
            return false;
        }
        DescribeVoicesRequest other = (DescribeVoicesRequest) obj;
        return Objects.equals(engineAsString(), other.engineAsString())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(includeAdditionalLanguageCodes(), other.includeAdditionalLanguageCodes())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeVoicesRequest").add("Engine", engineAsString())
                .add("LanguageCode", languageCodeAsString())
                .add("IncludeAdditionalLanguageCodes", includeAdditionalLanguageCodes()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Engine":
            return Optional.ofNullable(clazz.cast(engineAsString()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "IncludeAdditionalLanguageCodes":
            return Optional.ofNullable(clazz.cast(includeAdditionalLanguageCodes()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVoicesRequest, T> g) {
        return obj -> g.apply((DescribeVoicesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PollyRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeVoicesRequest> {
        /**
         * <p>
         * Specifies the engine (<code>standard</code>, <code>neural</code>, <code>long-form</code> or
         * <code>generative</code>) used by Amazon Polly when processing input text for speech synthesis.
         * </p>
         * 
         * @param engine
         *        Specifies the engine (<code>standard</code>, <code>neural</code>, <code>long-form</code> or
         *        <code>generative</code>) used by Amazon Polly when processing input text for speech synthesis.
         * @see Engine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Engine
         */
        Builder engine(String engine);

        /**
         * <p>
         * Specifies the engine (<code>standard</code>, <code>neural</code>, <code>long-form</code> or
         * <code>generative</code>) used by Amazon Polly when processing input text for speech synthesis.
         * </p>
         * 
         * @param engine
         *        Specifies the engine (<code>standard</code>, <code>neural</code>, <code>long-form</code> or
         *        <code>generative</code>) used by Amazon Polly when processing input text for speech synthesis.
         * @see Engine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Engine
         */
        Builder engine(Engine engine);

        /**
         * <p>
         * The language identification tag (ISO 639 code for the language name-ISO 3166 country code) for filtering the
         * list of voices returned. If you don't specify this optional parameter, all available voices are returned.
         * </p>
         * 
         * @param languageCode
         *        The language identification tag (ISO 639 code for the language name-ISO 3166 country code) for
         *        filtering the list of voices returned. If you don't specify this optional parameter, all available
         *        voices are returned.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language identification tag (ISO 639 code for the language name-ISO 3166 country code) for filtering the
         * list of voices returned. If you don't specify this optional parameter, all available voices are returned.
         * </p>
         * 
         * @param languageCode
         *        The language identification tag (ISO 639 code for the language name-ISO 3166 country code) for
         *        filtering the list of voices returned. If you don't specify this optional parameter, all available
         *        voices are returned.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * Boolean value indicating whether to return any bilingual voices that use the specified language as an
         * additional language. For instance, if you request all languages that use US English (es-US), and there is an
         * Italian voice that speaks both Italian (it-IT) and US English, that voice will be included if you specify
         * <code>yes</code> but not if you specify <code>no</code>.
         * </p>
         * 
         * @param includeAdditionalLanguageCodes
         *        Boolean value indicating whether to return any bilingual voices that use the specified language as an
         *        additional language. For instance, if you request all languages that use US English (es-US), and there
         *        is an Italian voice that speaks both Italian (it-IT) and US English, that voice will be included if
         *        you specify <code>yes</code> but not if you specify <code>no</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeAdditionalLanguageCodes(Boolean includeAdditionalLanguageCodes);

        /**
         * <p>
         * An opaque pagination token returned from the previous <code>DescribeVoices</code> operation. If present, this
         * indicates where to continue the listing.
         * </p>
         * 
         * @param nextToken
         *        An opaque pagination token returned from the previous <code>DescribeVoices</code> operation. If
         *        present, this indicates where to continue the listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PollyRequest.BuilderImpl implements Builder {
        private String engine;

        private String languageCode;

        private Boolean includeAdditionalLanguageCodes;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVoicesRequest model) {
            super(model);
            engine(model.engine);
            languageCode(model.languageCode);
            includeAdditionalLanguageCodes(model.includeAdditionalLanguageCodes);
            nextToken(model.nextToken);
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        @Override
        public final Builder engine(Engine engine) {
            this.engine(engine == null ? null : engine.toString());
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final Boolean getIncludeAdditionalLanguageCodes() {
            return includeAdditionalLanguageCodes;
        }

        public final void setIncludeAdditionalLanguageCodes(Boolean includeAdditionalLanguageCodes) {
            this.includeAdditionalLanguageCodes = includeAdditionalLanguageCodes;
        }

        @Override
        public final Builder includeAdditionalLanguageCodes(Boolean includeAdditionalLanguageCodes) {
            this.includeAdditionalLanguageCodes = includeAdditionalLanguageCodes;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeVoicesRequest build() {
            return new DescribeVoicesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
