/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.polly.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains metadata describing the lexicon such as the number of lexemes, language code, and so on. For more
 * information, see <a href="https://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html">Managing Lexicons</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LexiconAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<LexiconAttributes.Builder, LexiconAttributes> {
    private static final SdkField<String> ALPHABET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Alphabet").getter(getter(LexiconAttributes::alphabet)).setter(setter(Builder::alphabet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alphabet").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(LexiconAttributes::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModified").getter(getter(LexiconAttributes::lastModified)).setter(setter(Builder::lastModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build()).build();

    private static final SdkField<String> LEXICON_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LexiconArn").getter(getter(LexiconAttributes::lexiconArn)).setter(setter(Builder::lexiconArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LexiconArn").build()).build();

    private static final SdkField<Integer> LEXEMES_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("LexemesCount").getter(getter(LexiconAttributes::lexemesCount)).setter(setter(Builder::lexemesCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LexemesCount").build()).build();

    private static final SdkField<Integer> SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Size")
            .getter(getter(LexiconAttributes::size)).setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALPHABET_FIELD,
            LANGUAGE_CODE_FIELD, LAST_MODIFIED_FIELD, LEXICON_ARN_FIELD, LEXEMES_COUNT_FIELD, SIZE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String alphabet;

    private final String languageCode;

    private final Instant lastModified;

    private final String lexiconArn;

    private final Integer lexemesCount;

    private final Integer size;

    private LexiconAttributes(BuilderImpl builder) {
        this.alphabet = builder.alphabet;
        this.languageCode = builder.languageCode;
        this.lastModified = builder.lastModified;
        this.lexiconArn = builder.lexiconArn;
        this.lexemesCount = builder.lexemesCount;
        this.size = builder.size;
    }

    /**
     * <p>
     * Phonetic alphabet used in the lexicon. Valid values are <code>ipa</code> and <code>x-sampa</code>.
     * </p>
     * 
     * @return Phonetic alphabet used in the lexicon. Valid values are <code>ipa</code> and <code>x-sampa</code>.
     */
    public final String alphabet() {
        return alphabet;
    }

    /**
     * <p>
     * Language code that the lexicon applies to. A lexicon with a language code such as "en" would be applied to all
     * English languages (en-GB, en-US, en-AUS, en-WLS, and so on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return Language code that the lexicon applies to. A lexicon with a language code such as "en" would be applied
     *         to all English languages (en-GB, en-US, en-AUS, en-WLS, and so on.
     * @see LanguageCode
     */
    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * Language code that the lexicon applies to. A lexicon with a language code such as "en" would be applied to all
     * English languages (en-GB, en-US, en-AUS, en-WLS, and so on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return Language code that the lexicon applies to. A lexicon with a language code such as "en" would be applied
     *         to all English languages (en-GB, en-US, en-AUS, en-WLS, and so on.
     * @see LanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * Date lexicon was last modified (a timestamp value).
     * </p>
     * 
     * @return Date lexicon was last modified (a timestamp value).
     */
    public final Instant lastModified() {
        return lastModified;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the lexicon.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the lexicon.
     */
    public final String lexiconArn() {
        return lexiconArn;
    }

    /**
     * <p>
     * Number of lexemes in the lexicon.
     * </p>
     * 
     * @return Number of lexemes in the lexicon.
     */
    public final Integer lexemesCount() {
        return lexemesCount;
    }

    /**
     * <p>
     * Total size of the lexicon, in characters.
     * </p>
     * 
     * @return Total size of the lexicon, in characters.
     */
    public final Integer size() {
        return size;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alphabet());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(lexiconArn());
        hashCode = 31 * hashCode + Objects.hashCode(lexemesCount());
        hashCode = 31 * hashCode + Objects.hashCode(size());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LexiconAttributes)) {
            return false;
        }
        LexiconAttributes other = (LexiconAttributes) obj;
        return Objects.equals(alphabet(), other.alphabet())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(lastModified(), other.lastModified()) && Objects.equals(lexiconArn(), other.lexiconArn())
                && Objects.equals(lexemesCount(), other.lexemesCount()) && Objects.equals(size(), other.size());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LexiconAttributes").add("Alphabet", alphabet()).add("LanguageCode", languageCodeAsString())
                .add("LastModified", lastModified()).add("LexiconArn", lexiconArn()).add("LexemesCount", lexemesCount())
                .add("Size", size()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Alphabet":
            return Optional.ofNullable(clazz.cast(alphabet()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "LastModified":
            return Optional.ofNullable(clazz.cast(lastModified()));
        case "LexiconArn":
            return Optional.ofNullable(clazz.cast(lexiconArn()));
        case "LexemesCount":
            return Optional.ofNullable(clazz.cast(lexemesCount()));
        case "Size":
            return Optional.ofNullable(clazz.cast(size()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Alphabet", ALPHABET_FIELD);
        map.put("LanguageCode", LANGUAGE_CODE_FIELD);
        map.put("LastModified", LAST_MODIFIED_FIELD);
        map.put("LexiconArn", LEXICON_ARN_FIELD);
        map.put("LexemesCount", LEXEMES_COUNT_FIELD);
        map.put("Size", SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LexiconAttributes, T> g) {
        return obj -> g.apply((LexiconAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LexiconAttributes> {
        /**
         * <p>
         * Phonetic alphabet used in the lexicon. Valid values are <code>ipa</code> and <code>x-sampa</code>.
         * </p>
         * 
         * @param alphabet
         *        Phonetic alphabet used in the lexicon. Valid values are <code>ipa</code> and <code>x-sampa</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alphabet(String alphabet);

        /**
         * <p>
         * Language code that the lexicon applies to. A lexicon with a language code such as "en" would be applied to
         * all English languages (en-GB, en-US, en-AUS, en-WLS, and so on.
         * </p>
         * 
         * @param languageCode
         *        Language code that the lexicon applies to. A lexicon with a language code such as "en" would be
         *        applied to all English languages (en-GB, en-US, en-AUS, en-WLS, and so on.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * Language code that the lexicon applies to. A lexicon with a language code such as "en" would be applied to
         * all English languages (en-GB, en-US, en-AUS, en-WLS, and so on.
         * </p>
         * 
         * @param languageCode
         *        Language code that the lexicon applies to. A lexicon with a language code such as "en" would be
         *        applied to all English languages (en-GB, en-US, en-AUS, en-WLS, and so on.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * Date lexicon was last modified (a timestamp value).
         * </p>
         * 
         * @param lastModified
         *        Date lexicon was last modified (a timestamp value).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(Instant lastModified);

        /**
         * <p>
         * Amazon Resource Name (ARN) of the lexicon.
         * </p>
         * 
         * @param lexiconArn
         *        Amazon Resource Name (ARN) of the lexicon.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lexiconArn(String lexiconArn);

        /**
         * <p>
         * Number of lexemes in the lexicon.
         * </p>
         * 
         * @param lexemesCount
         *        Number of lexemes in the lexicon.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lexemesCount(Integer lexemesCount);

        /**
         * <p>
         * Total size of the lexicon, in characters.
         * </p>
         * 
         * @param size
         *        Total size of the lexicon, in characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Integer size);
    }

    static final class BuilderImpl implements Builder {
        private String alphabet;

        private String languageCode;

        private Instant lastModified;

        private String lexiconArn;

        private Integer lexemesCount;

        private Integer size;

        private BuilderImpl() {
        }

        private BuilderImpl(LexiconAttributes model) {
            alphabet(model.alphabet);
            languageCode(model.languageCode);
            lastModified(model.lastModified);
            lexiconArn(model.lexiconArn);
            lexemesCount(model.lexemesCount);
            size(model.size);
        }

        public final String getAlphabet() {
            return alphabet;
        }

        public final void setAlphabet(String alphabet) {
            this.alphabet = alphabet;
        }

        @Override
        public final Builder alphabet(String alphabet) {
            this.alphabet = alphabet;
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final Instant getLastModified() {
            return lastModified;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final String getLexiconArn() {
            return lexiconArn;
        }

        public final void setLexiconArn(String lexiconArn) {
            this.lexiconArn = lexiconArn;
        }

        @Override
        public final Builder lexiconArn(String lexiconArn) {
            this.lexiconArn = lexiconArn;
            return this;
        }

        public final Integer getLexemesCount() {
            return lexemesCount;
        }

        public final void setLexemesCount(Integer lexemesCount) {
            this.lexemesCount = lexemesCount;
        }

        @Override
        public final Builder lexemesCount(Integer lexemesCount) {
            this.lexemesCount = lexemesCount;
            return this;
        }

        public final Integer getSize() {
            return size;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        @Override
        public LexiconAttributes build() {
            return new LexiconAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
