/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.async.AsyncResponseTransformerUtils;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.polly.PollyAsyncClient;
import software.amazon.awssdk.services.polly.PollyServiceClientConfiguration;
import software.amazon.awssdk.services.polly.internal.PollyServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.polly.model.DeleteLexiconRequest;
import software.amazon.awssdk.services.polly.model.DeleteLexiconResponse;
import software.amazon.awssdk.services.polly.model.DescribeVoicesRequest;
import software.amazon.awssdk.services.polly.model.DescribeVoicesResponse;
import software.amazon.awssdk.services.polly.model.EngineNotSupportedException;
import software.amazon.awssdk.services.polly.model.GetLexiconRequest;
import software.amazon.awssdk.services.polly.model.GetLexiconResponse;
import software.amazon.awssdk.services.polly.model.GetSpeechSynthesisTaskRequest;
import software.amazon.awssdk.services.polly.model.GetSpeechSynthesisTaskResponse;
import software.amazon.awssdk.services.polly.model.InvalidLexiconException;
import software.amazon.awssdk.services.polly.model.InvalidNextTokenException;
import software.amazon.awssdk.services.polly.model.InvalidS3BucketException;
import software.amazon.awssdk.services.polly.model.InvalidS3KeyException;
import software.amazon.awssdk.services.polly.model.InvalidSampleRateException;
import software.amazon.awssdk.services.polly.model.InvalidSnsTopicArnException;
import software.amazon.awssdk.services.polly.model.InvalidSsmlException;
import software.amazon.awssdk.services.polly.model.InvalidTaskIdException;
import software.amazon.awssdk.services.polly.model.LanguageNotSupportedException;
import software.amazon.awssdk.services.polly.model.LexiconNotFoundException;
import software.amazon.awssdk.services.polly.model.LexiconSizeExceededException;
import software.amazon.awssdk.services.polly.model.ListLexiconsRequest;
import software.amazon.awssdk.services.polly.model.ListLexiconsResponse;
import software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksRequest;
import software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksResponse;
import software.amazon.awssdk.services.polly.model.MarksNotSupportedForFormatException;
import software.amazon.awssdk.services.polly.model.MaxLexemeLengthExceededException;
import software.amazon.awssdk.services.polly.model.MaxLexiconsNumberExceededException;
import software.amazon.awssdk.services.polly.model.PollyException;
import software.amazon.awssdk.services.polly.model.PutLexiconRequest;
import software.amazon.awssdk.services.polly.model.PutLexiconResponse;
import software.amazon.awssdk.services.polly.model.ServiceFailureException;
import software.amazon.awssdk.services.polly.model.SsmlMarksNotSupportedForTextTypeException;
import software.amazon.awssdk.services.polly.model.StartSpeechSynthesisTaskRequest;
import software.amazon.awssdk.services.polly.model.StartSpeechSynthesisTaskResponse;
import software.amazon.awssdk.services.polly.model.SynthesisTaskNotFoundException;
import software.amazon.awssdk.services.polly.model.SynthesizeSpeechRequest;
import software.amazon.awssdk.services.polly.model.SynthesizeSpeechResponse;
import software.amazon.awssdk.services.polly.model.TextLengthExceededException;
import software.amazon.awssdk.services.polly.model.UnsupportedPlsAlphabetException;
import software.amazon.awssdk.services.polly.model.UnsupportedPlsLanguageException;
import software.amazon.awssdk.services.polly.transform.DeleteLexiconRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.DescribeVoicesRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.GetLexiconRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.GetSpeechSynthesisTaskRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.ListLexiconsRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.ListSpeechSynthesisTasksRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.PutLexiconRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.StartSpeechSynthesisTaskRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.SynthesizeSpeechRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.Pair;

@SdkInternalApi
final class DefaultPollyAsyncClient
implements PollyAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultPollyAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultPollyAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<DeleteLexiconResponse> deleteLexicon(DeleteLexiconRequest deleteLexiconRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteLexiconRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPollyAsyncClient.resolveMetricPublishers(clientConfiguration, deleteLexiconRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Polly");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLexicon");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLexiconResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidS3BucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketException::builder).build());
                    }
                    case "InvalidSampleRateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSampleRateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSampleRateException::builder).build());
                    }
                    case "SynthesisTaskNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SynthesisTaskNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SynthesisTaskNotFoundException::builder).build());
                    }
                    case "MaxLexiconsNumberExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxLexiconsNumberExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxLexiconsNumberExceededException::builder).build());
                    }
                    case "MaxLexemeLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxLexemeLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxLexemeLengthExceededException::builder).build());
                    }
                    case "UnsupportedPlsAlphabetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlsAlphabetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedPlsAlphabetException::builder).build());
                    }
                    case "LanguageNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LanguageNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LanguageNotSupportedException::builder).build());
                    }
                    case "TextLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextLengthExceededException::builder).build());
                    }
                    case "InvalidLexiconException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLexiconException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLexiconException::builder).build());
                    }
                    case "SsmlMarksNotSupportedForTextTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SsmlMarksNotSupportedForTextTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SsmlMarksNotSupportedForTextTypeException::builder).build());
                    }
                    case "InvalidS3KeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyException::builder).build());
                    }
                    case "InvalidSnsTopicArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MarksNotSupportedForFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MarksNotSupportedForFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MarksNotSupportedForFormatException::builder).build());
                    }
                    case "InvalidTaskIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaskIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaskIdException::builder).build());
                    }
                    case "UnsupportedPlsLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlsLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedPlsLanguageException::builder).build());
                    }
                    case "LexiconNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LexiconNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(LexiconNotFoundException::builder).build());
                    }
                    case "LexiconSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LexiconSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LexiconSizeExceededException::builder).build());
                    }
                    case "InvalidSsmlException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSsmlException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSsmlException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EngineNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EngineNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EngineNotSupportedException::builder).build());
                    }
                    case "ServiceFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLexicon").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteLexiconRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteLexiconRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPollyAsyncClient.lambda$deleteLexicon$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPollyAsyncClient.lambda$deleteLexicon$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeVoicesResponse> describeVoices(DescribeVoicesRequest describeVoicesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeVoicesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPollyAsyncClient.resolveMetricPublishers(clientConfiguration, describeVoicesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Polly");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeVoices");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeVoicesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidS3BucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketException::builder).build());
                    }
                    case "InvalidSampleRateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSampleRateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSampleRateException::builder).build());
                    }
                    case "SynthesisTaskNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SynthesisTaskNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SynthesisTaskNotFoundException::builder).build());
                    }
                    case "MaxLexiconsNumberExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxLexiconsNumberExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxLexiconsNumberExceededException::builder).build());
                    }
                    case "MaxLexemeLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxLexemeLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxLexemeLengthExceededException::builder).build());
                    }
                    case "UnsupportedPlsAlphabetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlsAlphabetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedPlsAlphabetException::builder).build());
                    }
                    case "LanguageNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LanguageNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LanguageNotSupportedException::builder).build());
                    }
                    case "TextLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextLengthExceededException::builder).build());
                    }
                    case "InvalidLexiconException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLexiconException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLexiconException::builder).build());
                    }
                    case "SsmlMarksNotSupportedForTextTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SsmlMarksNotSupportedForTextTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SsmlMarksNotSupportedForTextTypeException::builder).build());
                    }
                    case "InvalidS3KeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyException::builder).build());
                    }
                    case "InvalidSnsTopicArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MarksNotSupportedForFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MarksNotSupportedForFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MarksNotSupportedForFormatException::builder).build());
                    }
                    case "InvalidTaskIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaskIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaskIdException::builder).build());
                    }
                    case "UnsupportedPlsLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlsLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedPlsLanguageException::builder).build());
                    }
                    case "LexiconNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LexiconNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(LexiconNotFoundException::builder).build());
                    }
                    case "LexiconSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LexiconSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LexiconSizeExceededException::builder).build());
                    }
                    case "InvalidSsmlException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSsmlException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSsmlException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EngineNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EngineNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EngineNotSupportedException::builder).build());
                    }
                    case "ServiceFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeVoices").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeVoicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeVoicesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPollyAsyncClient.lambda$describeVoices$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPollyAsyncClient.lambda$describeVoices$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetLexiconResponse> getLexicon(GetLexiconRequest getLexiconRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLexiconRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPollyAsyncClient.resolveMetricPublishers(clientConfiguration, getLexiconRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Polly");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLexicon");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLexiconResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidS3BucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketException::builder).build());
                    }
                    case "InvalidSampleRateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSampleRateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSampleRateException::builder).build());
                    }
                    case "SynthesisTaskNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SynthesisTaskNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SynthesisTaskNotFoundException::builder).build());
                    }
                    case "MaxLexiconsNumberExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxLexiconsNumberExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxLexiconsNumberExceededException::builder).build());
                    }
                    case "MaxLexemeLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxLexemeLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxLexemeLengthExceededException::builder).build());
                    }
                    case "UnsupportedPlsAlphabetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlsAlphabetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedPlsAlphabetException::builder).build());
                    }
                    case "LanguageNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LanguageNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LanguageNotSupportedException::builder).build());
                    }
                    case "TextLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextLengthExceededException::builder).build());
                    }
                    case "InvalidLexiconException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLexiconException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLexiconException::builder).build());
                    }
                    case "SsmlMarksNotSupportedForTextTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SsmlMarksNotSupportedForTextTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SsmlMarksNotSupportedForTextTypeException::builder).build());
                    }
                    case "InvalidS3KeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyException::builder).build());
                    }
                    case "InvalidSnsTopicArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MarksNotSupportedForFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MarksNotSupportedForFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MarksNotSupportedForFormatException::builder).build());
                    }
                    case "InvalidTaskIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaskIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaskIdException::builder).build());
                    }
                    case "UnsupportedPlsLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlsLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedPlsLanguageException::builder).build());
                    }
                    case "LexiconNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LexiconNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(LexiconNotFoundException::builder).build());
                    }
                    case "LexiconSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LexiconSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LexiconSizeExceededException::builder).build());
                    }
                    case "InvalidSsmlException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSsmlException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSsmlException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EngineNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EngineNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EngineNotSupportedException::builder).build());
                    }
                    case "ServiceFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLexicon").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetLexiconRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getLexiconRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPollyAsyncClient.lambda$getLexicon$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPollyAsyncClient.lambda$getLexicon$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSpeechSynthesisTaskResponse> getSpeechSynthesisTask(GetSpeechSynthesisTaskRequest getSpeechSynthesisTaskRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSpeechSynthesisTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPollyAsyncClient.resolveMetricPublishers(clientConfiguration, getSpeechSynthesisTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Polly");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSpeechSynthesisTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSpeechSynthesisTaskResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidS3BucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketException::builder).build());
                    }
                    case "InvalidSampleRateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSampleRateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSampleRateException::builder).build());
                    }
                    case "SynthesisTaskNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SynthesisTaskNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SynthesisTaskNotFoundException::builder).build());
                    }
                    case "MaxLexiconsNumberExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxLexiconsNumberExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxLexiconsNumberExceededException::builder).build());
                    }
                    case "MaxLexemeLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxLexemeLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxLexemeLengthExceededException::builder).build());
                    }
                    case "UnsupportedPlsAlphabetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlsAlphabetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedPlsAlphabetException::builder).build());
                    }
                    case "LanguageNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LanguageNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LanguageNotSupportedException::builder).build());
                    }
                    case "TextLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextLengthExceededException::builder).build());
                    }
                    case "InvalidLexiconException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLexiconException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLexiconException::builder).build());
                    }
                    case "SsmlMarksNotSupportedForTextTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SsmlMarksNotSupportedForTextTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SsmlMarksNotSupportedForTextTypeException::builder).build());
                    }
                    case "InvalidS3KeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyException::builder).build());
                    }
                    case "InvalidSnsTopicArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MarksNotSupportedForFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MarksNotSupportedForFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MarksNotSupportedForFormatException::builder).build());
                    }
                    case "InvalidTaskIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaskIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaskIdException::builder).build());
                    }
                    case "UnsupportedPlsLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlsLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedPlsLanguageException::builder).build());
                    }
                    case "LexiconNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LexiconNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(LexiconNotFoundException::builder).build());
                    }
                    case "LexiconSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LexiconSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LexiconSizeExceededException::builder).build());
                    }
                    case "InvalidSsmlException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSsmlException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSsmlException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EngineNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EngineNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EngineNotSupportedException::builder).build());
                    }
                    case "ServiceFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSpeechSynthesisTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetSpeechSynthesisTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getSpeechSynthesisTaskRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPollyAsyncClient.lambda$getSpeechSynthesisTask$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPollyAsyncClient.lambda$getSpeechSynthesisTask$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListLexiconsResponse> listLexicons(ListLexiconsRequest listLexiconsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listLexiconsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPollyAsyncClient.resolveMetricPublishers(clientConfiguration, listLexiconsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Polly");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLexicons");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLexiconsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidS3BucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketException::builder).build());
                    }
                    case "InvalidSampleRateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSampleRateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSampleRateException::builder).build());
                    }
                    case "SynthesisTaskNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SynthesisTaskNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SynthesisTaskNotFoundException::builder).build());
                    }
                    case "MaxLexiconsNumberExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxLexiconsNumberExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxLexiconsNumberExceededException::builder).build());
                    }
                    case "MaxLexemeLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxLexemeLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxLexemeLengthExceededException::builder).build());
                    }
                    case "UnsupportedPlsAlphabetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlsAlphabetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedPlsAlphabetException::builder).build());
                    }
                    case "LanguageNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LanguageNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LanguageNotSupportedException::builder).build());
                    }
                    case "TextLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextLengthExceededException::builder).build());
                    }
                    case "InvalidLexiconException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLexiconException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLexiconException::builder).build());
                    }
                    case "SsmlMarksNotSupportedForTextTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SsmlMarksNotSupportedForTextTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SsmlMarksNotSupportedForTextTypeException::builder).build());
                    }
                    case "InvalidS3KeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyException::builder).build());
                    }
                    case "InvalidSnsTopicArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MarksNotSupportedForFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MarksNotSupportedForFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MarksNotSupportedForFormatException::builder).build());
                    }
                    case "InvalidTaskIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaskIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaskIdException::builder).build());
                    }
                    case "UnsupportedPlsLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlsLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedPlsLanguageException::builder).build());
                    }
                    case "LexiconNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LexiconNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(LexiconNotFoundException::builder).build());
                    }
                    case "LexiconSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LexiconSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LexiconSizeExceededException::builder).build());
                    }
                    case "InvalidSsmlException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSsmlException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSsmlException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EngineNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EngineNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EngineNotSupportedException::builder).build());
                    }
                    case "ServiceFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLexicons").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListLexiconsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listLexiconsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPollyAsyncClient.lambda$listLexicons$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPollyAsyncClient.lambda$listLexicons$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListSpeechSynthesisTasksResponse> listSpeechSynthesisTasks(ListSpeechSynthesisTasksRequest listSpeechSynthesisTasksRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSpeechSynthesisTasksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPollyAsyncClient.resolveMetricPublishers(clientConfiguration, listSpeechSynthesisTasksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Polly");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSpeechSynthesisTasks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSpeechSynthesisTasksResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidS3BucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketException::builder).build());
                    }
                    case "InvalidSampleRateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSampleRateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSampleRateException::builder).build());
                    }
                    case "SynthesisTaskNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SynthesisTaskNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SynthesisTaskNotFoundException::builder).build());
                    }
                    case "MaxLexiconsNumberExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxLexiconsNumberExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxLexiconsNumberExceededException::builder).build());
                    }
                    case "MaxLexemeLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxLexemeLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxLexemeLengthExceededException::builder).build());
                    }
                    case "UnsupportedPlsAlphabetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlsAlphabetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedPlsAlphabetException::builder).build());
                    }
                    case "LanguageNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LanguageNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LanguageNotSupportedException::builder).build());
                    }
                    case "TextLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextLengthExceededException::builder).build());
                    }
                    case "InvalidLexiconException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLexiconException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLexiconException::builder).build());
                    }
                    case "SsmlMarksNotSupportedForTextTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SsmlMarksNotSupportedForTextTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SsmlMarksNotSupportedForTextTypeException::builder).build());
                    }
                    case "InvalidS3KeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyException::builder).build());
                    }
                    case "InvalidSnsTopicArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MarksNotSupportedForFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MarksNotSupportedForFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MarksNotSupportedForFormatException::builder).build());
                    }
                    case "InvalidTaskIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaskIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaskIdException::builder).build());
                    }
                    case "UnsupportedPlsLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlsLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedPlsLanguageException::builder).build());
                    }
                    case "LexiconNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LexiconNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(LexiconNotFoundException::builder).build());
                    }
                    case "LexiconSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LexiconSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LexiconSizeExceededException::builder).build());
                    }
                    case "InvalidSsmlException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSsmlException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSsmlException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EngineNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EngineNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EngineNotSupportedException::builder).build());
                    }
                    case "ServiceFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSpeechSynthesisTasks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListSpeechSynthesisTasksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listSpeechSynthesisTasksRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPollyAsyncClient.lambda$listSpeechSynthesisTasks$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPollyAsyncClient.lambda$listSpeechSynthesisTasks$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutLexiconResponse> putLexicon(PutLexiconRequest putLexiconRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putLexiconRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPollyAsyncClient.resolveMetricPublishers(clientConfiguration, putLexiconRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Polly");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutLexicon");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutLexiconResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidS3BucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketException::builder).build());
                    }
                    case "InvalidSampleRateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSampleRateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSampleRateException::builder).build());
                    }
                    case "SynthesisTaskNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SynthesisTaskNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SynthesisTaskNotFoundException::builder).build());
                    }
                    case "MaxLexiconsNumberExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxLexiconsNumberExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxLexiconsNumberExceededException::builder).build());
                    }
                    case "MaxLexemeLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxLexemeLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxLexemeLengthExceededException::builder).build());
                    }
                    case "UnsupportedPlsAlphabetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlsAlphabetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedPlsAlphabetException::builder).build());
                    }
                    case "LanguageNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LanguageNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LanguageNotSupportedException::builder).build());
                    }
                    case "TextLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextLengthExceededException::builder).build());
                    }
                    case "InvalidLexiconException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLexiconException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLexiconException::builder).build());
                    }
                    case "SsmlMarksNotSupportedForTextTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SsmlMarksNotSupportedForTextTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SsmlMarksNotSupportedForTextTypeException::builder).build());
                    }
                    case "InvalidS3KeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyException::builder).build());
                    }
                    case "InvalidSnsTopicArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MarksNotSupportedForFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MarksNotSupportedForFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MarksNotSupportedForFormatException::builder).build());
                    }
                    case "InvalidTaskIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaskIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaskIdException::builder).build());
                    }
                    case "UnsupportedPlsLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlsLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedPlsLanguageException::builder).build());
                    }
                    case "LexiconNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LexiconNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(LexiconNotFoundException::builder).build());
                    }
                    case "LexiconSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LexiconSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LexiconSizeExceededException::builder).build());
                    }
                    case "InvalidSsmlException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSsmlException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSsmlException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EngineNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EngineNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EngineNotSupportedException::builder).build());
                    }
                    case "ServiceFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutLexicon").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutLexiconRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putLexiconRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPollyAsyncClient.lambda$putLexicon$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPollyAsyncClient.lambda$putLexicon$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartSpeechSynthesisTaskResponse> startSpeechSynthesisTask(StartSpeechSynthesisTaskRequest startSpeechSynthesisTaskRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startSpeechSynthesisTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPollyAsyncClient.resolveMetricPublishers(clientConfiguration, startSpeechSynthesisTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Polly");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartSpeechSynthesisTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartSpeechSynthesisTaskResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidS3BucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketException::builder).build());
                    }
                    case "InvalidSampleRateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSampleRateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSampleRateException::builder).build());
                    }
                    case "SynthesisTaskNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SynthesisTaskNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SynthesisTaskNotFoundException::builder).build());
                    }
                    case "MaxLexiconsNumberExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxLexiconsNumberExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxLexiconsNumberExceededException::builder).build());
                    }
                    case "MaxLexemeLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxLexemeLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxLexemeLengthExceededException::builder).build());
                    }
                    case "UnsupportedPlsAlphabetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlsAlphabetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedPlsAlphabetException::builder).build());
                    }
                    case "LanguageNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LanguageNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LanguageNotSupportedException::builder).build());
                    }
                    case "TextLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextLengthExceededException::builder).build());
                    }
                    case "InvalidLexiconException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLexiconException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLexiconException::builder).build());
                    }
                    case "SsmlMarksNotSupportedForTextTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SsmlMarksNotSupportedForTextTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SsmlMarksNotSupportedForTextTypeException::builder).build());
                    }
                    case "InvalidS3KeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyException::builder).build());
                    }
                    case "InvalidSnsTopicArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MarksNotSupportedForFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MarksNotSupportedForFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MarksNotSupportedForFormatException::builder).build());
                    }
                    case "InvalidTaskIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaskIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaskIdException::builder).build());
                    }
                    case "UnsupportedPlsLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlsLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedPlsLanguageException::builder).build());
                    }
                    case "LexiconNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LexiconNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(LexiconNotFoundException::builder).build());
                    }
                    case "LexiconSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LexiconSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LexiconSizeExceededException::builder).build());
                    }
                    case "InvalidSsmlException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSsmlException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSsmlException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EngineNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EngineNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EngineNotSupportedException::builder).build());
                    }
                    case "ServiceFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartSpeechSynthesisTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartSpeechSynthesisTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startSpeechSynthesisTaskRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPollyAsyncClient.lambda$startSpeechSynthesisTask$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultPollyAsyncClient.lambda$startSpeechSynthesisTask$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public <ReturnT> CompletableFuture<ReturnT> synthesizeSpeech(SynthesizeSpeechRequest synthesizeSpeechRequest, AsyncResponseTransformer<SynthesizeSpeechResponse, ReturnT> asyncResponseTransformer) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)synthesizeSpeechRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPollyAsyncClient.resolveMetricPublishers(clientConfiguration, synthesizeSpeechRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Polly");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SynthesizeSpeech");
            Pair pair = AsyncResponseTransformerUtils.wrapWithEndOfStreamFuture(asyncResponseTransformer);
            asyncResponseTransformer = (AsyncResponseTransformer)pair.left();
            CompletableFuture endOfStreamFuture = (CompletableFuture)pair.right();
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(true).isPayloadJson(false).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SynthesizeSpeechResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidS3BucketException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketException::builder).build());
                    }
                    case "InvalidSampleRateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSampleRateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSampleRateException::builder).build());
                    }
                    case "SynthesisTaskNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SynthesisTaskNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SynthesisTaskNotFoundException::builder).build());
                    }
                    case "MaxLexiconsNumberExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxLexiconsNumberExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxLexiconsNumberExceededException::builder).build());
                    }
                    case "MaxLexemeLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MaxLexemeLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxLexemeLengthExceededException::builder).build());
                    }
                    case "UnsupportedPlsAlphabetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlsAlphabetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedPlsAlphabetException::builder).build());
                    }
                    case "LanguageNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LanguageNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LanguageNotSupportedException::builder).build());
                    }
                    case "TextLengthExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextLengthExceededException::builder).build());
                    }
                    case "InvalidLexiconException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLexiconException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLexiconException::builder).build());
                    }
                    case "SsmlMarksNotSupportedForTextTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SsmlMarksNotSupportedForTextTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SsmlMarksNotSupportedForTextTypeException::builder).build());
                    }
                    case "InvalidS3KeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyException::builder).build());
                    }
                    case "InvalidSnsTopicArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                    }
                    case "MarksNotSupportedForFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MarksNotSupportedForFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MarksNotSupportedForFormatException::builder).build());
                    }
                    case "InvalidTaskIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaskIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaskIdException::builder).build());
                    }
                    case "UnsupportedPlsLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlsLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedPlsLanguageException::builder).build());
                    }
                    case "LexiconNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LexiconNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(LexiconNotFoundException::builder).build());
                    }
                    case "LexiconSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LexiconSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LexiconSizeExceededException::builder).build());
                    }
                    case "InvalidSsmlException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSsmlException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSsmlException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EngineNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EngineNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EngineNotSupportedException::builder).build());
                    }
                    case "ServiceFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SynthesizeSpeech").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SynthesizeSpeechRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withAsyncResponseTransformer(asyncResponseTransformer).withInput((SdkRequest)synthesizeSpeechRequest), asyncResponseTransformer);
            AsyncResponseTransformer finalAsyncResponseTransformer = asyncResponseTransformer;
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultPollyAsyncClient.lambda$synthesizeSpeech$36(finalAsyncResponseTransformer, endOfStreamFuture, metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            AsyncResponseTransformer finalAsyncResponseTransformer = asyncResponseTransformer;
            FunctionalUtils.runAndLogError((Logger)log, (String)"Exception thrown in exceptionOccurred callback, ignoring", () -> finalAsyncResponseTransformer.exceptionOccurred(t));
            metricPublishers.forEach(arg_0 -> DefaultPollyAsyncClient.lambda$synthesizeSpeech$38((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final PollyServiceClientConfiguration serviceClientConfiguration() {
        return new PollyServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "polly";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(PollyException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        PollyServiceClientConfigurationBuilder serviceConfigBuilder = new PollyServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$synthesizeSpeech$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$synthesizeSpeech$36(AsyncResponseTransformer finalAsyncResponseTransformer, CompletableFuture endOfStreamFuture, List metricPublishers, MetricCollector apiCallMetricCollector, Object r, Throwable e) {
        if (e != null) {
            FunctionalUtils.runAndLogError((Logger)log, (String)"Exception thrown in exceptionOccurred callback, ignoring", () -> finalAsyncResponseTransformer.exceptionOccurred(e));
        }
        endOfStreamFuture.whenComplete((r2, e2) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
    }

    private static /* synthetic */ void lambda$startSpeechSynthesisTask$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startSpeechSynthesisTask$30(List metricPublishers, MetricCollector apiCallMetricCollector, StartSpeechSynthesisTaskResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putLexicon$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putLexicon$26(List metricPublishers, MetricCollector apiCallMetricCollector, PutLexiconResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listSpeechSynthesisTasks$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSpeechSynthesisTasks$22(List metricPublishers, MetricCollector apiCallMetricCollector, ListSpeechSynthesisTasksResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listLexicons$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLexicons$18(List metricPublishers, MetricCollector apiCallMetricCollector, ListLexiconsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getSpeechSynthesisTask$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSpeechSynthesisTask$14(List metricPublishers, MetricCollector apiCallMetricCollector, GetSpeechSynthesisTaskResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getLexicon$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLexicon$10(List metricPublishers, MetricCollector apiCallMetricCollector, GetLexiconResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeVoices$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeVoices$6(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeVoicesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteLexicon$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLexicon$2(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteLexiconResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

