/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.polly.PollyClient;
import software.amazon.awssdk.services.polly.PollyServiceClientConfiguration;
import software.amazon.awssdk.services.polly.internal.PollyServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.polly.model.DeleteLexiconRequest;
import software.amazon.awssdk.services.polly.model.DeleteLexiconResponse;
import software.amazon.awssdk.services.polly.model.DescribeVoicesRequest;
import software.amazon.awssdk.services.polly.model.DescribeVoicesResponse;
import software.amazon.awssdk.services.polly.model.EngineNotSupportedException;
import software.amazon.awssdk.services.polly.model.GetLexiconRequest;
import software.amazon.awssdk.services.polly.model.GetLexiconResponse;
import software.amazon.awssdk.services.polly.model.GetSpeechSynthesisTaskRequest;
import software.amazon.awssdk.services.polly.model.GetSpeechSynthesisTaskResponse;
import software.amazon.awssdk.services.polly.model.InvalidLexiconException;
import software.amazon.awssdk.services.polly.model.InvalidNextTokenException;
import software.amazon.awssdk.services.polly.model.InvalidS3BucketException;
import software.amazon.awssdk.services.polly.model.InvalidS3KeyException;
import software.amazon.awssdk.services.polly.model.InvalidSampleRateException;
import software.amazon.awssdk.services.polly.model.InvalidSnsTopicArnException;
import software.amazon.awssdk.services.polly.model.InvalidSsmlException;
import software.amazon.awssdk.services.polly.model.InvalidTaskIdException;
import software.amazon.awssdk.services.polly.model.LanguageNotSupportedException;
import software.amazon.awssdk.services.polly.model.LexiconNotFoundException;
import software.amazon.awssdk.services.polly.model.LexiconSizeExceededException;
import software.amazon.awssdk.services.polly.model.ListLexiconsRequest;
import software.amazon.awssdk.services.polly.model.ListLexiconsResponse;
import software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksRequest;
import software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksResponse;
import software.amazon.awssdk.services.polly.model.MarksNotSupportedForFormatException;
import software.amazon.awssdk.services.polly.model.MaxLexemeLengthExceededException;
import software.amazon.awssdk.services.polly.model.MaxLexiconsNumberExceededException;
import software.amazon.awssdk.services.polly.model.PollyException;
import software.amazon.awssdk.services.polly.model.PutLexiconRequest;
import software.amazon.awssdk.services.polly.model.PutLexiconResponse;
import software.amazon.awssdk.services.polly.model.ServiceFailureException;
import software.amazon.awssdk.services.polly.model.SsmlMarksNotSupportedForTextTypeException;
import software.amazon.awssdk.services.polly.model.StartSpeechSynthesisTaskRequest;
import software.amazon.awssdk.services.polly.model.StartSpeechSynthesisTaskResponse;
import software.amazon.awssdk.services.polly.model.SynthesisTaskNotFoundException;
import software.amazon.awssdk.services.polly.model.SynthesizeSpeechRequest;
import software.amazon.awssdk.services.polly.model.SynthesizeSpeechResponse;
import software.amazon.awssdk.services.polly.model.TextLengthExceededException;
import software.amazon.awssdk.services.polly.model.UnsupportedPlsAlphabetException;
import software.amazon.awssdk.services.polly.model.UnsupportedPlsLanguageException;
import software.amazon.awssdk.services.polly.transform.DeleteLexiconRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.DescribeVoicesRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.GetLexiconRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.GetSpeechSynthesisTaskRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.ListLexiconsRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.ListSpeechSynthesisTasksRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.PutLexiconRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.StartSpeechSynthesisTaskRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.SynthesizeSpeechRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultPollyClient
implements PollyClient {
    private static final Logger log = Logger.loggerFor(DefaultPollyClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultPollyClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Polly#2.31.78").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLexiconResponse deleteLexicon(DeleteLexiconRequest deleteLexiconRequest) throws LexiconNotFoundException, ServiceFailureException, AwsServiceException, SdkClientException, PollyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLexiconResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidS3BucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketException::builder).build());
                }
                case "InvalidSampleRateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSampleRateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSampleRateException::builder).build());
                }
                case "SynthesisTaskNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SynthesisTaskNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SynthesisTaskNotFoundException::builder).build());
                }
                case "MaxLexiconsNumberExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxLexiconsNumberExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxLexiconsNumberExceededException::builder).build());
                }
                case "MaxLexemeLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxLexemeLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxLexemeLengthExceededException::builder).build());
                }
                case "UnsupportedPlsAlphabetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlsAlphabetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedPlsAlphabetException::builder).build());
                }
                case "LanguageNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LanguageNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LanguageNotSupportedException::builder).build());
                }
                case "TextLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextLengthExceededException::builder).build());
                }
                case "InvalidLexiconException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLexiconException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLexiconException::builder).build());
                }
                case "SsmlMarksNotSupportedForTextTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SsmlMarksNotSupportedForTextTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SsmlMarksNotSupportedForTextTypeException::builder).build());
                }
                case "InvalidS3KeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyException::builder).build());
                }
                case "InvalidSnsTopicArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MarksNotSupportedForFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MarksNotSupportedForFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MarksNotSupportedForFormatException::builder).build());
                }
                case "InvalidTaskIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaskIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaskIdException::builder).build());
                }
                case "UnsupportedPlsLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlsLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedPlsLanguageException::builder).build());
                }
                case "LexiconNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LexiconNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(LexiconNotFoundException::builder).build());
                }
                case "LexiconSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LexiconSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LexiconSizeExceededException::builder).build());
                }
                case "InvalidSsmlException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSsmlException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSsmlException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "EngineNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EngineNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EngineNotSupportedException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteLexiconRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPollyClient.resolveMetricPublishers(clientConfiguration, deleteLexiconRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Polly");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLexicon");
            DeleteLexiconResponse deleteLexiconResponse = (DeleteLexiconResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLexicon").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteLexiconRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteLexiconRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteLexiconResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPollyClient.lambda$deleteLexicon$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeVoicesResponse describeVoices(DescribeVoicesRequest describeVoicesRequest) throws InvalidNextTokenException, ServiceFailureException, AwsServiceException, SdkClientException, PollyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeVoicesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidS3BucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketException::builder).build());
                }
                case "InvalidSampleRateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSampleRateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSampleRateException::builder).build());
                }
                case "SynthesisTaskNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SynthesisTaskNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SynthesisTaskNotFoundException::builder).build());
                }
                case "MaxLexiconsNumberExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxLexiconsNumberExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxLexiconsNumberExceededException::builder).build());
                }
                case "MaxLexemeLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxLexemeLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxLexemeLengthExceededException::builder).build());
                }
                case "UnsupportedPlsAlphabetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlsAlphabetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedPlsAlphabetException::builder).build());
                }
                case "LanguageNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LanguageNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LanguageNotSupportedException::builder).build());
                }
                case "TextLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextLengthExceededException::builder).build());
                }
                case "InvalidLexiconException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLexiconException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLexiconException::builder).build());
                }
                case "SsmlMarksNotSupportedForTextTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SsmlMarksNotSupportedForTextTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SsmlMarksNotSupportedForTextTypeException::builder).build());
                }
                case "InvalidS3KeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyException::builder).build());
                }
                case "InvalidSnsTopicArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MarksNotSupportedForFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MarksNotSupportedForFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MarksNotSupportedForFormatException::builder).build());
                }
                case "InvalidTaskIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaskIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaskIdException::builder).build());
                }
                case "UnsupportedPlsLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlsLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedPlsLanguageException::builder).build());
                }
                case "LexiconNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LexiconNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(LexiconNotFoundException::builder).build());
                }
                case "LexiconSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LexiconSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LexiconSizeExceededException::builder).build());
                }
                case "InvalidSsmlException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSsmlException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSsmlException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "EngineNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EngineNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EngineNotSupportedException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeVoicesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPollyClient.resolveMetricPublishers(clientConfiguration, describeVoicesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Polly");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeVoices");
            DescribeVoicesResponse describeVoicesResponse = (DescribeVoicesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeVoices").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeVoicesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeVoicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeVoicesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPollyClient.lambda$describeVoices$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLexiconResponse getLexicon(GetLexiconRequest getLexiconRequest) throws LexiconNotFoundException, ServiceFailureException, AwsServiceException, SdkClientException, PollyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLexiconResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidS3BucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketException::builder).build());
                }
                case "InvalidSampleRateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSampleRateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSampleRateException::builder).build());
                }
                case "SynthesisTaskNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SynthesisTaskNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SynthesisTaskNotFoundException::builder).build());
                }
                case "MaxLexiconsNumberExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxLexiconsNumberExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxLexiconsNumberExceededException::builder).build());
                }
                case "MaxLexemeLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxLexemeLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxLexemeLengthExceededException::builder).build());
                }
                case "UnsupportedPlsAlphabetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlsAlphabetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedPlsAlphabetException::builder).build());
                }
                case "LanguageNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LanguageNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LanguageNotSupportedException::builder).build());
                }
                case "TextLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextLengthExceededException::builder).build());
                }
                case "InvalidLexiconException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLexiconException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLexiconException::builder).build());
                }
                case "SsmlMarksNotSupportedForTextTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SsmlMarksNotSupportedForTextTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SsmlMarksNotSupportedForTextTypeException::builder).build());
                }
                case "InvalidS3KeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyException::builder).build());
                }
                case "InvalidSnsTopicArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MarksNotSupportedForFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MarksNotSupportedForFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MarksNotSupportedForFormatException::builder).build());
                }
                case "InvalidTaskIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaskIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaskIdException::builder).build());
                }
                case "UnsupportedPlsLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlsLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedPlsLanguageException::builder).build());
                }
                case "LexiconNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LexiconNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(LexiconNotFoundException::builder).build());
                }
                case "LexiconSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LexiconSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LexiconSizeExceededException::builder).build());
                }
                case "InvalidSsmlException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSsmlException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSsmlException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "EngineNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EngineNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EngineNotSupportedException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLexiconRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPollyClient.resolveMetricPublishers(clientConfiguration, getLexiconRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Polly");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLexicon");
            GetLexiconResponse getLexiconResponse = (GetLexiconResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLexicon").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getLexiconRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetLexiconRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLexiconResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPollyClient.lambda$getLexicon$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSpeechSynthesisTaskResponse getSpeechSynthesisTask(GetSpeechSynthesisTaskRequest getSpeechSynthesisTaskRequest) throws InvalidTaskIdException, ServiceFailureException, SynthesisTaskNotFoundException, AwsServiceException, SdkClientException, PollyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSpeechSynthesisTaskResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidS3BucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketException::builder).build());
                }
                case "InvalidSampleRateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSampleRateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSampleRateException::builder).build());
                }
                case "SynthesisTaskNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SynthesisTaskNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SynthesisTaskNotFoundException::builder).build());
                }
                case "MaxLexiconsNumberExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxLexiconsNumberExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxLexiconsNumberExceededException::builder).build());
                }
                case "MaxLexemeLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxLexemeLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxLexemeLengthExceededException::builder).build());
                }
                case "UnsupportedPlsAlphabetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlsAlphabetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedPlsAlphabetException::builder).build());
                }
                case "LanguageNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LanguageNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LanguageNotSupportedException::builder).build());
                }
                case "TextLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextLengthExceededException::builder).build());
                }
                case "InvalidLexiconException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLexiconException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLexiconException::builder).build());
                }
                case "SsmlMarksNotSupportedForTextTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SsmlMarksNotSupportedForTextTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SsmlMarksNotSupportedForTextTypeException::builder).build());
                }
                case "InvalidS3KeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyException::builder).build());
                }
                case "InvalidSnsTopicArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MarksNotSupportedForFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MarksNotSupportedForFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MarksNotSupportedForFormatException::builder).build());
                }
                case "InvalidTaskIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaskIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaskIdException::builder).build());
                }
                case "UnsupportedPlsLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlsLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedPlsLanguageException::builder).build());
                }
                case "LexiconNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LexiconNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(LexiconNotFoundException::builder).build());
                }
                case "LexiconSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LexiconSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LexiconSizeExceededException::builder).build());
                }
                case "InvalidSsmlException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSsmlException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSsmlException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "EngineNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EngineNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EngineNotSupportedException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSpeechSynthesisTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPollyClient.resolveMetricPublishers(clientConfiguration, getSpeechSynthesisTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Polly");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSpeechSynthesisTask");
            GetSpeechSynthesisTaskResponse getSpeechSynthesisTaskResponse = (GetSpeechSynthesisTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSpeechSynthesisTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getSpeechSynthesisTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSpeechSynthesisTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSpeechSynthesisTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPollyClient.lambda$getSpeechSynthesisTask$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListLexiconsResponse listLexicons(ListLexiconsRequest listLexiconsRequest) throws InvalidNextTokenException, ServiceFailureException, AwsServiceException, SdkClientException, PollyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLexiconsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidS3BucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketException::builder).build());
                }
                case "InvalidSampleRateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSampleRateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSampleRateException::builder).build());
                }
                case "SynthesisTaskNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SynthesisTaskNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SynthesisTaskNotFoundException::builder).build());
                }
                case "MaxLexiconsNumberExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxLexiconsNumberExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxLexiconsNumberExceededException::builder).build());
                }
                case "MaxLexemeLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxLexemeLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxLexemeLengthExceededException::builder).build());
                }
                case "UnsupportedPlsAlphabetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlsAlphabetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedPlsAlphabetException::builder).build());
                }
                case "LanguageNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LanguageNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LanguageNotSupportedException::builder).build());
                }
                case "TextLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextLengthExceededException::builder).build());
                }
                case "InvalidLexiconException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLexiconException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLexiconException::builder).build());
                }
                case "SsmlMarksNotSupportedForTextTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SsmlMarksNotSupportedForTextTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SsmlMarksNotSupportedForTextTypeException::builder).build());
                }
                case "InvalidS3KeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyException::builder).build());
                }
                case "InvalidSnsTopicArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MarksNotSupportedForFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MarksNotSupportedForFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MarksNotSupportedForFormatException::builder).build());
                }
                case "InvalidTaskIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaskIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaskIdException::builder).build());
                }
                case "UnsupportedPlsLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlsLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedPlsLanguageException::builder).build());
                }
                case "LexiconNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LexiconNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(LexiconNotFoundException::builder).build());
                }
                case "LexiconSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LexiconSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LexiconSizeExceededException::builder).build());
                }
                case "InvalidSsmlException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSsmlException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSsmlException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "EngineNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EngineNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EngineNotSupportedException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listLexiconsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPollyClient.resolveMetricPublishers(clientConfiguration, listLexiconsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Polly");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLexicons");
            ListLexiconsResponse listLexiconsResponse = (ListLexiconsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLexicons").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listLexiconsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListLexiconsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listLexiconsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPollyClient.lambda$listLexicons$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSpeechSynthesisTasksResponse listSpeechSynthesisTasks(ListSpeechSynthesisTasksRequest listSpeechSynthesisTasksRequest) throws InvalidNextTokenException, ServiceFailureException, AwsServiceException, SdkClientException, PollyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSpeechSynthesisTasksResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidS3BucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketException::builder).build());
                }
                case "InvalidSampleRateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSampleRateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSampleRateException::builder).build());
                }
                case "SynthesisTaskNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SynthesisTaskNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SynthesisTaskNotFoundException::builder).build());
                }
                case "MaxLexiconsNumberExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxLexiconsNumberExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxLexiconsNumberExceededException::builder).build());
                }
                case "MaxLexemeLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxLexemeLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxLexemeLengthExceededException::builder).build());
                }
                case "UnsupportedPlsAlphabetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlsAlphabetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedPlsAlphabetException::builder).build());
                }
                case "LanguageNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LanguageNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LanguageNotSupportedException::builder).build());
                }
                case "TextLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextLengthExceededException::builder).build());
                }
                case "InvalidLexiconException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLexiconException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLexiconException::builder).build());
                }
                case "SsmlMarksNotSupportedForTextTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SsmlMarksNotSupportedForTextTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SsmlMarksNotSupportedForTextTypeException::builder).build());
                }
                case "InvalidS3KeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyException::builder).build());
                }
                case "InvalidSnsTopicArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MarksNotSupportedForFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MarksNotSupportedForFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MarksNotSupportedForFormatException::builder).build());
                }
                case "InvalidTaskIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaskIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaskIdException::builder).build());
                }
                case "UnsupportedPlsLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlsLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedPlsLanguageException::builder).build());
                }
                case "LexiconNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LexiconNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(LexiconNotFoundException::builder).build());
                }
                case "LexiconSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LexiconSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LexiconSizeExceededException::builder).build());
                }
                case "InvalidSsmlException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSsmlException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSsmlException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "EngineNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EngineNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EngineNotSupportedException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSpeechSynthesisTasksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPollyClient.resolveMetricPublishers(clientConfiguration, listSpeechSynthesisTasksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Polly");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSpeechSynthesisTasks");
            ListSpeechSynthesisTasksResponse listSpeechSynthesisTasksResponse = (ListSpeechSynthesisTasksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSpeechSynthesisTasks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listSpeechSynthesisTasksRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSpeechSynthesisTasksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSpeechSynthesisTasksResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPollyClient.lambda$listSpeechSynthesisTasks$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutLexiconResponse putLexicon(PutLexiconRequest putLexiconRequest) throws InvalidLexiconException, UnsupportedPlsAlphabetException, UnsupportedPlsLanguageException, LexiconSizeExceededException, MaxLexemeLengthExceededException, MaxLexiconsNumberExceededException, ServiceFailureException, AwsServiceException, SdkClientException, PollyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutLexiconResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidS3BucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketException::builder).build());
                }
                case "InvalidSampleRateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSampleRateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSampleRateException::builder).build());
                }
                case "SynthesisTaskNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SynthesisTaskNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SynthesisTaskNotFoundException::builder).build());
                }
                case "MaxLexiconsNumberExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxLexiconsNumberExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxLexiconsNumberExceededException::builder).build());
                }
                case "MaxLexemeLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxLexemeLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxLexemeLengthExceededException::builder).build());
                }
                case "UnsupportedPlsAlphabetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlsAlphabetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedPlsAlphabetException::builder).build());
                }
                case "LanguageNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LanguageNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LanguageNotSupportedException::builder).build());
                }
                case "TextLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextLengthExceededException::builder).build());
                }
                case "InvalidLexiconException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLexiconException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLexiconException::builder).build());
                }
                case "SsmlMarksNotSupportedForTextTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SsmlMarksNotSupportedForTextTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SsmlMarksNotSupportedForTextTypeException::builder).build());
                }
                case "InvalidS3KeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyException::builder).build());
                }
                case "InvalidSnsTopicArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MarksNotSupportedForFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MarksNotSupportedForFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MarksNotSupportedForFormatException::builder).build());
                }
                case "InvalidTaskIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaskIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaskIdException::builder).build());
                }
                case "UnsupportedPlsLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlsLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedPlsLanguageException::builder).build());
                }
                case "LexiconNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LexiconNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(LexiconNotFoundException::builder).build());
                }
                case "LexiconSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LexiconSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LexiconSizeExceededException::builder).build());
                }
                case "InvalidSsmlException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSsmlException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSsmlException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "EngineNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EngineNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EngineNotSupportedException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putLexiconRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPollyClient.resolveMetricPublishers(clientConfiguration, putLexiconRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Polly");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutLexicon");
            PutLexiconResponse putLexiconResponse = (PutLexiconResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutLexicon").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putLexiconRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutLexiconRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putLexiconResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPollyClient.lambda$putLexicon$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartSpeechSynthesisTaskResponse startSpeechSynthesisTask(StartSpeechSynthesisTaskRequest startSpeechSynthesisTaskRequest) throws TextLengthExceededException, InvalidS3BucketException, InvalidS3KeyException, InvalidSampleRateException, InvalidSnsTopicArnException, InvalidSsmlException, EngineNotSupportedException, LexiconNotFoundException, ServiceFailureException, MarksNotSupportedForFormatException, SsmlMarksNotSupportedForTextTypeException, LanguageNotSupportedException, AwsServiceException, SdkClientException, PollyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartSpeechSynthesisTaskResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidS3BucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketException::builder).build());
                }
                case "InvalidSampleRateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSampleRateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSampleRateException::builder).build());
                }
                case "SynthesisTaskNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SynthesisTaskNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SynthesisTaskNotFoundException::builder).build());
                }
                case "MaxLexiconsNumberExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxLexiconsNumberExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxLexiconsNumberExceededException::builder).build());
                }
                case "MaxLexemeLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxLexemeLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxLexemeLengthExceededException::builder).build());
                }
                case "UnsupportedPlsAlphabetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlsAlphabetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedPlsAlphabetException::builder).build());
                }
                case "LanguageNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LanguageNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LanguageNotSupportedException::builder).build());
                }
                case "TextLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextLengthExceededException::builder).build());
                }
                case "InvalidLexiconException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLexiconException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLexiconException::builder).build());
                }
                case "SsmlMarksNotSupportedForTextTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SsmlMarksNotSupportedForTextTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SsmlMarksNotSupportedForTextTypeException::builder).build());
                }
                case "InvalidS3KeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyException::builder).build());
                }
                case "InvalidSnsTopicArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MarksNotSupportedForFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MarksNotSupportedForFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MarksNotSupportedForFormatException::builder).build());
                }
                case "InvalidTaskIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaskIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaskIdException::builder).build());
                }
                case "UnsupportedPlsLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlsLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedPlsLanguageException::builder).build());
                }
                case "LexiconNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LexiconNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(LexiconNotFoundException::builder).build());
                }
                case "LexiconSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LexiconSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LexiconSizeExceededException::builder).build());
                }
                case "InvalidSsmlException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSsmlException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSsmlException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "EngineNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EngineNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EngineNotSupportedException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startSpeechSynthesisTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPollyClient.resolveMetricPublishers(clientConfiguration, startSpeechSynthesisTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Polly");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartSpeechSynthesisTask");
            StartSpeechSynthesisTaskResponse startSpeechSynthesisTaskResponse = (StartSpeechSynthesisTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartSpeechSynthesisTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startSpeechSynthesisTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartSpeechSynthesisTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startSpeechSynthesisTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPollyClient.lambda$startSpeechSynthesisTask$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <ReturnT> ReturnT synthesizeSpeech(SynthesizeSpeechRequest synthesizeSpeechRequest, ResponseTransformer<SynthesizeSpeechResponse, ReturnT> responseTransformer) throws TextLengthExceededException, InvalidSampleRateException, InvalidSsmlException, LexiconNotFoundException, ServiceFailureException, MarksNotSupportedForFormatException, SsmlMarksNotSupportedForTextTypeException, LanguageNotSupportedException, EngineNotSupportedException, AwsServiceException, SdkClientException, PollyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(true).isPayloadJson(false).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SynthesizeSpeechResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidS3BucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketException::builder).build());
                }
                case "InvalidSampleRateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSampleRateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSampleRateException::builder).build());
                }
                case "SynthesisTaskNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SynthesisTaskNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SynthesisTaskNotFoundException::builder).build());
                }
                case "MaxLexiconsNumberExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxLexiconsNumberExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxLexiconsNumberExceededException::builder).build());
                }
                case "MaxLexemeLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxLexemeLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxLexemeLengthExceededException::builder).build());
                }
                case "UnsupportedPlsAlphabetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlsAlphabetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedPlsAlphabetException::builder).build());
                }
                case "LanguageNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LanguageNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LanguageNotSupportedException::builder).build());
                }
                case "TextLengthExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextLengthExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextLengthExceededException::builder).build());
                }
                case "InvalidLexiconException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLexiconException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLexiconException::builder).build());
                }
                case "SsmlMarksNotSupportedForTextTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SsmlMarksNotSupportedForTextTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SsmlMarksNotSupportedForTextTypeException::builder).build());
                }
                case "InvalidS3KeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyException::builder).build());
                }
                case "InvalidSnsTopicArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MarksNotSupportedForFormatException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MarksNotSupportedForFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MarksNotSupportedForFormatException::builder).build());
                }
                case "InvalidTaskIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTaskIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTaskIdException::builder).build());
                }
                case "UnsupportedPlsLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlsLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedPlsLanguageException::builder).build());
                }
                case "LexiconNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LexiconNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(LexiconNotFoundException::builder).build());
                }
                case "LexiconSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LexiconSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LexiconSizeExceededException::builder).build());
                }
                case "InvalidSsmlException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSsmlException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSsmlException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "EngineNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EngineNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EngineNotSupportedException::builder).build());
                }
                case "ServiceFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceFailureException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)synthesizeSpeechRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPollyClient.resolveMetricPublishers(clientConfiguration, synthesizeSpeechRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Polly");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SynthesizeSpeech");
            Object object = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SynthesizeSpeech").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)synthesizeSpeechRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withResponseTransformer(responseTransformer).withMarshaller((Marshaller)new SynthesizeSpeechRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)), responseTransformer);
            return (ReturnT)object;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPollyClient.lambda$synthesizeSpeech$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "polly";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        PollyServiceClientConfigurationBuilder serviceConfigBuilder = new PollyServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(PollyException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final PollyServiceClientConfiguration serviceClientConfiguration() {
        return new PollyServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$synthesizeSpeech$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startSpeechSynthesisTask$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putLexicon$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSpeechSynthesisTasks$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLexicons$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSpeechSynthesisTask$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLexicon$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeVoices$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLexicon$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

