/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.polly.model.PollyResponse;
import software.amazon.awssdk.services.polly.model.Voice;
import software.amazon.awssdk.services.polly.model.VoiceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVoicesResponse
extends PollyResponse
implements ToCopyableBuilder<Builder, DescribeVoicesResponse> {
    private static final SdkField<List<Voice>> VOICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Voices").getter(DescribeVoicesResponse.getter(DescribeVoicesResponse::voices)).setter(DescribeVoicesResponse.setter(Builder::voices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Voices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Voice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeVoicesResponse.getter(DescribeVoicesResponse::nextToken)).setter(DescribeVoicesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeVoicesResponse.memberNameToFieldInitializer();
    private final List<Voice> voices;
    private final String nextToken;

    private DescribeVoicesResponse(BuilderImpl builder) {
        super(builder);
        this.voices = builder.voices;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasVoices() {
        return this.voices != null && !(this.voices instanceof SdkAutoConstructList);
    }

    public final List<Voice> voices() {
        return this.voices;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVoices() ? this.voices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVoicesResponse)) {
            return false;
        }
        DescribeVoicesResponse other = (DescribeVoicesResponse)((Object)obj);
        return this.hasVoices() == other.hasVoices() && Objects.equals(this.voices(), other.voices()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeVoicesResponse").add("Voices", this.hasVoices() ? this.voices() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Voices": {
                return Optional.ofNullable(clazz.cast(this.voices()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Voices", VOICES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeVoicesResponse, T> g) {
        return obj -> g.apply((DescribeVoicesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PollyResponse.BuilderImpl
    implements Builder {
        private List<Voice> voices = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVoicesResponse model) {
            super(model);
            this.voices(model.voices);
            this.nextToken(model.nextToken);
        }

        public final List<Voice.Builder> getVoices() {
            List<Voice.Builder> result = VoiceListCopier.copyToBuilder(this.voices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVoices(Collection<Voice.BuilderImpl> voices) {
            this.voices = VoiceListCopier.copyFromBuilder(voices);
        }

        @Override
        public final Builder voices(Collection<Voice> voices) {
            this.voices = VoiceListCopier.copy(voices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder voices(Voice ... voices) {
            this.voices(Arrays.asList(voices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder voices(Consumer<Voice.Builder> ... voices) {
            this.voices(Stream.of(voices).map(c -> (Voice)((Voice.Builder)Voice.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeVoicesResponse build() {
            return new DescribeVoicesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PollyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVoicesResponse> {
        public Builder voices(Collection<Voice> var1);

        public Builder voices(Voice ... var1);

        public Builder voices(Consumer<Voice.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

