/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.polly.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Description of the voice.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Voice implements SdkPojo, Serializable, ToCopyableBuilder<Voice.Builder, Voice> {
    private static final SdkField<String> GENDER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Gender")
            .getter(getter(Voice::genderAsString)).setter(setter(Builder::gender))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Gender").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Voice::idAsString)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(Voice::languageCodeAsString)).setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<String> LANGUAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageName").getter(getter(Voice::languageName)).setter(setter(Builder::languageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageName").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Voice::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> ADDITIONAL_LANGUAGE_CODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AdditionalLanguageCodes")
            .getter(getter(Voice::additionalLanguageCodesAsStrings))
            .setter(setter(Builder::additionalLanguageCodesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalLanguageCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_ENGINES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedEngines")
            .getter(getter(Voice::supportedEnginesAsStrings))
            .setter(setter(Builder::supportedEnginesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedEngines").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GENDER_FIELD, ID_FIELD,
            LANGUAGE_CODE_FIELD, LANGUAGE_NAME_FIELD, NAME_FIELD, ADDITIONAL_LANGUAGE_CODES_FIELD, SUPPORTED_ENGINES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String gender;

    private final String id;

    private final String languageCode;

    private final String languageName;

    private final String name;

    private final List<String> additionalLanguageCodes;

    private final List<String> supportedEngines;

    private Voice(BuilderImpl builder) {
        this.gender = builder.gender;
        this.id = builder.id;
        this.languageCode = builder.languageCode;
        this.languageName = builder.languageName;
        this.name = builder.name;
        this.additionalLanguageCodes = builder.additionalLanguageCodes;
        this.supportedEngines = builder.supportedEngines;
    }

    /**
     * <p>
     * Gender of the voice.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gender} will
     * return {@link Gender#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #genderAsString}.
     * </p>
     * 
     * @return Gender of the voice.
     * @see Gender
     */
    public final Gender gender() {
        return Gender.fromValue(gender);
    }

    /**
     * <p>
     * Gender of the voice.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gender} will
     * return {@link Gender#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #genderAsString}.
     * </p>
     * 
     * @return Gender of the voice.
     * @see Gender
     */
    public final String genderAsString() {
        return gender;
    }

    /**
     * <p>
     * Amazon Polly assigned voice ID. This is the ID that you specify when calling the <code>SynthesizeSpeech</code>
     * operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #id} will return
     * {@link VoiceId#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #idAsString}.
     * </p>
     * 
     * @return Amazon Polly assigned voice ID. This is the ID that you specify when calling the
     *         <code>SynthesizeSpeech</code> operation.
     * @see VoiceId
     */
    public final VoiceId id() {
        return VoiceId.fromValue(id);
    }

    /**
     * <p>
     * Amazon Polly assigned voice ID. This is the ID that you specify when calling the <code>SynthesizeSpeech</code>
     * operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #id} will return
     * {@link VoiceId#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #idAsString}.
     * </p>
     * 
     * @return Amazon Polly assigned voice ID. This is the ID that you specify when calling the
     *         <code>SynthesizeSpeech</code> operation.
     * @see VoiceId
     */
    public final String idAsString() {
        return id;
    }

    /**
     * <p>
     * Language code of the voice.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return Language code of the voice.
     * @see LanguageCode
     */
    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * Language code of the voice.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return Language code of the voice.
     * @see LanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * Human readable name of the language in English.
     * </p>
     * 
     * @return Human readable name of the language in English.
     */
    public final String languageName() {
        return languageName;
    }

    /**
     * <p>
     * Name of the voice (for example, Salli, Kendra, etc.). This provides a human readable voice name that you might
     * display in your application.
     * </p>
     * 
     * @return Name of the voice (for example, Salli, Kendra, etc.). This provides a human readable voice name that you
     *         might display in your application.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Additional codes for languages available for the specified voice in addition to its default language.
     * </p>
     * <p>
     * For example, the default language for Aditi is Indian English (en-IN) because it was first used for that
     * language. Since Aditi is bilingual and fluent in both Indian English and Hindi, this parameter would show the
     * code <code>hi-IN</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalLanguageCodes} method.
     * </p>
     * 
     * @return Additional codes for languages available for the specified voice in addition to its default language.
     *         </p>
     *         <p>
     *         For example, the default language for Aditi is Indian English (en-IN) because it was first used for that
     *         language. Since Aditi is bilingual and fluent in both Indian English and Hindi, this parameter would show
     *         the code <code>hi-IN</code>.
     */
    public final List<LanguageCode> additionalLanguageCodes() {
        return LanguageCodeListCopier.copyStringToEnum(additionalLanguageCodes);
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalLanguageCodes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdditionalLanguageCodes() {
        return additionalLanguageCodes != null && !(additionalLanguageCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Additional codes for languages available for the specified voice in addition to its default language.
     * </p>
     * <p>
     * For example, the default language for Aditi is Indian English (en-IN) because it was first used for that
     * language. Since Aditi is bilingual and fluent in both Indian English and Hindi, this parameter would show the
     * code <code>hi-IN</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalLanguageCodes} method.
     * </p>
     * 
     * @return Additional codes for languages available for the specified voice in addition to its default language.
     *         </p>
     *         <p>
     *         For example, the default language for Aditi is Indian English (en-IN) because it was first used for that
     *         language. Since Aditi is bilingual and fluent in both Indian English and Hindi, this parameter would show
     *         the code <code>hi-IN</code>.
     */
    public final List<String> additionalLanguageCodesAsStrings() {
        return additionalLanguageCodes;
    }

    /**
     * <p>
     * Specifies which engines (<code>standard</code>, <code>neural</code>, <code>long-form</code> or
     * <code>generative</code>) are supported by a given voice.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedEngines} method.
     * </p>
     * 
     * @return Specifies which engines (<code>standard</code>, <code>neural</code>, <code>long-form</code> or
     *         <code>generative</code>) are supported by a given voice.
     */
    public final List<Engine> supportedEngines() {
        return EngineListCopier.copyStringToEnum(supportedEngines);
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedEngines property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSupportedEngines() {
        return supportedEngines != null && !(supportedEngines instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies which engines (<code>standard</code>, <code>neural</code>, <code>long-form</code> or
     * <code>generative</code>) are supported by a given voice.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedEngines} method.
     * </p>
     * 
     * @return Specifies which engines (<code>standard</code>, <code>neural</code>, <code>long-form</code> or
     *         <code>generative</code>) are supported by a given voice.
     */
    public final List<String> supportedEnginesAsStrings() {
        return supportedEngines;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(genderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(idAsString());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(languageName());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalLanguageCodes() ? additionalLanguageCodesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedEngines() ? supportedEnginesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Voice)) {
            return false;
        }
        Voice other = (Voice) obj;
        return Objects.equals(genderAsString(), other.genderAsString()) && Objects.equals(idAsString(), other.idAsString())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(languageName(), other.languageName()) && Objects.equals(name(), other.name())
                && hasAdditionalLanguageCodes() == other.hasAdditionalLanguageCodes()
                && Objects.equals(additionalLanguageCodesAsStrings(), other.additionalLanguageCodesAsStrings())
                && hasSupportedEngines() == other.hasSupportedEngines()
                && Objects.equals(supportedEnginesAsStrings(), other.supportedEnginesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Voice").add("Gender", genderAsString()).add("Id", idAsString())
                .add("LanguageCode", languageCodeAsString()).add("LanguageName", languageName()).add("Name", name())
                .add("AdditionalLanguageCodes", hasAdditionalLanguageCodes() ? additionalLanguageCodesAsStrings() : null)
                .add("SupportedEngines", hasSupportedEngines() ? supportedEnginesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Gender":
            return Optional.ofNullable(clazz.cast(genderAsString()));
        case "Id":
            return Optional.ofNullable(clazz.cast(idAsString()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "LanguageName":
            return Optional.ofNullable(clazz.cast(languageName()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "AdditionalLanguageCodes":
            return Optional.ofNullable(clazz.cast(additionalLanguageCodesAsStrings()));
        case "SupportedEngines":
            return Optional.ofNullable(clazz.cast(supportedEnginesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Gender", GENDER_FIELD);
        map.put("Id", ID_FIELD);
        map.put("LanguageCode", LANGUAGE_CODE_FIELD);
        map.put("LanguageName", LANGUAGE_NAME_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("AdditionalLanguageCodes", ADDITIONAL_LANGUAGE_CODES_FIELD);
        map.put("SupportedEngines", SUPPORTED_ENGINES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Voice, T> g) {
        return obj -> g.apply((Voice) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Voice> {
        /**
         * <p>
         * Gender of the voice.
         * </p>
         * 
         * @param gender
         *        Gender of the voice.
         * @see Gender
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Gender
         */
        Builder gender(String gender);

        /**
         * <p>
         * Gender of the voice.
         * </p>
         * 
         * @param gender
         *        Gender of the voice.
         * @see Gender
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Gender
         */
        Builder gender(Gender gender);

        /**
         * <p>
         * Amazon Polly assigned voice ID. This is the ID that you specify when calling the
         * <code>SynthesizeSpeech</code> operation.
         * </p>
         * 
         * @param id
         *        Amazon Polly assigned voice ID. This is the ID that you specify when calling the
         *        <code>SynthesizeSpeech</code> operation.
         * @see VoiceId
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VoiceId
         */
        Builder id(String id);

        /**
         * <p>
         * Amazon Polly assigned voice ID. This is the ID that you specify when calling the
         * <code>SynthesizeSpeech</code> operation.
         * </p>
         * 
         * @param id
         *        Amazon Polly assigned voice ID. This is the ID that you specify when calling the
         *        <code>SynthesizeSpeech</code> operation.
         * @see VoiceId
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VoiceId
         */
        Builder id(VoiceId id);

        /**
         * <p>
         * Language code of the voice.
         * </p>
         * 
         * @param languageCode
         *        Language code of the voice.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * Language code of the voice.
         * </p>
         * 
         * @param languageCode
         *        Language code of the voice.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * Human readable name of the language in English.
         * </p>
         * 
         * @param languageName
         *        Human readable name of the language in English.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageName(String languageName);

        /**
         * <p>
         * Name of the voice (for example, Salli, Kendra, etc.). This provides a human readable voice name that you
         * might display in your application.
         * </p>
         * 
         * @param name
         *        Name of the voice (for example, Salli, Kendra, etc.). This provides a human readable voice name that
         *        you might display in your application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Additional codes for languages available for the specified voice in addition to its default language.
         * </p>
         * <p>
         * For example, the default language for Aditi is Indian English (en-IN) because it was first used for that
         * language. Since Aditi is bilingual and fluent in both Indian English and Hindi, this parameter would show the
         * code <code>hi-IN</code>.
         * </p>
         * 
         * @param additionalLanguageCodes
         *        Additional codes for languages available for the specified voice in addition to its default language.
         *        </p>
         *        <p>
         *        For example, the default language for Aditi is Indian English (en-IN) because it was first used for
         *        that language. Since Aditi is bilingual and fluent in both Indian English and Hindi, this parameter
         *        would show the code <code>hi-IN</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalLanguageCodesWithStrings(Collection<String> additionalLanguageCodes);

        /**
         * <p>
         * Additional codes for languages available for the specified voice in addition to its default language.
         * </p>
         * <p>
         * For example, the default language for Aditi is Indian English (en-IN) because it was first used for that
         * language. Since Aditi is bilingual and fluent in both Indian English and Hindi, this parameter would show the
         * code <code>hi-IN</code>.
         * </p>
         * 
         * @param additionalLanguageCodes
         *        Additional codes for languages available for the specified voice in addition to its default language.
         *        </p>
         *        <p>
         *        For example, the default language for Aditi is Indian English (en-IN) because it was first used for
         *        that language. Since Aditi is bilingual and fluent in both Indian English and Hindi, this parameter
         *        would show the code <code>hi-IN</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalLanguageCodesWithStrings(String... additionalLanguageCodes);

        /**
         * <p>
         * Additional codes for languages available for the specified voice in addition to its default language.
         * </p>
         * <p>
         * For example, the default language for Aditi is Indian English (en-IN) because it was first used for that
         * language. Since Aditi is bilingual and fluent in both Indian English and Hindi, this parameter would show the
         * code <code>hi-IN</code>.
         * </p>
         * 
         * @param additionalLanguageCodes
         *        Additional codes for languages available for the specified voice in addition to its default language.
         *        </p>
         *        <p>
         *        For example, the default language for Aditi is Indian English (en-IN) because it was first used for
         *        that language. Since Aditi is bilingual and fluent in both Indian English and Hindi, this parameter
         *        would show the code <code>hi-IN</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalLanguageCodes(Collection<LanguageCode> additionalLanguageCodes);

        /**
         * <p>
         * Additional codes for languages available for the specified voice in addition to its default language.
         * </p>
         * <p>
         * For example, the default language for Aditi is Indian English (en-IN) because it was first used for that
         * language. Since Aditi is bilingual and fluent in both Indian English and Hindi, this parameter would show the
         * code <code>hi-IN</code>.
         * </p>
         * 
         * @param additionalLanguageCodes
         *        Additional codes for languages available for the specified voice in addition to its default language.
         *        </p>
         *        <p>
         *        For example, the default language for Aditi is Indian English (en-IN) because it was first used for
         *        that language. Since Aditi is bilingual and fluent in both Indian English and Hindi, this parameter
         *        would show the code <code>hi-IN</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalLanguageCodes(LanguageCode... additionalLanguageCodes);

        /**
         * <p>
         * Specifies which engines (<code>standard</code>, <code>neural</code>, <code>long-form</code> or
         * <code>generative</code>) are supported by a given voice.
         * </p>
         * 
         * @param supportedEngines
         *        Specifies which engines (<code>standard</code>, <code>neural</code>, <code>long-form</code> or
         *        <code>generative</code>) are supported by a given voice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedEnginesWithStrings(Collection<String> supportedEngines);

        /**
         * <p>
         * Specifies which engines (<code>standard</code>, <code>neural</code>, <code>long-form</code> or
         * <code>generative</code>) are supported by a given voice.
         * </p>
         * 
         * @param supportedEngines
         *        Specifies which engines (<code>standard</code>, <code>neural</code>, <code>long-form</code> or
         *        <code>generative</code>) are supported by a given voice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedEnginesWithStrings(String... supportedEngines);

        /**
         * <p>
         * Specifies which engines (<code>standard</code>, <code>neural</code>, <code>long-form</code> or
         * <code>generative</code>) are supported by a given voice.
         * </p>
         * 
         * @param supportedEngines
         *        Specifies which engines (<code>standard</code>, <code>neural</code>, <code>long-form</code> or
         *        <code>generative</code>) are supported by a given voice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedEngines(Collection<Engine> supportedEngines);

        /**
         * <p>
         * Specifies which engines (<code>standard</code>, <code>neural</code>, <code>long-form</code> or
         * <code>generative</code>) are supported by a given voice.
         * </p>
         * 
         * @param supportedEngines
         *        Specifies which engines (<code>standard</code>, <code>neural</code>, <code>long-form</code> or
         *        <code>generative</code>) are supported by a given voice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedEngines(Engine... supportedEngines);
    }

    static final class BuilderImpl implements Builder {
        private String gender;

        private String id;

        private String languageCode;

        private String languageName;

        private String name;

        private List<String> additionalLanguageCodes = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedEngines = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Voice model) {
            gender(model.gender);
            id(model.id);
            languageCode(model.languageCode);
            languageName(model.languageName);
            name(model.name);
            additionalLanguageCodesWithStrings(model.additionalLanguageCodes);
            supportedEnginesWithStrings(model.supportedEngines);
        }

        public final String getGender() {
            return gender;
        }

        public final void setGender(String gender) {
            this.gender = gender;
        }

        @Override
        public final Builder gender(String gender) {
            this.gender = gender;
            return this;
        }

        @Override
        public final Builder gender(Gender gender) {
            this.gender(gender == null ? null : gender.toString());
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public final Builder id(VoiceId id) {
            this.id(id == null ? null : id.toString());
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getLanguageName() {
            return languageName;
        }

        public final void setLanguageName(String languageName) {
            this.languageName = languageName;
        }

        @Override
        public final Builder languageName(String languageName) {
            this.languageName = languageName;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getAdditionalLanguageCodes() {
            if (additionalLanguageCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return additionalLanguageCodes;
        }

        public final void setAdditionalLanguageCodes(Collection<String> additionalLanguageCodes) {
            this.additionalLanguageCodes = LanguageCodeListCopier.copy(additionalLanguageCodes);
        }

        @Override
        public final Builder additionalLanguageCodesWithStrings(Collection<String> additionalLanguageCodes) {
            this.additionalLanguageCodes = LanguageCodeListCopier.copy(additionalLanguageCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalLanguageCodesWithStrings(String... additionalLanguageCodes) {
            additionalLanguageCodesWithStrings(Arrays.asList(additionalLanguageCodes));
            return this;
        }

        @Override
        public final Builder additionalLanguageCodes(Collection<LanguageCode> additionalLanguageCodes) {
            this.additionalLanguageCodes = LanguageCodeListCopier.copyEnumToString(additionalLanguageCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalLanguageCodes(LanguageCode... additionalLanguageCodes) {
            additionalLanguageCodes(Arrays.asList(additionalLanguageCodes));
            return this;
        }

        public final Collection<String> getSupportedEngines() {
            if (supportedEngines instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedEngines;
        }

        public final void setSupportedEngines(Collection<String> supportedEngines) {
            this.supportedEngines = EngineListCopier.copy(supportedEngines);
        }

        @Override
        public final Builder supportedEnginesWithStrings(Collection<String> supportedEngines) {
            this.supportedEngines = EngineListCopier.copy(supportedEngines);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedEnginesWithStrings(String... supportedEngines) {
            supportedEnginesWithStrings(Arrays.asList(supportedEngines));
            return this;
        }

        @Override
        public final Builder supportedEngines(Collection<Engine> supportedEngines) {
            this.supportedEngines = EngineListCopier.copyEnumToString(supportedEngines);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedEngines(Engine... supportedEngines) {
            supportedEngines(Arrays.asList(supportedEngines));
            return this;
        }

        @Override
        public Voice build() {
            return new Voice(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
