/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.polly.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SynthesizeSpeechResponse extends PollyResponse implements
        ToCopyableBuilder<SynthesizeSpeechResponse.Builder, SynthesizeSpeechResponse> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentType").getter(getter(SynthesizeSpeechResponse::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()).build();

    private static final SdkField<Integer> REQUEST_CHARACTERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RequestCharacters").getter(getter(SynthesizeSpeechResponse::requestCharacters))
            .setter(setter(Builder::requestCharacters))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-RequestCharacters").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD,
            REQUEST_CHARACTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String contentType;

    private final Integer requestCharacters;

    private SynthesizeSpeechResponse(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.requestCharacters = builder.requestCharacters;
    }

    /**
     * <p>
     * Specifies the type audio stream. This should reflect the <code>OutputFormat</code> parameter in your request.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you request <code>mp3</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned is
     * audio/mpeg.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you request <code>ogg_vorbis</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned is
     * audio/ogg.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you request <code>pcm</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned is
     * audio/pcm in a signed 16-bit, 1 channel (mono), little-endian format.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you request <code>json</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned is
     * application/x-json-stream.
     * </p>
     * </li>
     * </ul>
     * <p>
     * </p>
     * 
     * @return Specifies the type audio stream. This should reflect the <code>OutputFormat</code> parameter in your
     *         request. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you request <code>mp3</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned
     *         is audio/mpeg.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you request <code>ogg_vorbis</code> as the <code>OutputFormat</code>, the <code>ContentType</code>
     *         returned is audio/ogg.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you request <code>pcm</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned
     *         is audio/pcm in a signed 16-bit, 1 channel (mono), little-endian format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you request <code>json</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned
     *         is application/x-json-stream.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * Number of characters synthesized.
     * </p>
     * 
     * @return Number of characters synthesized.
     */
    public final Integer requestCharacters() {
        return requestCharacters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(requestCharacters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SynthesizeSpeechResponse)) {
            return false;
        }
        SynthesizeSpeechResponse other = (SynthesizeSpeechResponse) obj;
        return Objects.equals(contentType(), other.contentType())
                && Objects.equals(requestCharacters(), other.requestCharacters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SynthesizeSpeechResponse").add("ContentType", contentType())
                .add("RequestCharacters", requestCharacters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "RequestCharacters":
            return Optional.ofNullable(clazz.cast(requestCharacters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Content-Type", CONTENT_TYPE_FIELD);
        map.put("x-amzn-RequestCharacters", REQUEST_CHARACTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SynthesizeSpeechResponse, T> g) {
        return obj -> g.apply((SynthesizeSpeechResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PollyResponse.Builder, SdkPojo, CopyableBuilder<Builder, SynthesizeSpeechResponse> {
        /**
         * <p>
         * Specifies the type audio stream. This should reflect the <code>OutputFormat</code> parameter in your request.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you request <code>mp3</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned is
         * audio/mpeg.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you request <code>ogg_vorbis</code> as the <code>OutputFormat</code>, the <code>ContentType</code>
         * returned is audio/ogg.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you request <code>pcm</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned is
         * audio/pcm in a signed 16-bit, 1 channel (mono), little-endian format.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you request <code>json</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned is
         * application/x-json-stream.
         * </p>
         * </li>
         * </ul>
         * <p>
         * </p>
         * 
         * @param contentType
         *        Specifies the type audio stream. This should reflect the <code>OutputFormat</code> parameter in your
         *        request. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you request <code>mp3</code> as the <code>OutputFormat</code>, the <code>ContentType</code>
         *        returned is audio/mpeg.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you request <code>ogg_vorbis</code> as the <code>OutputFormat</code>, the <code>ContentType</code>
         *        returned is audio/ogg.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you request <code>pcm</code> as the <code>OutputFormat</code>, the <code>ContentType</code>
         *        returned is audio/pcm in a signed 16-bit, 1 channel (mono), little-endian format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you request <code>json</code> as the <code>OutputFormat</code>, the <code>ContentType</code>
         *        returned is application/x-json-stream.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * Number of characters synthesized.
         * </p>
         * 
         * @param requestCharacters
         *        Number of characters synthesized.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestCharacters(Integer requestCharacters);
    }

    static final class BuilderImpl extends PollyResponse.BuilderImpl implements Builder {
        private String contentType;

        private Integer requestCharacters;

        private BuilderImpl() {
        }

        private BuilderImpl(SynthesizeSpeechResponse model) {
            super(model);
            contentType(model.contentType);
            requestCharacters(model.requestCharacters);
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final Integer getRequestCharacters() {
            return requestCharacters;
        }

        public final void setRequestCharacters(Integer requestCharacters) {
            this.requestCharacters = requestCharacters;
        }

        @Override
        public final Builder requestCharacters(Integer requestCharacters) {
            this.requestCharacters = requestCharacters;
            return this;
        }

        @Override
        public SynthesizeSpeechResponse build() {
            return new SynthesizeSpeechResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
