/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pricing.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The constraints that you want all returned products to match.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Filter implements SdkPojo, Serializable, ToCopyableBuilder<Filter.Builder, Filter> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Filter::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Field")
            .getter(getter(Filter::field)).setter(setter(Builder::field))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Field").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(Filter::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, FIELD_FIELD,
            VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String field;

    private final String value;

    private Filter(BuilderImpl builder) {
        this.type = builder.type;
        this.field = builder.field;
        this.value = builder.value;
    }

    /**
     * <p>
     * The type of filter that you want to use.
     * </p>
     * <p>
     * Valid values are: <code>TERM_MATCH</code>. <code>TERM_MATCH</code> returns only products that match both the
     * given filter field and the given value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of filter that you want to use.</p>
     *         <p>
     *         Valid values are: <code>TERM_MATCH</code>. <code>TERM_MATCH</code> returns only products that match both
     *         the given filter field and the given value.
     * @see FilterType
     */
    public final FilterType type() {
        return FilterType.fromValue(type);
    }

    /**
     * <p>
     * The type of filter that you want to use.
     * </p>
     * <p>
     * Valid values are: <code>TERM_MATCH</code>. <code>TERM_MATCH</code> returns only products that match both the
     * given filter field and the given value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of filter that you want to use.</p>
     *         <p>
     *         Valid values are: <code>TERM_MATCH</code>. <code>TERM_MATCH</code> returns only products that match both
     *         the given filter field and the given value.
     * @see FilterType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The product metadata field that you want to filter on. You can filter by just the service code to see all
     * products for a specific service, filter by just the attribute name to see a specific attribute for multiple
     * services, or use both a service code and an attribute name to retrieve only products that match both fields.
     * </p>
     * <p>
     * Valid values include: <code>ServiceCode</code>, and all attribute names
     * </p>
     * <p>
     * For example, you can filter by the <code>AmazonEC2</code> service code and the <code>volumeType</code> attribute
     * name to get the prices for only Amazon EC2 volumes.
     * </p>
     * 
     * @return The product metadata field that you want to filter on. You can filter by just the service code to see all
     *         products for a specific service, filter by just the attribute name to see a specific attribute for
     *         multiple services, or use both a service code and an attribute name to retrieve only products that match
     *         both fields.</p>
     *         <p>
     *         Valid values include: <code>ServiceCode</code>, and all attribute names
     *         </p>
     *         <p>
     *         For example, you can filter by the <code>AmazonEC2</code> service code and the <code>volumeType</code>
     *         attribute name to get the prices for only Amazon EC2 volumes.
     */
    public final String field() {
        return field;
    }

    /**
     * <p>
     * The service code or attribute value that you want to filter by. If you are filtering by service code this is the
     * actual service code, such as <code>AmazonEC2</code>. If you are filtering by attribute name, this is the
     * attribute value that you want the returned products to match, such as a <code>Provisioned IOPS</code> volume.
     * </p>
     * 
     * @return The service code or attribute value that you want to filter by. If you are filtering by service code this
     *         is the actual service code, such as <code>AmazonEC2</code>. If you are filtering by attribute name, this
     *         is the attribute value that you want the returned products to match, such as a
     *         <code>Provisioned IOPS</code> volume.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(field());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filter)) {
            return false;
        }
        Filter other = (Filter) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(field(), other.field())
                && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Filter").add("Type", typeAsString()).add("Field", field()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Field":
            return Optional.ofNullable(clazz.cast(field()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Filter, T> g) {
        return obj -> g.apply((Filter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Filter> {
        /**
         * <p>
         * The type of filter that you want to use.
         * </p>
         * <p>
         * Valid values are: <code>TERM_MATCH</code>. <code>TERM_MATCH</code> returns only products that match both the
         * given filter field and the given value.
         * </p>
         * 
         * @param type
         *        The type of filter that you want to use.</p>
         *        <p>
         *        Valid values are: <code>TERM_MATCH</code>. <code>TERM_MATCH</code> returns only products that match
         *        both the given filter field and the given value.
         * @see FilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of filter that you want to use.
         * </p>
         * <p>
         * Valid values are: <code>TERM_MATCH</code>. <code>TERM_MATCH</code> returns only products that match both the
         * given filter field and the given value.
         * </p>
         * 
         * @param type
         *        The type of filter that you want to use.</p>
         *        <p>
         *        Valid values are: <code>TERM_MATCH</code>. <code>TERM_MATCH</code> returns only products that match
         *        both the given filter field and the given value.
         * @see FilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterType
         */
        Builder type(FilterType type);

        /**
         * <p>
         * The product metadata field that you want to filter on. You can filter by just the service code to see all
         * products for a specific service, filter by just the attribute name to see a specific attribute for multiple
         * services, or use both a service code and an attribute name to retrieve only products that match both fields.
         * </p>
         * <p>
         * Valid values include: <code>ServiceCode</code>, and all attribute names
         * </p>
         * <p>
         * For example, you can filter by the <code>AmazonEC2</code> service code and the <code>volumeType</code>
         * attribute name to get the prices for only Amazon EC2 volumes.
         * </p>
         * 
         * @param field
         *        The product metadata field that you want to filter on. You can filter by just the service code to see
         *        all products for a specific service, filter by just the attribute name to see a specific attribute for
         *        multiple services, or use both a service code and an attribute name to retrieve only products that
         *        match both fields.</p>
         *        <p>
         *        Valid values include: <code>ServiceCode</code>, and all attribute names
         *        </p>
         *        <p>
         *        For example, you can filter by the <code>AmazonEC2</code> service code and the <code>volumeType</code>
         *        attribute name to get the prices for only Amazon EC2 volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder field(String field);

        /**
         * <p>
         * The service code or attribute value that you want to filter by. If you are filtering by service code this is
         * the actual service code, such as <code>AmazonEC2</code>. If you are filtering by attribute name, this is the
         * attribute value that you want the returned products to match, such as a <code>Provisioned IOPS</code> volume.
         * </p>
         * 
         * @param value
         *        The service code or attribute value that you want to filter by. If you are filtering by service code
         *        this is the actual service code, such as <code>AmazonEC2</code>. If you are filtering by attribute
         *        name, this is the attribute value that you want the returned products to match, such as a
         *        <code>Provisioned IOPS</code> volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String field;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(Filter model) {
            type(model.type);
            field(model.field);
            value(model.value);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(FilterType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getField() {
            return field;
        }

        public final void setField(String field) {
            this.field = field;
        }

        @Override
        @Transient
        public final Builder field(String field) {
            this.field = field;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        @Transient
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public Filter build() {
            return new Filter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
