/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pricing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetProductsResponse extends PricingResponse implements
        ToCopyableBuilder<GetProductsResponse.Builder, GetProductsResponse> {
    private static final SdkField<String> FORMAT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FormatVersion").getter(getter(GetProductsResponse::formatVersion))
            .setter(setter(Builder::formatVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FormatVersion").build()).build();

    private static final SdkField<List<String>> PRICE_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PriceList")
            .getter(getter(GetProductsResponse::priceList))
            .setter(setter(Builder::priceList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PriceList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(), JsonValueTrait.create()).build()).build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetProductsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_VERSION_FIELD,
            PRICE_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final String formatVersion;

    private final List<String> priceList;

    private final String nextToken;

    private GetProductsResponse(BuilderImpl builder) {
        super(builder);
        this.formatVersion = builder.formatVersion;
        this.priceList = builder.priceList;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The format version of the response. For example, aws_v1.
     * </p>
     * 
     * @return The format version of the response. For example, aws_v1.
     */
    public final String formatVersion() {
        return formatVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the PriceList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPriceList() {
        return priceList != null && !(priceList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of products that match your filters. The list contains both the product metadata and the price
     * information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPriceList} method.
     * </p>
     * 
     * @return The list of products that match your filters. The list contains both the product metadata and the price
     *         information.
     */
    public final List<String> priceList() {
        return priceList;
    }

    /**
     * <p>
     * The pagination token that indicates the next set of results to retrieve.
     * </p>
     * 
     * @return The pagination token that indicates the next set of results to retrieve.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(formatVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasPriceList() ? priceList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProductsResponse)) {
            return false;
        }
        GetProductsResponse other = (GetProductsResponse) obj;
        return Objects.equals(formatVersion(), other.formatVersion()) && hasPriceList() == other.hasPriceList()
                && Objects.equals(priceList(), other.priceList()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetProductsResponse").add("FormatVersion", formatVersion())
                .add("PriceList", hasPriceList() ? priceList() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FormatVersion":
            return Optional.ofNullable(clazz.cast(formatVersion()));
        case "PriceList":
            return Optional.ofNullable(clazz.cast(priceList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetProductsResponse, T> g) {
        return obj -> g.apply((GetProductsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PricingResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetProductsResponse> {
        /**
         * <p>
         * The format version of the response. For example, aws_v1.
         * </p>
         * 
         * @param formatVersion
         *        The format version of the response. For example, aws_v1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formatVersion(String formatVersion);

        /**
         * <p>
         * The list of products that match your filters. The list contains both the product metadata and the price
         * information.
         * </p>
         * 
         * @param priceList
         *        The list of products that match your filters. The list contains both the product metadata and the
         *        price information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priceList(Collection<String> priceList);

        /**
         * <p>
         * The list of products that match your filters. The list contains both the product metadata and the price
         * information.
         * </p>
         * 
         * @param priceList
         *        The list of products that match your filters. The list contains both the product metadata and the
         *        price information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priceList(String... priceList);

        /**
         * <p>
         * The pagination token that indicates the next set of results to retrieve.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that indicates the next set of results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PricingResponse.BuilderImpl implements Builder {
        private String formatVersion;

        private List<String> priceList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProductsResponse model) {
            super(model);
            formatVersion(model.formatVersion);
            priceList(model.priceList);
            nextToken(model.nextToken);
        }

        public final String getFormatVersion() {
            return formatVersion;
        }

        public final void setFormatVersion(String formatVersion) {
            this.formatVersion = formatVersion;
        }

        @Override
        public final Builder formatVersion(String formatVersion) {
            this.formatVersion = formatVersion;
            return this;
        }

        public final Collection<String> getPriceList() {
            if (priceList instanceof SdkAutoConstructList) {
                return null;
            }
            return priceList;
        }

        public final void setPriceList(Collection<String> priceList) {
            this.priceList = PriceListCopier.copy(priceList);
        }

        @Override
        public final Builder priceList(Collection<String> priceList) {
            this.priceList = PriceListCopier.copy(priceList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder priceList(String... priceList) {
            priceList(Arrays.asList(priceList));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetProductsResponse build() {
            return new GetProductsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
