/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pricing;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.pricing.model.DescribeServicesRequest;
import software.amazon.awssdk.services.pricing.model.DescribeServicesResponse;
import software.amazon.awssdk.services.pricing.model.GetAttributeValuesRequest;
import software.amazon.awssdk.services.pricing.model.GetAttributeValuesResponse;
import software.amazon.awssdk.services.pricing.model.GetPriceListFileUrlRequest;
import software.amazon.awssdk.services.pricing.model.GetPriceListFileUrlResponse;
import software.amazon.awssdk.services.pricing.model.GetProductsRequest;
import software.amazon.awssdk.services.pricing.model.GetProductsResponse;
import software.amazon.awssdk.services.pricing.model.ListPriceListsRequest;
import software.amazon.awssdk.services.pricing.model.ListPriceListsResponse;
import software.amazon.awssdk.services.pricing.paginators.DescribeServicesPublisher;
import software.amazon.awssdk.services.pricing.paginators.GetAttributeValuesPublisher;
import software.amazon.awssdk.services.pricing.paginators.GetProductsPublisher;
import software.amazon.awssdk.services.pricing.paginators.ListPriceListsPublisher;

/**
 * Service client for accessing AWS Pricing asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Amazon Web Services Price List API is a centralized and convenient way to programmatically query Amazon Web Services
 * for services, products, and pricing information. The Amazon Web Services Price List uses standardized product
 * attributes such as <code>Location</code>, <code>Storage Class</code>, and <code>Operating System</code>, and provides
 * prices at the SKU level. You can use the Amazon Web Services Price List to build cost control and scenario planning
 * tools, reconcile billing data, forecast future spend for budgeting purposes, and provide cost benefit analysis that
 * compare your internal workloads with Amazon Web Services.
 * </p>
 * <p>
 * Use <code>GetServices</code> without a service code to retrieve the service codes for all AWS services, then
 * <code>GetServices</code> with a service code to retrieve the attribute names for that service. After you have the
 * service code and attribute names, you can use <code>GetAttributeValues</code> to see what values are available for an
 * attribute. With the service code and an attribute name and value, you can use <code>GetProducts</code> to find
 * specific products that you're interested in, such as an <code>AmazonEC2</code> instance, with a
 * <code>Provisioned IOPS</code> <code>volumeType</code>.
 * </p>
 * <p>
 * Service Endpoint
 * </p>
 * <p>
 * Amazon Web Services Price List service API provides the following two endpoints:
 * </p>
 * <ul>
 * <li>
 * <p>
 * https://api.pricing.us-east-1.amazonaws.com
 * </p>
 * </li>
 * <li>
 * <p>
 * https://api.pricing.ap-south-1.amazonaws.com
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface PricingAsyncClient extends AwsClient {
    String SERVICE_NAME = "pricing";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "api.pricing";

    /**
     * <p>
     * Returns the metadata for one service or a list of the metadata for all services. Use this without a service code
     * to get the service codes for all services. Use it with a service code, such as <code>AmazonEC2</code>, to get
     * information specific to that service, such as the attribute names available for that service. For example, some
     * of the attribute names available for EC2 are <code>volumeType</code>, <code>maxIopsVolume</code>,
     * <code>operation</code>, <code>locationType</code>, and <code>instanceCapacity10xlarge</code>.
     * </p>
     *
     * @param describeServicesRequest
     * @return A Java Future containing the result of the DescribeServices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException One or more parameters had an invalid value.</li>
     *         <li>NotFoundException The requested resource can't be found.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>ExpiredNextTokenException The pagination token expired. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PricingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PricingAsyncClient.DescribeServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pricing-2017-10-15/DescribeServices" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeServicesResponse> describeServices(DescribeServicesRequest describeServicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the metadata for one service or a list of the metadata for all services. Use this without a service code
     * to get the service codes for all services. Use it with a service code, such as <code>AmazonEC2</code>, to get
     * information specific to that service, such as the attribute names available for that service. For example, some
     * of the attribute names available for EC2 are <code>volumeType</code>, <code>maxIopsVolume</code>,
     * <code>operation</code>, <code>locationType</code>, and <code>instanceCapacity10xlarge</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeServicesRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeServicesRequest#builder()}
     * </p>
     *
     * @param describeServicesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeServicesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeServices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException One or more parameters had an invalid value.</li>
     *         <li>NotFoundException The requested resource can't be found.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>ExpiredNextTokenException The pagination token expired. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PricingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PricingAsyncClient.DescribeServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pricing-2017-10-15/DescribeServices" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeServicesResponse> describeServices(
            Consumer<DescribeServicesRequest.Builder> describeServicesRequest) {
        return describeServices(DescribeServicesRequest.builder().applyMutation(describeServicesRequest).build());
    }

    /**
     * <p>
     * Returns the metadata for one service or a list of the metadata for all services. Use this without a service code
     * to get the service codes for all services. Use it with a service code, such as <code>AmazonEC2</code>, to get
     * information specific to that service, such as the attribute names available for that service. For example, some
     * of the attribute names available for EC2 are <code>volumeType</code>, <code>maxIopsVolume</code>,
     * <code>operation</code>, <code>locationType</code>, and <code>instanceCapacity10xlarge</code>.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeServices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException One or more parameters had an invalid value.</li>
     *         <li>NotFoundException The requested resource can't be found.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>ExpiredNextTokenException The pagination token expired. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PricingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PricingAsyncClient.DescribeServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pricing-2017-10-15/DescribeServices" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeServicesResponse> describeServices() {
        return describeServices(DescribeServicesRequest.builder().build());
    }

    /**
     * <p>
     * Returns the metadata for one service or a list of the metadata for all services. Use this without a service code
     * to get the service codes for all services. Use it with a service code, such as <code>AmazonEC2</code>, to get
     * information specific to that service, such as the attribute names available for that service. For example, some
     * of the attribute names available for EC2 are <code>volumeType</code>, <code>maxIopsVolume</code>,
     * <code>operation</code>, <code>locationType</code>, and <code>instanceCapacity10xlarge</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeServices(software.amazon.awssdk.services.pricing.model.DescribeServicesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pricing.paginators.DescribeServicesPublisher publisher = client.describeServicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pricing.paginators.DescribeServicesPublisher publisher = client.describeServicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pricing.model.DescribeServicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pricing.model.DescribeServicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeServices(software.amazon.awssdk.services.pricing.model.DescribeServicesRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException One or more parameters had an invalid value.</li>
     *         <li>NotFoundException The requested resource can't be found.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>ExpiredNextTokenException The pagination token expired. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PricingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PricingAsyncClient.DescribeServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pricing-2017-10-15/DescribeServices" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeServicesPublisher describeServicesPaginator() {
        return describeServicesPaginator(DescribeServicesRequest.builder().build());
    }

    /**
     * <p>
     * Returns the metadata for one service or a list of the metadata for all services. Use this without a service code
     * to get the service codes for all services. Use it with a service code, such as <code>AmazonEC2</code>, to get
     * information specific to that service, such as the attribute names available for that service. For example, some
     * of the attribute names available for EC2 are <code>volumeType</code>, <code>maxIopsVolume</code>,
     * <code>operation</code>, <code>locationType</code>, and <code>instanceCapacity10xlarge</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeServices(software.amazon.awssdk.services.pricing.model.DescribeServicesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pricing.paginators.DescribeServicesPublisher publisher = client.describeServicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pricing.paginators.DescribeServicesPublisher publisher = client.describeServicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pricing.model.DescribeServicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pricing.model.DescribeServicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeServices(software.amazon.awssdk.services.pricing.model.DescribeServicesRequest)} operation.</b>
     * </p>
     *
     * @param describeServicesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException One or more parameters had an invalid value.</li>
     *         <li>NotFoundException The requested resource can't be found.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>ExpiredNextTokenException The pagination token expired. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PricingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PricingAsyncClient.DescribeServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pricing-2017-10-15/DescribeServices" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeServicesPublisher describeServicesPaginator(DescribeServicesRequest describeServicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the metadata for one service or a list of the metadata for all services. Use this without a service code
     * to get the service codes for all services. Use it with a service code, such as <code>AmazonEC2</code>, to get
     * information specific to that service, such as the attribute names available for that service. For example, some
     * of the attribute names available for EC2 are <code>volumeType</code>, <code>maxIopsVolume</code>,
     * <code>operation</code>, <code>locationType</code>, and <code>instanceCapacity10xlarge</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeServices(software.amazon.awssdk.services.pricing.model.DescribeServicesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pricing.paginators.DescribeServicesPublisher publisher = client.describeServicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pricing.paginators.DescribeServicesPublisher publisher = client.describeServicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pricing.model.DescribeServicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pricing.model.DescribeServicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeServices(software.amazon.awssdk.services.pricing.model.DescribeServicesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeServicesRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeServicesRequest#builder()}
     * </p>
     *
     * @param describeServicesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeServicesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException One or more parameters had an invalid value.</li>
     *         <li>NotFoundException The requested resource can't be found.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>ExpiredNextTokenException The pagination token expired. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PricingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PricingAsyncClient.DescribeServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pricing-2017-10-15/DescribeServices" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeServicesPublisher describeServicesPaginator(Consumer<DescribeServicesRequest.Builder> describeServicesRequest) {
        return describeServicesPaginator(DescribeServicesRequest.builder().applyMutation(describeServicesRequest).build());
    }

    /**
     * <p>
     * Returns a list of attribute values. Attributes are similar to the details in a Price List API offer file. For a
     * list of available attributes, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/reading-an-offer.html#pps-defs">Offer File
     * Definitions</a> in the <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-what-is.html">Billing and Cost
     * Management User Guide</a>.
     * </p>
     *
     * @param getAttributeValuesRequest
     * @return A Java Future containing the result of the GetAttributeValues operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException One or more parameters had an invalid value.</li>
     *         <li>NotFoundException The requested resource can't be found.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>ExpiredNextTokenException The pagination token expired. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PricingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PricingAsyncClient.GetAttributeValues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pricing-2017-10-15/GetAttributeValues" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAttributeValuesResponse> getAttributeValues(GetAttributeValuesRequest getAttributeValuesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of attribute values. Attributes are similar to the details in a Price List API offer file. For a
     * list of available attributes, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/reading-an-offer.html#pps-defs">Offer File
     * Definitions</a> in the <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-what-is.html">Billing and Cost
     * Management User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAttributeValuesRequest.Builder} avoiding the
     * need to create one manually via {@link GetAttributeValuesRequest#builder()}
     * </p>
     *
     * @param getAttributeValuesRequest
     *        A {@link Consumer} that will call methods on {@link GetAttributeValuesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAttributeValues operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException One or more parameters had an invalid value.</li>
     *         <li>NotFoundException The requested resource can't be found.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>ExpiredNextTokenException The pagination token expired. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PricingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PricingAsyncClient.GetAttributeValues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pricing-2017-10-15/GetAttributeValues" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAttributeValuesResponse> getAttributeValues(
            Consumer<GetAttributeValuesRequest.Builder> getAttributeValuesRequest) {
        return getAttributeValues(GetAttributeValuesRequest.builder().applyMutation(getAttributeValuesRequest).build());
    }

    /**
     * <p>
     * Returns a list of attribute values. Attributes are similar to the details in a Price List API offer file. For a
     * list of available attributes, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/reading-an-offer.html#pps-defs">Offer File
     * Definitions</a> in the <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-what-is.html">Billing and Cost
     * Management User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getAttributeValues(software.amazon.awssdk.services.pricing.model.GetAttributeValuesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pricing.paginators.GetAttributeValuesPublisher publisher = client.getAttributeValuesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pricing.paginators.GetAttributeValuesPublisher publisher = client.getAttributeValuesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pricing.model.GetAttributeValuesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pricing.model.GetAttributeValuesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAttributeValues(software.amazon.awssdk.services.pricing.model.GetAttributeValuesRequest)}
     * operation.</b>
     * </p>
     *
     * @param getAttributeValuesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException One or more parameters had an invalid value.</li>
     *         <li>NotFoundException The requested resource can't be found.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>ExpiredNextTokenException The pagination token expired. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PricingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PricingAsyncClient.GetAttributeValues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pricing-2017-10-15/GetAttributeValues" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAttributeValuesPublisher getAttributeValuesPaginator(GetAttributeValuesRequest getAttributeValuesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of attribute values. Attributes are similar to the details in a Price List API offer file. For a
     * list of available attributes, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/reading-an-offer.html#pps-defs">Offer File
     * Definitions</a> in the <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-what-is.html">Billing and Cost
     * Management User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getAttributeValues(software.amazon.awssdk.services.pricing.model.GetAttributeValuesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pricing.paginators.GetAttributeValuesPublisher publisher = client.getAttributeValuesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pricing.paginators.GetAttributeValuesPublisher publisher = client.getAttributeValuesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pricing.model.GetAttributeValuesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pricing.model.GetAttributeValuesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAttributeValues(software.amazon.awssdk.services.pricing.model.GetAttributeValuesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAttributeValuesRequest.Builder} avoiding the
     * need to create one manually via {@link GetAttributeValuesRequest#builder()}
     * </p>
     *
     * @param getAttributeValuesRequest
     *        A {@link Consumer} that will call methods on {@link GetAttributeValuesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException One or more parameters had an invalid value.</li>
     *         <li>NotFoundException The requested resource can't be found.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>ExpiredNextTokenException The pagination token expired. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PricingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PricingAsyncClient.GetAttributeValues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pricing-2017-10-15/GetAttributeValues" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAttributeValuesPublisher getAttributeValuesPaginator(
            Consumer<GetAttributeValuesRequest.Builder> getAttributeValuesRequest) {
        return getAttributeValuesPaginator(GetAttributeValuesRequest.builder().applyMutation(getAttributeValuesRequest).build());
    }

    /**
     * <p>
     * <i> <b>This feature is in preview release and is subject to change. Your use of Amazon Web Services Price List
     * API is subject to the Beta Service Participation terms of the <a
     * href="https://aws.amazon.com/service-terms/">Amazon Web Services Service Terms</a> (Section 1.10).</b> </i>
     * </p>
     * <p>
     * This returns the URL that you can retrieve your Price List file from. This URL is based on the
     * <code>PriceListArn</code> and <code>FileFormat</code> that you retrieve from the <a
     * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_ListPriceLists.html">
     * <code>ListPriceLists</code> </a> response.
     * </p>
     *
     * @param getPriceListFileUrlRequest
     * @return A Java Future containing the result of the GetPriceListFileUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException One or more parameters had an invalid value.</li>
     *         <li>NotFoundException The requested resource can't be found.</li>
     *         <li>AccessDeniedException General authentication failure. The request wasn't signed correctly.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PricingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PricingAsyncClient.GetPriceListFileUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pricing-2017-10-15/GetPriceListFileUrl" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetPriceListFileUrlResponse> getPriceListFileUrl(
            GetPriceListFileUrlRequest getPriceListFileUrlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <i> <b>This feature is in preview release and is subject to change. Your use of Amazon Web Services Price List
     * API is subject to the Beta Service Participation terms of the <a
     * href="https://aws.amazon.com/service-terms/">Amazon Web Services Service Terms</a> (Section 1.10).</b> </i>
     * </p>
     * <p>
     * This returns the URL that you can retrieve your Price List file from. This URL is based on the
     * <code>PriceListArn</code> and <code>FileFormat</code> that you retrieve from the <a
     * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_ListPriceLists.html">
     * <code>ListPriceLists</code> </a> response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPriceListFileUrlRequest.Builder} avoiding the
     * need to create one manually via {@link GetPriceListFileUrlRequest#builder()}
     * </p>
     *
     * @param getPriceListFileUrlRequest
     *        A {@link Consumer} that will call methods on {@link GetPriceListFileUrlRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetPriceListFileUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException One or more parameters had an invalid value.</li>
     *         <li>NotFoundException The requested resource can't be found.</li>
     *         <li>AccessDeniedException General authentication failure. The request wasn't signed correctly.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PricingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PricingAsyncClient.GetPriceListFileUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pricing-2017-10-15/GetPriceListFileUrl" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetPriceListFileUrlResponse> getPriceListFileUrl(
            Consumer<GetPriceListFileUrlRequest.Builder> getPriceListFileUrlRequest) {
        return getPriceListFileUrl(GetPriceListFileUrlRequest.builder().applyMutation(getPriceListFileUrlRequest).build());
    }

    /**
     * <p>
     * Returns a list of all products that match the filter criteria.
     * </p>
     *
     * @param getProductsRequest
     * @return A Java Future containing the result of the GetProducts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException One or more parameters had an invalid value.</li>
     *         <li>NotFoundException The requested resource can't be found.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>ExpiredNextTokenException The pagination token expired. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PricingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PricingAsyncClient.GetProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pricing-2017-10-15/GetProducts" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetProductsResponse> getProducts(GetProductsRequest getProductsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all products that match the filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProductsRequest.Builder} avoiding the need to
     * create one manually via {@link GetProductsRequest#builder()}
     * </p>
     *
     * @param getProductsRequest
     *        A {@link Consumer} that will call methods on {@link GetProductsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetProducts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException One or more parameters had an invalid value.</li>
     *         <li>NotFoundException The requested resource can't be found.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>ExpiredNextTokenException The pagination token expired. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PricingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PricingAsyncClient.GetProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pricing-2017-10-15/GetProducts" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetProductsResponse> getProducts(Consumer<GetProductsRequest.Builder> getProductsRequest) {
        return getProducts(GetProductsRequest.builder().applyMutation(getProductsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all products that match the filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getProducts(software.amazon.awssdk.services.pricing.model.GetProductsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pricing.paginators.GetProductsPublisher publisher = client.getProductsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pricing.paginators.GetProductsPublisher publisher = client.getProductsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pricing.model.GetProductsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pricing.model.GetProductsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getProducts(software.amazon.awssdk.services.pricing.model.GetProductsRequest)} operation.</b>
     * </p>
     *
     * @param getProductsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException One or more parameters had an invalid value.</li>
     *         <li>NotFoundException The requested resource can't be found.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>ExpiredNextTokenException The pagination token expired. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PricingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PricingAsyncClient.GetProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pricing-2017-10-15/GetProducts" target="_top">AWS API
     *      Documentation</a>
     */
    default GetProductsPublisher getProductsPaginator(GetProductsRequest getProductsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all products that match the filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getProducts(software.amazon.awssdk.services.pricing.model.GetProductsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pricing.paginators.GetProductsPublisher publisher = client.getProductsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pricing.paginators.GetProductsPublisher publisher = client.getProductsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pricing.model.GetProductsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pricing.model.GetProductsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getProducts(software.amazon.awssdk.services.pricing.model.GetProductsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProductsRequest.Builder} avoiding the need to
     * create one manually via {@link GetProductsRequest#builder()}
     * </p>
     *
     * @param getProductsRequest
     *        A {@link Consumer} that will call methods on {@link GetProductsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException One or more parameters had an invalid value.</li>
     *         <li>NotFoundException The requested resource can't be found.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>ExpiredNextTokenException The pagination token expired. Try again without a pagination token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PricingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PricingAsyncClient.GetProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pricing-2017-10-15/GetProducts" target="_top">AWS API
     *      Documentation</a>
     */
    default GetProductsPublisher getProductsPaginator(Consumer<GetProductsRequest.Builder> getProductsRequest) {
        return getProductsPaginator(GetProductsRequest.builder().applyMutation(getProductsRequest).build());
    }

    /**
     * <p>
     * <i> <b>This feature is in preview release and is subject to change. Your use of Amazon Web Services Price List
     * API is subject to the Beta Service Participation terms of the <a
     * href="https://aws.amazon.com/service-terms/">Amazon Web Services Service Terms</a> (Section 1.10).</b> </i>
     * </p>
     * <p>
     * This returns a list of Price List references that the requester if authorized to view, given a
     * <code>ServiceCode</code>, <code>CurrencyCode</code>, and an <code>EffectiveDate</code>. Use without a
     * <code>RegionCode</code> filter to list Price List references from all available Amazon Web Services Regions. Use
     * with a <code>RegionCode</code> filter to get the Price List reference that's specific to a specific Amazon Web
     * Services Region. You can use the <code>PriceListArn</code> from the response to get your preferred Price List
     * files through the <a
     * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_GetPriceListFileUrl.html">
     * <code>GetPriceListFileUrl</code> </a> API.
     * </p>
     *
     * @param listPriceListsRequest
     * @return A Java Future containing the result of the ListPriceLists operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException One or more parameters had an invalid value.</li>
     *         <li>NotFoundException The requested resource can't be found.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>ExpiredNextTokenException The pagination token expired. Try again without a pagination token.</li>
     *         <li>AccessDeniedException General authentication failure. The request wasn't signed correctly.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PricingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PricingAsyncClient.ListPriceLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pricing-2017-10-15/ListPriceLists" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPriceListsResponse> listPriceLists(ListPriceListsRequest listPriceListsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <i> <b>This feature is in preview release and is subject to change. Your use of Amazon Web Services Price List
     * API is subject to the Beta Service Participation terms of the <a
     * href="https://aws.amazon.com/service-terms/">Amazon Web Services Service Terms</a> (Section 1.10).</b> </i>
     * </p>
     * <p>
     * This returns a list of Price List references that the requester if authorized to view, given a
     * <code>ServiceCode</code>, <code>CurrencyCode</code>, and an <code>EffectiveDate</code>. Use without a
     * <code>RegionCode</code> filter to list Price List references from all available Amazon Web Services Regions. Use
     * with a <code>RegionCode</code> filter to get the Price List reference that's specific to a specific Amazon Web
     * Services Region. You can use the <code>PriceListArn</code> from the response to get your preferred Price List
     * files through the <a
     * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_GetPriceListFileUrl.html">
     * <code>GetPriceListFileUrl</code> </a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPriceListsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPriceListsRequest#builder()}
     * </p>
     *
     * @param listPriceListsRequest
     *        A {@link Consumer} that will call methods on {@link ListPriceListsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListPriceLists operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException One or more parameters had an invalid value.</li>
     *         <li>NotFoundException The requested resource can't be found.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>ExpiredNextTokenException The pagination token expired. Try again without a pagination token.</li>
     *         <li>AccessDeniedException General authentication failure. The request wasn't signed correctly.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PricingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PricingAsyncClient.ListPriceLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pricing-2017-10-15/ListPriceLists" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPriceListsResponse> listPriceLists(Consumer<ListPriceListsRequest.Builder> listPriceListsRequest) {
        return listPriceLists(ListPriceListsRequest.builder().applyMutation(listPriceListsRequest).build());
    }

    /**
     * <p>
     * <i> <b>This feature is in preview release and is subject to change. Your use of Amazon Web Services Price List
     * API is subject to the Beta Service Participation terms of the <a
     * href="https://aws.amazon.com/service-terms/">Amazon Web Services Service Terms</a> (Section 1.10).</b> </i>
     * </p>
     * <p>
     * This returns a list of Price List references that the requester if authorized to view, given a
     * <code>ServiceCode</code>, <code>CurrencyCode</code>, and an <code>EffectiveDate</code>. Use without a
     * <code>RegionCode</code> filter to list Price List references from all available Amazon Web Services Regions. Use
     * with a <code>RegionCode</code> filter to get the Price List reference that's specific to a specific Amazon Web
     * Services Region. You can use the <code>PriceListArn</code> from the response to get your preferred Price List
     * files through the <a
     * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_GetPriceListFileUrl.html">
     * <code>GetPriceListFileUrl</code> </a> API.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listPriceLists(software.amazon.awssdk.services.pricing.model.ListPriceListsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pricing.paginators.ListPriceListsPublisher publisher = client.listPriceListsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pricing.paginators.ListPriceListsPublisher publisher = client.listPriceListsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pricing.model.ListPriceListsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pricing.model.ListPriceListsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPriceLists(software.amazon.awssdk.services.pricing.model.ListPriceListsRequest)} operation.</b>
     * </p>
     *
     * @param listPriceListsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException One or more parameters had an invalid value.</li>
     *         <li>NotFoundException The requested resource can't be found.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>ExpiredNextTokenException The pagination token expired. Try again without a pagination token.</li>
     *         <li>AccessDeniedException General authentication failure. The request wasn't signed correctly.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PricingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PricingAsyncClient.ListPriceLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pricing-2017-10-15/ListPriceLists" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPriceListsPublisher listPriceListsPaginator(ListPriceListsRequest listPriceListsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <i> <b>This feature is in preview release and is subject to change. Your use of Amazon Web Services Price List
     * API is subject to the Beta Service Participation terms of the <a
     * href="https://aws.amazon.com/service-terms/">Amazon Web Services Service Terms</a> (Section 1.10).</b> </i>
     * </p>
     * <p>
     * This returns a list of Price List references that the requester if authorized to view, given a
     * <code>ServiceCode</code>, <code>CurrencyCode</code>, and an <code>EffectiveDate</code>. Use without a
     * <code>RegionCode</code> filter to list Price List references from all available Amazon Web Services Regions. Use
     * with a <code>RegionCode</code> filter to get the Price List reference that's specific to a specific Amazon Web
     * Services Region. You can use the <code>PriceListArn</code> from the response to get your preferred Price List
     * files through the <a
     * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_GetPriceListFileUrl.html">
     * <code>GetPriceListFileUrl</code> </a> API.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listPriceLists(software.amazon.awssdk.services.pricing.model.ListPriceListsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pricing.paginators.ListPriceListsPublisher publisher = client.listPriceListsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pricing.paginators.ListPriceListsPublisher publisher = client.listPriceListsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pricing.model.ListPriceListsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pricing.model.ListPriceListsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPriceLists(software.amazon.awssdk.services.pricing.model.ListPriceListsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPriceListsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPriceListsRequest#builder()}
     * </p>
     *
     * @param listPriceListsRequest
     *        A {@link Consumer} that will call methods on {@link ListPriceListsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException One or more parameters had an invalid value.</li>
     *         <li>NotFoundException The requested resource can't be found.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid. Try again without a pagination token.</li>
     *         <li>ExpiredNextTokenException The pagination token expired. Try again without a pagination token.</li>
     *         <li>AccessDeniedException General authentication failure. The request wasn't signed correctly.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PricingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PricingAsyncClient.ListPriceLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pricing-2017-10-15/ListPriceLists" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPriceListsPublisher listPriceListsPaginator(Consumer<ListPriceListsRequest.Builder> listPriceListsRequest) {
        return listPriceListsPaginator(ListPriceListsRequest.builder().applyMutation(listPriceListsRequest).build());
    }

    @Override
    PricingServiceClientConfiguration serviceClientConfiguration();

    /**
     * Create a {@link PricingAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static PricingAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link PricingAsyncClient}.
     */
    static PricingAsyncClientBuilder builder() {
        return new DefaultPricingAsyncClientBuilder();
    }
}
