/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.pricing.DefaultPricingAsyncClient;
import software.amazon.awssdk.services.pricing.DefaultPricingBaseClientBuilder;
import software.amazon.awssdk.services.pricing.PricingAsyncClient;
import software.amazon.awssdk.services.pricing.PricingAsyncClientBuilder;
import software.amazon.awssdk.services.pricing.PricingServiceClientConfiguration;
import software.amazon.awssdk.services.pricing.endpoints.PricingEndpointProvider;

@SdkInternalApi
final class DefaultPricingAsyncClientBuilder
extends DefaultPricingBaseClientBuilder<PricingAsyncClientBuilder, PricingAsyncClient>
implements PricingAsyncClientBuilder {
    DefaultPricingAsyncClientBuilder() {
    }

    @Override
    public DefaultPricingAsyncClientBuilder endpointProvider(PricingEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final PricingAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultPricingAsyncClientBuilder.validateClientOptions(clientConfiguration);
        PricingServiceClientConfiguration serviceClientConfiguration = PricingServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultPricingAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

