/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pricing.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeServicesRequest extends PricingRequest implements
        ToCopyableBuilder<DescribeServicesRequest.Builder, DescribeServicesRequest> {
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceCode").getter(getter(DescribeServicesRequest::serviceCode)).setter(setter(Builder::serviceCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCode").build()).build();

    private static final SdkField<String> FORMAT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FormatVersion").getter(getter(DescribeServicesRequest::formatVersion))
            .setter(setter(Builder::formatVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FormatVersion").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeServicesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeServicesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_CODE_FIELD,
            FORMAT_VERSION_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String serviceCode;

    private final String formatVersion;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeServicesRequest(BuilderImpl builder) {
        super(builder);
        this.serviceCode = builder.serviceCode;
        this.formatVersion = builder.formatVersion;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The code for the service whose information you want to retrieve, such as <code>AmazonEC2</code>. You can use the
     * <code>ServiceCode</code> to filter the results in a <code>GetProducts</code> call. To retrieve a list of all
     * services, leave this blank.
     * </p>
     * 
     * @return The code for the service whose information you want to retrieve, such as <code>AmazonEC2</code>. You can
     *         use the <code>ServiceCode</code> to filter the results in a <code>GetProducts</code> call. To retrieve a
     *         list of all services, leave this blank.
     */
    public final String serviceCode() {
        return serviceCode;
    }

    /**
     * <p>
     * The format version that you want the response to be in.
     * </p>
     * <p>
     * Valid values are: <code>aws_v1</code>
     * </p>
     * 
     * @return The format version that you want the response to be in.</p>
     *         <p>
     *         Valid values are: <code>aws_v1</code>
     */
    public final String formatVersion() {
        return formatVersion;
    }

    /**
     * <p>
     * The pagination token that indicates the next set of results that you want to retrieve.
     * </p>
     * 
     * @return The pagination token that indicates the next set of results that you want to retrieve.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results that you want returned in the response.
     * </p>
     * 
     * @return The maximum number of results that you want returned in the response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(formatVersion());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServicesRequest)) {
            return false;
        }
        DescribeServicesRequest other = (DescribeServicesRequest) obj;
        return Objects.equals(serviceCode(), other.serviceCode()) && Objects.equals(formatVersion(), other.formatVersion())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeServicesRequest").add("ServiceCode", serviceCode())
                .add("FormatVersion", formatVersion()).add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceCode":
            return Optional.ofNullable(clazz.cast(serviceCode()));
        case "FormatVersion":
            return Optional.ofNullable(clazz.cast(formatVersion()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ServiceCode", SERVICE_CODE_FIELD);
        map.put("FormatVersion", FORMAT_VERSION_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeServicesRequest, T> g) {
        return obj -> g.apply((DescribeServicesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PricingRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeServicesRequest> {
        /**
         * <p>
         * The code for the service whose information you want to retrieve, such as <code>AmazonEC2</code>. You can use
         * the <code>ServiceCode</code> to filter the results in a <code>GetProducts</code> call. To retrieve a list of
         * all services, leave this blank.
         * </p>
         * 
         * @param serviceCode
         *        The code for the service whose information you want to retrieve, such as <code>AmazonEC2</code>. You
         *        can use the <code>ServiceCode</code> to filter the results in a <code>GetProducts</code> call. To
         *        retrieve a list of all services, leave this blank.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCode(String serviceCode);

        /**
         * <p>
         * The format version that you want the response to be in.
         * </p>
         * <p>
         * Valid values are: <code>aws_v1</code>
         * </p>
         * 
         * @param formatVersion
         *        The format version that you want the response to be in.</p>
         *        <p>
         *        Valid values are: <code>aws_v1</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formatVersion(String formatVersion);

        /**
         * <p>
         * The pagination token that indicates the next set of results that you want to retrieve.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that indicates the next set of results that you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results that you want returned in the response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results that you want returned in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PricingRequest.BuilderImpl implements Builder {
        private String serviceCode;

        private String formatVersion;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServicesRequest model) {
            super(model);
            serviceCode(model.serviceCode);
            formatVersion(model.formatVersion);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getServiceCode() {
            return serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final String getFormatVersion() {
            return formatVersion;
        }

        public final void setFormatVersion(String formatVersion) {
            this.formatVersion = formatVersion;
        }

        @Override
        public final Builder formatVersion(String formatVersion) {
            this.formatVersion = formatVersion;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeServicesRequest build() {
            return new DescribeServicesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
