/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pricing.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPriceListFileUrlRequest extends PricingRequest implements
        ToCopyableBuilder<GetPriceListFileUrlRequest.Builder, GetPriceListFileUrlRequest> {
    private static final SdkField<String> PRICE_LIST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PriceListArn").getter(getter(GetPriceListFileUrlRequest::priceListArn))
            .setter(setter(Builder::priceListArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PriceListArn").build()).build();

    private static final SdkField<String> FILE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileFormat").getter(getter(GetPriceListFileUrlRequest::fileFormat)).setter(setter(Builder::fileFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileFormat").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRICE_LIST_ARN_FIELD,
            FILE_FORMAT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String priceListArn;

    private final String fileFormat;

    private GetPriceListFileUrlRequest(BuilderImpl builder) {
        super(builder);
        this.priceListArn = builder.priceListArn;
        this.fileFormat = builder.fileFormat;
    }

    /**
     * <p>
     * The unique identifier that maps to where your Price List files are located. <code>PriceListArn</code> can be
     * obtained from the <a
     * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_ListPriceLists.html"
     * >ListPriceLists</a> response.
     * </p>
     * 
     * @return The unique identifier that maps to where your Price List files are located. <code>PriceListArn</code> can
     *         be obtained from the <a href=
     *         "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_ListPriceLists.html"
     *         >ListPriceLists</a> response.
     */
    public final String priceListArn() {
        return priceListArn;
    }

    /**
     * <p>
     * The format that you want to retrieve your Price List files in. The <code>FileFormat</code> can be obtained from
     * the <a
     * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_ListPriceLists.html">
     * ListPriceLists</a> response.
     * </p>
     * 
     * @return The format that you want to retrieve your Price List files in. The <code>FileFormat</code> can be
     *         obtained from the <a href=
     *         "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_ListPriceLists.html"
     *         >ListPriceLists</a> response.
     */
    public final String fileFormat() {
        return fileFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(priceListArn());
        hashCode = 31 * hashCode + Objects.hashCode(fileFormat());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPriceListFileUrlRequest)) {
            return false;
        }
        GetPriceListFileUrlRequest other = (GetPriceListFileUrlRequest) obj;
        return Objects.equals(priceListArn(), other.priceListArn()) && Objects.equals(fileFormat(), other.fileFormat());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPriceListFileUrlRequest").add("PriceListArn", priceListArn()).add("FileFormat", fileFormat())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PriceListArn":
            return Optional.ofNullable(clazz.cast(priceListArn()));
        case "FileFormat":
            return Optional.ofNullable(clazz.cast(fileFormat()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PriceListArn", PRICE_LIST_ARN_FIELD);
        map.put("FileFormat", FILE_FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPriceListFileUrlRequest, T> g) {
        return obj -> g.apply((GetPriceListFileUrlRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PricingRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetPriceListFileUrlRequest> {
        /**
         * <p>
         * The unique identifier that maps to where your Price List files are located. <code>PriceListArn</code> can be
         * obtained from the <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_ListPriceLists.html"
         * >ListPriceLists</a> response.
         * </p>
         * 
         * @param priceListArn
         *        The unique identifier that maps to where your Price List files are located. <code>PriceListArn</code>
         *        can be obtained from the <a href=
         *        "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_ListPriceLists.html"
         *        >ListPriceLists</a> response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priceListArn(String priceListArn);

        /**
         * <p>
         * The format that you want to retrieve your Price List files in. The <code>FileFormat</code> can be obtained
         * from the <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_ListPriceLists.html"
         * >ListPriceLists</a> response.
         * </p>
         * 
         * @param fileFormat
         *        The format that you want to retrieve your Price List files in. The <code>FileFormat</code> can be
         *        obtained from the <a href=
         *        "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_ListPriceLists.html"
         *        >ListPriceLists</a> response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileFormat(String fileFormat);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PricingRequest.BuilderImpl implements Builder {
        private String priceListArn;

        private String fileFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPriceListFileUrlRequest model) {
            super(model);
            priceListArn(model.priceListArn);
            fileFormat(model.fileFormat);
        }

        public final String getPriceListArn() {
            return priceListArn;
        }

        public final void setPriceListArn(String priceListArn) {
            this.priceListArn = priceListArn;
        }

        @Override
        public final Builder priceListArn(String priceListArn) {
            this.priceListArn = priceListArn;
            return this;
        }

        public final String getFileFormat() {
            return fileFormat;
        }

        public final void setFileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
        }

        @Override
        public final Builder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPriceListFileUrlRequest build() {
            return new GetPriceListFileUrlRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
