/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pricing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * <i> <b>This feature is in preview release and is subject to change. Your use of Amazon Web Services Price List API is
 * subject to the Beta Service Participation terms of the <a href="https://aws.amazon.com/service-terms/">Amazon Web
 * Services Service Terms</a> (Section 1.10).</b> </i>
 * </p>
 * <p>
 * This is the type of price list references that match your request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PriceList implements SdkPojo, Serializable, ToCopyableBuilder<PriceList.Builder, PriceList> {
    private static final SdkField<String> PRICE_LIST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PriceListArn").getter(getter(PriceList::priceListArn)).setter(setter(Builder::priceListArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PriceListArn").build()).build();

    private static final SdkField<String> REGION_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegionCode").getter(getter(PriceList::regionCode)).setter(setter(Builder::regionCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionCode").build()).build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrencyCode").getter(getter(PriceList::currencyCode)).setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()).build();

    private static final SdkField<List<String>> FILE_FORMATS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FileFormats")
            .getter(getter(PriceList::fileFormats))
            .setter(setter(Builder::fileFormats))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileFormats").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRICE_LIST_ARN_FIELD,
            REGION_CODE_FIELD, CURRENCY_CODE_FIELD, FILE_FORMATS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String priceListArn;

    private final String regionCode;

    private final String currencyCode;

    private final List<String> fileFormats;

    private PriceList(BuilderImpl builder) {
        this.priceListArn = builder.priceListArn;
        this.regionCode = builder.regionCode;
        this.currencyCode = builder.currencyCode;
        this.fileFormats = builder.fileFormats;
    }

    /**
     * <p>
     * The unique identifier that maps to where your Price List files are located. <code>PriceListArn</code> can be
     * obtained from the <a
     * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_ListPriceLists.html">
     * <code>ListPriceList</code> </a> response.
     * </p>
     * 
     * @return The unique identifier that maps to where your Price List files are located. <code>PriceListArn</code> can
     *         be obtained from the <a href=
     *         "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_ListPriceLists.html">
     *         <code>ListPriceList</code> </a> response.
     */
    public final String priceListArn() {
        return priceListArn;
    }

    /**
     * <p>
     * This is used to filter the Price List by Amazon Web Services Region. For example, to get the price list only for
     * the <code>US East (N. Virginia)</code> Region, use <code>us-east-1</code>. If nothing is specified, you retrieve
     * price lists for all applicable Regions. The available <code>RegionCode</code> list can be retrieved from <a
     * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_GetAttributeValues.html">
     * <code>GetAttributeValues</code> </a> API.
     * </p>
     * 
     * @return This is used to filter the Price List by Amazon Web Services Region. For example, to get the price list
     *         only for the <code>US East (N. Virginia)</code> Region, use <code>us-east-1</code>. If nothing is
     *         specified, you retrieve price lists for all applicable Regions. The available <code>RegionCode</code>
     *         list can be retrieved from <a href=
     *         "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_GetAttributeValues.html"
     *         > <code>GetAttributeValues</code> </a> API.
     */
    public final String regionCode() {
        return regionCode;
    }

    /**
     * <p>
     * The three alphabetical character ISO-4217 currency code the Price List files are denominated in.
     * </p>
     * 
     * @return The three alphabetical character ISO-4217 currency code the Price List files are denominated in.
     */
    public final String currencyCode() {
        return currencyCode;
    }

    /**
     * For responses, this returns true if the service returned a value for the FileFormats property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFileFormats() {
        return fileFormats != null && !(fileFormats instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The format you want to retrieve your Price List files. The <code>FileFormat</code> can be obtained from the <a
     * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_ListPriceLists.html">
     * <code>ListPriceList</code> </a> response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFileFormats} method.
     * </p>
     * 
     * @return The format you want to retrieve your Price List files. The <code>FileFormat</code> can be obtained from
     *         the <a href=
     *         "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_ListPriceLists.html">
     *         <code>ListPriceList</code> </a> response.
     */
    public final List<String> fileFormats() {
        return fileFormats;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(priceListArn());
        hashCode = 31 * hashCode + Objects.hashCode(regionCode());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(hasFileFormats() ? fileFormats() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PriceList)) {
            return false;
        }
        PriceList other = (PriceList) obj;
        return Objects.equals(priceListArn(), other.priceListArn()) && Objects.equals(regionCode(), other.regionCode())
                && Objects.equals(currencyCode(), other.currencyCode()) && hasFileFormats() == other.hasFileFormats()
                && Objects.equals(fileFormats(), other.fileFormats());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PriceList").add("PriceListArn", priceListArn()).add("RegionCode", regionCode())
                .add("CurrencyCode", currencyCode()).add("FileFormats", hasFileFormats() ? fileFormats() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PriceListArn":
            return Optional.ofNullable(clazz.cast(priceListArn()));
        case "RegionCode":
            return Optional.ofNullable(clazz.cast(regionCode()));
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCode()));
        case "FileFormats":
            return Optional.ofNullable(clazz.cast(fileFormats()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PriceListArn", PRICE_LIST_ARN_FIELD);
        map.put("RegionCode", REGION_CODE_FIELD);
        map.put("CurrencyCode", CURRENCY_CODE_FIELD);
        map.put("FileFormats", FILE_FORMATS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PriceList, T> g) {
        return obj -> g.apply((PriceList) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PriceList> {
        /**
         * <p>
         * The unique identifier that maps to where your Price List files are located. <code>PriceListArn</code> can be
         * obtained from the <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_ListPriceLists.html">
         * <code>ListPriceList</code> </a> response.
         * </p>
         * 
         * @param priceListArn
         *        The unique identifier that maps to where your Price List files are located. <code>PriceListArn</code>
         *        can be obtained from the <a href=
         *        "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_ListPriceLists.html">
         *        <code>ListPriceList</code> </a> response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priceListArn(String priceListArn);

        /**
         * <p>
         * This is used to filter the Price List by Amazon Web Services Region. For example, to get the price list only
         * for the <code>US East (N. Virginia)</code> Region, use <code>us-east-1</code>. If nothing is specified, you
         * retrieve price lists for all applicable Regions. The available <code>RegionCode</code> list can be retrieved
         * from <a href=
         * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_GetAttributeValues.html">
         * <code>GetAttributeValues</code> </a> API.
         * </p>
         * 
         * @param regionCode
         *        This is used to filter the Price List by Amazon Web Services Region. For example, to get the price
         *        list only for the <code>US East (N. Virginia)</code> Region, use <code>us-east-1</code>. If nothing is
         *        specified, you retrieve price lists for all applicable Regions. The available <code>RegionCode</code>
         *        list can be retrieved from <a href=
         *        "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_GetAttributeValues.html"
         *        > <code>GetAttributeValues</code> </a> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionCode(String regionCode);

        /**
         * <p>
         * The three alphabetical character ISO-4217 currency code the Price List files are denominated in.
         * </p>
         * 
         * @param currencyCode
         *        The three alphabetical character ISO-4217 currency code the Price List files are denominated in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The format you want to retrieve your Price List files. The <code>FileFormat</code> can be obtained from the
         * <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_ListPriceLists.html">
         * <code>ListPriceList</code> </a> response.
         * </p>
         * 
         * @param fileFormats
         *        The format you want to retrieve your Price List files. The <code>FileFormat</code> can be obtained
         *        from the <a href=
         *        "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_ListPriceLists.html">
         *        <code>ListPriceList</code> </a> response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileFormats(Collection<String> fileFormats);

        /**
         * <p>
         * The format you want to retrieve your Price List files. The <code>FileFormat</code> can be obtained from the
         * <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_ListPriceLists.html">
         * <code>ListPriceList</code> </a> response.
         * </p>
         * 
         * @param fileFormats
         *        The format you want to retrieve your Price List files. The <code>FileFormat</code> can be obtained
         *        from the <a href=
         *        "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_pricing_ListPriceLists.html">
         *        <code>ListPriceList</code> </a> response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileFormats(String... fileFormats);
    }

    static final class BuilderImpl implements Builder {
        private String priceListArn;

        private String regionCode;

        private String currencyCode;

        private List<String> fileFormats = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PriceList model) {
            priceListArn(model.priceListArn);
            regionCode(model.regionCode);
            currencyCode(model.currencyCode);
            fileFormats(model.fileFormats);
        }

        public final String getPriceListArn() {
            return priceListArn;
        }

        public final void setPriceListArn(String priceListArn) {
            this.priceListArn = priceListArn;
        }

        @Override
        public final Builder priceListArn(String priceListArn) {
            this.priceListArn = priceListArn;
            return this;
        }

        public final String getRegionCode() {
            return regionCode;
        }

        public final void setRegionCode(String regionCode) {
            this.regionCode = regionCode;
        }

        @Override
        public final Builder regionCode(String regionCode) {
            this.regionCode = regionCode;
            return this;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final Collection<String> getFileFormats() {
            if (fileFormats instanceof SdkAutoConstructList) {
                return null;
            }
            return fileFormats;
        }

        public final void setFileFormats(Collection<String> fileFormats) {
            this.fileFormats = FileFormatsCopier.copy(fileFormats);
        }

        @Override
        public final Builder fileFormats(Collection<String> fileFormats) {
            this.fileFormats = FileFormatsCopier.copy(fileFormats);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileFormats(String... fileFormats) {
            fileFormats(Arrays.asList(fileFormats));
            return this;
        }

        @Override
        public PriceList build() {
            return new PriceList(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
