/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.privatenetworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteNetworkSiteResponse extends PrivateNetworksResponse implements
        ToCopyableBuilder<DeleteNetworkSiteResponse.Builder, DeleteNetworkSiteResponse> {
    private static final SdkField<NetworkSite> NETWORK_SITE_FIELD = SdkField.<NetworkSite> builder(MarshallingType.SDK_POJO)
            .memberName("networkSite").getter(getter(DeleteNetworkSiteResponse::networkSite))
            .setter(setter(Builder::networkSite)).constructor(NetworkSite::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkSite").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_SITE_FIELD));

    private final NetworkSite networkSite;

    private DeleteNetworkSiteResponse(BuilderImpl builder) {
        super(builder);
        this.networkSite = builder.networkSite;
    }

    /**
     * <p>
     * Information about the network site.
     * </p>
     * 
     * @return Information about the network site.
     */
    public final NetworkSite networkSite() {
        return networkSite;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(networkSite());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteNetworkSiteResponse)) {
            return false;
        }
        DeleteNetworkSiteResponse other = (DeleteNetworkSiteResponse) obj;
        return Objects.equals(networkSite(), other.networkSite());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteNetworkSiteResponse").add("NetworkSite", networkSite()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "networkSite":
            return Optional.ofNullable(clazz.cast(networkSite()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteNetworkSiteResponse, T> g) {
        return obj -> g.apply((DeleteNetworkSiteResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PrivateNetworksResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteNetworkSiteResponse> {
        /**
         * <p>
         * Information about the network site.
         * </p>
         * 
         * @param networkSite
         *        Information about the network site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkSite(NetworkSite networkSite);

        /**
         * <p>
         * Information about the network site.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkSite.Builder} avoiding the need to
         * create one manually via {@link NetworkSite#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkSite.Builder#build()} is called immediately and its result
         * is passed to {@link #networkSite(NetworkSite)}.
         * 
         * @param networkSite
         *        a consumer that will call methods on {@link NetworkSite.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkSite(NetworkSite)
         */
        default Builder networkSite(Consumer<NetworkSite.Builder> networkSite) {
            return networkSite(NetworkSite.builder().applyMutation(networkSite).build());
        }
    }

    static final class BuilderImpl extends PrivateNetworksResponse.BuilderImpl implements Builder {
        private NetworkSite networkSite;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteNetworkSiteResponse model) {
            super(model);
            networkSite(model.networkSite);
        }

        public final NetworkSite.Builder getNetworkSite() {
            return networkSite != null ? networkSite.toBuilder() : null;
        }

        public final void setNetworkSite(NetworkSite.BuilderImpl networkSite) {
            this.networkSite = networkSite != null ? networkSite.build() : null;
        }

        @Override
        public final Builder networkSite(NetworkSite networkSite) {
            this.networkSite = networkSite;
            return this;
        }

        @Override
        public DeleteNetworkSiteResponse build() {
            return new DeleteNetworkSiteResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
