/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.privatenetworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDeviceIdentifiersResponse extends PrivateNetworksResponse implements
        ToCopyableBuilder<ListDeviceIdentifiersResponse.Builder, ListDeviceIdentifiersResponse> {
    private static final SdkField<List<DeviceIdentifier>> DEVICE_IDENTIFIERS_FIELD = SdkField
            .<List<DeviceIdentifier>> builder(MarshallingType.LIST)
            .memberName("deviceIdentifiers")
            .getter(getter(ListDeviceIdentifiersResponse::deviceIdentifiers))
            .setter(setter(Builder::deviceIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeviceIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeviceIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListDeviceIdentifiersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_IDENTIFIERS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<DeviceIdentifier> deviceIdentifiers;

    private final String nextToken;

    private ListDeviceIdentifiersResponse(BuilderImpl builder) {
        super(builder);
        this.deviceIdentifiers = builder.deviceIdentifiers;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeviceIdentifiers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeviceIdentifiers() {
        return deviceIdentifiers != null && !(deviceIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the device identifiers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeviceIdentifiers} method.
     * </p>
     * 
     * @return Information about the device identifiers.
     */
    public final List<DeviceIdentifier> deviceIdentifiers() {
        return deviceIdentifiers;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDeviceIdentifiers() ? deviceIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeviceIdentifiersResponse)) {
            return false;
        }
        ListDeviceIdentifiersResponse other = (ListDeviceIdentifiersResponse) obj;
        return hasDeviceIdentifiers() == other.hasDeviceIdentifiers()
                && Objects.equals(deviceIdentifiers(), other.deviceIdentifiers())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDeviceIdentifiersResponse")
                .add("DeviceIdentifiers", hasDeviceIdentifiers() ? deviceIdentifiers() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deviceIdentifiers":
            return Optional.ofNullable(clazz.cast(deviceIdentifiers()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDeviceIdentifiersResponse, T> g) {
        return obj -> g.apply((ListDeviceIdentifiersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PrivateNetworksResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDeviceIdentifiersResponse> {
        /**
         * <p>
         * Information about the device identifiers.
         * </p>
         * 
         * @param deviceIdentifiers
         *        Information about the device identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceIdentifiers(Collection<DeviceIdentifier> deviceIdentifiers);

        /**
         * <p>
         * Information about the device identifiers.
         * </p>
         * 
         * @param deviceIdentifiers
         *        Information about the device identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceIdentifiers(DeviceIdentifier... deviceIdentifiers);

        /**
         * <p>
         * Information about the device identifiers.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<DeviceIdentifier>.Builder} avoiding
         * the need to create one manually via {@link List<DeviceIdentifier>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DeviceIdentifier>.Builder#build()} is called immediately and
         * its result is passed to {@link #deviceIdentifiers(List<DeviceIdentifier>)}.
         * 
         * @param deviceIdentifiers
         *        a consumer that will call methods on {@link List<DeviceIdentifier>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceIdentifiers(List<DeviceIdentifier>)
         */
        Builder deviceIdentifiers(Consumer<DeviceIdentifier.Builder>... deviceIdentifiers);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PrivateNetworksResponse.BuilderImpl implements Builder {
        private List<DeviceIdentifier> deviceIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeviceIdentifiersResponse model) {
            super(model);
            deviceIdentifiers(model.deviceIdentifiers);
            nextToken(model.nextToken);
        }

        public final List<DeviceIdentifier.Builder> getDeviceIdentifiers() {
            List<DeviceIdentifier.Builder> result = DeviceIdentifierListCopier.copyToBuilder(this.deviceIdentifiers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeviceIdentifiers(Collection<DeviceIdentifier.BuilderImpl> deviceIdentifiers) {
            this.deviceIdentifiers = DeviceIdentifierListCopier.copyFromBuilder(deviceIdentifiers);
        }

        @Override
        public final Builder deviceIdentifiers(Collection<DeviceIdentifier> deviceIdentifiers) {
            this.deviceIdentifiers = DeviceIdentifierListCopier.copy(deviceIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceIdentifiers(DeviceIdentifier... deviceIdentifiers) {
            deviceIdentifiers(Arrays.asList(deviceIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceIdentifiers(Consumer<DeviceIdentifier.Builder>... deviceIdentifiers) {
            deviceIdentifiers(Stream.of(deviceIdentifiers).map(c -> DeviceIdentifier.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDeviceIdentifiersResponse build() {
            return new ListDeviceIdentifiersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
