/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.privatenetworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a site plan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SitePlan implements SdkPojo, Serializable, ToCopyableBuilder<SitePlan.Builder, SitePlan> {
    private static final SdkField<List<NameValuePair>> OPTIONS_FIELD = SdkField
            .<List<NameValuePair>> builder(MarshallingType.LIST)
            .memberName("options")
            .getter(getter(SitePlan::options))
            .setter(setter(Builder::options))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("options").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NameValuePair> builder(MarshallingType.SDK_POJO)
                                            .constructor(NameValuePair::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<NetworkResourceDefinition>> RESOURCE_DEFINITIONS_FIELD = SdkField
            .<List<NetworkResourceDefinition>> builder(MarshallingType.LIST)
            .memberName("resourceDefinitions")
            .getter(getter(SitePlan::resourceDefinitions))
            .setter(setter(Builder::resourceDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NetworkResourceDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(NetworkResourceDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTIONS_FIELD,
            RESOURCE_DEFINITIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<NameValuePair> options;

    private final List<NetworkResourceDefinition> resourceDefinitions;

    private SitePlan(BuilderImpl builder) {
        this.options = builder.options;
        this.resourceDefinitions = builder.resourceDefinitions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Options property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOptions() {
        return options != null && !(options instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The options of the plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptions} method.
     * </p>
     * 
     * @return The options of the plan.
     */
    public final List<NameValuePair> options() {
        return options;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceDefinitions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceDefinitions() {
        return resourceDefinitions != null && !(resourceDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resource definitions of the plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceDefinitions} method.
     * </p>
     * 
     * @return The resource definitions of the plan.
     */
    public final List<NetworkResourceDefinition> resourceDefinitions() {
        return resourceDefinitions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOptions() ? options() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceDefinitions() ? resourceDefinitions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SitePlan)) {
            return false;
        }
        SitePlan other = (SitePlan) obj;
        return hasOptions() == other.hasOptions() && Objects.equals(options(), other.options())
                && hasResourceDefinitions() == other.hasResourceDefinitions()
                && Objects.equals(resourceDefinitions(), other.resourceDefinitions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SitePlan").add("Options", hasOptions() ? options() : null)
                .add("ResourceDefinitions", hasResourceDefinitions() ? resourceDefinitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "options":
            return Optional.ofNullable(clazz.cast(options()));
        case "resourceDefinitions":
            return Optional.ofNullable(clazz.cast(resourceDefinitions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SitePlan, T> g) {
        return obj -> g.apply((SitePlan) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SitePlan> {
        /**
         * <p>
         * The options of the plan.
         * </p>
         * 
         * @param options
         *        The options of the plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(Collection<NameValuePair> options);

        /**
         * <p>
         * The options of the plan.
         * </p>
         * 
         * @param options
         *        The options of the plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(NameValuePair... options);

        /**
         * <p>
         * The options of the plan.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<NameValuePair>.Builder} avoiding the
         * need to create one manually via {@link List<NameValuePair>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NameValuePair>.Builder#build()} is called immediately and
         * its result is passed to {@link #options(List<NameValuePair>)}.
         * 
         * @param options
         *        a consumer that will call methods on {@link List<NameValuePair>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(List<NameValuePair>)
         */
        Builder options(Consumer<NameValuePair.Builder>... options);

        /**
         * <p>
         * The resource definitions of the plan.
         * </p>
         * 
         * @param resourceDefinitions
         *        The resource definitions of the plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceDefinitions(Collection<NetworkResourceDefinition> resourceDefinitions);

        /**
         * <p>
         * The resource definitions of the plan.
         * </p>
         * 
         * @param resourceDefinitions
         *        The resource definitions of the plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceDefinitions(NetworkResourceDefinition... resourceDefinitions);

        /**
         * <p>
         * The resource definitions of the plan.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<NetworkResourceDefinition>.Builder}
         * avoiding the need to create one manually via {@link List<NetworkResourceDefinition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NetworkResourceDefinition>.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceDefinitions(List<NetworkResourceDefinition>)}.
         * 
         * @param resourceDefinitions
         *        a consumer that will call methods on {@link List<NetworkResourceDefinition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceDefinitions(List<NetworkResourceDefinition>)
         */
        Builder resourceDefinitions(Consumer<NetworkResourceDefinition.Builder>... resourceDefinitions);
    }

    static final class BuilderImpl implements Builder {
        private List<NameValuePair> options = DefaultSdkAutoConstructList.getInstance();

        private List<NetworkResourceDefinition> resourceDefinitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SitePlan model) {
            options(model.options);
            resourceDefinitions(model.resourceDefinitions);
        }

        public final List<NameValuePair.Builder> getOptions() {
            List<NameValuePair.Builder> result = OptionsCopier.copyToBuilder(this.options);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptions(Collection<NameValuePair.BuilderImpl> options) {
            this.options = OptionsCopier.copyFromBuilder(options);
        }

        @Override
        public final Builder options(Collection<NameValuePair> options) {
            this.options = OptionsCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(NameValuePair... options) {
            options(Arrays.asList(options));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(Consumer<NameValuePair.Builder>... options) {
            options(Stream.of(options).map(c -> NameValuePair.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<NetworkResourceDefinition.Builder> getResourceDefinitions() {
            List<NetworkResourceDefinition.Builder> result = NetworkResourceDefinitionsCopier
                    .copyToBuilder(this.resourceDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceDefinitions(Collection<NetworkResourceDefinition.BuilderImpl> resourceDefinitions) {
            this.resourceDefinitions = NetworkResourceDefinitionsCopier.copyFromBuilder(resourceDefinitions);
        }

        @Override
        public final Builder resourceDefinitions(Collection<NetworkResourceDefinition> resourceDefinitions) {
            this.resourceDefinitions = NetworkResourceDefinitionsCopier.copy(resourceDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceDefinitions(NetworkResourceDefinition... resourceDefinitions) {
            resourceDefinitions(Arrays.asList(resourceDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceDefinitions(Consumer<NetworkResourceDefinition.Builder>... resourceDefinitions) {
            resourceDefinitions(Stream.of(resourceDefinitions)
                    .map(c -> NetworkResourceDefinition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SitePlan build() {
            return new SitePlan(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
