/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.privatenetworks.model.CommitmentLength;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CommitmentConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CommitmentConfiguration> {
    private static final SdkField<Boolean> AUTOMATIC_RENEWAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("automaticRenewal").getter(CommitmentConfiguration.getter(CommitmentConfiguration::automaticRenewal)).setter(CommitmentConfiguration.setter(Builder::automaticRenewal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("automaticRenewal").build()}).build();
    private static final SdkField<String> COMMITMENT_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("commitmentLength").getter(CommitmentConfiguration.getter(CommitmentConfiguration::commitmentLengthAsString)).setter(CommitmentConfiguration.setter(Builder::commitmentLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitmentLength").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATIC_RENEWAL_FIELD, COMMITMENT_LENGTH_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean automaticRenewal;
    private final String commitmentLength;

    private CommitmentConfiguration(BuilderImpl builder) {
        this.automaticRenewal = builder.automaticRenewal;
        this.commitmentLength = builder.commitmentLength;
    }

    public final Boolean automaticRenewal() {
        return this.automaticRenewal;
    }

    public final CommitmentLength commitmentLength() {
        return CommitmentLength.fromValue(this.commitmentLength);
    }

    public final String commitmentLengthAsString() {
        return this.commitmentLength;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticRenewal());
        hashCode = 31 * hashCode + Objects.hashCode(this.commitmentLengthAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommitmentConfiguration)) {
            return false;
        }
        CommitmentConfiguration other = (CommitmentConfiguration)obj;
        return Objects.equals(this.automaticRenewal(), other.automaticRenewal()) && Objects.equals(this.commitmentLengthAsString(), other.commitmentLengthAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CommitmentConfiguration").add("AutomaticRenewal", (Object)this.automaticRenewal()).add("CommitmentLength", (Object)this.commitmentLengthAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "automaticRenewal": {
                return Optional.ofNullable(clazz.cast(this.automaticRenewal()));
            }
            case "commitmentLength": {
                return Optional.ofNullable(clazz.cast(this.commitmentLengthAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CommitmentConfiguration, T> g) {
        return obj -> g.apply((CommitmentConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean automaticRenewal;
        private String commitmentLength;

        private BuilderImpl() {
        }

        private BuilderImpl(CommitmentConfiguration model) {
            this.automaticRenewal(model.automaticRenewal);
            this.commitmentLength(model.commitmentLength);
        }

        public final Boolean getAutomaticRenewal() {
            return this.automaticRenewal;
        }

        public final void setAutomaticRenewal(Boolean automaticRenewal) {
            this.automaticRenewal = automaticRenewal;
        }

        @Override
        public final Builder automaticRenewal(Boolean automaticRenewal) {
            this.automaticRenewal = automaticRenewal;
            return this;
        }

        public final String getCommitmentLength() {
            return this.commitmentLength;
        }

        public final void setCommitmentLength(String commitmentLength) {
            this.commitmentLength = commitmentLength;
        }

        @Override
        public final Builder commitmentLength(String commitmentLength) {
            this.commitmentLength = commitmentLength;
            return this;
        }

        @Override
        public final Builder commitmentLength(CommitmentLength commitmentLength) {
            this.commitmentLength(commitmentLength == null ? null : commitmentLength.toString());
            return this;
        }

        public CommitmentConfiguration build() {
            return new CommitmentConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CommitmentConfiguration> {
        public Builder automaticRenewal(Boolean var1);

        public Builder commitmentLength(String var1);

        public Builder commitmentLength(CommitmentLength var1);
    }
}

