/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.privatenetworks.PrivateNetworksClient;
import software.amazon.awssdk.services.privatenetworks.internal.UserAgentUtils;
import software.amazon.awssdk.services.privatenetworks.model.ListNetworksRequest;
import software.amazon.awssdk.services.privatenetworks.model.ListNetworksResponse;
import software.amazon.awssdk.services.privatenetworks.model.Network;

public class ListNetworksIterable
implements SdkIterable<ListNetworksResponse> {
    private final PrivateNetworksClient client;
    private final ListNetworksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListNetworksIterable(PrivateNetworksClient client, ListNetworksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListNetworksResponseFetcher();
    }

    public Iterator<ListNetworksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Network> networks() {
        Function<ListNetworksResponse, Iterator> getIterator = response -> {
            if (response != null && response.networks() != null) {
                return response.networks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListNetworksResponseFetcher
    implements SyncPageFetcher<ListNetworksResponse> {
        private ListNetworksResponseFetcher() {
        }

        public boolean hasNextPage(ListNetworksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListNetworksResponse nextPage(ListNetworksResponse previousPage) {
            if (previousPage == null) {
                return ListNetworksIterable.this.client.listNetworks(ListNetworksIterable.this.firstRequest);
            }
            return ListNetworksIterable.this.client.listNetworks((ListNetworksRequest)((Object)ListNetworksIterable.this.firstRequest.toBuilder().startToken(previousPage.nextToken()).build()));
        }
    }
}

