/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.privatenetworks;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.privatenetworks.model.AccessDeniedException;
import software.amazon.awssdk.services.privatenetworks.model.AcknowledgeOrderReceiptRequest;
import software.amazon.awssdk.services.privatenetworks.model.AcknowledgeOrderReceiptResponse;
import software.amazon.awssdk.services.privatenetworks.model.ActivateDeviceIdentifierRequest;
import software.amazon.awssdk.services.privatenetworks.model.ActivateDeviceIdentifierResponse;
import software.amazon.awssdk.services.privatenetworks.model.ActivateNetworkSiteRequest;
import software.amazon.awssdk.services.privatenetworks.model.ActivateNetworkSiteResponse;
import software.amazon.awssdk.services.privatenetworks.model.ConfigureAccessPointRequest;
import software.amazon.awssdk.services.privatenetworks.model.ConfigureAccessPointResponse;
import software.amazon.awssdk.services.privatenetworks.model.CreateNetworkRequest;
import software.amazon.awssdk.services.privatenetworks.model.CreateNetworkResponse;
import software.amazon.awssdk.services.privatenetworks.model.CreateNetworkSiteRequest;
import software.amazon.awssdk.services.privatenetworks.model.CreateNetworkSiteResponse;
import software.amazon.awssdk.services.privatenetworks.model.DeactivateDeviceIdentifierRequest;
import software.amazon.awssdk.services.privatenetworks.model.DeactivateDeviceIdentifierResponse;
import software.amazon.awssdk.services.privatenetworks.model.DeleteNetworkRequest;
import software.amazon.awssdk.services.privatenetworks.model.DeleteNetworkResponse;
import software.amazon.awssdk.services.privatenetworks.model.DeleteNetworkSiteRequest;
import software.amazon.awssdk.services.privatenetworks.model.DeleteNetworkSiteResponse;
import software.amazon.awssdk.services.privatenetworks.model.GetDeviceIdentifierRequest;
import software.amazon.awssdk.services.privatenetworks.model.GetDeviceIdentifierResponse;
import software.amazon.awssdk.services.privatenetworks.model.GetNetworkRequest;
import software.amazon.awssdk.services.privatenetworks.model.GetNetworkResourceRequest;
import software.amazon.awssdk.services.privatenetworks.model.GetNetworkResourceResponse;
import software.amazon.awssdk.services.privatenetworks.model.GetNetworkResponse;
import software.amazon.awssdk.services.privatenetworks.model.GetNetworkSiteRequest;
import software.amazon.awssdk.services.privatenetworks.model.GetNetworkSiteResponse;
import software.amazon.awssdk.services.privatenetworks.model.GetOrderRequest;
import software.amazon.awssdk.services.privatenetworks.model.GetOrderResponse;
import software.amazon.awssdk.services.privatenetworks.model.InternalServerException;
import software.amazon.awssdk.services.privatenetworks.model.LimitExceededException;
import software.amazon.awssdk.services.privatenetworks.model.ListDeviceIdentifiersRequest;
import software.amazon.awssdk.services.privatenetworks.model.ListDeviceIdentifiersResponse;
import software.amazon.awssdk.services.privatenetworks.model.ListNetworkResourcesRequest;
import software.amazon.awssdk.services.privatenetworks.model.ListNetworkResourcesResponse;
import software.amazon.awssdk.services.privatenetworks.model.ListNetworkSitesRequest;
import software.amazon.awssdk.services.privatenetworks.model.ListNetworkSitesResponse;
import software.amazon.awssdk.services.privatenetworks.model.ListNetworksRequest;
import software.amazon.awssdk.services.privatenetworks.model.ListNetworksResponse;
import software.amazon.awssdk.services.privatenetworks.model.ListOrdersRequest;
import software.amazon.awssdk.services.privatenetworks.model.ListOrdersResponse;
import software.amazon.awssdk.services.privatenetworks.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.privatenetworks.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.privatenetworks.model.PingRequest;
import software.amazon.awssdk.services.privatenetworks.model.PingResponse;
import software.amazon.awssdk.services.privatenetworks.model.PrivateNetworksException;
import software.amazon.awssdk.services.privatenetworks.model.ResourceNotFoundException;
import software.amazon.awssdk.services.privatenetworks.model.StartNetworkResourceUpdateRequest;
import software.amazon.awssdk.services.privatenetworks.model.StartNetworkResourceUpdateResponse;
import software.amazon.awssdk.services.privatenetworks.model.TagResourceRequest;
import software.amazon.awssdk.services.privatenetworks.model.TagResourceResponse;
import software.amazon.awssdk.services.privatenetworks.model.ThrottlingException;
import software.amazon.awssdk.services.privatenetworks.model.UntagResourceRequest;
import software.amazon.awssdk.services.privatenetworks.model.UntagResourceResponse;
import software.amazon.awssdk.services.privatenetworks.model.UpdateNetworkSitePlanRequest;
import software.amazon.awssdk.services.privatenetworks.model.UpdateNetworkSitePlanResponse;
import software.amazon.awssdk.services.privatenetworks.model.UpdateNetworkSiteRequest;
import software.amazon.awssdk.services.privatenetworks.model.UpdateNetworkSiteResponse;
import software.amazon.awssdk.services.privatenetworks.model.ValidationException;
import software.amazon.awssdk.services.privatenetworks.paginators.ListDeviceIdentifiersIterable;
import software.amazon.awssdk.services.privatenetworks.paginators.ListNetworkResourcesIterable;
import software.amazon.awssdk.services.privatenetworks.paginators.ListNetworkSitesIterable;
import software.amazon.awssdk.services.privatenetworks.paginators.ListNetworksIterable;
import software.amazon.awssdk.services.privatenetworks.paginators.ListOrdersIterable;

/**
 * Service client for accessing AWS Private 5G. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Web Services Private 5G is a managed service that makes it easy to deploy, operate, and scale your own private
 * mobile network at your on-premises location. Private 5G provides the pre-configured hardware and software for mobile
 * networks, helps automate setup, and scales capacity on demand to support additional devices as needed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface PrivateNetworksClient extends AwsClient {
    String SERVICE_NAME = "private-networks";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "private-networks";

    /**
     * <p>
     * Acknowledges that the specified network order was received.
     * </p>
     *
     * @param acknowledgeOrderReceiptRequest
     * @return Result of the AcknowledgeOrderReceipt operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.AcknowledgeOrderReceipt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/AcknowledgeOrderReceipt"
     *      target="_top">AWS API Documentation</a>
     */
    default AcknowledgeOrderReceiptResponse acknowledgeOrderReceipt(AcknowledgeOrderReceiptRequest acknowledgeOrderReceiptRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PrivateNetworksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Acknowledges that the specified network order was received.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcknowledgeOrderReceiptRequest.Builder} avoiding
     * the need to create one manually via {@link AcknowledgeOrderReceiptRequest#builder()}
     * </p>
     *
     * @param acknowledgeOrderReceiptRequest
     *        A {@link Consumer} that will call methods on {@link AcknowledgeOrderReceiptRequest.Builder} to create a
     *        request.
     * @return Result of the AcknowledgeOrderReceipt operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.AcknowledgeOrderReceipt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/AcknowledgeOrderReceipt"
     *      target="_top">AWS API Documentation</a>
     */
    default AcknowledgeOrderReceiptResponse acknowledgeOrderReceipt(
            Consumer<AcknowledgeOrderReceiptRequest.Builder> acknowledgeOrderReceiptRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, PrivateNetworksException {
        return acknowledgeOrderReceipt(AcknowledgeOrderReceiptRequest.builder().applyMutation(acknowledgeOrderReceiptRequest)
                .build());
    }

    /**
     * <p>
     * Activates the specified device identifier.
     * </p>
     *
     * @param activateDeviceIdentifierRequest
     * @return Result of the ActivateDeviceIdentifier operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.ActivateDeviceIdentifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ActivateDeviceIdentifier"
     *      target="_top">AWS API Documentation</a>
     */
    default ActivateDeviceIdentifierResponse activateDeviceIdentifier(
            ActivateDeviceIdentifierRequest activateDeviceIdentifierRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, PrivateNetworksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activates the specified device identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ActivateDeviceIdentifierRequest.Builder} avoiding
     * the need to create one manually via {@link ActivateDeviceIdentifierRequest#builder()}
     * </p>
     *
     * @param activateDeviceIdentifierRequest
     *        A {@link Consumer} that will call methods on {@link ActivateDeviceIdentifierRequest.Builder} to create a
     *        request.
     * @return Result of the ActivateDeviceIdentifier operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.ActivateDeviceIdentifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ActivateDeviceIdentifier"
     *      target="_top">AWS API Documentation</a>
     */
    default ActivateDeviceIdentifierResponse activateDeviceIdentifier(
            Consumer<ActivateDeviceIdentifierRequest.Builder> activateDeviceIdentifierRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, PrivateNetworksException {
        return activateDeviceIdentifier(ActivateDeviceIdentifierRequest.builder().applyMutation(activateDeviceIdentifierRequest)
                .build());
    }

    /**
     * <p>
     * Activates the specified network site.
     * </p>
     *
     * @param activateNetworkSiteRequest
     * @return Result of the ActivateNetworkSite operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.ActivateNetworkSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ActivateNetworkSite"
     *      target="_top">AWS API Documentation</a>
     */
    default ActivateNetworkSiteResponse activateNetworkSite(ActivateNetworkSiteRequest activateNetworkSiteRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PrivateNetworksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activates the specified network site.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ActivateNetworkSiteRequest.Builder} avoiding the
     * need to create one manually via {@link ActivateNetworkSiteRequest#builder()}
     * </p>
     *
     * @param activateNetworkSiteRequest
     *        A {@link Consumer} that will call methods on {@link ActivateNetworkSiteRequest.Builder} to create a
     *        request.
     * @return Result of the ActivateNetworkSite operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.ActivateNetworkSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ActivateNetworkSite"
     *      target="_top">AWS API Documentation</a>
     */
    default ActivateNetworkSiteResponse activateNetworkSite(
            Consumer<ActivateNetworkSiteRequest.Builder> activateNetworkSiteRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, PrivateNetworksException {
        return activateNetworkSite(ActivateNetworkSiteRequest.builder().applyMutation(activateNetworkSiteRequest).build());
    }

    /**
     * <p>
     * Configures the specified network resource.
     * </p>
     * <p>
     * Use this action to specify the geographic position of the hardware. You must provide Certified Professional
     * Installer (CPI) credentials in the request so that we can obtain spectrum grants. For more information, see <a
     * href="https://docs.aws.amazon.com/private-networks/latest/userguide/radio-units.html">Radio units</a> in the
     * <i>Amazon Web Services Private 5G User Guide</i>.
     * </p>
     *
     * @param configureAccessPointRequest
     * @return Result of the ConfigureAccessPoint operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.ConfigureAccessPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ConfigureAccessPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default ConfigureAccessPointResponse configureAccessPoint(ConfigureAccessPointRequest configureAccessPointRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PrivateNetworksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures the specified network resource.
     * </p>
     * <p>
     * Use this action to specify the geographic position of the hardware. You must provide Certified Professional
     * Installer (CPI) credentials in the request so that we can obtain spectrum grants. For more information, see <a
     * href="https://docs.aws.amazon.com/private-networks/latest/userguide/radio-units.html">Radio units</a> in the
     * <i>Amazon Web Services Private 5G User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ConfigureAccessPointRequest.Builder} avoiding the
     * need to create one manually via {@link ConfigureAccessPointRequest#builder()}
     * </p>
     *
     * @param configureAccessPointRequest
     *        A {@link Consumer} that will call methods on {@link ConfigureAccessPointRequest.Builder} to create a
     *        request.
     * @return Result of the ConfigureAccessPoint operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.ConfigureAccessPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ConfigureAccessPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default ConfigureAccessPointResponse configureAccessPoint(
            Consumer<ConfigureAccessPointRequest.Builder> configureAccessPointRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, PrivateNetworksException {
        return configureAccessPoint(ConfigureAccessPointRequest.builder().applyMutation(configureAccessPointRequest).build());
    }

    /**
     * <p>
     * Creates a network.
     * </p>
     *
     * @param createNetworkRequest
     * @return Result of the CreateNetwork operation returned by the service.
     * @throws LimitExceededException
     *         The limit was exceeded.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.CreateNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/CreateNetwork" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateNetworkResponse createNetwork(CreateNetworkRequest createNetworkRequest) throws LimitExceededException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, PrivateNetworksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNetworkRequest.Builder} avoiding the need to
     * create one manually via {@link CreateNetworkRequest#builder()}
     * </p>
     *
     * @param createNetworkRequest
     *        A {@link Consumer} that will call methods on {@link CreateNetworkRequest.Builder} to create a request.
     * @return Result of the CreateNetwork operation returned by the service.
     * @throws LimitExceededException
     *         The limit was exceeded.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.CreateNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/CreateNetwork" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateNetworkResponse createNetwork(Consumer<CreateNetworkRequest.Builder> createNetworkRequest)
            throws LimitExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            PrivateNetworksException {
        return createNetwork(CreateNetworkRequest.builder().applyMutation(createNetworkRequest).build());
    }

    /**
     * <p>
     * Creates a network site.
     * </p>
     *
     * @param createNetworkSiteRequest
     * @return Result of the CreateNetworkSite operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.CreateNetworkSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/CreateNetworkSite"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNetworkSiteResponse createNetworkSite(CreateNetworkSiteRequest createNetworkSiteRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PrivateNetworksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a network site.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNetworkSiteRequest.Builder} avoiding the need
     * to create one manually via {@link CreateNetworkSiteRequest#builder()}
     * </p>
     *
     * @param createNetworkSiteRequest
     *        A {@link Consumer} that will call methods on {@link CreateNetworkSiteRequest.Builder} to create a request.
     * @return Result of the CreateNetworkSite operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.CreateNetworkSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/CreateNetworkSite"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNetworkSiteResponse createNetworkSite(Consumer<CreateNetworkSiteRequest.Builder> createNetworkSiteRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PrivateNetworksException {
        return createNetworkSite(CreateNetworkSiteRequest.builder().applyMutation(createNetworkSiteRequest).build());
    }

    /**
     * <p>
     * Deactivates the specified device identifier.
     * </p>
     *
     * @param deactivateDeviceIdentifierRequest
     * @return Result of the DeactivateDeviceIdentifier operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.DeactivateDeviceIdentifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/DeactivateDeviceIdentifier"
     *      target="_top">AWS API Documentation</a>
     */
    default DeactivateDeviceIdentifierResponse deactivateDeviceIdentifier(
            DeactivateDeviceIdentifierRequest deactivateDeviceIdentifierRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, PrivateNetworksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deactivates the specified device identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeactivateDeviceIdentifierRequest.Builder} avoiding
     * the need to create one manually via {@link DeactivateDeviceIdentifierRequest#builder()}
     * </p>
     *
     * @param deactivateDeviceIdentifierRequest
     *        A {@link Consumer} that will call methods on {@link DeactivateDeviceIdentifierRequest.Builder} to create a
     *        request.
     * @return Result of the DeactivateDeviceIdentifier operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.DeactivateDeviceIdentifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/DeactivateDeviceIdentifier"
     *      target="_top">AWS API Documentation</a>
     */
    default DeactivateDeviceIdentifierResponse deactivateDeviceIdentifier(
            Consumer<DeactivateDeviceIdentifierRequest.Builder> deactivateDeviceIdentifierRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PrivateNetworksException {
        return deactivateDeviceIdentifier(DeactivateDeviceIdentifierRequest.builder()
                .applyMutation(deactivateDeviceIdentifierRequest).build());
    }

    /**
     * <p>
     * Deletes the specified network. You must delete network sites before you delete the network. For more information,
     * see <a href="https://docs.aws.amazon.com/private-networks/latest/APIReference/API_DeleteNetworkSite.html">
     * DeleteNetworkSite</a> in the <i>API Reference for Amazon Web Services Private 5G</i>.
     * </p>
     *
     * @param deleteNetworkRequest
     * @return Result of the DeleteNetwork operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.DeleteNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/DeleteNetwork" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteNetworkResponse deleteNetwork(DeleteNetworkRequest deleteNetworkRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            PrivateNetworksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified network. You must delete network sites before you delete the network. For more information,
     * see <a href="https://docs.aws.amazon.com/private-networks/latest/APIReference/API_DeleteNetworkSite.html">
     * DeleteNetworkSite</a> in the <i>API Reference for Amazon Web Services Private 5G</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNetworkRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteNetworkRequest#builder()}
     * </p>
     *
     * @param deleteNetworkRequest
     *        A {@link Consumer} that will call methods on {@link DeleteNetworkRequest.Builder} to create a request.
     * @return Result of the DeleteNetwork operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.DeleteNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/DeleteNetwork" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteNetworkResponse deleteNetwork(Consumer<DeleteNetworkRequest.Builder> deleteNetworkRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, PrivateNetworksException {
        return deleteNetwork(DeleteNetworkRequest.builder().applyMutation(deleteNetworkRequest).build());
    }

    /**
     * <p>
     * Deletes the specified network site. Return the hardware after you delete the network site. You are responsible
     * for minimum charges. For more information, see <a
     * href="https://docs.aws.amazon.com/private-networks/latest/userguide/hardware-maintenance.html">Hardware
     * returns</a> in the <i>Amazon Web Services Private 5G User Guide</i>.
     * </p>
     *
     * @param deleteNetworkSiteRequest
     * @return Result of the DeleteNetworkSite operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.DeleteNetworkSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/DeleteNetworkSite"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNetworkSiteResponse deleteNetworkSite(DeleteNetworkSiteRequest deleteNetworkSiteRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, PrivateNetworksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified network site. Return the hardware after you delete the network site. You are responsible
     * for minimum charges. For more information, see <a
     * href="https://docs.aws.amazon.com/private-networks/latest/userguide/hardware-maintenance.html">Hardware
     * returns</a> in the <i>Amazon Web Services Private 5G User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNetworkSiteRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteNetworkSiteRequest#builder()}
     * </p>
     *
     * @param deleteNetworkSiteRequest
     *        A {@link Consumer} that will call methods on {@link DeleteNetworkSiteRequest.Builder} to create a request.
     * @return Result of the DeleteNetworkSite operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.DeleteNetworkSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/DeleteNetworkSite"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNetworkSiteResponse deleteNetworkSite(Consumer<DeleteNetworkSiteRequest.Builder> deleteNetworkSiteRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, PrivateNetworksException {
        return deleteNetworkSite(DeleteNetworkSiteRequest.builder().applyMutation(deleteNetworkSiteRequest).build());
    }

    /**
     * <p>
     * Gets the specified device identifier.
     * </p>
     *
     * @param getDeviceIdentifierRequest
     * @return Result of the GetDeviceIdentifier operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.GetDeviceIdentifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/GetDeviceIdentifier"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDeviceIdentifierResponse getDeviceIdentifier(GetDeviceIdentifierRequest getDeviceIdentifierRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PrivateNetworksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the specified device identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeviceIdentifierRequest.Builder} avoiding the
     * need to create one manually via {@link GetDeviceIdentifierRequest#builder()}
     * </p>
     *
     * @param getDeviceIdentifierRequest
     *        A {@link Consumer} that will call methods on {@link GetDeviceIdentifierRequest.Builder} to create a
     *        request.
     * @return Result of the GetDeviceIdentifier operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.GetDeviceIdentifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/GetDeviceIdentifier"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDeviceIdentifierResponse getDeviceIdentifier(
            Consumer<GetDeviceIdentifierRequest.Builder> getDeviceIdentifierRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, PrivateNetworksException {
        return getDeviceIdentifier(GetDeviceIdentifierRequest.builder().applyMutation(getDeviceIdentifierRequest).build());
    }

    /**
     * <p>
     * Gets the specified network.
     * </p>
     *
     * @param getNetworkRequest
     * @return Result of the GetNetwork operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.GetNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/GetNetwork" target="_top">AWS
     *      API Documentation</a>
     */
    default GetNetworkResponse getNetwork(GetNetworkRequest getNetworkRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, PrivateNetworksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the specified network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNetworkRequest.Builder} avoiding the need to
     * create one manually via {@link GetNetworkRequest#builder()}
     * </p>
     *
     * @param getNetworkRequest
     *        A {@link Consumer} that will call methods on {@link GetNetworkRequest.Builder} to create a request.
     * @return Result of the GetNetwork operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.GetNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/GetNetwork" target="_top">AWS
     *      API Documentation</a>
     */
    default GetNetworkResponse getNetwork(Consumer<GetNetworkRequest.Builder> getNetworkRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PrivateNetworksException {
        return getNetwork(GetNetworkRequest.builder().applyMutation(getNetworkRequest).build());
    }

    /**
     * <p>
     * Gets the specified network resource.
     * </p>
     *
     * @param getNetworkResourceRequest
     * @return Result of the GetNetworkResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.GetNetworkResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/GetNetworkResource"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNetworkResourceResponse getNetworkResource(GetNetworkResourceRequest getNetworkResourceRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PrivateNetworksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the specified network resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNetworkResourceRequest.Builder} avoiding the
     * need to create one manually via {@link GetNetworkResourceRequest#builder()}
     * </p>
     *
     * @param getNetworkResourceRequest
     *        A {@link Consumer} that will call methods on {@link GetNetworkResourceRequest.Builder} to create a
     *        request.
     * @return Result of the GetNetworkResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.GetNetworkResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/GetNetworkResource"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNetworkResourceResponse getNetworkResource(Consumer<GetNetworkResourceRequest.Builder> getNetworkResourceRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PrivateNetworksException {
        return getNetworkResource(GetNetworkResourceRequest.builder().applyMutation(getNetworkResourceRequest).build());
    }

    /**
     * <p>
     * Gets the specified network site.
     * </p>
     *
     * @param getNetworkSiteRequest
     * @return Result of the GetNetworkSite operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.GetNetworkSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/GetNetworkSite"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNetworkSiteResponse getNetworkSite(GetNetworkSiteRequest getNetworkSiteRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, PrivateNetworksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the specified network site.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNetworkSiteRequest.Builder} avoiding the need to
     * create one manually via {@link GetNetworkSiteRequest#builder()}
     * </p>
     *
     * @param getNetworkSiteRequest
     *        A {@link Consumer} that will call methods on {@link GetNetworkSiteRequest.Builder} to create a request.
     * @return Result of the GetNetworkSite operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.GetNetworkSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/GetNetworkSite"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNetworkSiteResponse getNetworkSite(Consumer<GetNetworkSiteRequest.Builder> getNetworkSiteRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PrivateNetworksException {
        return getNetworkSite(GetNetworkSiteRequest.builder().applyMutation(getNetworkSiteRequest).build());
    }

    /**
     * <p>
     * Gets the specified order.
     * </p>
     *
     * @param getOrderRequest
     * @return Result of the GetOrder operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.GetOrder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/GetOrder" target="_top">AWS API
     *      Documentation</a>
     */
    default GetOrderResponse getOrder(GetOrderRequest getOrderRequest) throws ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PrivateNetworksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the specified order.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOrderRequest.Builder} avoiding the need to
     * create one manually via {@link GetOrderRequest#builder()}
     * </p>
     *
     * @param getOrderRequest
     *        A {@link Consumer} that will call methods on {@link GetOrderRequest.Builder} to create a request.
     * @return Result of the GetOrder operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.GetOrder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/GetOrder" target="_top">AWS API
     *      Documentation</a>
     */
    default GetOrderResponse getOrder(Consumer<GetOrderRequest.Builder> getOrderRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, PrivateNetworksException {
        return getOrder(GetOrderRequest.builder().applyMutation(getOrderRequest).build());
    }

    /**
     * <p>
     * Lists device identifiers. Add filters to your request to return a more specific list of results. Use filters to
     * match the Amazon Resource Name (ARN) of an order, the status of device identifiers, or the ARN of the traffic
     * group.
     * </p>
     * <p>
     * If you specify multiple filters, filters are joined with an OR, and the request returns results that match all of
     * the specified filters.
     * </p>
     *
     * @param listDeviceIdentifiersRequest
     * @return Result of the ListDeviceIdentifiers operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.ListDeviceIdentifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListDeviceIdentifiers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceIdentifiersResponse listDeviceIdentifiers(ListDeviceIdentifiersRequest listDeviceIdentifiersRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PrivateNetworksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists device identifiers. Add filters to your request to return a more specific list of results. Use filters to
     * match the Amazon Resource Name (ARN) of an order, the status of device identifiers, or the ARN of the traffic
     * group.
     * </p>
     * <p>
     * If you specify multiple filters, filters are joined with an OR, and the request returns results that match all of
     * the specified filters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeviceIdentifiersRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeviceIdentifiersRequest#builder()}
     * </p>
     *
     * @param listDeviceIdentifiersRequest
     *        A {@link Consumer} that will call methods on {@link ListDeviceIdentifiersRequest.Builder} to create a
     *        request.
     * @return Result of the ListDeviceIdentifiers operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.ListDeviceIdentifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListDeviceIdentifiers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceIdentifiersResponse listDeviceIdentifiers(
            Consumer<ListDeviceIdentifiersRequest.Builder> listDeviceIdentifiersRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, PrivateNetworksException {
        return listDeviceIdentifiers(ListDeviceIdentifiersRequest.builder().applyMutation(listDeviceIdentifiersRequest).build());
    }

    /**
     * <p>
     * Lists device identifiers. Add filters to your request to return a more specific list of results. Use filters to
     * match the Amazon Resource Name (ARN) of an order, the status of device identifiers, or the ARN of the traffic
     * group.
     * </p>
     * <p>
     * If you specify multiple filters, filters are joined with an OR, and the request returns results that match all of
     * the specified filters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeviceIdentifiers(software.amazon.awssdk.services.privatenetworks.model.ListDeviceIdentifiersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListDeviceIdentifiersIterable responses = client.listDeviceIdentifiersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.privatenetworks.paginators.ListDeviceIdentifiersIterable responses = client
     *             .listDeviceIdentifiersPaginator(request);
     *     for (software.amazon.awssdk.services.privatenetworks.model.ListDeviceIdentifiersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListDeviceIdentifiersIterable responses = client.listDeviceIdentifiersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeviceIdentifiers(software.amazon.awssdk.services.privatenetworks.model.ListDeviceIdentifiersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDeviceIdentifiersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.ListDeviceIdentifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListDeviceIdentifiers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceIdentifiersIterable listDeviceIdentifiersPaginator(ListDeviceIdentifiersRequest listDeviceIdentifiersRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PrivateNetworksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists device identifiers. Add filters to your request to return a more specific list of results. Use filters to
     * match the Amazon Resource Name (ARN) of an order, the status of device identifiers, or the ARN of the traffic
     * group.
     * </p>
     * <p>
     * If you specify multiple filters, filters are joined with an OR, and the request returns results that match all of
     * the specified filters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeviceIdentifiers(software.amazon.awssdk.services.privatenetworks.model.ListDeviceIdentifiersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListDeviceIdentifiersIterable responses = client.listDeviceIdentifiersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.privatenetworks.paginators.ListDeviceIdentifiersIterable responses = client
     *             .listDeviceIdentifiersPaginator(request);
     *     for (software.amazon.awssdk.services.privatenetworks.model.ListDeviceIdentifiersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListDeviceIdentifiersIterable responses = client.listDeviceIdentifiersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeviceIdentifiers(software.amazon.awssdk.services.privatenetworks.model.ListDeviceIdentifiersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeviceIdentifiersRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeviceIdentifiersRequest#builder()}
     * </p>
     *
     * @param listDeviceIdentifiersRequest
     *        A {@link Consumer} that will call methods on {@link ListDeviceIdentifiersRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.ListDeviceIdentifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListDeviceIdentifiers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceIdentifiersIterable listDeviceIdentifiersPaginator(
            Consumer<ListDeviceIdentifiersRequest.Builder> listDeviceIdentifiersRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, PrivateNetworksException {
        return listDeviceIdentifiersPaginator(ListDeviceIdentifiersRequest.builder().applyMutation(listDeviceIdentifiersRequest)
                .build());
    }

    /**
     * <p>
     * Lists network resources. Add filters to your request to return a more specific list of results. Use filters to
     * match the Amazon Resource Name (ARN) of an order or the status of network resources.
     * </p>
     * <p>
     * If you specify multiple filters, filters are joined with an OR, and the request returns results that match all of
     * the specified filters.
     * </p>
     *
     * @param listNetworkResourcesRequest
     * @return Result of the ListNetworkResources operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.ListNetworkResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListNetworkResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNetworkResourcesResponse listNetworkResources(ListNetworkResourcesRequest listNetworkResourcesRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PrivateNetworksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists network resources. Add filters to your request to return a more specific list of results. Use filters to
     * match the Amazon Resource Name (ARN) of an order or the status of network resources.
     * </p>
     * <p>
     * If you specify multiple filters, filters are joined with an OR, and the request returns results that match all of
     * the specified filters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNetworkResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListNetworkResourcesRequest#builder()}
     * </p>
     *
     * @param listNetworkResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListNetworkResourcesRequest.Builder} to create a
     *        request.
     * @return Result of the ListNetworkResources operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.ListNetworkResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListNetworkResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNetworkResourcesResponse listNetworkResources(
            Consumer<ListNetworkResourcesRequest.Builder> listNetworkResourcesRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, PrivateNetworksException {
        return listNetworkResources(ListNetworkResourcesRequest.builder().applyMutation(listNetworkResourcesRequest).build());
    }

    /**
     * <p>
     * Lists network resources. Add filters to your request to return a more specific list of results. Use filters to
     * match the Amazon Resource Name (ARN) of an order or the status of network resources.
     * </p>
     * <p>
     * If you specify multiple filters, filters are joined with an OR, and the request returns results that match all of
     * the specified filters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNetworkResources(software.amazon.awssdk.services.privatenetworks.model.ListNetworkResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListNetworkResourcesIterable responses = client.listNetworkResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.privatenetworks.paginators.ListNetworkResourcesIterable responses = client
     *             .listNetworkResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.privatenetworks.model.ListNetworkResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListNetworkResourcesIterable responses = client.listNetworkResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNetworkResources(software.amazon.awssdk.services.privatenetworks.model.ListNetworkResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNetworkResourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.ListNetworkResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListNetworkResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNetworkResourcesIterable listNetworkResourcesPaginator(ListNetworkResourcesRequest listNetworkResourcesRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PrivateNetworksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists network resources. Add filters to your request to return a more specific list of results. Use filters to
     * match the Amazon Resource Name (ARN) of an order or the status of network resources.
     * </p>
     * <p>
     * If you specify multiple filters, filters are joined with an OR, and the request returns results that match all of
     * the specified filters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNetworkResources(software.amazon.awssdk.services.privatenetworks.model.ListNetworkResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListNetworkResourcesIterable responses = client.listNetworkResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.privatenetworks.paginators.ListNetworkResourcesIterable responses = client
     *             .listNetworkResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.privatenetworks.model.ListNetworkResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListNetworkResourcesIterable responses = client.listNetworkResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNetworkResources(software.amazon.awssdk.services.privatenetworks.model.ListNetworkResourcesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNetworkResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListNetworkResourcesRequest#builder()}
     * </p>
     *
     * @param listNetworkResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListNetworkResourcesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.ListNetworkResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListNetworkResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNetworkResourcesIterable listNetworkResourcesPaginator(
            Consumer<ListNetworkResourcesRequest.Builder> listNetworkResourcesRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, PrivateNetworksException {
        return listNetworkResourcesPaginator(ListNetworkResourcesRequest.builder().applyMutation(listNetworkResourcesRequest)
                .build());
    }

    /**
     * <p>
     * Lists network sites. Add filters to your request to return a more specific list of results. Use filters to match
     * the status of the network site.
     * </p>
     *
     * @param listNetworkSitesRequest
     * @return Result of the ListNetworkSites operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.ListNetworkSites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListNetworkSites"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNetworkSitesResponse listNetworkSites(ListNetworkSitesRequest listNetworkSitesRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PrivateNetworksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists network sites. Add filters to your request to return a more specific list of results. Use filters to match
     * the status of the network site.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNetworkSitesRequest.Builder} avoiding the need
     * to create one manually via {@link ListNetworkSitesRequest#builder()}
     * </p>
     *
     * @param listNetworkSitesRequest
     *        A {@link Consumer} that will call methods on {@link ListNetworkSitesRequest.Builder} to create a request.
     * @return Result of the ListNetworkSites operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.ListNetworkSites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListNetworkSites"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNetworkSitesResponse listNetworkSites(Consumer<ListNetworkSitesRequest.Builder> listNetworkSitesRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PrivateNetworksException {
        return listNetworkSites(ListNetworkSitesRequest.builder().applyMutation(listNetworkSitesRequest).build());
    }

    /**
     * <p>
     * Lists network sites. Add filters to your request to return a more specific list of results. Use filters to match
     * the status of the network site.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNetworkSites(software.amazon.awssdk.services.privatenetworks.model.ListNetworkSitesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListNetworkSitesIterable responses = client.listNetworkSitesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.privatenetworks.paginators.ListNetworkSitesIterable responses = client
     *             .listNetworkSitesPaginator(request);
     *     for (software.amazon.awssdk.services.privatenetworks.model.ListNetworkSitesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListNetworkSitesIterable responses = client.listNetworkSitesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNetworkSites(software.amazon.awssdk.services.privatenetworks.model.ListNetworkSitesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNetworkSitesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.ListNetworkSites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListNetworkSites"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNetworkSitesIterable listNetworkSitesPaginator(ListNetworkSitesRequest listNetworkSitesRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PrivateNetworksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists network sites. Add filters to your request to return a more specific list of results. Use filters to match
     * the status of the network site.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNetworkSites(software.amazon.awssdk.services.privatenetworks.model.ListNetworkSitesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListNetworkSitesIterable responses = client.listNetworkSitesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.privatenetworks.paginators.ListNetworkSitesIterable responses = client
     *             .listNetworkSitesPaginator(request);
     *     for (software.amazon.awssdk.services.privatenetworks.model.ListNetworkSitesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListNetworkSitesIterable responses = client.listNetworkSitesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNetworkSites(software.amazon.awssdk.services.privatenetworks.model.ListNetworkSitesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNetworkSitesRequest.Builder} avoiding the need
     * to create one manually via {@link ListNetworkSitesRequest#builder()}
     * </p>
     *
     * @param listNetworkSitesRequest
     *        A {@link Consumer} that will call methods on {@link ListNetworkSitesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.ListNetworkSites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListNetworkSites"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNetworkSitesIterable listNetworkSitesPaginator(Consumer<ListNetworkSitesRequest.Builder> listNetworkSitesRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PrivateNetworksException {
        return listNetworkSitesPaginator(ListNetworkSitesRequest.builder().applyMutation(listNetworkSitesRequest).build());
    }

    /**
     * <p>
     * Lists networks. Add filters to your request to return a more specific list of results. Use filters to match the
     * status of the network.
     * </p>
     *
     * @param listNetworksRequest
     * @return Result of the ListNetworks operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.ListNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListNetworks" target="_top">AWS
     *      API Documentation</a>
     */
    default ListNetworksResponse listNetworks(ListNetworksRequest listNetworksRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, PrivateNetworksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists networks. Add filters to your request to return a more specific list of results. Use filters to match the
     * status of the network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNetworksRequest.Builder} avoiding the need to
     * create one manually via {@link ListNetworksRequest#builder()}
     * </p>
     *
     * @param listNetworksRequest
     *        A {@link Consumer} that will call methods on {@link ListNetworksRequest.Builder} to create a request.
     * @return Result of the ListNetworks operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.ListNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListNetworks" target="_top">AWS
     *      API Documentation</a>
     */
    default ListNetworksResponse listNetworks(Consumer<ListNetworksRequest.Builder> listNetworksRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PrivateNetworksException {
        return listNetworks(ListNetworksRequest.builder().applyMutation(listNetworksRequest).build());
    }

    /**
     * <p>
     * Lists networks. Add filters to your request to return a more specific list of results. Use filters to match the
     * status of the network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNetworks(software.amazon.awssdk.services.privatenetworks.model.ListNetworksRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListNetworksIterable responses = client.listNetworksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.privatenetworks.paginators.ListNetworksIterable responses = client
     *             .listNetworksPaginator(request);
     *     for (software.amazon.awssdk.services.privatenetworks.model.ListNetworksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListNetworksIterable responses = client.listNetworksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNetworks(software.amazon.awssdk.services.privatenetworks.model.ListNetworksRequest)} operation.</b>
     * </p>
     *
     * @param listNetworksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.ListNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListNetworks" target="_top">AWS
     *      API Documentation</a>
     */
    default ListNetworksIterable listNetworksPaginator(ListNetworksRequest listNetworksRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, PrivateNetworksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists networks. Add filters to your request to return a more specific list of results. Use filters to match the
     * status of the network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNetworks(software.amazon.awssdk.services.privatenetworks.model.ListNetworksRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListNetworksIterable responses = client.listNetworksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.privatenetworks.paginators.ListNetworksIterable responses = client
     *             .listNetworksPaginator(request);
     *     for (software.amazon.awssdk.services.privatenetworks.model.ListNetworksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListNetworksIterable responses = client.listNetworksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNetworks(software.amazon.awssdk.services.privatenetworks.model.ListNetworksRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNetworksRequest.Builder} avoiding the need to
     * create one manually via {@link ListNetworksRequest#builder()}
     * </p>
     *
     * @param listNetworksRequest
     *        A {@link Consumer} that will call methods on {@link ListNetworksRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.ListNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListNetworks" target="_top">AWS
     *      API Documentation</a>
     */
    default ListNetworksIterable listNetworksPaginator(Consumer<ListNetworksRequest.Builder> listNetworksRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PrivateNetworksException {
        return listNetworksPaginator(ListNetworksRequest.builder().applyMutation(listNetworksRequest).build());
    }

    /**
     * <p>
     * Lists orders. Add filters to your request to return a more specific list of results. Use filters to match the
     * Amazon Resource Name (ARN) of the network site or the status of the order.
     * </p>
     * <p>
     * If you specify multiple filters, filters are joined with an OR, and the request returns results that match all of
     * the specified filters.
     * </p>
     *
     * @param listOrdersRequest
     * @return Result of the ListOrders operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.ListOrders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListOrders" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOrdersResponse listOrders(ListOrdersRequest listOrdersRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, PrivateNetworksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists orders. Add filters to your request to return a more specific list of results. Use filters to match the
     * Amazon Resource Name (ARN) of the network site or the status of the order.
     * </p>
     * <p>
     * If you specify multiple filters, filters are joined with an OR, and the request returns results that match all of
     * the specified filters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrdersRequest.Builder} avoiding the need to
     * create one manually via {@link ListOrdersRequest#builder()}
     * </p>
     *
     * @param listOrdersRequest
     *        A {@link Consumer} that will call methods on {@link ListOrdersRequest.Builder} to create a request.
     * @return Result of the ListOrders operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.ListOrders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListOrders" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOrdersResponse listOrders(Consumer<ListOrdersRequest.Builder> listOrdersRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PrivateNetworksException {
        return listOrders(ListOrdersRequest.builder().applyMutation(listOrdersRequest).build());
    }

    /**
     * <p>
     * Lists orders. Add filters to your request to return a more specific list of results. Use filters to match the
     * Amazon Resource Name (ARN) of the network site or the status of the order.
     * </p>
     * <p>
     * If you specify multiple filters, filters are joined with an OR, and the request returns results that match all of
     * the specified filters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listOrders(software.amazon.awssdk.services.privatenetworks.model.ListOrdersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListOrdersIterable responses = client.listOrdersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.privatenetworks.paginators.ListOrdersIterable responses = client.listOrdersPaginator(request);
     *     for (software.amazon.awssdk.services.privatenetworks.model.ListOrdersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListOrdersIterable responses = client.listOrdersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrders(software.amazon.awssdk.services.privatenetworks.model.ListOrdersRequest)} operation.</b>
     * </p>
     *
     * @param listOrdersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.ListOrders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListOrders" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOrdersIterable listOrdersPaginator(ListOrdersRequest listOrdersRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, PrivateNetworksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists orders. Add filters to your request to return a more specific list of results. Use filters to match the
     * Amazon Resource Name (ARN) of the network site or the status of the order.
     * </p>
     * <p>
     * If you specify multiple filters, filters are joined with an OR, and the request returns results that match all of
     * the specified filters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listOrders(software.amazon.awssdk.services.privatenetworks.model.ListOrdersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListOrdersIterable responses = client.listOrdersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.privatenetworks.paginators.ListOrdersIterable responses = client.listOrdersPaginator(request);
     *     for (software.amazon.awssdk.services.privatenetworks.model.ListOrdersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListOrdersIterable responses = client.listOrdersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrders(software.amazon.awssdk.services.privatenetworks.model.ListOrdersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrdersRequest.Builder} avoiding the need to
     * create one manually via {@link ListOrdersRequest#builder()}
     * </p>
     *
     * @param listOrdersRequest
     *        A {@link Consumer} that will call methods on {@link ListOrdersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.ListOrders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListOrders" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOrdersIterable listOrdersPaginator(Consumer<ListOrdersRequest.Builder> listOrdersRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PrivateNetworksException {
        return listOrdersPaginator(ListOrdersRequest.builder().applyMutation(listOrdersRequest).build());
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, PrivateNetworksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, PrivateNetworksException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Checks the health of the service.
     * </p>
     *
     * @param pingRequest
     * @return Result of the Ping operation returned by the service.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.Ping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/Ping" target="_top">AWS API
     *      Documentation</a>
     */
    default PingResponse ping(PingRequest pingRequest) throws InternalServerException, AwsServiceException, SdkClientException,
            PrivateNetworksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Checks the health of the service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PingRequest.Builder} avoiding the need to create
     * one manually via {@link PingRequest#builder()}
     * </p>
     *
     * @param pingRequest
     *        A {@link Consumer} that will call methods on {@link PingRequest.Builder} to create a request.
     * @return Result of the Ping operation returned by the service.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.Ping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/Ping" target="_top">AWS API
     *      Documentation</a>
     */
    default PingResponse ping(Consumer<PingRequest.Builder> pingRequest) throws InternalServerException, AwsServiceException,
            SdkClientException, PrivateNetworksException {
        return ping(PingRequest.builder().applyMutation(pingRequest).build());
    }

    /**
     * <p>
     * Starts an update of the specified network resource.
     * </p>
     * <p>
     * After you submit a request to replace or return a network resource, the status of the network resource is
     * <code>CREATING_SHIPPING_LABEL</code>. The shipping label is available when the status of the network resource is
     * <code>PENDING_RETURN</code>. After the network resource is successfully returned, its status is
     * <code>DELETED</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/private-networks/latest/userguide/radio-units.html#return-radio-unit">Return a
     * radio unit</a>.
     * </p>
     *
     * @param startNetworkResourceUpdateRequest
     * @return Result of the StartNetworkResourceUpdate operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.StartNetworkResourceUpdate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/StartNetworkResourceUpdate"
     *      target="_top">AWS API Documentation</a>
     */
    default StartNetworkResourceUpdateResponse startNetworkResourceUpdate(
            StartNetworkResourceUpdateRequest startNetworkResourceUpdateRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, PrivateNetworksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an update of the specified network resource.
     * </p>
     * <p>
     * After you submit a request to replace or return a network resource, the status of the network resource is
     * <code>CREATING_SHIPPING_LABEL</code>. The shipping label is available when the status of the network resource is
     * <code>PENDING_RETURN</code>. After the network resource is successfully returned, its status is
     * <code>DELETED</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/private-networks/latest/userguide/radio-units.html#return-radio-unit">Return a
     * radio unit</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartNetworkResourceUpdateRequest.Builder} avoiding
     * the need to create one manually via {@link StartNetworkResourceUpdateRequest#builder()}
     * </p>
     *
     * @param startNetworkResourceUpdateRequest
     *        A {@link Consumer} that will call methods on {@link StartNetworkResourceUpdateRequest.Builder} to create a
     *        request.
     * @return Result of the StartNetworkResourceUpdate operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.StartNetworkResourceUpdate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/StartNetworkResourceUpdate"
     *      target="_top">AWS API Documentation</a>
     */
    default StartNetworkResourceUpdateResponse startNetworkResourceUpdate(
            Consumer<StartNetworkResourceUpdateRequest.Builder> startNetworkResourceUpdateRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PrivateNetworksException {
        return startNetworkResourceUpdate(StartNetworkResourceUpdateRequest.builder()
                .applyMutation(startNetworkResourceUpdateRequest).build());
    }

    /**
     * <p>
     * Adds tags to the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, PrivateNetworksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, PrivateNetworksException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, PrivateNetworksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, PrivateNetworksException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the specified network site.
     * </p>
     *
     * @param updateNetworkSiteRequest
     * @return Result of the UpdateNetworkSite operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.UpdateNetworkSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/UpdateNetworkSite"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateNetworkSiteResponse updateNetworkSite(UpdateNetworkSiteRequest updateNetworkSiteRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PrivateNetworksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified network site.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNetworkSiteRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateNetworkSiteRequest#builder()}
     * </p>
     *
     * @param updateNetworkSiteRequest
     *        A {@link Consumer} that will call methods on {@link UpdateNetworkSiteRequest.Builder} to create a request.
     * @return Result of the UpdateNetworkSite operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.UpdateNetworkSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/UpdateNetworkSite"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateNetworkSiteResponse updateNetworkSite(Consumer<UpdateNetworkSiteRequest.Builder> updateNetworkSiteRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PrivateNetworksException {
        return updateNetworkSite(UpdateNetworkSiteRequest.builder().applyMutation(updateNetworkSiteRequest).build());
    }

    /**
     * <p>
     * Updates the specified network site plan.
     * </p>
     *
     * @param updateNetworkSitePlanRequest
     * @return Result of the UpdateNetworkSitePlan operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.UpdateNetworkSitePlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/UpdateNetworkSitePlan"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateNetworkSitePlanResponse updateNetworkSitePlan(UpdateNetworkSitePlanRequest updateNetworkSitePlanRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PrivateNetworksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified network site plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNetworkSitePlanRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateNetworkSitePlanRequest#builder()}
     * </p>
     *
     * @param updateNetworkSitePlanRequest
     *        A {@link Consumer} that will call methods on {@link UpdateNetworkSitePlanRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateNetworkSitePlan operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ValidationException
     *         The request failed validation.
     * @throws InternalServerException
     *         Information about an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PrivateNetworksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PrivateNetworksClient.UpdateNetworkSitePlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/UpdateNetworkSitePlan"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateNetworkSitePlanResponse updateNetworkSitePlan(
            Consumer<UpdateNetworkSitePlanRequest.Builder> updateNetworkSitePlanRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, PrivateNetworksException {
        return updateNetworkSitePlan(UpdateNetworkSitePlanRequest.builder().applyMutation(updateNetworkSitePlanRequest).build());
    }

    /**
     * Create a {@link PrivateNetworksClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static PrivateNetworksClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link PrivateNetworksClient}.
     */
    static PrivateNetworksClientBuilder builder() {
        return new DefaultPrivateNetworksClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    PrivateNetworksServiceClientConfiguration serviceClientConfiguration();
}
