/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.privatenetworks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a network.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Network implements SdkPojo, Serializable, ToCopyableBuilder<Network.Builder, Network> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(Network::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(Network::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> NETWORK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("networkArn").getter(getter(Network::networkArn)).setter(setter(Builder::networkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkArn").build()).build();

    private static final SdkField<String> NETWORK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("networkName").getter(getter(Network::networkName)).setter(setter(Builder::networkName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Network::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(Network::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            DESCRIPTION_FIELD, NETWORK_ARN_FIELD, NETWORK_NAME_FIELD, STATUS_FIELD, STATUS_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final String description;

    private final String networkArn;

    private final String networkName;

    private final String status;

    private final String statusReason;

    private Network(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.networkArn = builder.networkArn;
        this.networkName = builder.networkName;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
    }

    /**
     * <p>
     * The creation time of the network.
     * </p>
     * 
     * @return The creation time of the network.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The description of the network.
     * </p>
     * 
     * @return The description of the network.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the network.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the network.
     */
    public final String networkArn() {
        return networkArn;
    }

    /**
     * <p>
     * The name of the network.
     * </p>
     * 
     * @return The name of the network.
     */
    public final String networkName() {
        return networkName;
    }

    /**
     * <p>
     * The status of the network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NetworkStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the network.
     * @see NetworkStatus
     */
    public final NetworkStatus status() {
        return NetworkStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NetworkStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the network.
     * @see NetworkStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The status reason of the network.
     * </p>
     * 
     * @return The status reason of the network.
     */
    public final String statusReason() {
        return statusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(networkArn());
        hashCode = 31 * hashCode + Objects.hashCode(networkName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Network)) {
            return false;
        }
        Network other = (Network) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(description(), other.description())
                && Objects.equals(networkArn(), other.networkArn()) && Objects.equals(networkName(), other.networkName())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Network").add("CreatedAt", createdAt()).add("Description", description())
                .add("NetworkArn", networkArn()).add("NetworkName", networkName()).add("Status", statusAsString())
                .add("StatusReason", statusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "networkArn":
            return Optional.ofNullable(clazz.cast(networkArn()));
        case "networkName":
            return Optional.ofNullable(clazz.cast(networkName()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Network, T> g) {
        return obj -> g.apply((Network) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Network> {
        /**
         * <p>
         * The creation time of the network.
         * </p>
         * 
         * @param createdAt
         *        The creation time of the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The description of the network.
         * </p>
         * 
         * @param description
         *        The description of the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the network.
         * </p>
         * 
         * @param networkArn
         *        The Amazon Resource Name (ARN) of the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkArn(String networkArn);

        /**
         * <p>
         * The name of the network.
         * </p>
         * 
         * @param networkName
         *        The name of the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkName(String networkName);

        /**
         * <p>
         * The status of the network.
         * </p>
         * 
         * @param status
         *        The status of the network.
         * @see NetworkStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the network.
         * </p>
         * 
         * @param status
         *        The status of the network.
         * @see NetworkStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkStatus
         */
        Builder status(NetworkStatus status);

        /**
         * <p>
         * The status reason of the network.
         * </p>
         * 
         * @param statusReason
         *        The status reason of the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private String description;

        private String networkArn;

        private String networkName;

        private String status;

        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(Network model) {
            createdAt(model.createdAt);
            description(model.description);
            networkArn(model.networkArn);
            networkName(model.networkName);
            status(model.status);
            statusReason(model.statusReason);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getNetworkArn() {
            return networkArn;
        }

        public final void setNetworkArn(String networkArn) {
            this.networkArn = networkArn;
        }

        @Override
        public final Builder networkArn(String networkArn) {
            this.networkArn = networkArn;
            return this;
        }

        public final String getNetworkName() {
            return networkName;
        }

        public final void setNetworkName(String networkName) {
            this.networkName = networkName;
        }

        @Override
        public final Builder networkName(String networkName) {
            this.networkName = networkName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NetworkStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public Network build() {
            return new Network(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
