/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Address
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Address> {
    private static final SdkField<String> CITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("city").getter(Address.getter(Address::city)).setter(Address.setter(Builder::city)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("city").build()}).build();
    private static final SdkField<String> COMPANY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("company").getter(Address.getter(Address::company)).setter(Address.setter(Builder::company)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("company").build()}).build();
    private static final SdkField<String> COUNTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("country").getter(Address.getter(Address::country)).setter(Address.setter(Builder::country)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("country").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Address.getter(Address::name)).setter(Address.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("phoneNumber").getter(Address.getter(Address::phoneNumber)).setter(Address.setter(Builder::phoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("phoneNumber").build()}).build();
    private static final SdkField<String> POSTAL_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("postalCode").getter(Address.getter(Address::postalCode)).setter(Address.setter(Builder::postalCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postalCode").build()}).build();
    private static final SdkField<String> STATE_OR_PROVINCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stateOrProvince").getter(Address.getter(Address::stateOrProvince)).setter(Address.setter(Builder::stateOrProvince)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateOrProvince").build()}).build();
    private static final SdkField<String> STREET1_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("street1").getter(Address.getter(Address::street1)).setter(Address.setter(Builder::street1)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("street1").build()}).build();
    private static final SdkField<String> STREET2_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("street2").getter(Address.getter(Address::street2)).setter(Address.setter(Builder::street2)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("street2").build()}).build();
    private static final SdkField<String> STREET3_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("street3").getter(Address.getter(Address::street3)).setter(Address.setter(Builder::street3)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("street3").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CITY_FIELD, COMPANY_FIELD, COUNTRY_FIELD, NAME_FIELD, PHONE_NUMBER_FIELD, POSTAL_CODE_FIELD, STATE_OR_PROVINCE_FIELD, STREET1_FIELD, STREET2_FIELD, STREET3_FIELD));
    private static final long serialVersionUID = 1L;
    private final String city;
    private final String company;
    private final String country;
    private final String name;
    private final String phoneNumber;
    private final String postalCode;
    private final String stateOrProvince;
    private final String street1;
    private final String street2;
    private final String street3;

    private Address(BuilderImpl builder) {
        this.city = builder.city;
        this.company = builder.company;
        this.country = builder.country;
        this.name = builder.name;
        this.phoneNumber = builder.phoneNumber;
        this.postalCode = builder.postalCode;
        this.stateOrProvince = builder.stateOrProvince;
        this.street1 = builder.street1;
        this.street2 = builder.street2;
        this.street3 = builder.street3;
    }

    public final String city() {
        return this.city;
    }

    public final String company() {
        return this.company;
    }

    public final String country() {
        return this.country;
    }

    public final String name() {
        return this.name;
    }

    public final String phoneNumber() {
        return this.phoneNumber;
    }

    public final String postalCode() {
        return this.postalCode;
    }

    public final String stateOrProvince() {
        return this.stateOrProvince;
    }

    public final String street1() {
        return this.street1;
    }

    public final String street2() {
        return this.street2;
    }

    public final String street3() {
        return this.street3;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.city());
        hashCode = 31 * hashCode + Objects.hashCode(this.company());
        hashCode = 31 * hashCode + Objects.hashCode(this.country());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.postalCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateOrProvince());
        hashCode = 31 * hashCode + Objects.hashCode(this.street1());
        hashCode = 31 * hashCode + Objects.hashCode(this.street2());
        hashCode = 31 * hashCode + Objects.hashCode(this.street3());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Address)) {
            return false;
        }
        Address other = (Address)obj;
        return Objects.equals(this.city(), other.city()) && Objects.equals(this.company(), other.company()) && Objects.equals(this.country(), other.country()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.phoneNumber(), other.phoneNumber()) && Objects.equals(this.postalCode(), other.postalCode()) && Objects.equals(this.stateOrProvince(), other.stateOrProvince()) && Objects.equals(this.street1(), other.street1()) && Objects.equals(this.street2(), other.street2()) && Objects.equals(this.street3(), other.street3());
    }

    public final String toString() {
        return ToString.builder((String)"Address").add("City", (Object)(this.city() == null ? null : "*** Sensitive Data Redacted ***")).add("Company", (Object)(this.company() == null ? null : "*** Sensitive Data Redacted ***")).add("Country", (Object)(this.country() == null ? null : "*** Sensitive Data Redacted ***")).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("PhoneNumber", (Object)(this.phoneNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("PostalCode", (Object)(this.postalCode() == null ? null : "*** Sensitive Data Redacted ***")).add("StateOrProvince", (Object)(this.stateOrProvince() == null ? null : "*** Sensitive Data Redacted ***")).add("Street1", (Object)(this.street1() == null ? null : "*** Sensitive Data Redacted ***")).add("Street2", (Object)(this.street2() == null ? null : "*** Sensitive Data Redacted ***")).add("Street3", (Object)(this.street3() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "city": {
                return Optional.ofNullable(clazz.cast(this.city()));
            }
            case "company": {
                return Optional.ofNullable(clazz.cast(this.company()));
            }
            case "country": {
                return Optional.ofNullable(clazz.cast(this.country()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "phoneNumber": {
                return Optional.ofNullable(clazz.cast(this.phoneNumber()));
            }
            case "postalCode": {
                return Optional.ofNullable(clazz.cast(this.postalCode()));
            }
            case "stateOrProvince": {
                return Optional.ofNullable(clazz.cast(this.stateOrProvince()));
            }
            case "street1": {
                return Optional.ofNullable(clazz.cast(this.street1()));
            }
            case "street2": {
                return Optional.ofNullable(clazz.cast(this.street2()));
            }
            case "street3": {
                return Optional.ofNullable(clazz.cast(this.street3()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Address, T> g) {
        return obj -> g.apply((Address)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String city;
        private String company;
        private String country;
        private String name;
        private String phoneNumber;
        private String postalCode;
        private String stateOrProvince;
        private String street1;
        private String street2;
        private String street3;

        private BuilderImpl() {
        }

        private BuilderImpl(Address model) {
            this.city(model.city);
            this.company(model.company);
            this.country(model.country);
            this.name(model.name);
            this.phoneNumber(model.phoneNumber);
            this.postalCode(model.postalCode);
            this.stateOrProvince(model.stateOrProvince);
            this.street1(model.street1);
            this.street2(model.street2);
            this.street3(model.street3);
        }

        public final String getCity() {
            return this.city;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final String getCompany() {
            return this.company;
        }

        public final void setCompany(String company) {
            this.company = company;
        }

        @Override
        public final Builder company(String company) {
            this.company = company;
            return this;
        }

        public final String getCountry() {
            return this.country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPhoneNumber() {
            return this.phoneNumber;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final String getPostalCode() {
            return this.postalCode;
        }

        public final void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        @Override
        public final Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public final String getStateOrProvince() {
            return this.stateOrProvince;
        }

        public final void setStateOrProvince(String stateOrProvince) {
            this.stateOrProvince = stateOrProvince;
        }

        @Override
        public final Builder stateOrProvince(String stateOrProvince) {
            this.stateOrProvince = stateOrProvince;
            return this;
        }

        public final String getStreet1() {
            return this.street1;
        }

        public final void setStreet1(String street1) {
            this.street1 = street1;
        }

        @Override
        public final Builder street1(String street1) {
            this.street1 = street1;
            return this;
        }

        public final String getStreet2() {
            return this.street2;
        }

        public final void setStreet2(String street2) {
            this.street2 = street2;
        }

        @Override
        public final Builder street2(String street2) {
            this.street2 = street2;
            return this;
        }

        public final String getStreet3() {
            return this.street3;
        }

        public final void setStreet3(String street3) {
            this.street3 = street3;
        }

        @Override
        public final Builder street3(String street3) {
            this.street3 = street3;
            return this;
        }

        public Address build() {
            return new Address(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Address> {
        public Builder city(String var1);

        public Builder company(String var1);

        public Builder country(String var1);

        public Builder name(String var1);

        public Builder phoneNumber(String var1);

        public Builder postalCode(String var1);

        public Builder stateOrProvince(String var1);

        public Builder street1(String var1);

        public Builder street2(String var1);

        public Builder street3(String var1);
    }
}

