/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.privatenetworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateNetworkSiteRequest extends PrivateNetworksRequest implements
        ToCopyableBuilder<CreateNetworkSiteRequest.Builder, CreateNetworkSiteRequest> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availabilityZone").getter(getter(CreateNetworkSiteRequest::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availabilityZoneId").getter(getter(CreateNetworkSiteRequest::availabilityZoneId))
            .setter(setter(Builder::availabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneId").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientToken").getter(getter(CreateNetworkSiteRequest::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateNetworkSiteRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> NETWORK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("networkArn").getter(getter(CreateNetworkSiteRequest::networkArn)).setter(setter(Builder::networkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkArn").build()).build();

    private static final SdkField<String> NETWORK_SITE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("networkSiteName").getter(getter(CreateNetworkSiteRequest::networkSiteName))
            .setter(setter(Builder::networkSiteName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkSiteName").build()).build();

    private static final SdkField<SitePlan> PENDING_PLAN_FIELD = SdkField.<SitePlan> builder(MarshallingType.SDK_POJO)
            .memberName("pendingPlan").getter(getter(CreateNetworkSiteRequest::pendingPlan)).setter(setter(Builder::pendingPlan))
            .constructor(SitePlan::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingPlan").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateNetworkSiteRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD,
            AVAILABILITY_ZONE_ID_FIELD, CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, NETWORK_ARN_FIELD, NETWORK_SITE_NAME_FIELD,
            PENDING_PLAN_FIELD, TAGS_FIELD));

    private final String availabilityZone;

    private final String availabilityZoneId;

    private final String clientToken;

    private final String description;

    private final String networkArn;

    private final String networkSiteName;

    private final SitePlan pendingPlan;

    private final Map<String, String> tags;

    private CreateNetworkSiteRequest(BuilderImpl builder) {
        super(builder);
        this.availabilityZone = builder.availabilityZone;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.networkArn = builder.networkArn;
        this.networkSiteName = builder.networkSiteName;
        this.pendingPlan = builder.pendingPlan;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Availability Zone that is the parent of this site. You can't change the Availability Zone after you create
     * the site.
     * </p>
     * 
     * @return The Availability Zone that is the parent of this site. You can't change the Availability Zone after you
     *         create the site.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The ID of the Availability Zone that is the parent of this site. You can't change the Availability Zone after you
     * create the site.
     * </p>
     * 
     * @return The ID of the Availability Zone that is the parent of this site. You can't change the Availability Zone
     *         after you create the site.
     */
    public final String availabilityZoneId() {
        return availabilityZoneId;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How
     * to ensure idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to ensure
     *         idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The description of the site.
     * </p>
     * 
     * @return The description of the site.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the network.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the network.
     */
    public final String networkArn() {
        return networkArn;
    }

    /**
     * <p>
     * The name of the site. You can't change the name after you create the site.
     * </p>
     * 
     * @return The name of the site. You can't change the name after you create the site.
     */
    public final String networkSiteName() {
        return networkSiteName;
    }

    /**
     * <p>
     * Information about the pending plan for this site.
     * </p>
     * 
     * @return Information about the pending plan for this site.
     */
    public final SitePlan pendingPlan() {
        return pendingPlan;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to apply to the network site.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to apply to the network site.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(networkArn());
        hashCode = 31 * hashCode + Objects.hashCode(networkSiteName());
        hashCode = 31 * hashCode + Objects.hashCode(pendingPlan());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkSiteRequest)) {
            return false;
        }
        CreateNetworkSiteRequest other = (CreateNetworkSiteRequest) obj;
        return Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(availabilityZoneId(), other.availabilityZoneId())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(description(), other.description())
                && Objects.equals(networkArn(), other.networkArn()) && Objects.equals(networkSiteName(), other.networkSiteName())
                && Objects.equals(pendingPlan(), other.pendingPlan()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateNetworkSiteRequest").add("AvailabilityZone", availabilityZone())
                .add("AvailabilityZoneId", availabilityZoneId()).add("ClientToken", clientToken())
                .add("Description", description()).add("NetworkArn", networkArn()).add("NetworkSiteName", networkSiteName())
                .add("PendingPlan", pendingPlan()).add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "availabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "availabilityZoneId":
            return Optional.ofNullable(clazz.cast(availabilityZoneId()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "networkArn":
            return Optional.ofNullable(clazz.cast(networkArn()));
        case "networkSiteName":
            return Optional.ofNullable(clazz.cast(networkSiteName()));
        case "pendingPlan":
            return Optional.ofNullable(clazz.cast(pendingPlan()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNetworkSiteRequest, T> g) {
        return obj -> g.apply((CreateNetworkSiteRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PrivateNetworksRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateNetworkSiteRequest> {
        /**
         * <p>
         * The Availability Zone that is the parent of this site. You can't change the Availability Zone after you
         * create the site.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone that is the parent of this site. You can't change the Availability Zone after
         *        you create the site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The ID of the Availability Zone that is the parent of this site. You can't change the Availability Zone after
         * you create the site.
         * </p>
         * 
         * @param availabilityZoneId
         *        The ID of the Availability Zone that is the parent of this site. You can't change the Availability
         *        Zone after you create the site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneId(String availabilityZoneId);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to ensure
         * idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to ensure
         *        idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The description of the site.
         * </p>
         * 
         * @param description
         *        The description of the site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the network.
         * </p>
         * 
         * @param networkArn
         *        The Amazon Resource Name (ARN) of the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkArn(String networkArn);

        /**
         * <p>
         * The name of the site. You can't change the name after you create the site.
         * </p>
         * 
         * @param networkSiteName
         *        The name of the site. You can't change the name after you create the site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkSiteName(String networkSiteName);

        /**
         * <p>
         * Information about the pending plan for this site.
         * </p>
         * 
         * @param pendingPlan
         *        Information about the pending plan for this site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingPlan(SitePlan pendingPlan);

        /**
         * <p>
         * Information about the pending plan for this site.
         * </p>
         * This is a convenience method that creates an instance of the {@link SitePlan.Builder} avoiding the need to
         * create one manually via {@link SitePlan#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SitePlan.Builder#build()} is called immediately and its result is
         * passed to {@link #pendingPlan(SitePlan)}.
         * 
         * @param pendingPlan
         *        a consumer that will call methods on {@link SitePlan.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pendingPlan(SitePlan)
         */
        default Builder pendingPlan(Consumer<SitePlan.Builder> pendingPlan) {
            return pendingPlan(SitePlan.builder().applyMutation(pendingPlan).build());
        }

        /**
         * <p>
         * The tags to apply to the network site.
         * </p>
         * 
         * @param tags
         *        The tags to apply to the network site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PrivateNetworksRequest.BuilderImpl implements Builder {
        private String availabilityZone;

        private String availabilityZoneId;

        private String clientToken;

        private String description;

        private String networkArn;

        private String networkSiteName;

        private SitePlan pendingPlan;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNetworkSiteRequest model) {
            super(model);
            availabilityZone(model.availabilityZone);
            availabilityZoneId(model.availabilityZoneId);
            clientToken(model.clientToken);
            description(model.description);
            networkArn(model.networkArn);
            networkSiteName(model.networkSiteName);
            pendingPlan(model.pendingPlan);
            tags(model.tags);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getNetworkArn() {
            return networkArn;
        }

        public final void setNetworkArn(String networkArn) {
            this.networkArn = networkArn;
        }

        @Override
        public final Builder networkArn(String networkArn) {
            this.networkArn = networkArn;
            return this;
        }

        public final String getNetworkSiteName() {
            return networkSiteName;
        }

        public final void setNetworkSiteName(String networkSiteName) {
            this.networkSiteName = networkSiteName;
        }

        @Override
        public final Builder networkSiteName(String networkSiteName) {
            this.networkSiteName = networkSiteName;
            return this;
        }

        public final SitePlan.Builder getPendingPlan() {
            return pendingPlan != null ? pendingPlan.toBuilder() : null;
        }

        public final void setPendingPlan(SitePlan.BuilderImpl pendingPlan) {
            this.pendingPlan = pendingPlan != null ? pendingPlan.build() : null;
        }

        @Override
        public final Builder pendingPlan(SitePlan pendingPlan) {
            this.pendingPlan = pendingPlan;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNetworkSiteRequest build() {
            return new CreateNetworkSiteRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
