/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.privatenetworks.model.Address;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReturnInformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReturnInformation> {
    private static final SdkField<String> REPLACEMENT_ORDER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("replacementOrderArn").getter(ReturnInformation.getter(ReturnInformation::replacementOrderArn)).setter(ReturnInformation.setter(Builder::replacementOrderArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replacementOrderArn").build()}).build();
    private static final SdkField<String> RETURN_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("returnReason").getter(ReturnInformation.getter(ReturnInformation::returnReason)).setter(ReturnInformation.setter(Builder::returnReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("returnReason").build()}).build();
    private static final SdkField<Address> SHIPPING_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("shippingAddress").getter(ReturnInformation.getter(ReturnInformation::shippingAddress)).setter(ReturnInformation.setter(Builder::shippingAddress)).constructor(Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shippingAddress").build()}).build();
    private static final SdkField<String> SHIPPING_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("shippingLabel").getter(ReturnInformation.getter(ReturnInformation::shippingLabel)).setter(ReturnInformation.setter(Builder::shippingLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shippingLabel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLACEMENT_ORDER_ARN_FIELD, RETURN_REASON_FIELD, SHIPPING_ADDRESS_FIELD, SHIPPING_LABEL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String replacementOrderArn;
    private final String returnReason;
    private final Address shippingAddress;
    private final String shippingLabel;

    private ReturnInformation(BuilderImpl builder) {
        this.replacementOrderArn = builder.replacementOrderArn;
        this.returnReason = builder.returnReason;
        this.shippingAddress = builder.shippingAddress;
        this.shippingLabel = builder.shippingLabel;
    }

    public final String replacementOrderArn() {
        return this.replacementOrderArn;
    }

    public final String returnReason() {
        return this.returnReason;
    }

    public final Address shippingAddress() {
        return this.shippingAddress;
    }

    public final String shippingLabel() {
        return this.shippingLabel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replacementOrderArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.shippingAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.shippingLabel());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReturnInformation)) {
            return false;
        }
        ReturnInformation other = (ReturnInformation)obj;
        return Objects.equals(this.replacementOrderArn(), other.replacementOrderArn()) && Objects.equals(this.returnReason(), other.returnReason()) && Objects.equals(this.shippingAddress(), other.shippingAddress()) && Objects.equals(this.shippingLabel(), other.shippingLabel());
    }

    public final String toString() {
        return ToString.builder((String)"ReturnInformation").add("ReplacementOrderArn", (Object)this.replacementOrderArn()).add("ReturnReason", (Object)this.returnReason()).add("ShippingAddress", (Object)this.shippingAddress()).add("ShippingLabel", (Object)this.shippingLabel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "replacementOrderArn": {
                return Optional.ofNullable(clazz.cast(this.replacementOrderArn()));
            }
            case "returnReason": {
                return Optional.ofNullable(clazz.cast(this.returnReason()));
            }
            case "shippingAddress": {
                return Optional.ofNullable(clazz.cast(this.shippingAddress()));
            }
            case "shippingLabel": {
                return Optional.ofNullable(clazz.cast(this.shippingLabel()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReturnInformation, T> g) {
        return obj -> g.apply((ReturnInformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String replacementOrderArn;
        private String returnReason;
        private Address shippingAddress;
        private String shippingLabel;

        private BuilderImpl() {
        }

        private BuilderImpl(ReturnInformation model) {
            this.replacementOrderArn(model.replacementOrderArn);
            this.returnReason(model.returnReason);
            this.shippingAddress(model.shippingAddress);
            this.shippingLabel(model.shippingLabel);
        }

        public final String getReplacementOrderArn() {
            return this.replacementOrderArn;
        }

        public final void setReplacementOrderArn(String replacementOrderArn) {
            this.replacementOrderArn = replacementOrderArn;
        }

        @Override
        public final Builder replacementOrderArn(String replacementOrderArn) {
            this.replacementOrderArn = replacementOrderArn;
            return this;
        }

        public final String getReturnReason() {
            return this.returnReason;
        }

        public final void setReturnReason(String returnReason) {
            this.returnReason = returnReason;
        }

        @Override
        public final Builder returnReason(String returnReason) {
            this.returnReason = returnReason;
            return this;
        }

        public final Address.Builder getShippingAddress() {
            return this.shippingAddress != null ? this.shippingAddress.toBuilder() : null;
        }

        public final void setShippingAddress(Address.BuilderImpl shippingAddress) {
            this.shippingAddress = shippingAddress != null ? shippingAddress.build() : null;
        }

        @Override
        public final Builder shippingAddress(Address shippingAddress) {
            this.shippingAddress = shippingAddress;
            return this;
        }

        public final String getShippingLabel() {
            return this.shippingLabel;
        }

        public final void setShippingLabel(String shippingLabel) {
            this.shippingLabel = shippingLabel;
        }

        @Override
        public final Builder shippingLabel(String shippingLabel) {
            this.shippingLabel = shippingLabel;
            return this;
        }

        public ReturnInformation build() {
            return new ReturnInformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReturnInformation> {
        public Builder replacementOrderArn(String var1);

        public Builder returnReason(String var1);

        public Builder shippingAddress(Address var1);

        default public Builder shippingAddress(Consumer<Address.Builder> shippingAddress) {
            return this.shippingAddress((Address)((Address.Builder)Address.builder().applyMutation(shippingAddress)).build());
        }

        public Builder shippingLabel(String var1);
    }
}

