/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.privatenetworks.model.DeviceIdentifier;
import software.amazon.awssdk.services.privatenetworks.model.PrivateNetworksResponse;
import software.amazon.awssdk.services.privatenetworks.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDeviceIdentifierResponse
extends PrivateNetworksResponse
implements ToCopyableBuilder<Builder, GetDeviceIdentifierResponse> {
    private static final SdkField<DeviceIdentifier> DEVICE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deviceIdentifier").getter(GetDeviceIdentifierResponse.getter(GetDeviceIdentifierResponse::deviceIdentifier)).setter(GetDeviceIdentifierResponse.setter(Builder::deviceIdentifier)).constructor(DeviceIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceIdentifier").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetDeviceIdentifierResponse.getter(GetDeviceIdentifierResponse::tags)).setter(GetDeviceIdentifierResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_IDENTIFIER_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("deviceIdentifier", DEVICE_IDENTIFIER_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final DeviceIdentifier deviceIdentifier;
    private final Map<String, String> tags;

    private GetDeviceIdentifierResponse(BuilderImpl builder) {
        super(builder);
        this.deviceIdentifier = builder.deviceIdentifier;
        this.tags = builder.tags;
    }

    public final DeviceIdentifier deviceIdentifier() {
        return this.deviceIdentifier;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeviceIdentifierResponse)) {
            return false;
        }
        GetDeviceIdentifierResponse other = (GetDeviceIdentifierResponse)((Object)obj);
        return Objects.equals(this.deviceIdentifier(), other.deviceIdentifier()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetDeviceIdentifierResponse").add("DeviceIdentifier", (Object)this.deviceIdentifier()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deviceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.deviceIdentifier()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetDeviceIdentifierResponse, T> g) {
        return obj -> g.apply((GetDeviceIdentifierResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PrivateNetworksResponse.BuilderImpl
    implements Builder {
        private DeviceIdentifier deviceIdentifier;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeviceIdentifierResponse model) {
            super(model);
            this.deviceIdentifier(model.deviceIdentifier);
            this.tags(model.tags);
        }

        public final DeviceIdentifier.Builder getDeviceIdentifier() {
            return this.deviceIdentifier != null ? this.deviceIdentifier.toBuilder() : null;
        }

        public final void setDeviceIdentifier(DeviceIdentifier.BuilderImpl deviceIdentifier) {
            this.deviceIdentifier = deviceIdentifier != null ? deviceIdentifier.build() : null;
        }

        @Override
        public final Builder deviceIdentifier(DeviceIdentifier deviceIdentifier) {
            this.deviceIdentifier = deviceIdentifier;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetDeviceIdentifierResponse build() {
            return new GetDeviceIdentifierResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PrivateNetworksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDeviceIdentifierResponse> {
        public Builder deviceIdentifier(DeviceIdentifier var1);

        default public Builder deviceIdentifier(Consumer<DeviceIdentifier.Builder> deviceIdentifier) {
            return this.deviceIdentifier((DeviceIdentifier)((DeviceIdentifier.Builder)DeviceIdentifier.builder().applyMutation(deviceIdentifier)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

