/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.privatenetworks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a network resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkResource implements SdkPojo, Serializable, ToCopyableBuilder<NetworkResource.Builder, NetworkResource> {
    private static final SdkField<List<NameValuePair>> ATTRIBUTES_FIELD = SdkField
            .<List<NameValuePair>> builder(MarshallingType.LIST)
            .memberName("attributes")
            .getter(getter(NetworkResource::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NameValuePair> builder(MarshallingType.SDK_POJO)
                                            .constructor(NameValuePair::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CommitmentInformation> COMMITMENT_INFORMATION_FIELD = SdkField
            .<CommitmentInformation> builder(MarshallingType.SDK_POJO).memberName("commitmentInformation")
            .getter(getter(NetworkResource::commitmentInformation)).setter(setter(Builder::commitmentInformation))
            .constructor(CommitmentInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitmentInformation").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(NetworkResource::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(NetworkResource::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> HEALTH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("health")
            .getter(getter(NetworkResource::healthAsString)).setter(setter(Builder::health))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("health").build()).build();

    private static final SdkField<String> MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("model")
            .getter(getter(NetworkResource::model)).setter(setter(Builder::model))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("model").build()).build();

    private static final SdkField<String> NETWORK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("networkArn").getter(getter(NetworkResource::networkArn)).setter(setter(Builder::networkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkArn").build()).build();

    private static final SdkField<String> NETWORK_RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("networkResourceArn").getter(getter(NetworkResource::networkResourceArn))
            .setter(setter(Builder::networkResourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkResourceArn").build())
            .build();

    private static final SdkField<String> NETWORK_SITE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("networkSiteArn").getter(getter(NetworkResource::networkSiteArn)).setter(setter(Builder::networkSiteArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkSiteArn").build()).build();

    private static final SdkField<String> ORDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("orderArn").getter(getter(NetworkResource::orderArn)).setter(setter(Builder::orderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orderArn").build()).build();

    private static final SdkField<Position> POSITION_FIELD = SdkField.<Position> builder(MarshallingType.SDK_POJO)
            .memberName("position").getter(getter(NetworkResource::position)).setter(setter(Builder::position))
            .constructor(Position::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("position").build()).build();

    private static final SdkField<ReturnInformation> RETURN_INFORMATION_FIELD = SdkField
            .<ReturnInformation> builder(MarshallingType.SDK_POJO).memberName("returnInformation")
            .getter(getter(NetworkResource::returnInformation)).setter(setter(Builder::returnInformation))
            .constructor(ReturnInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("returnInformation").build()).build();

    private static final SdkField<String> SERIAL_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serialNumber").getter(getter(NetworkResource::serialNumber)).setter(setter(Builder::serialNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serialNumber").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(NetworkResource::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(NetworkResource::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(NetworkResource::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> VENDOR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("vendor")
            .getter(getter(NetworkResource::vendor)).setter(setter(Builder::vendor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vendor").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD,
            COMMITMENT_INFORMATION_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, HEALTH_FIELD, MODEL_FIELD, NETWORK_ARN_FIELD,
            NETWORK_RESOURCE_ARN_FIELD, NETWORK_SITE_ARN_FIELD, ORDER_ARN_FIELD, POSITION_FIELD, RETURN_INFORMATION_FIELD,
            SERIAL_NUMBER_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, TYPE_FIELD, VENDOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<NameValuePair> attributes;

    private final CommitmentInformation commitmentInformation;

    private final Instant createdAt;

    private final String description;

    private final String health;

    private final String model;

    private final String networkArn;

    private final String networkResourceArn;

    private final String networkSiteArn;

    private final String orderArn;

    private final Position position;

    private final ReturnInformation returnInformation;

    private final String serialNumber;

    private final String status;

    private final String statusReason;

    private final String type;

    private final String vendor;

    private NetworkResource(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.commitmentInformation = builder.commitmentInformation;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.health = builder.health;
        this.model = builder.model;
        this.networkArn = builder.networkArn;
        this.networkResourceArn = builder.networkResourceArn;
        this.networkSiteArn = builder.networkSiteArn;
        this.orderArn = builder.orderArn;
        this.position = builder.position;
        this.returnInformation = builder.returnInformation;
        this.serialNumber = builder.serialNumber;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.type = builder.type;
        this.vendor = builder.vendor;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attributes of the network resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return The attributes of the network resource.
     */
    public final List<NameValuePair> attributes() {
        return attributes;
    }

    /**
     * <p>
     * Information about the commitment period for the radio unit. Shows the duration, the date and time that the
     * contract started and ends, and the renewal status of the commitment period.
     * </p>
     * 
     * @return Information about the commitment period for the radio unit. Shows the duration, the date and time that
     *         the contract started and ends, and the renewal status of the commitment period.
     */
    public final CommitmentInformation commitmentInformation() {
        return commitmentInformation;
    }

    /**
     * <p>
     * The creation time of the network resource.
     * </p>
     * 
     * @return The creation time of the network resource.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The description of the network resource.
     * </p>
     * 
     * @return The description of the network resource.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The health of the network resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #health} will
     * return {@link HealthStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #healthAsString}.
     * </p>
     * 
     * @return The health of the network resource.
     * @see HealthStatus
     */
    public final HealthStatus health() {
        return HealthStatus.fromValue(health);
    }

    /**
     * <p>
     * The health of the network resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #health} will
     * return {@link HealthStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #healthAsString}.
     * </p>
     * 
     * @return The health of the network resource.
     * @see HealthStatus
     */
    public final String healthAsString() {
        return health;
    }

    /**
     * <p>
     * The model of the network resource.
     * </p>
     * 
     * @return The model of the network resource.
     */
    public final String model() {
        return model;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the network on which this network resource appears.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the network on which this network resource appears.
     */
    public final String networkArn() {
        return networkArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the network resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the network resource.
     */
    public final String networkResourceArn() {
        return networkResourceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the network site on which this network resource appears.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the network site on which this network resource appears.
     */
    public final String networkSiteArn() {
        return networkSiteArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the order used to purchase this network resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the order used to purchase this network resource.
     */
    public final String orderArn() {
        return orderArn;
    }

    /**
     * <p>
     * The position of the network resource.
     * </p>
     * 
     * @return The position of the network resource.
     */
    public final Position position() {
        return position;
    }

    /**
     * <p>
     * Information about a request to return the network resource.
     * </p>
     * 
     * @return Information about a request to return the network resource.
     */
    public final ReturnInformation returnInformation() {
        return returnInformation;
    }

    /**
     * <p>
     * The serial number of the network resource.
     * </p>
     * 
     * @return The serial number of the network resource.
     */
    public final String serialNumber() {
        return serialNumber;
    }

    /**
     * <p>
     * The status of the network resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NetworkResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the network resource.
     * @see NetworkResourceStatus
     */
    public final NetworkResourceStatus status() {
        return NetworkResourceStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the network resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NetworkResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the network resource.
     * @see NetworkResourceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The status reason of the network resource.
     * </p>
     * 
     * @return The status reason of the network resource.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The type of the network resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link NetworkResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the network resource.
     * @see NetworkResourceType
     */
    public final NetworkResourceType type() {
        return NetworkResourceType.fromValue(type);
    }

    /**
     * <p>
     * The type of the network resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link NetworkResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the network resource.
     * @see NetworkResourceType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The vendor of the network resource.
     * </p>
     * 
     * @return The vendor of the network resource.
     */
    public final String vendor() {
        return vendor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(commitmentInformation());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(healthAsString());
        hashCode = 31 * hashCode + Objects.hashCode(model());
        hashCode = 31 * hashCode + Objects.hashCode(networkArn());
        hashCode = 31 * hashCode + Objects.hashCode(networkResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(networkSiteArn());
        hashCode = 31 * hashCode + Objects.hashCode(orderArn());
        hashCode = 31 * hashCode + Objects.hashCode(position());
        hashCode = 31 * hashCode + Objects.hashCode(returnInformation());
        hashCode = 31 * hashCode + Objects.hashCode(serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vendor());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkResource)) {
            return false;
        }
        NetworkResource other = (NetworkResource) obj;
        return hasAttributes() == other.hasAttributes() && Objects.equals(attributes(), other.attributes())
                && Objects.equals(commitmentInformation(), other.commitmentInformation())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(description(), other.description())
                && Objects.equals(healthAsString(), other.healthAsString()) && Objects.equals(model(), other.model())
                && Objects.equals(networkArn(), other.networkArn())
                && Objects.equals(networkResourceArn(), other.networkResourceArn())
                && Objects.equals(networkSiteArn(), other.networkSiteArn()) && Objects.equals(orderArn(), other.orderArn())
                && Objects.equals(position(), other.position()) && Objects.equals(returnInformation(), other.returnInformation())
                && Objects.equals(serialNumber(), other.serialNumber())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(vendor(), other.vendor());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkResource").add("Attributes", hasAttributes() ? attributes() : null)
                .add("CommitmentInformation", commitmentInformation()).add("CreatedAt", createdAt())
                .add("Description", description()).add("Health", healthAsString()).add("Model", model())
                .add("NetworkArn", networkArn()).add("NetworkResourceArn", networkResourceArn())
                .add("NetworkSiteArn", networkSiteArn()).add("OrderArn", orderArn()).add("Position", position())
                .add("ReturnInformation", returnInformation()).add("SerialNumber", serialNumber())
                .add("Status", statusAsString()).add("StatusReason", statusReason()).add("Type", typeAsString())
                .add("Vendor", vendor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "commitmentInformation":
            return Optional.ofNullable(clazz.cast(commitmentInformation()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "health":
            return Optional.ofNullable(clazz.cast(healthAsString()));
        case "model":
            return Optional.ofNullable(clazz.cast(model()));
        case "networkArn":
            return Optional.ofNullable(clazz.cast(networkArn()));
        case "networkResourceArn":
            return Optional.ofNullable(clazz.cast(networkResourceArn()));
        case "networkSiteArn":
            return Optional.ofNullable(clazz.cast(networkSiteArn()));
        case "orderArn":
            return Optional.ofNullable(clazz.cast(orderArn()));
        case "position":
            return Optional.ofNullable(clazz.cast(position()));
        case "returnInformation":
            return Optional.ofNullable(clazz.cast(returnInformation()));
        case "serialNumber":
            return Optional.ofNullable(clazz.cast(serialNumber()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "vendor":
            return Optional.ofNullable(clazz.cast(vendor()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("attributes", ATTRIBUTES_FIELD);
        map.put("commitmentInformation", COMMITMENT_INFORMATION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("health", HEALTH_FIELD);
        map.put("model", MODEL_FIELD);
        map.put("networkArn", NETWORK_ARN_FIELD);
        map.put("networkResourceArn", NETWORK_RESOURCE_ARN_FIELD);
        map.put("networkSiteArn", NETWORK_SITE_ARN_FIELD);
        map.put("orderArn", ORDER_ARN_FIELD);
        map.put("position", POSITION_FIELD);
        map.put("returnInformation", RETURN_INFORMATION_FIELD);
        map.put("serialNumber", SERIAL_NUMBER_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("vendor", VENDOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkResource, T> g) {
        return obj -> g.apply((NetworkResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkResource> {
        /**
         * <p>
         * The attributes of the network resource.
         * </p>
         * 
         * @param attributes
         *        The attributes of the network resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<NameValuePair> attributes);

        /**
         * <p>
         * The attributes of the network resource.
         * </p>
         * 
         * @param attributes
         *        The attributes of the network resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(NameValuePair... attributes);

        /**
         * <p>
         * The attributes of the network resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.privatenetworks.model.NameValuePair.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.privatenetworks.model.NameValuePair#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.privatenetworks.model.NameValuePair.Builder#build()} is called
         * immediately and its result is passed to {@link #attributes(List<NameValuePair>)}.
         * 
         * @param attributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.privatenetworks.model.NameValuePair.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(java.util.Collection<NameValuePair>)
         */
        Builder attributes(Consumer<NameValuePair.Builder>... attributes);

        /**
         * <p>
         * Information about the commitment period for the radio unit. Shows the duration, the date and time that the
         * contract started and ends, and the renewal status of the commitment period.
         * </p>
         * 
         * @param commitmentInformation
         *        Information about the commitment period for the radio unit. Shows the duration, the date and time that
         *        the contract started and ends, and the renewal status of the commitment period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitmentInformation(CommitmentInformation commitmentInformation);

        /**
         * <p>
         * Information about the commitment period for the radio unit. Shows the duration, the date and time that the
         * contract started and ends, and the renewal status of the commitment period.
         * </p>
         * This is a convenience method that creates an instance of the {@link CommitmentInformation.Builder} avoiding
         * the need to create one manually via {@link CommitmentInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CommitmentInformation.Builder#build()} is called immediately and
         * its result is passed to {@link #commitmentInformation(CommitmentInformation)}.
         * 
         * @param commitmentInformation
         *        a consumer that will call methods on {@link CommitmentInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #commitmentInformation(CommitmentInformation)
         */
        default Builder commitmentInformation(Consumer<CommitmentInformation.Builder> commitmentInformation) {
            return commitmentInformation(CommitmentInformation.builder().applyMutation(commitmentInformation).build());
        }

        /**
         * <p>
         * The creation time of the network resource.
         * </p>
         * 
         * @param createdAt
         *        The creation time of the network resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The description of the network resource.
         * </p>
         * 
         * @param description
         *        The description of the network resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The health of the network resource.
         * </p>
         * 
         * @param health
         *        The health of the network resource.
         * @see HealthStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HealthStatus
         */
        Builder health(String health);

        /**
         * <p>
         * The health of the network resource.
         * </p>
         * 
         * @param health
         *        The health of the network resource.
         * @see HealthStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HealthStatus
         */
        Builder health(HealthStatus health);

        /**
         * <p>
         * The model of the network resource.
         * </p>
         * 
         * @param model
         *        The model of the network resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder model(String model);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the network on which this network resource appears.
         * </p>
         * 
         * @param networkArn
         *        The Amazon Resource Name (ARN) of the network on which this network resource appears.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkArn(String networkArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the network resource.
         * </p>
         * 
         * @param networkResourceArn
         *        The Amazon Resource Name (ARN) of the network resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkResourceArn(String networkResourceArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the network site on which this network resource appears.
         * </p>
         * 
         * @param networkSiteArn
         *        The Amazon Resource Name (ARN) of the network site on which this network resource appears.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkSiteArn(String networkSiteArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the order used to purchase this network resource.
         * </p>
         * 
         * @param orderArn
         *        The Amazon Resource Name (ARN) of the order used to purchase this network resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderArn(String orderArn);

        /**
         * <p>
         * The position of the network resource.
         * </p>
         * 
         * @param position
         *        The position of the network resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(Position position);

        /**
         * <p>
         * The position of the network resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link Position.Builder} avoiding the need to
         * create one manually via {@link Position#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Position.Builder#build()} is called immediately and its result is
         * passed to {@link #position(Position)}.
         * 
         * @param position
         *        a consumer that will call methods on {@link Position.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #position(Position)
         */
        default Builder position(Consumer<Position.Builder> position) {
            return position(Position.builder().applyMutation(position).build());
        }

        /**
         * <p>
         * Information about a request to return the network resource.
         * </p>
         * 
         * @param returnInformation
         *        Information about a request to return the network resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnInformation(ReturnInformation returnInformation);

        /**
         * <p>
         * Information about a request to return the network resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReturnInformation.Builder} avoiding the
         * need to create one manually via {@link ReturnInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReturnInformation.Builder#build()} is called immediately and its
         * result is passed to {@link #returnInformation(ReturnInformation)}.
         * 
         * @param returnInformation
         *        a consumer that will call methods on {@link ReturnInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #returnInformation(ReturnInformation)
         */
        default Builder returnInformation(Consumer<ReturnInformation.Builder> returnInformation) {
            return returnInformation(ReturnInformation.builder().applyMutation(returnInformation).build());
        }

        /**
         * <p>
         * The serial number of the network resource.
         * </p>
         * 
         * @param serialNumber
         *        The serial number of the network resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serialNumber(String serialNumber);

        /**
         * <p>
         * The status of the network resource.
         * </p>
         * 
         * @param status
         *        The status of the network resource.
         * @see NetworkResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkResourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the network resource.
         * </p>
         * 
         * @param status
         *        The status of the network resource.
         * @see NetworkResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkResourceStatus
         */
        Builder status(NetworkResourceStatus status);

        /**
         * <p>
         * The status reason of the network resource.
         * </p>
         * 
         * @param statusReason
         *        The status reason of the network resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The type of the network resource.
         * </p>
         * 
         * @param type
         *        The type of the network resource.
         * @see NetworkResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkResourceType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the network resource.
         * </p>
         * 
         * @param type
         *        The type of the network resource.
         * @see NetworkResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkResourceType
         */
        Builder type(NetworkResourceType type);

        /**
         * <p>
         * The vendor of the network resource.
         * </p>
         * 
         * @param vendor
         *        The vendor of the network resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vendor(String vendor);
    }

    static final class BuilderImpl implements Builder {
        private List<NameValuePair> attributes = DefaultSdkAutoConstructList.getInstance();

        private CommitmentInformation commitmentInformation;

        private Instant createdAt;

        private String description;

        private String health;

        private String model;

        private String networkArn;

        private String networkResourceArn;

        private String networkSiteArn;

        private String orderArn;

        private Position position;

        private ReturnInformation returnInformation;

        private String serialNumber;

        private String status;

        private String statusReason;

        private String type;

        private String vendor;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkResource model) {
            attributes(model.attributes);
            commitmentInformation(model.commitmentInformation);
            createdAt(model.createdAt);
            description(model.description);
            health(model.health);
            model(model.model);
            networkArn(model.networkArn);
            networkResourceArn(model.networkResourceArn);
            networkSiteArn(model.networkSiteArn);
            orderArn(model.orderArn);
            position(model.position);
            returnInformation(model.returnInformation);
            serialNumber(model.serialNumber);
            status(model.status);
            statusReason(model.statusReason);
            type(model.type);
            vendor(model.vendor);
        }

        public final List<NameValuePair.Builder> getAttributes() {
            List<NameValuePair.Builder> result = NameValuePairsCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Collection<NameValuePair.BuilderImpl> attributes) {
            this.attributes = NameValuePairsCopier.copyFromBuilder(attributes);
        }

        @Override
        public final Builder attributes(Collection<NameValuePair> attributes) {
            this.attributes = NameValuePairsCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(NameValuePair... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<NameValuePair.Builder>... attributes) {
            attributes(Stream.of(attributes).map(c -> NameValuePair.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final CommitmentInformation.Builder getCommitmentInformation() {
            return commitmentInformation != null ? commitmentInformation.toBuilder() : null;
        }

        public final void setCommitmentInformation(CommitmentInformation.BuilderImpl commitmentInformation) {
            this.commitmentInformation = commitmentInformation != null ? commitmentInformation.build() : null;
        }

        @Override
        public final Builder commitmentInformation(CommitmentInformation commitmentInformation) {
            this.commitmentInformation = commitmentInformation;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getHealth() {
            return health;
        }

        public final void setHealth(String health) {
            this.health = health;
        }

        @Override
        public final Builder health(String health) {
            this.health = health;
            return this;
        }

        @Override
        public final Builder health(HealthStatus health) {
            this.health(health == null ? null : health.toString());
            return this;
        }

        public final String getModel() {
            return model;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        @Override
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final String getNetworkArn() {
            return networkArn;
        }

        public final void setNetworkArn(String networkArn) {
            this.networkArn = networkArn;
        }

        @Override
        public final Builder networkArn(String networkArn) {
            this.networkArn = networkArn;
            return this;
        }

        public final String getNetworkResourceArn() {
            return networkResourceArn;
        }

        public final void setNetworkResourceArn(String networkResourceArn) {
            this.networkResourceArn = networkResourceArn;
        }

        @Override
        public final Builder networkResourceArn(String networkResourceArn) {
            this.networkResourceArn = networkResourceArn;
            return this;
        }

        public final String getNetworkSiteArn() {
            return networkSiteArn;
        }

        public final void setNetworkSiteArn(String networkSiteArn) {
            this.networkSiteArn = networkSiteArn;
        }

        @Override
        public final Builder networkSiteArn(String networkSiteArn) {
            this.networkSiteArn = networkSiteArn;
            return this;
        }

        public final String getOrderArn() {
            return orderArn;
        }

        public final void setOrderArn(String orderArn) {
            this.orderArn = orderArn;
        }

        @Override
        public final Builder orderArn(String orderArn) {
            this.orderArn = orderArn;
            return this;
        }

        public final Position.Builder getPosition() {
            return position != null ? position.toBuilder() : null;
        }

        public final void setPosition(Position.BuilderImpl position) {
            this.position = position != null ? position.build() : null;
        }

        @Override
        public final Builder position(Position position) {
            this.position = position;
            return this;
        }

        public final ReturnInformation.Builder getReturnInformation() {
            return returnInformation != null ? returnInformation.toBuilder() : null;
        }

        public final void setReturnInformation(ReturnInformation.BuilderImpl returnInformation) {
            this.returnInformation = returnInformation != null ? returnInformation.build() : null;
        }

        @Override
        public final Builder returnInformation(ReturnInformation returnInformation) {
            this.returnInformation = returnInformation;
            return this;
        }

        public final String getSerialNumber() {
            return serialNumber;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NetworkResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(NetworkResourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getVendor() {
            return vendor;
        }

        public final void setVendor(String vendor) {
            this.vendor = vendor;
        }

        @Override
        public final Builder vendor(String vendor) {
            this.vendor = vendor;
            return this;
        }

        @Override
        public NetworkResource build() {
            return new NetworkResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
