/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.privatenetworks.model.NetworkResource;
import software.amazon.awssdk.services.privatenetworks.model.PrivateNetworksResponse;
import software.amazon.awssdk.services.privatenetworks.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetNetworkResourceResponse
extends PrivateNetworksResponse
implements ToCopyableBuilder<Builder, GetNetworkResourceResponse> {
    private static final SdkField<NetworkResource> NETWORK_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networkResource").getter(GetNetworkResourceResponse.getter(GetNetworkResourceResponse::networkResource)).setter(GetNetworkResourceResponse.setter(Builder::networkResource)).constructor(NetworkResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkResource").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetNetworkResourceResponse.getter(GetNetworkResourceResponse::tags)).setter(GetNetworkResourceResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_RESOURCE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetNetworkResourceResponse.memberNameToFieldInitializer();
    private final NetworkResource networkResource;
    private final Map<String, String> tags;

    private GetNetworkResourceResponse(BuilderImpl builder) {
        super(builder);
        this.networkResource = builder.networkResource;
        this.tags = builder.tags;
    }

    public final NetworkResource networkResource() {
        return this.networkResource;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.networkResource());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNetworkResourceResponse)) {
            return false;
        }
        GetNetworkResourceResponse other = (GetNetworkResourceResponse)((Object)obj);
        return Objects.equals(this.networkResource(), other.networkResource()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetNetworkResourceResponse").add("NetworkResource", (Object)this.networkResource()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "networkResource": {
                return Optional.ofNullable(clazz.cast(this.networkResource()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("networkResource", NETWORK_RESOURCE_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetNetworkResourceResponse, T> g) {
        return obj -> g.apply((GetNetworkResourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PrivateNetworksResponse.BuilderImpl
    implements Builder {
        private NetworkResource networkResource;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetNetworkResourceResponse model) {
            super(model);
            this.networkResource(model.networkResource);
            this.tags(model.tags);
        }

        public final NetworkResource.Builder getNetworkResource() {
            return this.networkResource != null ? this.networkResource.toBuilder() : null;
        }

        public final void setNetworkResource(NetworkResource.BuilderImpl networkResource) {
            this.networkResource = networkResource != null ? networkResource.build() : null;
        }

        @Override
        public final Builder networkResource(NetworkResource networkResource) {
            this.networkResource = networkResource;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetNetworkResourceResponse build() {
            return new GetNetworkResourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PrivateNetworksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetNetworkResourceResponse> {
        public Builder networkResource(NetworkResource var1);

        default public Builder networkResource(Consumer<NetworkResource.Builder> networkResource) {
            return this.networkResource((NetworkResource)((NetworkResource.Builder)NetworkResource.builder().applyMutation(networkResource)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

