/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.privatenetworks.model.PrivateNetworksRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeactivateDeviceIdentifierRequest
extends PrivateNetworksRequest
implements ToCopyableBuilder<Builder, DeactivateDeviceIdentifierRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(DeactivateDeviceIdentifierRequest.getter(DeactivateDeviceIdentifierRequest::clientToken)).setter(DeactivateDeviceIdentifierRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final SdkField<String> DEVICE_IDENTIFIER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deviceIdentifierArn").getter(DeactivateDeviceIdentifierRequest.getter(DeactivateDeviceIdentifierRequest::deviceIdentifierArn)).setter(DeactivateDeviceIdentifierRequest.setter(Builder::deviceIdentifierArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceIdentifierArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DEVICE_IDENTIFIER_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeactivateDeviceIdentifierRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String deviceIdentifierArn;

    private DeactivateDeviceIdentifierRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.deviceIdentifierArn = builder.deviceIdentifierArn;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String deviceIdentifierArn() {
        return this.deviceIdentifierArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceIdentifierArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeactivateDeviceIdentifierRequest)) {
            return false;
        }
        DeactivateDeviceIdentifierRequest other = (DeactivateDeviceIdentifierRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.deviceIdentifierArn(), other.deviceIdentifierArn());
    }

    public final String toString() {
        return ToString.builder((String)"DeactivateDeviceIdentifierRequest").add("ClientToken", (Object)this.clientToken()).add("DeviceIdentifierArn", (Object)this.deviceIdentifierArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "deviceIdentifierArn": {
                return Optional.ofNullable(clazz.cast(this.deviceIdentifierArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("deviceIdentifierArn", DEVICE_IDENTIFIER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeactivateDeviceIdentifierRequest, T> g) {
        return obj -> g.apply((DeactivateDeviceIdentifierRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PrivateNetworksRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String deviceIdentifierArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeactivateDeviceIdentifierRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.deviceIdentifierArn(model.deviceIdentifierArn);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDeviceIdentifierArn() {
            return this.deviceIdentifierArn;
        }

        public final void setDeviceIdentifierArn(String deviceIdentifierArn) {
            this.deviceIdentifierArn = deviceIdentifierArn;
        }

        @Override
        public final Builder deviceIdentifierArn(String deviceIdentifierArn) {
            this.deviceIdentifierArn = deviceIdentifierArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeactivateDeviceIdentifierRequest build() {
            return new DeactivateDeviceIdentifierRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PrivateNetworksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeactivateDeviceIdentifierRequest> {
        public Builder clientToken(String var1);

        public Builder deviceIdentifierArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

