/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.privatenetworks.model.PrivateNetworksRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteNetworkSiteRequest
extends PrivateNetworksRequest
implements ToCopyableBuilder<Builder, DeleteNetworkSiteRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(DeleteNetworkSiteRequest.getter(DeleteNetworkSiteRequest::clientToken)).setter(DeleteNetworkSiteRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clientToken").build()}).build();
    private static final SdkField<String> NETWORK_SITE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkSiteArn").getter(DeleteNetworkSiteRequest.getter(DeleteNetworkSiteRequest::networkSiteArn)).setter(DeleteNetworkSiteRequest.setter(Builder::networkSiteArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("networkSiteArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, NETWORK_SITE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteNetworkSiteRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String networkSiteArn;

    private DeleteNetworkSiteRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.networkSiteArn = builder.networkSiteArn;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String networkSiteArn() {
        return this.networkSiteArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkSiteArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteNetworkSiteRequest)) {
            return false;
        }
        DeleteNetworkSiteRequest other = (DeleteNetworkSiteRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.networkSiteArn(), other.networkSiteArn());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteNetworkSiteRequest").add("ClientToken", (Object)this.clientToken()).add("NetworkSiteArn", (Object)this.networkSiteArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "networkSiteArn": {
                return Optional.ofNullable(clazz.cast(this.networkSiteArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("networkSiteArn", NETWORK_SITE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteNetworkSiteRequest, T> g) {
        return obj -> g.apply((DeleteNetworkSiteRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PrivateNetworksRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String networkSiteArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteNetworkSiteRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.networkSiteArn(model.networkSiteArn);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getNetworkSiteArn() {
            return this.networkSiteArn;
        }

        public final void setNetworkSiteArn(String networkSiteArn) {
            this.networkSiteArn = networkSiteArn;
        }

        @Override
        public final Builder networkSiteArn(String networkSiteArn) {
            this.networkSiteArn = networkSiteArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteNetworkSiteRequest build() {
            return new DeleteNetworkSiteRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PrivateNetworksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteNetworkSiteRequest> {
        public Builder clientToken(String var1);

        public Builder networkSiteArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

