/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.privatenetworks.model.DeviceIdentifierFilterKeys;
import software.amazon.awssdk.services.privatenetworks.model.DeviceIdentifierFiltersCopier;
import software.amazon.awssdk.services.privatenetworks.model.PrivateNetworksRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDeviceIdentifiersRequest
extends PrivateNetworksRequest
implements ToCopyableBuilder<Builder, ListDeviceIdentifiersRequest> {
    private static final SdkField<Map<String, List<String>>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("filters").getter(ListDeviceIdentifiersRequest.getter(ListDeviceIdentifiersRequest::filtersAsStrings)).setter(ListDeviceIdentifiersRequest.setter(Builder::filtersWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListDeviceIdentifiersRequest.getter(ListDeviceIdentifiersRequest::maxResults)).setter(ListDeviceIdentifiersRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NETWORK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkArn").getter(ListDeviceIdentifiersRequest.getter(ListDeviceIdentifiersRequest::networkArn)).setter(ListDeviceIdentifiersRequest.setter(Builder::networkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkArn").build()}).build();
    private static final SdkField<String> START_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("startToken").getter(ListDeviceIdentifiersRequest.getter(ListDeviceIdentifiersRequest::startToken)).setter(ListDeviceIdentifiersRequest.setter(Builder::startToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD, MAX_RESULTS_FIELD, NETWORK_ARN_FIELD, START_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDeviceIdentifiersRequest.memberNameToFieldInitializer();
    private final Map<String, List<String>> filters;
    private final Integer maxResults;
    private final String networkArn;
    private final String startToken;

    private ListDeviceIdentifiersRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.networkArn = builder.networkArn;
        this.startToken = builder.startToken;
    }

    public final Map<DeviceIdentifierFilterKeys, List<String>> filters() {
        return DeviceIdentifierFiltersCopier.copyStringToEnum(this.filters);
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> filtersAsStrings() {
        return this.filters;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String networkArn() {
        return this.networkArn;
    }

    public final String startToken() {
        return this.startToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filtersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.startToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeviceIdentifiersRequest)) {
            return false;
        }
        ListDeviceIdentifiersRequest other = (ListDeviceIdentifiersRequest)((Object)obj);
        return this.hasFilters() == other.hasFilters() && Objects.equals(this.filtersAsStrings(), other.filtersAsStrings()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.networkArn(), other.networkArn()) && Objects.equals(this.startToken(), other.startToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDeviceIdentifiersRequest").add("Filters", this.hasFilters() ? this.filtersAsStrings() : null).add("MaxResults", (Object)this.maxResults()).add("NetworkArn", (Object)this.networkArn()).add("StartToken", (Object)this.startToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filtersAsStrings()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "networkArn": {
                return Optional.ofNullable(clazz.cast(this.networkArn()));
            }
            case "startToken": {
                return Optional.ofNullable(clazz.cast(this.startToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("filters", FILTERS_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("networkArn", NETWORK_ARN_FIELD);
        map.put("startToken", START_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDeviceIdentifiersRequest, T> g) {
        return obj -> g.apply((ListDeviceIdentifiersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PrivateNetworksRequest.BuilderImpl
    implements Builder {
        private Map<String, List<String>> filters = DefaultSdkAutoConstructMap.getInstance();
        private Integer maxResults;
        private String networkArn;
        private String startToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeviceIdentifiersRequest model) {
            super(model);
            this.filtersWithStrings(model.filters);
            this.maxResults(model.maxResults);
            this.networkArn(model.networkArn);
            this.startToken(model.startToken);
        }

        public final Map<String, ? extends Collection<String>> getFilters() {
            if (this.filters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.filters;
        }

        public final void setFilters(Map<String, ? extends Collection<String>> filters) {
            this.filters = DeviceIdentifierFiltersCopier.copy(filters);
        }

        @Override
        public final Builder filtersWithStrings(Map<String, ? extends Collection<String>> filters) {
            this.filters = DeviceIdentifierFiltersCopier.copy(filters);
            return this;
        }

        @Override
        public final Builder filters(Map<DeviceIdentifierFilterKeys, ? extends Collection<String>> filters) {
            this.filters = DeviceIdentifierFiltersCopier.copyEnumToString(filters);
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNetworkArn() {
            return this.networkArn;
        }

        public final void setNetworkArn(String networkArn) {
            this.networkArn = networkArn;
        }

        @Override
        public final Builder networkArn(String networkArn) {
            this.networkArn = networkArn;
            return this;
        }

        public final String getStartToken() {
            return this.startToken;
        }

        public final void setStartToken(String startToken) {
            this.startToken = startToken;
        }

        @Override
        public final Builder startToken(String startToken) {
            this.startToken = startToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDeviceIdentifiersRequest build() {
            return new ListDeviceIdentifiersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PrivateNetworksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDeviceIdentifiersRequest> {
        public Builder filtersWithStrings(Map<String, ? extends Collection<String>> var1);

        public Builder filters(Map<DeviceIdentifierFilterKeys, ? extends Collection<String>> var1);

        public Builder maxResults(Integer var1);

        public Builder networkArn(String var1);

        public Builder startToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

