/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.privatenetworks.model.NetworkSite;
import software.amazon.awssdk.services.privatenetworks.model.NetworkSiteListCopier;
import software.amazon.awssdk.services.privatenetworks.model.PrivateNetworksResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListNetworkSitesResponse
extends PrivateNetworksResponse
implements ToCopyableBuilder<Builder, ListNetworkSitesResponse> {
    private static final SdkField<List<NetworkSite>> NETWORK_SITES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("networkSites").getter(ListNetworkSitesResponse.getter(ListNetworkSitesResponse::networkSites)).setter(ListNetworkSitesResponse.setter(Builder::networkSites)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkSites").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkSite::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListNetworkSitesResponse.getter(ListNetworkSitesResponse::nextToken)).setter(ListNetworkSitesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_SITES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListNetworkSitesResponse.memberNameToFieldInitializer();
    private final List<NetworkSite> networkSites;
    private final String nextToken;

    private ListNetworkSitesResponse(BuilderImpl builder) {
        super(builder);
        this.networkSites = builder.networkSites;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasNetworkSites() {
        return this.networkSites != null && !(this.networkSites instanceof SdkAutoConstructList);
    }

    public final List<NetworkSite> networkSites() {
        return this.networkSites;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkSites() ? this.networkSites() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNetworkSitesResponse)) {
            return false;
        }
        ListNetworkSitesResponse other = (ListNetworkSitesResponse)((Object)obj);
        return this.hasNetworkSites() == other.hasNetworkSites() && Objects.equals(this.networkSites(), other.networkSites()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListNetworkSitesResponse").add("NetworkSites", this.hasNetworkSites() ? this.networkSites() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "networkSites": {
                return Optional.ofNullable(clazz.cast(this.networkSites()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("networkSites", NETWORK_SITES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListNetworkSitesResponse, T> g) {
        return obj -> g.apply((ListNetworkSitesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PrivateNetworksResponse.BuilderImpl
    implements Builder {
        private List<NetworkSite> networkSites = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNetworkSitesResponse model) {
            super(model);
            this.networkSites(model.networkSites);
            this.nextToken(model.nextToken);
        }

        public final List<NetworkSite.Builder> getNetworkSites() {
            List<NetworkSite.Builder> result = NetworkSiteListCopier.copyToBuilder(this.networkSites);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkSites(Collection<NetworkSite.BuilderImpl> networkSites) {
            this.networkSites = NetworkSiteListCopier.copyFromBuilder(networkSites);
        }

        @Override
        public final Builder networkSites(Collection<NetworkSite> networkSites) {
            this.networkSites = NetworkSiteListCopier.copy(networkSites);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkSites(NetworkSite ... networkSites) {
            this.networkSites(Arrays.asList(networkSites));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkSites(Consumer<NetworkSite.Builder> ... networkSites) {
            this.networkSites(Stream.of(networkSites).map(c -> (NetworkSite)((NetworkSite.Builder)NetworkSite.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListNetworkSitesResponse build() {
            return new ListNetworkSitesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PrivateNetworksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListNetworkSitesResponse> {
        public Builder networkSites(Collection<NetworkSite> var1);

        public Builder networkSites(NetworkSite ... var1);

        public Builder networkSites(Consumer<NetworkSite.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

