/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.privatenetworks.model.NetworkStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Network
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Network> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Network.getter(Network::createdAt)).setter(Network.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Network.getter(Network::description)).setter(Network.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> NETWORK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkArn").getter(Network.getter(Network::networkArn)).setter(Network.setter(Builder::networkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkArn").build()}).build();
    private static final SdkField<String> NETWORK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkName").getter(Network.getter(Network::networkName)).setter(Network.setter(Builder::networkName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Network.getter(Network::statusAsString)).setter(Network.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(Network.getter(Network::statusReason)).setter(Network.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, DESCRIPTION_FIELD, NETWORK_ARN_FIELD, NETWORK_NAME_FIELD, STATUS_FIELD, STATUS_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Network.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant createdAt;
    private final String description;
    private final String networkArn;
    private final String networkName;
    private final String status;
    private final String statusReason;

    private Network(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.networkArn = builder.networkArn;
        this.networkName = builder.networkName;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String description() {
        return this.description;
    }

    public final String networkArn() {
        return this.networkArn;
    }

    public final String networkName() {
        return this.networkName;
    }

    public final NetworkStatus status() {
        return NetworkStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Network)) {
            return false;
        }
        Network other = (Network)obj;
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.networkArn(), other.networkArn()) && Objects.equals(this.networkName(), other.networkName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason());
    }

    public final String toString() {
        return ToString.builder((String)"Network").add("CreatedAt", (Object)this.createdAt()).add("Description", (Object)this.description()).add("NetworkArn", (Object)this.networkArn()).add("NetworkName", (Object)this.networkName()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "networkArn": {
                return Optional.ofNullable(clazz.cast(this.networkArn()));
            }
            case "networkName": {
                return Optional.ofNullable(clazz.cast(this.networkName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("networkArn", NETWORK_ARN_FIELD);
        map.put("networkName", NETWORK_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Network, T> g) {
        return obj -> g.apply((Network)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String description;
        private String networkArn;
        private String networkName;
        private String status;
        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(Network model) {
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.networkArn(model.networkArn);
            this.networkName(model.networkName);
            this.status(model.status);
            this.statusReason(model.statusReason);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getNetworkArn() {
            return this.networkArn;
        }

        public final void setNetworkArn(String networkArn) {
            this.networkArn = networkArn;
        }

        @Override
        public final Builder networkArn(String networkArn) {
            this.networkArn = networkArn;
            return this;
        }

        public final String getNetworkName() {
            return this.networkName;
        }

        public final void setNetworkName(String networkName) {
            this.networkName = networkName;
        }

        @Override
        public final Builder networkName(String networkName) {
            this.networkName = networkName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NetworkStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public Network build() {
            return new Network(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Network> {
        public Builder createdAt(Instant var1);

        public Builder description(String var1);

        public Builder networkArn(String var1);

        public Builder networkName(String var1);

        public Builder status(String var1);

        public Builder status(NetworkStatus var1);

        public Builder statusReason(String var1);
    }
}

