/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.privatenetworks.model.AcknowledgmentStatus;
import software.amazon.awssdk.services.privatenetworks.model.Address;
import software.amazon.awssdk.services.privatenetworks.model.OrderedResourceDefinition;
import software.amazon.awssdk.services.privatenetworks.model.OrderedResourceDefinitionsCopier;
import software.amazon.awssdk.services.privatenetworks.model.TrackingInformation;
import software.amazon.awssdk.services.privatenetworks.model.TrackingInformationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Order
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Order> {
    private static final SdkField<String> ACKNOWLEDGMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("acknowledgmentStatus").getter(Order.getter(Order::acknowledgmentStatusAsString)).setter(Order.setter(Builder::acknowledgmentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acknowledgmentStatus").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Order.getter(Order::createdAt)).setter(Order.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> NETWORK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkArn").getter(Order.getter(Order::networkArn)).setter(Order.setter(Builder::networkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkArn").build()}).build();
    private static final SdkField<String> NETWORK_SITE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkSiteArn").getter(Order.getter(Order::networkSiteArn)).setter(Order.setter(Builder::networkSiteArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkSiteArn").build()}).build();
    private static final SdkField<String> ORDER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("orderArn").getter(Order.getter(Order::orderArn)).setter(Order.setter(Builder::orderArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orderArn").build()}).build();
    private static final SdkField<List<OrderedResourceDefinition>> ORDERED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("orderedResources").getter(Order.getter(Order::orderedResources)).setter(Order.setter(Builder::orderedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orderedResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OrderedResourceDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Address> SHIPPING_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("shippingAddress").getter(Order.getter(Order::shippingAddress)).setter(Order.setter(Builder::shippingAddress)).constructor(Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shippingAddress").build()}).build();
    private static final SdkField<List<TrackingInformation>> TRACKING_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("trackingInformation").getter(Order.getter(Order::trackingInformation)).setter(Order.setter(Builder::trackingInformation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackingInformation").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrackingInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACKNOWLEDGMENT_STATUS_FIELD, CREATED_AT_FIELD, NETWORK_ARN_FIELD, NETWORK_SITE_ARN_FIELD, ORDER_ARN_FIELD, ORDERED_RESOURCES_FIELD, SHIPPING_ADDRESS_FIELD, TRACKING_INFORMATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Order.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String acknowledgmentStatus;
    private final Instant createdAt;
    private final String networkArn;
    private final String networkSiteArn;
    private final String orderArn;
    private final List<OrderedResourceDefinition> orderedResources;
    private final Address shippingAddress;
    private final List<TrackingInformation> trackingInformation;

    private Order(BuilderImpl builder) {
        this.acknowledgmentStatus = builder.acknowledgmentStatus;
        this.createdAt = builder.createdAt;
        this.networkArn = builder.networkArn;
        this.networkSiteArn = builder.networkSiteArn;
        this.orderArn = builder.orderArn;
        this.orderedResources = builder.orderedResources;
        this.shippingAddress = builder.shippingAddress;
        this.trackingInformation = builder.trackingInformation;
    }

    public final AcknowledgmentStatus acknowledgmentStatus() {
        return AcknowledgmentStatus.fromValue(this.acknowledgmentStatus);
    }

    public final String acknowledgmentStatusAsString() {
        return this.acknowledgmentStatus;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String networkArn() {
        return this.networkArn;
    }

    public final String networkSiteArn() {
        return this.networkSiteArn;
    }

    public final String orderArn() {
        return this.orderArn;
    }

    public final boolean hasOrderedResources() {
        return this.orderedResources != null && !(this.orderedResources instanceof SdkAutoConstructList);
    }

    public final List<OrderedResourceDefinition> orderedResources() {
        return this.orderedResources;
    }

    public final Address shippingAddress() {
        return this.shippingAddress;
    }

    public final boolean hasTrackingInformation() {
        return this.trackingInformation != null && !(this.trackingInformation instanceof SdkAutoConstructList);
    }

    public final List<TrackingInformation> trackingInformation() {
        return this.trackingInformation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acknowledgmentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkSiteArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrderedResources() ? this.orderedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.shippingAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrackingInformation() ? this.trackingInformation() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Order)) {
            return false;
        }
        Order other = (Order)obj;
        return Objects.equals(this.acknowledgmentStatusAsString(), other.acknowledgmentStatusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.networkArn(), other.networkArn()) && Objects.equals(this.networkSiteArn(), other.networkSiteArn()) && Objects.equals(this.orderArn(), other.orderArn()) && this.hasOrderedResources() == other.hasOrderedResources() && Objects.equals(this.orderedResources(), other.orderedResources()) && Objects.equals(this.shippingAddress(), other.shippingAddress()) && this.hasTrackingInformation() == other.hasTrackingInformation() && Objects.equals(this.trackingInformation(), other.trackingInformation());
    }

    public final String toString() {
        return ToString.builder((String)"Order").add("AcknowledgmentStatus", (Object)this.acknowledgmentStatusAsString()).add("CreatedAt", (Object)this.createdAt()).add("NetworkArn", (Object)this.networkArn()).add("NetworkSiteArn", (Object)this.networkSiteArn()).add("OrderArn", (Object)this.orderArn()).add("OrderedResources", this.hasOrderedResources() ? this.orderedResources() : null).add("ShippingAddress", (Object)this.shippingAddress()).add("TrackingInformation", this.hasTrackingInformation() ? this.trackingInformation() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "acknowledgmentStatus": {
                return Optional.ofNullable(clazz.cast(this.acknowledgmentStatusAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "networkArn": {
                return Optional.ofNullable(clazz.cast(this.networkArn()));
            }
            case "networkSiteArn": {
                return Optional.ofNullable(clazz.cast(this.networkSiteArn()));
            }
            case "orderArn": {
                return Optional.ofNullable(clazz.cast(this.orderArn()));
            }
            case "orderedResources": {
                return Optional.ofNullable(clazz.cast(this.orderedResources()));
            }
            case "shippingAddress": {
                return Optional.ofNullable(clazz.cast(this.shippingAddress()));
            }
            case "trackingInformation": {
                return Optional.ofNullable(clazz.cast(this.trackingInformation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("acknowledgmentStatus", ACKNOWLEDGMENT_STATUS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("networkArn", NETWORK_ARN_FIELD);
        map.put("networkSiteArn", NETWORK_SITE_ARN_FIELD);
        map.put("orderArn", ORDER_ARN_FIELD);
        map.put("orderedResources", ORDERED_RESOURCES_FIELD);
        map.put("shippingAddress", SHIPPING_ADDRESS_FIELD);
        map.put("trackingInformation", TRACKING_INFORMATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Order, T> g) {
        return obj -> g.apply((Order)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String acknowledgmentStatus;
        private Instant createdAt;
        private String networkArn;
        private String networkSiteArn;
        private String orderArn;
        private List<OrderedResourceDefinition> orderedResources = DefaultSdkAutoConstructList.getInstance();
        private Address shippingAddress;
        private List<TrackingInformation> trackingInformation = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Order model) {
            this.acknowledgmentStatus(model.acknowledgmentStatus);
            this.createdAt(model.createdAt);
            this.networkArn(model.networkArn);
            this.networkSiteArn(model.networkSiteArn);
            this.orderArn(model.orderArn);
            this.orderedResources(model.orderedResources);
            this.shippingAddress(model.shippingAddress);
            this.trackingInformation(model.trackingInformation);
        }

        public final String getAcknowledgmentStatus() {
            return this.acknowledgmentStatus;
        }

        public final void setAcknowledgmentStatus(String acknowledgmentStatus) {
            this.acknowledgmentStatus = acknowledgmentStatus;
        }

        @Override
        public final Builder acknowledgmentStatus(String acknowledgmentStatus) {
            this.acknowledgmentStatus = acknowledgmentStatus;
            return this;
        }

        @Override
        public final Builder acknowledgmentStatus(AcknowledgmentStatus acknowledgmentStatus) {
            this.acknowledgmentStatus(acknowledgmentStatus == null ? null : acknowledgmentStatus.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getNetworkArn() {
            return this.networkArn;
        }

        public final void setNetworkArn(String networkArn) {
            this.networkArn = networkArn;
        }

        @Override
        public final Builder networkArn(String networkArn) {
            this.networkArn = networkArn;
            return this;
        }

        public final String getNetworkSiteArn() {
            return this.networkSiteArn;
        }

        public final void setNetworkSiteArn(String networkSiteArn) {
            this.networkSiteArn = networkSiteArn;
        }

        @Override
        public final Builder networkSiteArn(String networkSiteArn) {
            this.networkSiteArn = networkSiteArn;
            return this;
        }

        public final String getOrderArn() {
            return this.orderArn;
        }

        public final void setOrderArn(String orderArn) {
            this.orderArn = orderArn;
        }

        @Override
        public final Builder orderArn(String orderArn) {
            this.orderArn = orderArn;
            return this;
        }

        public final List<OrderedResourceDefinition.Builder> getOrderedResources() {
            List<OrderedResourceDefinition.Builder> result = OrderedResourceDefinitionsCopier.copyToBuilder(this.orderedResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrderedResources(Collection<OrderedResourceDefinition.BuilderImpl> orderedResources) {
            this.orderedResources = OrderedResourceDefinitionsCopier.copyFromBuilder(orderedResources);
        }

        @Override
        public final Builder orderedResources(Collection<OrderedResourceDefinition> orderedResources) {
            this.orderedResources = OrderedResourceDefinitionsCopier.copy(orderedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderedResources(OrderedResourceDefinition ... orderedResources) {
            this.orderedResources(Arrays.asList(orderedResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderedResources(Consumer<OrderedResourceDefinition.Builder> ... orderedResources) {
            this.orderedResources(Stream.of(orderedResources).map(c -> (OrderedResourceDefinition)((OrderedResourceDefinition.Builder)OrderedResourceDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Address.Builder getShippingAddress() {
            return this.shippingAddress != null ? this.shippingAddress.toBuilder() : null;
        }

        public final void setShippingAddress(Address.BuilderImpl shippingAddress) {
            this.shippingAddress = shippingAddress != null ? shippingAddress.build() : null;
        }

        @Override
        public final Builder shippingAddress(Address shippingAddress) {
            this.shippingAddress = shippingAddress;
            return this;
        }

        public final List<TrackingInformation.Builder> getTrackingInformation() {
            List<TrackingInformation.Builder> result = TrackingInformationListCopier.copyToBuilder(this.trackingInformation);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrackingInformation(Collection<TrackingInformation.BuilderImpl> trackingInformation) {
            this.trackingInformation = TrackingInformationListCopier.copyFromBuilder(trackingInformation);
        }

        @Override
        public final Builder trackingInformation(Collection<TrackingInformation> trackingInformation) {
            this.trackingInformation = TrackingInformationListCopier.copy(trackingInformation);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trackingInformation(TrackingInformation ... trackingInformation) {
            this.trackingInformation(Arrays.asList(trackingInformation));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trackingInformation(Consumer<TrackingInformation.Builder> ... trackingInformation) {
            this.trackingInformation(Stream.of(trackingInformation).map(c -> (TrackingInformation)((TrackingInformation.Builder)TrackingInformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Order build() {
            return new Order(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Order> {
        public Builder acknowledgmentStatus(String var1);

        public Builder acknowledgmentStatus(AcknowledgmentStatus var1);

        public Builder createdAt(Instant var1);

        public Builder networkArn(String var1);

        public Builder networkSiteArn(String var1);

        public Builder orderArn(String var1);

        public Builder orderedResources(Collection<OrderedResourceDefinition> var1);

        public Builder orderedResources(OrderedResourceDefinition ... var1);

        public Builder orderedResources(Consumer<OrderedResourceDefinition.Builder> ... var1);

        public Builder shippingAddress(Address var1);

        default public Builder shippingAddress(Consumer<Address.Builder> shippingAddress) {
            return this.shippingAddress((Address)((Address.Builder)Address.builder().applyMutation(shippingAddress)).build());
        }

        public Builder trackingInformation(Collection<TrackingInformation> var1);

        public Builder trackingInformation(TrackingInformation ... var1);

        public Builder trackingInformation(Consumer<TrackingInformation.Builder> ... var1);
    }
}

