/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.proton.model.TemplateVersionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnvironmentTemplateVersionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnvironmentTemplateVersionSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(EnvironmentTemplateVersionSummary.getter(EnvironmentTemplateVersionSummary::arn)).setter(EnvironmentTemplateVersionSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(EnvironmentTemplateVersionSummary.getter(EnvironmentTemplateVersionSummary::createdAt)).setter(EnvironmentTemplateVersionSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(EnvironmentTemplateVersionSummary.getter(EnvironmentTemplateVersionSummary::description)).setter(EnvironmentTemplateVersionSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedAt").getter(EnvironmentTemplateVersionSummary.getter(EnvironmentTemplateVersionSummary::lastModifiedAt)).setter(EnvironmentTemplateVersionSummary.setter(Builder::lastModifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedAt").build()}).build();
    private static final SdkField<String> MAJOR_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("majorVersion").getter(EnvironmentTemplateVersionSummary.getter(EnvironmentTemplateVersionSummary::majorVersion)).setter(EnvironmentTemplateVersionSummary.setter(Builder::majorVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("majorVersion").build()}).build();
    private static final SdkField<String> MINOR_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("minorVersion").getter(EnvironmentTemplateVersionSummary.getter(EnvironmentTemplateVersionSummary::minorVersion)).setter(EnvironmentTemplateVersionSummary.setter(Builder::minorVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minorVersion").build()}).build();
    private static final SdkField<String> RECOMMENDED_MINOR_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendedMinorVersion").getter(EnvironmentTemplateVersionSummary.getter(EnvironmentTemplateVersionSummary::recommendedMinorVersion)).setter(EnvironmentTemplateVersionSummary.setter(Builder::recommendedMinorVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedMinorVersion").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(EnvironmentTemplateVersionSummary.getter(EnvironmentTemplateVersionSummary::statusAsString)).setter(EnvironmentTemplateVersionSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(EnvironmentTemplateVersionSummary.getter(EnvironmentTemplateVersionSummary::statusMessage)).setter(EnvironmentTemplateVersionSummary.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateName").getter(EnvironmentTemplateVersionSummary.getter(EnvironmentTemplateVersionSummary::templateName)).setter(EnvironmentTemplateVersionSummary.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, LAST_MODIFIED_AT_FIELD, MAJOR_VERSION_FIELD, MINOR_VERSION_FIELD, RECOMMENDED_MINOR_VERSION_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, TEMPLATE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Instant createdAt;
    private final String description;
    private final Instant lastModifiedAt;
    private final String majorVersion;
    private final String minorVersion;
    private final String recommendedMinorVersion;
    private final String status;
    private final String statusMessage;
    private final String templateName;

    private EnvironmentTemplateVersionSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.lastModifiedAt = builder.lastModifiedAt;
        this.majorVersion = builder.majorVersion;
        this.minorVersion = builder.minorVersion;
        this.recommendedMinorVersion = builder.recommendedMinorVersion;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.templateName = builder.templateName;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String description() {
        return this.description;
    }

    public final Instant lastModifiedAt() {
        return this.lastModifiedAt;
    }

    public final String majorVersion() {
        return this.majorVersion;
    }

    public final String minorVersion() {
        return this.minorVersion;
    }

    public final String recommendedMinorVersion() {
        return this.recommendedMinorVersion;
    }

    public final TemplateVersionStatus status() {
        return TemplateVersionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String templateName() {
        return this.templateName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.majorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.minorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendedMinorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentTemplateVersionSummary)) {
            return false;
        }
        EnvironmentTemplateVersionSummary other = (EnvironmentTemplateVersionSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.lastModifiedAt(), other.lastModifiedAt()) && Objects.equals(this.majorVersion(), other.majorVersion()) && Objects.equals(this.minorVersion(), other.minorVersion()) && Objects.equals(this.recommendedMinorVersion(), other.recommendedMinorVersion()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.templateName(), other.templateName());
    }

    public final String toString() {
        return ToString.builder((String)"EnvironmentTemplateVersionSummary").add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("LastModifiedAt", (Object)this.lastModifiedAt()).add("MajorVersion", (Object)this.majorVersion()).add("MinorVersion", (Object)this.minorVersion()).add("RecommendedMinorVersion", (Object)this.recommendedMinorVersion()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)(this.statusMessage() == null ? null : "*** Sensitive Data Redacted ***")).add("TemplateName", (Object)this.templateName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "lastModifiedAt": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedAt()));
            }
            case "majorVersion": {
                return Optional.ofNullable(clazz.cast(this.majorVersion()));
            }
            case "minorVersion": {
                return Optional.ofNullable(clazz.cast(this.minorVersion()));
            }
            case "recommendedMinorVersion": {
                return Optional.ofNullable(clazz.cast(this.recommendedMinorVersion()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "templateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentTemplateVersionSummary, T> g) {
        return obj -> g.apply((EnvironmentTemplateVersionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Instant createdAt;
        private String description;
        private Instant lastModifiedAt;
        private String majorVersion;
        private String minorVersion;
        private String recommendedMinorVersion;
        private String status;
        private String statusMessage;
        private String templateName;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentTemplateVersionSummary model) {
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.lastModifiedAt(model.lastModifiedAt);
            this.majorVersion(model.majorVersion);
            this.minorVersion(model.minorVersion);
            this.recommendedMinorVersion(model.recommendedMinorVersion);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.templateName(model.templateName);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getLastModifiedAt() {
            return this.lastModifiedAt;
        }

        @Override
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        public final String getMajorVersion() {
            return this.majorVersion;
        }

        @Override
        public final Builder majorVersion(String majorVersion) {
            this.majorVersion = majorVersion;
            return this;
        }

        public final void setMajorVersion(String majorVersion) {
            this.majorVersion = majorVersion;
        }

        public final String getMinorVersion() {
            return this.minorVersion;
        }

        @Override
        public final Builder minorVersion(String minorVersion) {
            this.minorVersion = minorVersion;
            return this;
        }

        public final void setMinorVersion(String minorVersion) {
            this.minorVersion = minorVersion;
        }

        public final String getRecommendedMinorVersion() {
            return this.recommendedMinorVersion;
        }

        @Override
        public final Builder recommendedMinorVersion(String recommendedMinorVersion) {
            this.recommendedMinorVersion = recommendedMinorVersion;
            return this;
        }

        public final void setRecommendedMinorVersion(String recommendedMinorVersion) {
            this.recommendedMinorVersion = recommendedMinorVersion;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TemplateVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public EnvironmentTemplateVersionSummary build() {
            return new EnvironmentTemplateVersionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnvironmentTemplateVersionSummary> {
        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder description(String var1);

        public Builder lastModifiedAt(Instant var1);

        public Builder majorVersion(String var1);

        public Builder minorVersion(String var1);

        public Builder recommendedMinorVersion(String var1);

        public Builder status(String var1);

        public Builder status(TemplateVersionStatus var1);

        public Builder statusMessage(String var1);

        public Builder templateName(String var1);
    }
}

