/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Proton pipeline service role and repository data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountSettings implements SdkPojo, Serializable, ToCopyableBuilder<AccountSettings.Builder, AccountSettings> {
    private static final SdkField<RepositoryBranch> PIPELINE_PROVISIONING_REPOSITORY_FIELD = SdkField
            .<RepositoryBranch> builder(MarshallingType.SDK_POJO)
            .memberName("pipelineProvisioningRepository")
            .getter(getter(AccountSettings::pipelineProvisioningRepository))
            .setter(setter(Builder::pipelineProvisioningRepository))
            .constructor(RepositoryBranch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineProvisioningRepository")
                    .build()).build();

    private static final SdkField<String> PIPELINE_SERVICE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pipelineServiceRoleArn").getter(getter(AccountSettings::pipelineServiceRoleArn))
            .setter(setter(Builder::pipelineServiceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineServiceRoleArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PIPELINE_PROVISIONING_REPOSITORY_FIELD, PIPELINE_SERVICE_ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final RepositoryBranch pipelineProvisioningRepository;

    private final String pipelineServiceRoleArn;

    private AccountSettings(BuilderImpl builder) {
        this.pipelineProvisioningRepository = builder.pipelineProvisioningRepository;
        this.pipelineServiceRoleArn = builder.pipelineServiceRoleArn;
    }

    /**
     * <p>
     * The repository that you provide with pull request provisioning.
     * </p>
     * <important>
     * <p>
     * Provisioning by pull request is currently in feature preview and is only usable with Terraform based Proton
     * Templates. To learn more about <a href="https://aws.amazon.com/service-terms">Amazon Web Services Feature Preview
     * terms</a>, see section 2 on Beta and Previews.
     * </p>
     * </important>
     * 
     * @return The repository that you provide with pull request provisioning.</p> <important>
     *         <p>
     *         Provisioning by pull request is currently in feature preview and is only usable with Terraform based
     *         Proton Templates. To learn more about <a href="https://aws.amazon.com/service-terms">Amazon Web Services
     *         Feature Preview terms</a>, see section 2 on Beta and Previews.
     *         </p>
     */
    public final RepositoryBranch pipelineProvisioningRepository() {
        return pipelineProvisioningRepository;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Proton pipeline service role.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Proton pipeline service role.
     */
    public final String pipelineServiceRoleArn() {
        return pipelineServiceRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pipelineProvisioningRepository());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineServiceRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountSettings)) {
            return false;
        }
        AccountSettings other = (AccountSettings) obj;
        return Objects.equals(pipelineProvisioningRepository(), other.pipelineProvisioningRepository())
                && Objects.equals(pipelineServiceRoleArn(), other.pipelineServiceRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountSettings").add("PipelineProvisioningRepository", pipelineProvisioningRepository())
                .add("PipelineServiceRoleArn", pipelineServiceRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipelineProvisioningRepository":
            return Optional.ofNullable(clazz.cast(pipelineProvisioningRepository()));
        case "pipelineServiceRoleArn":
            return Optional.ofNullable(clazz.cast(pipelineServiceRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountSettings, T> g) {
        return obj -> g.apply((AccountSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountSettings> {
        /**
         * <p>
         * The repository that you provide with pull request provisioning.
         * </p>
         * <important>
         * <p>
         * Provisioning by pull request is currently in feature preview and is only usable with Terraform based Proton
         * Templates. To learn more about <a href="https://aws.amazon.com/service-terms">Amazon Web Services Feature
         * Preview terms</a>, see section 2 on Beta and Previews.
         * </p>
         * </important>
         * 
         * @param pipelineProvisioningRepository
         *        The repository that you provide with pull request provisioning.</p> <important>
         *        <p>
         *        Provisioning by pull request is currently in feature preview and is only usable with Terraform based
         *        Proton Templates. To learn more about <a href="https://aws.amazon.com/service-terms">Amazon Web
         *        Services Feature Preview terms</a>, see section 2 on Beta and Previews.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineProvisioningRepository(RepositoryBranch pipelineProvisioningRepository);

        /**
         * <p>
         * The repository that you provide with pull request provisioning.
         * </p>
         * <important>
         * <p>
         * Provisioning by pull request is currently in feature preview and is only usable with Terraform based Proton
         * Templates. To learn more about <a href="https://aws.amazon.com/service-terms">Amazon Web Services Feature
         * Preview terms</a>, see section 2 on Beta and Previews.
         * </p>
         * </important> This is a convenience that creates an instance of the {@link RepositoryBranch.Builder} avoiding
         * the need to create one manually via {@link RepositoryBranch#builder()}.
         *
         * When the {@link Consumer} completes, {@link RepositoryBranch.Builder#build()} is called immediately and its
         * result is passed to {@link #pipelineProvisioningRepository(RepositoryBranch)}.
         * 
         * @param pipelineProvisioningRepository
         *        a consumer that will call methods on {@link RepositoryBranch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipelineProvisioningRepository(RepositoryBranch)
         */
        default Builder pipelineProvisioningRepository(Consumer<RepositoryBranch.Builder> pipelineProvisioningRepository) {
            return pipelineProvisioningRepository(RepositoryBranch.builder().applyMutation(pipelineProvisioningRepository)
                    .build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Proton pipeline service role.
         * </p>
         * 
         * @param pipelineServiceRoleArn
         *        The Amazon Resource Name (ARN) of the Proton pipeline service role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineServiceRoleArn(String pipelineServiceRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private RepositoryBranch pipelineProvisioningRepository;

        private String pipelineServiceRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountSettings model) {
            pipelineProvisioningRepository(model.pipelineProvisioningRepository);
            pipelineServiceRoleArn(model.pipelineServiceRoleArn);
        }

        public final RepositoryBranch.Builder getPipelineProvisioningRepository() {
            return pipelineProvisioningRepository != null ? pipelineProvisioningRepository.toBuilder() : null;
        }

        public final void setPipelineProvisioningRepository(RepositoryBranch.BuilderImpl pipelineProvisioningRepository) {
            this.pipelineProvisioningRepository = pipelineProvisioningRepository != null ? pipelineProvisioningRepository.build()
                    : null;
        }

        @Override
        @Transient
        public final Builder pipelineProvisioningRepository(RepositoryBranch pipelineProvisioningRepository) {
            this.pipelineProvisioningRepository = pipelineProvisioningRepository;
            return this;
        }

        public final String getPipelineServiceRoleArn() {
            return pipelineServiceRoleArn;
        }

        public final void setPipelineServiceRoleArn(String pipelineServiceRoleArn) {
            this.pipelineServiceRoleArn = pipelineServiceRoleArn;
        }

        @Override
        @Transient
        public final Builder pipelineServiceRoleArn(String pipelineServiceRoleArn) {
            this.pipelineServiceRoleArn = pipelineServiceRoleArn;
            return this;
        }

        @Override
        public AccountSettings build() {
            return new AccountSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
