/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRepositoryRequest extends ProtonRequest implements
        ToCopyableBuilder<CreateRepositoryRequest.Builder, CreateRepositoryRequest> {
    private static final SdkField<String> CONNECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectionArn").getter(getter(CreateRepositoryRequest::connectionArn))
            .setter(setter(Builder::connectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionArn").build()).build();

    private static final SdkField<String> ENCRYPTION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("encryptionKey").getter(getter(CreateRepositoryRequest::encryptionKey))
            .setter(setter(Builder::encryptionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKey").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateRepositoryRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("provider").getter(getter(CreateRepositoryRequest::providerAsString)).setter(setter(Builder::provider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provider").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ARN_FIELD,
            ENCRYPTION_KEY_FIELD, NAME_FIELD, PROVIDER_FIELD));

    private final String connectionArn;

    private final String encryptionKey;

    private final String name;

    private final String provider;

    private CreateRepositoryRequest(BuilderImpl builder) {
        super(builder);
        this.connectionArn = builder.connectionArn;
        this.encryptionKey = builder.encryptionKey;
        this.name = builder.name;
        this.provider = builder.provider;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of your Amazon Web Services CodeStar connection. For more information, see <a
     * href="https://docs.aws.amazon.com/setting-up-for-service">Setting up for Proton</a> in the <i>Proton
     * Administrator Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of your Amazon Web Services CodeStar connection. For more information, see
     *         <a href="https://docs.aws.amazon.com/setting-up-for-service">Setting up for Proton</a> in the <i>Proton
     *         Administrator Guide</i>.
     */
    public final String connectionArn() {
        return connectionArn;
    }

    /**
     * <p>
     * The ARN of your customer Amazon Web Services Key Management Service (Amazon Web Services KMS) key.
     * </p>
     * 
     * @return The ARN of your customer Amazon Web Services Key Management Service (Amazon Web Services KMS) key.
     */
    public final String encryptionKey() {
        return encryptionKey;
    }

    /**
     * <p>
     * The repository name, for example <code>myrepos/myrepo</code>.
     * </p>
     * 
     * @return The repository name, for example <code>myrepos/myrepo</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The repository provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provider} will
     * return {@link RepositoryProvider#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #providerAsString}.
     * </p>
     * 
     * @return The repository provider.
     * @see RepositoryProvider
     */
    public final RepositoryProvider provider() {
        return RepositoryProvider.fromValue(provider);
    }

    /**
     * <p>
     * The repository provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provider} will
     * return {@link RepositoryProvider#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #providerAsString}.
     * </p>
     * 
     * @return The repository provider.
     * @see RepositoryProvider
     */
    public final String providerAsString() {
        return provider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(providerAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRepositoryRequest)) {
            return false;
        }
        CreateRepositoryRequest other = (CreateRepositoryRequest) obj;
        return Objects.equals(connectionArn(), other.connectionArn()) && Objects.equals(encryptionKey(), other.encryptionKey())
                && Objects.equals(name(), other.name()) && Objects.equals(providerAsString(), other.providerAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRepositoryRequest").add("ConnectionArn", connectionArn())
                .add("EncryptionKey", encryptionKey()).add("Name", name()).add("Provider", providerAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectionArn":
            return Optional.ofNullable(clazz.cast(connectionArn()));
        case "encryptionKey":
            return Optional.ofNullable(clazz.cast(encryptionKey()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "provider":
            return Optional.ofNullable(clazz.cast(providerAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRepositoryRequest, T> g) {
        return obj -> g.apply((CreateRepositoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateRepositoryRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of your Amazon Web Services CodeStar connection. For more information, see <a
         * href="https://docs.aws.amazon.com/setting-up-for-service">Setting up for Proton</a> in the <i>Proton
         * Administrator Guide</i>.
         * </p>
         * 
         * @param connectionArn
         *        The Amazon Resource Name (ARN) of your Amazon Web Services CodeStar connection. For more information,
         *        see <a href="https://docs.aws.amazon.com/setting-up-for-service">Setting up for Proton</a> in the
         *        <i>Proton Administrator Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionArn(String connectionArn);

        /**
         * <p>
         * The ARN of your customer Amazon Web Services Key Management Service (Amazon Web Services KMS) key.
         * </p>
         * 
         * @param encryptionKey
         *        The ARN of your customer Amazon Web Services Key Management Service (Amazon Web Services KMS) key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKey(String encryptionKey);

        /**
         * <p>
         * The repository name, for example <code>myrepos/myrepo</code>.
         * </p>
         * 
         * @param name
         *        The repository name, for example <code>myrepos/myrepo</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The repository provider.
         * </p>
         * 
         * @param provider
         *        The repository provider.
         * @see RepositoryProvider
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RepositoryProvider
         */
        Builder provider(String provider);

        /**
         * <p>
         * The repository provider.
         * </p>
         * 
         * @param provider
         *        The repository provider.
         * @see RepositoryProvider
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RepositoryProvider
         */
        Builder provider(RepositoryProvider provider);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ProtonRequest.BuilderImpl implements Builder {
        private String connectionArn;

        private String encryptionKey;

        private String name;

        private String provider;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRepositoryRequest model) {
            super(model);
            connectionArn(model.connectionArn);
            encryptionKey(model.encryptionKey);
            name(model.name);
            provider(model.provider);
        }

        public final String getConnectionArn() {
            return connectionArn;
        }

        public final void setConnectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
        }

        @Override
        @Transient
        public final Builder connectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        public final String getEncryptionKey() {
            return encryptionKey;
        }

        public final void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        @Override
        @Transient
        public final Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProvider() {
            return provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        @Transient
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        @Override
        @Transient
        public final Builder provider(RepositoryProvider provider) {
            this.provider(provider == null ? null : provider.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRepositoryRequest build() {
            return new CreateRepositoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
