/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteRepositoryResponse extends ProtonResponse implements
        ToCopyableBuilder<DeleteRepositoryResponse.Builder, DeleteRepositoryResponse> {
    private static final SdkField<Repository> REPOSITORY_FIELD = SdkField.<Repository> builder(MarshallingType.SDK_POJO)
            .memberName("repository").getter(getter(DeleteRepositoryResponse::repository)).setter(setter(Builder::repository))
            .constructor(Repository::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repository").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_FIELD));

    private final Repository repository;

    private DeleteRepositoryResponse(BuilderImpl builder) {
        super(builder);
        this.repository = builder.repository;
    }

    /**
     * <p>
     * The repository detail data that's returned by Proton.
     * </p>
     * 
     * @return The repository detail data that's returned by Proton.
     */
    public final Repository repository() {
        return repository;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(repository());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRepositoryResponse)) {
            return false;
        }
        DeleteRepositoryResponse other = (DeleteRepositoryResponse) obj;
        return Objects.equals(repository(), other.repository());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteRepositoryResponse").add("Repository", repository()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repository":
            return Optional.ofNullable(clazz.cast(repository()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteRepositoryResponse, T> g) {
        return obj -> g.apply((DeleteRepositoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteRepositoryResponse> {
        /**
         * <p>
         * The repository detail data that's returned by Proton.
         * </p>
         * 
         * @param repository
         *        The repository detail data that's returned by Proton.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repository(Repository repository);

        /**
         * <p>
         * The repository detail data that's returned by Proton.
         * </p>
         * This is a convenience that creates an instance of the {@link Repository.Builder} avoiding the need to create
         * one manually via {@link Repository#builder()}.
         *
         * When the {@link Consumer} completes, {@link Repository.Builder#build()} is called immediately and its result
         * is passed to {@link #repository(Repository)}.
         * 
         * @param repository
         *        a consumer that will call methods on {@link Repository.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #repository(Repository)
         */
        default Builder repository(Consumer<Repository.Builder> repository) {
            return repository(Repository.builder().applyMutation(repository).build());
        }
    }

    static final class BuilderImpl extends ProtonResponse.BuilderImpl implements Builder {
        private Repository repository;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRepositoryResponse model) {
            super(model);
            repository(model.repository);
        }

        public final Repository.Builder getRepository() {
            return repository != null ? repository.toBuilder() : null;
        }

        public final void setRepository(Repository.BuilderImpl repository) {
            this.repository = repository != null ? repository.build() : null;
        }

        @Override
        @Transient
        public final Builder repository(Repository repository) {
            this.repository = repository;
            return this;
        }

        @Override
        public DeleteRepositoryResponse build() {
            return new DeleteRepositoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
