/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEnvironmentTemplateResponse extends ProtonResponse implements
        ToCopyableBuilder<GetEnvironmentTemplateResponse.Builder, GetEnvironmentTemplateResponse> {
    private static final SdkField<EnvironmentTemplate> ENVIRONMENT_TEMPLATE_FIELD = SdkField
            .<EnvironmentTemplate> builder(MarshallingType.SDK_POJO).memberName("environmentTemplate")
            .getter(getter(GetEnvironmentTemplateResponse::environmentTemplate)).setter(setter(Builder::environmentTemplate))
            .constructor(EnvironmentTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentTemplate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_TEMPLATE_FIELD));

    private final EnvironmentTemplate environmentTemplate;

    private GetEnvironmentTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.environmentTemplate = builder.environmentTemplate;
    }

    /**
     * <p>
     * The environment template detail data that's returned by Proton.
     * </p>
     * 
     * @return The environment template detail data that's returned by Proton.
     */
    public final EnvironmentTemplate environmentTemplate() {
        return environmentTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(environmentTemplate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEnvironmentTemplateResponse)) {
            return false;
        }
        GetEnvironmentTemplateResponse other = (GetEnvironmentTemplateResponse) obj;
        return Objects.equals(environmentTemplate(), other.environmentTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEnvironmentTemplateResponse").add("EnvironmentTemplate", environmentTemplate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "environmentTemplate":
            return Optional.ofNullable(clazz.cast(environmentTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEnvironmentTemplateResponse, T> g) {
        return obj -> g.apply((GetEnvironmentTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetEnvironmentTemplateResponse> {
        /**
         * <p>
         * The environment template detail data that's returned by Proton.
         * </p>
         * 
         * @param environmentTemplate
         *        The environment template detail data that's returned by Proton.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentTemplate(EnvironmentTemplate environmentTemplate);

        /**
         * <p>
         * The environment template detail data that's returned by Proton.
         * </p>
         * This is a convenience that creates an instance of the {@link EnvironmentTemplate.Builder} avoiding the need
         * to create one manually via {@link EnvironmentTemplate#builder()}.
         *
         * When the {@link Consumer} completes, {@link EnvironmentTemplate.Builder#build()} is called immediately and
         * its result is passed to {@link #environmentTemplate(EnvironmentTemplate)}.
         * 
         * @param environmentTemplate
         *        a consumer that will call methods on {@link EnvironmentTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentTemplate(EnvironmentTemplate)
         */
        default Builder environmentTemplate(Consumer<EnvironmentTemplate.Builder> environmentTemplate) {
            return environmentTemplate(EnvironmentTemplate.builder().applyMutation(environmentTemplate).build());
        }
    }

    static final class BuilderImpl extends ProtonResponse.BuilderImpl implements Builder {
        private EnvironmentTemplate environmentTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEnvironmentTemplateResponse model) {
            super(model);
            environmentTemplate(model.environmentTemplate);
        }

        public final EnvironmentTemplate.Builder getEnvironmentTemplate() {
            return environmentTemplate != null ? environmentTemplate.toBuilder() : null;
        }

        public final void setEnvironmentTemplate(EnvironmentTemplate.BuilderImpl environmentTemplate) {
            this.environmentTemplate = environmentTemplate != null ? environmentTemplate.build() : null;
        }

        @Override
        @Transient
        public final Builder environmentTemplate(EnvironmentTemplate environmentTemplate) {
            this.environmentTemplate = environmentTemplate;
            return this;
        }

        @Override
        public GetEnvironmentTemplateResponse build() {
            return new GetEnvironmentTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
