/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEnvironmentsRequest extends ProtonRequest implements
        ToCopyableBuilder<ListEnvironmentsRequest.Builder, ListEnvironmentsRequest> {
    private static final SdkField<List<EnvironmentTemplateFilter>> ENVIRONMENT_TEMPLATES_FIELD = SdkField
            .<List<EnvironmentTemplateFilter>> builder(MarshallingType.LIST)
            .memberName("environmentTemplates")
            .getter(getter(ListEnvironmentsRequest::environmentTemplates))
            .setter(setter(Builder::environmentTemplates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentTemplates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnvironmentTemplateFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnvironmentTemplateFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListEnvironmentsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListEnvironmentsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_TEMPLATES_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<EnvironmentTemplateFilter> environmentTemplates;

    private final Integer maxResults;

    private final String nextToken;

    private ListEnvironmentsRequest(BuilderImpl builder) {
        super(builder);
        this.environmentTemplates = builder.environmentTemplates;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnvironmentTemplates property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnvironmentTemplates() {
        return environmentTemplates != null && !(environmentTemplates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of the versions of the environment template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironmentTemplates} method.
     * </p>
     * 
     * @return An array of the versions of the environment template.
     */
    public final List<EnvironmentTemplateFilter> environmentTemplates() {
        return environmentTemplates;
    }

    /**
     * <p>
     * The maximum number of environments to list.
     * </p>
     * 
     * @return The maximum number of environments to list.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token to indicate the location of the next environment in the array of environments, after the list of
     * environments that was previously requested.
     * </p>
     * 
     * @return A token to indicate the location of the next environment in the array of environments, after the list of
     *         environments that was previously requested.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironmentTemplates() ? environmentTemplates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnvironmentsRequest)) {
            return false;
        }
        ListEnvironmentsRequest other = (ListEnvironmentsRequest) obj;
        return hasEnvironmentTemplates() == other.hasEnvironmentTemplates()
                && Objects.equals(environmentTemplates(), other.environmentTemplates())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEnvironmentsRequest")
                .add("EnvironmentTemplates", hasEnvironmentTemplates() ? environmentTemplates() : null)
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "environmentTemplates":
            return Optional.ofNullable(clazz.cast(environmentTemplates()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEnvironmentsRequest, T> g) {
        return obj -> g.apply((ListEnvironmentsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListEnvironmentsRequest> {
        /**
         * <p>
         * An array of the versions of the environment template.
         * </p>
         * 
         * @param environmentTemplates
         *        An array of the versions of the environment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentTemplates(Collection<EnvironmentTemplateFilter> environmentTemplates);

        /**
         * <p>
         * An array of the versions of the environment template.
         * </p>
         * 
         * @param environmentTemplates
         *        An array of the versions of the environment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentTemplates(EnvironmentTemplateFilter... environmentTemplates);

        /**
         * <p>
         * An array of the versions of the environment template.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EnvironmentTemplateFilter>.Builder}
         * avoiding the need to create one manually via {@link List<EnvironmentTemplateFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EnvironmentTemplateFilter>.Builder#build()} is called
         * immediately and its result is passed to {@link #environmentTemplates(List<EnvironmentTemplateFilter>)}.
         * 
         * @param environmentTemplates
         *        a consumer that will call methods on {@link List<EnvironmentTemplateFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentTemplates(List<EnvironmentTemplateFilter>)
         */
        Builder environmentTemplates(Consumer<EnvironmentTemplateFilter.Builder>... environmentTemplates);

        /**
         * <p>
         * The maximum number of environments to list.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of environments to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A token to indicate the location of the next environment in the array of environments, after the list of
         * environments that was previously requested.
         * </p>
         * 
         * @param nextToken
         *        A token to indicate the location of the next environment in the array of environments, after the list
         *        of environments that was previously requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ProtonRequest.BuilderImpl implements Builder {
        private List<EnvironmentTemplateFilter> environmentTemplates = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnvironmentsRequest model) {
            super(model);
            environmentTemplates(model.environmentTemplates);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final List<EnvironmentTemplateFilter.Builder> getEnvironmentTemplates() {
            List<EnvironmentTemplateFilter.Builder> result = EnvironmentTemplateFilterListCopier
                    .copyToBuilder(this.environmentTemplates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentTemplates(Collection<EnvironmentTemplateFilter.BuilderImpl> environmentTemplates) {
            this.environmentTemplates = EnvironmentTemplateFilterListCopier.copyFromBuilder(environmentTemplates);
        }

        @Override
        @Transient
        public final Builder environmentTemplates(Collection<EnvironmentTemplateFilter> environmentTemplates) {
            this.environmentTemplates = EnvironmentTemplateFilterListCopier.copy(environmentTemplates);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder environmentTemplates(EnvironmentTemplateFilter... environmentTemplates) {
            environmentTemplates(Arrays.asList(environmentTemplates));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder environmentTemplates(Consumer<EnvironmentTemplateFilter.Builder>... environmentTemplates) {
            environmentTemplates(Stream.of(environmentTemplates)
                    .map(c -> EnvironmentTemplateFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEnvironmentsRequest build() {
            return new ListEnvironmentsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
