/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRepositorySyncDefinitionsResponse extends ProtonResponse implements
        ToCopyableBuilder<ListRepositorySyncDefinitionsResponse.Builder, ListRepositorySyncDefinitionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListRepositorySyncDefinitionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<RepositorySyncDefinition>> SYNC_DEFINITIONS_FIELD = SdkField
            .<List<RepositorySyncDefinition>> builder(MarshallingType.LIST)
            .memberName("syncDefinitions")
            .getter(getter(ListRepositorySyncDefinitionsResponse::syncDefinitions))
            .setter(setter(Builder::syncDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RepositorySyncDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(RepositorySyncDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SYNC_DEFINITIONS_FIELD));

    private final String nextToken;

    private final List<RepositorySyncDefinition> syncDefinitions;

    private ListRepositorySyncDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.syncDefinitions = builder.syncDefinitions;
    }

    /**
     * <p>
     * A token to indicate the location of the next repository sync definition in the array of repository sync
     * definitions, after the current requested list of repository sync definitions.
     * </p>
     * 
     * @return A token to indicate the location of the next repository sync definition in the array of repository sync
     *         definitions, after the current requested list of repository sync definitions.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SyncDefinitions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSyncDefinitions() {
        return syncDefinitions != null && !(syncDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of repository sync definitions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSyncDefinitions} method.
     * </p>
     * 
     * @return An array of repository sync definitions.
     */
    public final List<RepositorySyncDefinition> syncDefinitions() {
        return syncDefinitions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasSyncDefinitions() ? syncDefinitions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRepositorySyncDefinitionsResponse)) {
            return false;
        }
        ListRepositorySyncDefinitionsResponse other = (ListRepositorySyncDefinitionsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasSyncDefinitions() == other.hasSyncDefinitions()
                && Objects.equals(syncDefinitions(), other.syncDefinitions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRepositorySyncDefinitionsResponse").add("NextToken", nextToken())
                .add("SyncDefinitions", hasSyncDefinitions() ? syncDefinitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "syncDefinitions":
            return Optional.ofNullable(clazz.cast(syncDefinitions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRepositorySyncDefinitionsResponse, T> g) {
        return obj -> g.apply((ListRepositorySyncDefinitionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListRepositorySyncDefinitionsResponse> {
        /**
         * <p>
         * A token to indicate the location of the next repository sync definition in the array of repository sync
         * definitions, after the current requested list of repository sync definitions.
         * </p>
         * 
         * @param nextToken
         *        A token to indicate the location of the next repository sync definition in the array of repository
         *        sync definitions, after the current requested list of repository sync definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of repository sync definitions.
         * </p>
         * 
         * @param syncDefinitions
         *        An array of repository sync definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncDefinitions(Collection<RepositorySyncDefinition> syncDefinitions);

        /**
         * <p>
         * An array of repository sync definitions.
         * </p>
         * 
         * @param syncDefinitions
         *        An array of repository sync definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncDefinitions(RepositorySyncDefinition... syncDefinitions);

        /**
         * <p>
         * An array of repository sync definitions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RepositorySyncDefinition>.Builder} avoiding
         * the need to create one manually via {@link List<RepositorySyncDefinition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RepositorySyncDefinition>.Builder#build()} is called
         * immediately and its result is passed to {@link #syncDefinitions(List<RepositorySyncDefinition>)}.
         * 
         * @param syncDefinitions
         *        a consumer that will call methods on {@link List<RepositorySyncDefinition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #syncDefinitions(List<RepositorySyncDefinition>)
         */
        Builder syncDefinitions(Consumer<RepositorySyncDefinition.Builder>... syncDefinitions);
    }

    static final class BuilderImpl extends ProtonResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<RepositorySyncDefinition> syncDefinitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRepositorySyncDefinitionsResponse model) {
            super(model);
            nextToken(model.nextToken);
            syncDefinitions(model.syncDefinitions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RepositorySyncDefinition.Builder> getSyncDefinitions() {
            List<RepositorySyncDefinition.Builder> result = RepositorySyncDefinitionListCopier
                    .copyToBuilder(this.syncDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSyncDefinitions(Collection<RepositorySyncDefinition.BuilderImpl> syncDefinitions) {
            this.syncDefinitions = RepositorySyncDefinitionListCopier.copyFromBuilder(syncDefinitions);
        }

        @Override
        @Transient
        public final Builder syncDefinitions(Collection<RepositorySyncDefinition> syncDefinitions) {
            this.syncDefinitions = RepositorySyncDefinitionListCopier.copy(syncDefinitions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder syncDefinitions(RepositorySyncDefinition... syncDefinitions) {
            syncDefinitions(Arrays.asList(syncDefinitions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder syncDefinitions(Consumer<RepositorySyncDefinition.Builder>... syncDefinitions) {
            syncDefinitions(Stream.of(syncDefinitions).map(c -> RepositorySyncDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListRepositorySyncDefinitionsResponse build() {
            return new ListRepositorySyncDefinitionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
