/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServiceInstanceProvisionedResourcesRequest extends ProtonRequest implements
        ToCopyableBuilder<ListServiceInstanceProvisionedResourcesRequest.Builder, ListServiceInstanceProvisionedResourcesRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListServiceInstanceProvisionedResourcesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> SERVICE_INSTANCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceInstanceName")
            .getter(getter(ListServiceInstanceProvisionedResourcesRequest::serviceInstanceName))
            .setter(setter(Builder::serviceInstanceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceInstanceName").build())
            .build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceName").getter(getter(ListServiceInstanceProvisionedResourcesRequest::serviceName))
            .setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SERVICE_INSTANCE_NAME_FIELD, SERVICE_NAME_FIELD));

    private final String nextToken;

    private final String serviceInstanceName;

    private final String serviceName;

    private ListServiceInstanceProvisionedResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.serviceInstanceName = builder.serviceInstanceName;
        this.serviceName = builder.serviceName;
    }

    /**
     * <p>
     * A token to indicate the location of the next provisioned resource in the array of provisioned resources, after
     * the list of provisioned resources that was previously requested.
     * </p>
     * 
     * @return A token to indicate the location of the next provisioned resource in the array of provisioned resources,
     *         after the list of provisioned resources that was previously requested.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The service instance name.
     * </p>
     * 
     * @return The service instance name.
     */
    public final String serviceInstanceName() {
        return serviceInstanceName;
    }

    /**
     * <p>
     * The service name.
     * </p>
     * 
     * @return The service name.
     */
    public final String serviceName() {
        return serviceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(serviceInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceInstanceProvisionedResourcesRequest)) {
            return false;
        }
        ListServiceInstanceProvisionedResourcesRequest other = (ListServiceInstanceProvisionedResourcesRequest) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(serviceInstanceName(), other.serviceInstanceName())
                && Objects.equals(serviceName(), other.serviceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListServiceInstanceProvisionedResourcesRequest").add("NextToken", nextToken())
                .add("ServiceInstanceName", serviceInstanceName()).add("ServiceName", serviceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "serviceInstanceName":
            return Optional.ofNullable(clazz.cast(serviceInstanceName()));
        case "serviceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListServiceInstanceProvisionedResourcesRequest, T> g) {
        return obj -> g.apply((ListServiceInstanceProvisionedResourcesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListServiceInstanceProvisionedResourcesRequest> {
        /**
         * <p>
         * A token to indicate the location of the next provisioned resource in the array of provisioned resources,
         * after the list of provisioned resources that was previously requested.
         * </p>
         * 
         * @param nextToken
         *        A token to indicate the location of the next provisioned resource in the array of provisioned
         *        resources, after the list of provisioned resources that was previously requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The service instance name.
         * </p>
         * 
         * @param serviceInstanceName
         *        The service instance name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceInstanceName(String serviceInstanceName);

        /**
         * <p>
         * The service name.
         * </p>
         * 
         * @param serviceName
         *        The service name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ProtonRequest.BuilderImpl implements Builder {
        private String nextToken;

        private String serviceInstanceName;

        private String serviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceInstanceProvisionedResourcesRequest model) {
            super(model);
            nextToken(model.nextToken);
            serviceInstanceName(model.serviceInstanceName);
            serviceName(model.serviceName);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getServiceInstanceName() {
            return serviceInstanceName;
        }

        public final void setServiceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = serviceInstanceName;
        }

        @Override
        @Transient
        public final Builder serviceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = serviceInstanceName;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        @Transient
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListServiceInstanceProvisionedResourcesRequest build() {
            return new ListServiceInstanceProvisionedResourcesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
