/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detail data for a repository sync attempt activated by a push to a repository.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RepositorySyncAttempt implements SdkPojo, Serializable,
        ToCopyableBuilder<RepositorySyncAttempt.Builder, RepositorySyncAttempt> {
    private static final SdkField<List<RepositorySyncEvent>> EVENTS_FIELD = SdkField
            .<List<RepositorySyncEvent>> builder(MarshallingType.LIST)
            .memberName("events")
            .getter(getter(RepositorySyncAttempt::events))
            .setter(setter(Builder::events))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("events").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RepositorySyncEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(RepositorySyncEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedAt").getter(getter(RepositorySyncAttempt::startedAt)).setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(RepositorySyncAttempt::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENTS_FIELD,
            STARTED_AT_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<RepositorySyncEvent> events;

    private final Instant startedAt;

    private final String status;

    private RepositorySyncAttempt(BuilderImpl builder) {
        this.events = builder.events;
        this.startedAt = builder.startedAt;
        this.status = builder.status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Events property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEvents() {
        return events != null && !(events instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Detail data for sync attempt events.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvents} method.
     * </p>
     * 
     * @return Detail data for sync attempt events.
     */
    public final List<RepositorySyncEvent> events() {
        return events;
    }

    /**
     * <p>
     * The time when the sync attempt started.
     * </p>
     * 
     * @return The time when the sync attempt started.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The sync attempt status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RepositorySyncStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The sync attempt status.
     * @see RepositorySyncStatus
     */
    public final RepositorySyncStatus status() {
        return RepositorySyncStatus.fromValue(status);
    }

    /**
     * <p>
     * The sync attempt status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RepositorySyncStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The sync attempt status.
     * @see RepositorySyncStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEvents() ? events() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositorySyncAttempt)) {
            return false;
        }
        RepositorySyncAttempt other = (RepositorySyncAttempt) obj;
        return hasEvents() == other.hasEvents() && Objects.equals(events(), other.events())
                && Objects.equals(startedAt(), other.startedAt()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RepositorySyncAttempt").add("Events", hasEvents() ? events() : null)
                .add("StartedAt", startedAt()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "events":
            return Optional.ofNullable(clazz.cast(events()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RepositorySyncAttempt, T> g) {
        return obj -> g.apply((RepositorySyncAttempt) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RepositorySyncAttempt> {
        /**
         * <p>
         * Detail data for sync attempt events.
         * </p>
         * 
         * @param events
         *        Detail data for sync attempt events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<RepositorySyncEvent> events);

        /**
         * <p>
         * Detail data for sync attempt events.
         * </p>
         * 
         * @param events
         *        Detail data for sync attempt events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(RepositorySyncEvent... events);

        /**
         * <p>
         * Detail data for sync attempt events.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RepositorySyncEvent>.Builder} avoiding the
         * need to create one manually via {@link List<RepositorySyncEvent>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RepositorySyncEvent>.Builder#build()} is called immediately
         * and its result is passed to {@link #events(List<RepositorySyncEvent>)}.
         * 
         * @param events
         *        a consumer that will call methods on {@link List<RepositorySyncEvent>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #events(List<RepositorySyncEvent>)
         */
        Builder events(Consumer<RepositorySyncEvent.Builder>... events);

        /**
         * <p>
         * The time when the sync attempt started.
         * </p>
         * 
         * @param startedAt
         *        The time when the sync attempt started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The sync attempt status.
         * </p>
         * 
         * @param status
         *        The sync attempt status.
         * @see RepositorySyncStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RepositorySyncStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The sync attempt status.
         * </p>
         * 
         * @param status
         *        The sync attempt status.
         * @see RepositorySyncStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RepositorySyncStatus
         */
        Builder status(RepositorySyncStatus status);
    }

    static final class BuilderImpl implements Builder {
        private List<RepositorySyncEvent> events = DefaultSdkAutoConstructList.getInstance();

        private Instant startedAt;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(RepositorySyncAttempt model) {
            events(model.events);
            startedAt(model.startedAt);
            status(model.status);
        }

        public final List<RepositorySyncEvent.Builder> getEvents() {
            List<RepositorySyncEvent.Builder> result = RepositorySyncEventsCopier.copyToBuilder(this.events);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvents(Collection<RepositorySyncEvent.BuilderImpl> events) {
            this.events = RepositorySyncEventsCopier.copyFromBuilder(events);
        }

        @Override
        @Transient
        public final Builder events(Collection<RepositorySyncEvent> events) {
            this.events = RepositorySyncEventsCopier.copy(events);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder events(RepositorySyncEvent... events) {
            events(Arrays.asList(events));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder events(Consumer<RepositorySyncEvent.Builder>... events) {
            events(Stream.of(events).map(c -> RepositorySyncEvent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        @Transient
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(RepositorySyncStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public RepositorySyncAttempt build() {
            return new RepositorySyncAttempt(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
