/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Repository sync event detail data for a sync attempt.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RepositorySyncEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<RepositorySyncEvent.Builder, RepositorySyncEvent> {
    private static final SdkField<String> EVENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("event")
            .getter(getter(RepositorySyncEvent::event)).setter(setter(Builder::event))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("event").build()).build();

    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("externalId").getter(getter(RepositorySyncEvent::externalId)).setter(setter(Builder::externalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()).build();

    private static final SdkField<Instant> TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT).memberName("time")
            .getter(getter(RepositorySyncEvent::time)).setter(setter(Builder::time))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("time").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(RepositorySyncEvent::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_FIELD,
            EXTERNAL_ID_FIELD, TIME_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String event;

    private final String externalId;

    private final Instant time;

    private final String type;

    private RepositorySyncEvent(BuilderImpl builder) {
        this.event = builder.event;
        this.externalId = builder.externalId;
        this.time = builder.time;
        this.type = builder.type;
    }

    /**
     * <p>
     * Event detail for a repository sync attempt.
     * </p>
     * 
     * @return Event detail for a repository sync attempt.
     */
    public final String event() {
        return event;
    }

    /**
     * <p>
     * The external ID of the sync event.
     * </p>
     * 
     * @return The external ID of the sync event.
     */
    public final String externalId() {
        return externalId;
    }

    /**
     * <p>
     * The time that the sync event occurred.
     * </p>
     * 
     * @return The time that the sync event occurred.
     */
    public final Instant time() {
        return time;
    }

    /**
     * <p>
     * The type of event.
     * </p>
     * 
     * @return The type of event.
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(event());
        hashCode = 31 * hashCode + Objects.hashCode(externalId());
        hashCode = 31 * hashCode + Objects.hashCode(time());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositorySyncEvent)) {
            return false;
        }
        RepositorySyncEvent other = (RepositorySyncEvent) obj;
        return Objects.equals(event(), other.event()) && Objects.equals(externalId(), other.externalId())
                && Objects.equals(time(), other.time()) && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RepositorySyncEvent").add("Event", event()).add("ExternalId", externalId()).add("Time", time())
                .add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "event":
            return Optional.ofNullable(clazz.cast(event()));
        case "externalId":
            return Optional.ofNullable(clazz.cast(externalId()));
        case "time":
            return Optional.ofNullable(clazz.cast(time()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RepositorySyncEvent, T> g) {
        return obj -> g.apply((RepositorySyncEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RepositorySyncEvent> {
        /**
         * <p>
         * Event detail for a repository sync attempt.
         * </p>
         * 
         * @param event
         *        Event detail for a repository sync attempt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder event(String event);

        /**
         * <p>
         * The external ID of the sync event.
         * </p>
         * 
         * @param externalId
         *        The external ID of the sync event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalId(String externalId);

        /**
         * <p>
         * The time that the sync event occurred.
         * </p>
         * 
         * @param time
         *        The time that the sync event occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder time(Instant time);

        /**
         * <p>
         * The type of event.
         * </p>
         * 
         * @param type
         *        The type of event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private String event;

        private String externalId;

        private Instant time;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(RepositorySyncEvent model) {
            event(model.event);
            externalId(model.externalId);
            time(model.time);
            type(model.type);
        }

        public final String getEvent() {
            return event;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        @Override
        @Transient
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        public final String getExternalId() {
            return externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        @Transient
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final Instant getTime() {
            return time;
        }

        public final void setTime(Instant time) {
            this.time = time;
        }

        @Override
        @Transient
        public final Builder time(Instant time) {
            this.time = time;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public RepositorySyncEvent build() {
            return new RepositorySyncEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
