/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The service detail data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Service implements SdkPojo, Serializable, ToCopyableBuilder<Service.Builder, Service> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Service::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> BRANCH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("branchName").getter(getter(Service::branchName)).setter(setter(Builder::branchName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branchName").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(Service::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(Service::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedAt").getter(getter(Service::lastModifiedAt)).setter(setter(Builder::lastModifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedAt").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Service::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<ServicePipeline> PIPELINE_FIELD = SdkField.<ServicePipeline> builder(MarshallingType.SDK_POJO)
            .memberName("pipeline").getter(getter(Service::pipeline)).setter(setter(Builder::pipeline))
            .constructor(ServicePipeline::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipeline").build()).build();

    private static final SdkField<String> REPOSITORY_CONNECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryConnectionArn").getter(getter(Service::repositoryConnectionArn))
            .setter(setter(Builder::repositoryConnectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryConnectionArn").build())
            .build();

    private static final SdkField<String> REPOSITORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryId").getter(getter(Service::repositoryId)).setter(setter(Builder::repositoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryId").build()).build();

    private static final SdkField<String> SPEC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("spec")
            .getter(getter(Service::spec)).setter(setter(Builder::spec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Service::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(Service::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateName").getter(getter(Service::templateName)).setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, BRANCH_NAME_FIELD,
            CREATED_AT_FIELD, DESCRIPTION_FIELD, LAST_MODIFIED_AT_FIELD, NAME_FIELD, PIPELINE_FIELD,
            REPOSITORY_CONNECTION_ARN_FIELD, REPOSITORY_ID_FIELD, SPEC_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD,
            TEMPLATE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String branchName;

    private final Instant createdAt;

    private final String description;

    private final Instant lastModifiedAt;

    private final String name;

    private final ServicePipeline pipeline;

    private final String repositoryConnectionArn;

    private final String repositoryId;

    private final String spec;

    private final String status;

    private final String statusMessage;

    private final String templateName;

    private Service(BuilderImpl builder) {
        this.arn = builder.arn;
        this.branchName = builder.branchName;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.lastModifiedAt = builder.lastModifiedAt;
        this.name = builder.name;
        this.pipeline = builder.pipeline;
        this.repositoryConnectionArn = builder.repositoryConnectionArn;
        this.repositoryId = builder.repositoryId;
        this.spec = builder.spec;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.templateName = builder.templateName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the service.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the service.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the code repository branch that holds the code that's deployed in Proton.
     * </p>
     * 
     * @return The name of the code repository branch that holds the code that's deployed in Proton.
     */
    public final String branchName() {
        return branchName;
    }

    /**
     * <p>
     * The time when the service was created.
     * </p>
     * 
     * @return The time when the service was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * A description of a service.
     * </p>
     * 
     * @return A description of a service.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The time when the service was last modified.
     * </p>
     * 
     * @return The time when the service was last modified.
     */
    public final Instant lastModifiedAt() {
        return lastModifiedAt;
    }

    /**
     * <p>
     * The name of the service.
     * </p>
     * 
     * @return The name of the service.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The service pipeline detail data.
     * </p>
     * 
     * @return The service pipeline detail data.
     */
    public final ServicePipeline pipeline() {
        return pipeline;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the repository connection. For more information, see <a
     * href="https://docs.aws.amazon.com/proton/latest/adminguide/setting-up-for-service.html#setting-up-vcontrol">Set
     * up a repository connection</a> in the <i>Proton Administrator Guide</i> and <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/proton-setup.html#setup-repo-connection">Setting up
     * with Proton</a> in the <i>Proton User Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the repository connection. For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/adminguide/setting-up-for-service.html#setting-up-vcontrol"
     *         >Set up a repository connection</a> in the <i>Proton Administrator Guide</i> and <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/proton-setup.html#setup-repo-connection"
     *         >Setting up with Proton</a> in the <i>Proton User Guide</i>.
     */
    public final String repositoryConnectionArn() {
        return repositoryConnectionArn;
    }

    /**
     * <p>
     * The ID of the source code repository.
     * </p>
     * 
     * @return The ID of the source code repository.
     */
    public final String repositoryId() {
        return repositoryId;
    }

    /**
     * <p>
     * The formatted specification that defines the service.
     * </p>
     * 
     * @return The formatted specification that defines the service.
     */
    public final String spec() {
        return spec;
    }

    /**
     * <p>
     * The status of the service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ServiceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the service.
     * @see ServiceStatus
     */
    public final ServiceStatus status() {
        return ServiceStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ServiceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the service.
     * @see ServiceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A service status message.
     * </p>
     * 
     * @return A service status message.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The name of the service template.
     * </p>
     * 
     * @return The name of the service template.
     */
    public final String templateName() {
        return templateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(branchName());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(pipeline());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryConnectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryId());
        hashCode = 31 * hashCode + Objects.hashCode(spec());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Service)) {
            return false;
        }
        Service other = (Service) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(branchName(), other.branchName())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(description(), other.description())
                && Objects.equals(lastModifiedAt(), other.lastModifiedAt()) && Objects.equals(name(), other.name())
                && Objects.equals(pipeline(), other.pipeline())
                && Objects.equals(repositoryConnectionArn(), other.repositoryConnectionArn())
                && Objects.equals(repositoryId(), other.repositoryId()) && Objects.equals(spec(), other.spec())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(templateName(), other.templateName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Service").add("Arn", arn()).add("BranchName", branchName()).add("CreatedAt", createdAt())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("LastModifiedAt", lastModifiedAt()).add("Name", name()).add("Pipeline", pipeline())
                .add("RepositoryConnectionArn", repositoryConnectionArn()).add("RepositoryId", repositoryId())
                .add("Spec", spec() == null ? null : "*** Sensitive Data Redacted ***").add("Status", statusAsString())
                .add("StatusMessage", statusMessage() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TemplateName", templateName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "branchName":
            return Optional.ofNullable(clazz.cast(branchName()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "lastModifiedAt":
            return Optional.ofNullable(clazz.cast(lastModifiedAt()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "pipeline":
            return Optional.ofNullable(clazz.cast(pipeline()));
        case "repositoryConnectionArn":
            return Optional.ofNullable(clazz.cast(repositoryConnectionArn()));
        case "repositoryId":
            return Optional.ofNullable(clazz.cast(repositoryId()));
        case "spec":
            return Optional.ofNullable(clazz.cast(spec()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "templateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Service, T> g) {
        return obj -> g.apply((Service) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Service> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the service.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the code repository branch that holds the code that's deployed in Proton.
         * </p>
         * 
         * @param branchName
         *        The name of the code repository branch that holds the code that's deployed in Proton.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branchName(String branchName);

        /**
         * <p>
         * The time when the service was created.
         * </p>
         * 
         * @param createdAt
         *        The time when the service was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * A description of a service.
         * </p>
         * 
         * @param description
         *        A description of a service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The time when the service was last modified.
         * </p>
         * 
         * @param lastModifiedAt
         *        The time when the service was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedAt(Instant lastModifiedAt);

        /**
         * <p>
         * The name of the service.
         * </p>
         * 
         * @param name
         *        The name of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The service pipeline detail data.
         * </p>
         * 
         * @param pipeline
         *        The service pipeline detail data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipeline(ServicePipeline pipeline);

        /**
         * <p>
         * The service pipeline detail data.
         * </p>
         * This is a convenience that creates an instance of the {@link ServicePipeline.Builder} avoiding the need to
         * create one manually via {@link ServicePipeline#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServicePipeline.Builder#build()} is called immediately and its
         * result is passed to {@link #pipeline(ServicePipeline)}.
         * 
         * @param pipeline
         *        a consumer that will call methods on {@link ServicePipeline.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipeline(ServicePipeline)
         */
        default Builder pipeline(Consumer<ServicePipeline.Builder> pipeline) {
            return pipeline(ServicePipeline.builder().applyMutation(pipeline).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the repository connection. For more information, see <a
         * href="https://docs.aws.amazon.com/proton/latest/adminguide/setting-up-for-service.html#setting-up-vcontrol"
         * >Set up a repository connection</a> in the <i>Proton Administrator Guide</i> and <a
         * href="https://docs.aws.amazon.com/proton/latest/userguide/proton-setup.html#setup-repo-connection">Setting up
         * with Proton</a> in the <i>Proton User Guide</i>.
         * </p>
         * 
         * @param repositoryConnectionArn
         *        The Amazon Resource Name (ARN) of the repository connection. For more information, see <a href=
         *        "https://docs.aws.amazon.com/proton/latest/adminguide/setting-up-for-service.html#setting-up-vcontrol"
         *        >Set up a repository connection</a> in the <i>Proton Administrator Guide</i> and <a
         *        href="https://docs.aws.amazon.com/proton/latest/userguide/proton-setup.html#setup-repo-connection"
         *        >Setting up with Proton</a> in the <i>Proton User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryConnectionArn(String repositoryConnectionArn);

        /**
         * <p>
         * The ID of the source code repository.
         * </p>
         * 
         * @param repositoryId
         *        The ID of the source code repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryId(String repositoryId);

        /**
         * <p>
         * The formatted specification that defines the service.
         * </p>
         * 
         * @param spec
         *        The formatted specification that defines the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spec(String spec);

        /**
         * <p>
         * The status of the service.
         * </p>
         * 
         * @param status
         *        The status of the service.
         * @see ServiceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the service.
         * </p>
         * 
         * @param status
         *        The status of the service.
         * @see ServiceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceStatus
         */
        Builder status(ServiceStatus status);

        /**
         * <p>
         * A service status message.
         * </p>
         * 
         * @param statusMessage
         *        A service status message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The name of the service template.
         * </p>
         * 
         * @param templateName
         *        The name of the service template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String branchName;

        private Instant createdAt;

        private String description;

        private Instant lastModifiedAt;

        private String name;

        private ServicePipeline pipeline;

        private String repositoryConnectionArn;

        private String repositoryId;

        private String spec;

        private String status;

        private String statusMessage;

        private String templateName;

        private BuilderImpl() {
        }

        private BuilderImpl(Service model) {
            arn(model.arn);
            branchName(model.branchName);
            createdAt(model.createdAt);
            description(model.description);
            lastModifiedAt(model.lastModifiedAt);
            name(model.name);
            pipeline(model.pipeline);
            repositoryConnectionArn(model.repositoryConnectionArn);
            repositoryId(model.repositoryId);
            spec(model.spec);
            status(model.status);
            statusMessage(model.statusMessage);
            templateName(model.templateName);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getBranchName() {
            return branchName;
        }

        public final void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        @Override
        @Transient
        public final Builder branchName(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getLastModifiedAt() {
            return lastModifiedAt;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        @Transient
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ServicePipeline.Builder getPipeline() {
            return pipeline != null ? pipeline.toBuilder() : null;
        }

        public final void setPipeline(ServicePipeline.BuilderImpl pipeline) {
            this.pipeline = pipeline != null ? pipeline.build() : null;
        }

        @Override
        @Transient
        public final Builder pipeline(ServicePipeline pipeline) {
            this.pipeline = pipeline;
            return this;
        }

        public final String getRepositoryConnectionArn() {
            return repositoryConnectionArn;
        }

        public final void setRepositoryConnectionArn(String repositoryConnectionArn) {
            this.repositoryConnectionArn = repositoryConnectionArn;
        }

        @Override
        @Transient
        public final Builder repositoryConnectionArn(String repositoryConnectionArn) {
            this.repositoryConnectionArn = repositoryConnectionArn;
            return this;
        }

        public final String getRepositoryId() {
            return repositoryId;
        }

        public final void setRepositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
        }

        @Override
        @Transient
        public final Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            return this;
        }

        public final String getSpec() {
            return spec;
        }

        public final void setSpec(String spec) {
            this.spec = spec;
        }

        @Override
        @Transient
        public final Builder spec(String spec) {
            this.spec = spec;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(ServiceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        @Transient
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        @Transient
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        @Override
        public Service build() {
            return new Service(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
