/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The service pipeline detail data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServicePipeline implements SdkPojo, Serializable, ToCopyableBuilder<ServicePipeline.Builder, ServicePipeline> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ServicePipeline::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(ServicePipeline::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> DEPLOYMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentStatus").getter(getter(ServicePipeline::deploymentStatusAsString))
            .setter(setter(Builder::deploymentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStatus").build()).build();

    private static final SdkField<String> DEPLOYMENT_STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentStatusMessage").getter(getter(ServicePipeline::deploymentStatusMessage))
            .setter(setter(Builder::deploymentStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStatusMessage").build())
            .build();

    private static final SdkField<Instant> LAST_DEPLOYMENT_ATTEMPTED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("lastDeploymentAttemptedAt")
            .getter(getter(ServicePipeline::lastDeploymentAttemptedAt)).setter(setter(Builder::lastDeploymentAttemptedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDeploymentAttemptedAt").build())
            .build();

    private static final SdkField<Instant> LAST_DEPLOYMENT_SUCCEEDED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("lastDeploymentSucceededAt")
            .getter(getter(ServicePipeline::lastDeploymentSucceededAt)).setter(setter(Builder::lastDeploymentSucceededAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDeploymentSucceededAt").build())
            .build();

    private static final SdkField<String> SPEC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("spec")
            .getter(getter(ServicePipeline::spec)).setter(setter(Builder::spec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()).build();

    private static final SdkField<String> TEMPLATE_MAJOR_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateMajorVersion").getter(getter(ServicePipeline::templateMajorVersion))
            .setter(setter(Builder::templateMajorVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateMajorVersion").build())
            .build();

    private static final SdkField<String> TEMPLATE_MINOR_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateMinorVersion").getter(getter(ServicePipeline::templateMinorVersion))
            .setter(setter(Builder::templateMinorVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateMinorVersion").build())
            .build();

    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateName").getter(getter(ServicePipeline::templateName)).setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD,
            DEPLOYMENT_STATUS_FIELD, DEPLOYMENT_STATUS_MESSAGE_FIELD, LAST_DEPLOYMENT_ATTEMPTED_AT_FIELD,
            LAST_DEPLOYMENT_SUCCEEDED_AT_FIELD, SPEC_FIELD, TEMPLATE_MAJOR_VERSION_FIELD, TEMPLATE_MINOR_VERSION_FIELD,
            TEMPLATE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Instant createdAt;

    private final String deploymentStatus;

    private final String deploymentStatusMessage;

    private final Instant lastDeploymentAttemptedAt;

    private final Instant lastDeploymentSucceededAt;

    private final String spec;

    private final String templateMajorVersion;

    private final String templateMinorVersion;

    private final String templateName;

    private ServicePipeline(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.deploymentStatus = builder.deploymentStatus;
        this.deploymentStatusMessage = builder.deploymentStatusMessage;
        this.lastDeploymentAttemptedAt = builder.lastDeploymentAttemptedAt;
        this.lastDeploymentSucceededAt = builder.lastDeploymentSucceededAt;
        this.spec = builder.spec;
        this.templateMajorVersion = builder.templateMajorVersion;
        this.templateMinorVersion = builder.templateMinorVersion;
        this.templateName = builder.templateName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the service pipeline.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the service pipeline.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The time when the service pipeline was created.
     * </p>
     * 
     * @return The time when the service pipeline was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The deployment status of the service pipeline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentStatus}
     * will return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentStatusAsString}.
     * </p>
     * 
     * @return The deployment status of the service pipeline.
     * @see DeploymentStatus
     */
    public final DeploymentStatus deploymentStatus() {
        return DeploymentStatus.fromValue(deploymentStatus);
    }

    /**
     * <p>
     * The deployment status of the service pipeline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentStatus}
     * will return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentStatusAsString}.
     * </p>
     * 
     * @return The deployment status of the service pipeline.
     * @see DeploymentStatus
     */
    public final String deploymentStatusAsString() {
        return deploymentStatus;
    }

    /**
     * <p>
     * A service pipeline deployment status message.
     * </p>
     * 
     * @return A service pipeline deployment status message.
     */
    public final String deploymentStatusMessage() {
        return deploymentStatusMessage;
    }

    /**
     * <p>
     * The time when a deployment of the service pipeline was last attempted.
     * </p>
     * 
     * @return The time when a deployment of the service pipeline was last attempted.
     */
    public final Instant lastDeploymentAttemptedAt() {
        return lastDeploymentAttemptedAt;
    }

    /**
     * <p>
     * The time when the service pipeline was last deployed successfully.
     * </p>
     * 
     * @return The time when the service pipeline was last deployed successfully.
     */
    public final Instant lastDeploymentSucceededAt() {
        return lastDeploymentSucceededAt;
    }

    /**
     * <p>
     * The service spec that was used to create the service pipeline.
     * </p>
     * 
     * @return The service spec that was used to create the service pipeline.
     */
    public final String spec() {
        return spec;
    }

    /**
     * <p>
     * The major version of the service template that was used to create the service pipeline.
     * </p>
     * 
     * @return The major version of the service template that was used to create the service pipeline.
     */
    public final String templateMajorVersion() {
        return templateMajorVersion;
    }

    /**
     * <p>
     * The minor version of the service template that was used to create the service pipeline.
     * </p>
     * 
     * @return The minor version of the service template that was used to create the service pipeline.
     */
    public final String templateMinorVersion() {
        return templateMinorVersion;
    }

    /**
     * <p>
     * The name of the service template that was used to create the service pipeline.
     * </p>
     * 
     * @return The name of the service template that was used to create the service pipeline.
     */
    public final String templateName() {
        return templateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(lastDeploymentAttemptedAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastDeploymentSucceededAt());
        hashCode = 31 * hashCode + Objects.hashCode(spec());
        hashCode = 31 * hashCode + Objects.hashCode(templateMajorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(templateMinorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServicePipeline)) {
            return false;
        }
        ServicePipeline other = (ServicePipeline) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(deploymentStatusAsString(), other.deploymentStatusAsString())
                && Objects.equals(deploymentStatusMessage(), other.deploymentStatusMessage())
                && Objects.equals(lastDeploymentAttemptedAt(), other.lastDeploymentAttemptedAt())
                && Objects.equals(lastDeploymentSucceededAt(), other.lastDeploymentSucceededAt())
                && Objects.equals(spec(), other.spec()) && Objects.equals(templateMajorVersion(), other.templateMajorVersion())
                && Objects.equals(templateMinorVersion(), other.templateMinorVersion())
                && Objects.equals(templateName(), other.templateName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServicePipeline").add("Arn", arn()).add("CreatedAt", createdAt())
                .add("DeploymentStatus", deploymentStatusAsString())
                .add("DeploymentStatusMessage", deploymentStatusMessage() == null ? null : "*** Sensitive Data Redacted ***")
                .add("LastDeploymentAttemptedAt", lastDeploymentAttemptedAt())
                .add("LastDeploymentSucceededAt", lastDeploymentSucceededAt())
                .add("Spec", spec() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TemplateMajorVersion", templateMajorVersion()).add("TemplateMinorVersion", templateMinorVersion())
                .add("TemplateName", templateName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "deploymentStatus":
            return Optional.ofNullable(clazz.cast(deploymentStatusAsString()));
        case "deploymentStatusMessage":
            return Optional.ofNullable(clazz.cast(deploymentStatusMessage()));
        case "lastDeploymentAttemptedAt":
            return Optional.ofNullable(clazz.cast(lastDeploymentAttemptedAt()));
        case "lastDeploymentSucceededAt":
            return Optional.ofNullable(clazz.cast(lastDeploymentSucceededAt()));
        case "spec":
            return Optional.ofNullable(clazz.cast(spec()));
        case "templateMajorVersion":
            return Optional.ofNullable(clazz.cast(templateMajorVersion()));
        case "templateMinorVersion":
            return Optional.ofNullable(clazz.cast(templateMinorVersion()));
        case "templateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServicePipeline, T> g) {
        return obj -> g.apply((ServicePipeline) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServicePipeline> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the service pipeline.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the service pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The time when the service pipeline was created.
         * </p>
         * 
         * @param createdAt
         *        The time when the service pipeline was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The deployment status of the service pipeline.
         * </p>
         * 
         * @param deploymentStatus
         *        The deployment status of the service pipeline.
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder deploymentStatus(String deploymentStatus);

        /**
         * <p>
         * The deployment status of the service pipeline.
         * </p>
         * 
         * @param deploymentStatus
         *        The deployment status of the service pipeline.
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder deploymentStatus(DeploymentStatus deploymentStatus);

        /**
         * <p>
         * A service pipeline deployment status message.
         * </p>
         * 
         * @param deploymentStatusMessage
         *        A service pipeline deployment status message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentStatusMessage(String deploymentStatusMessage);

        /**
         * <p>
         * The time when a deployment of the service pipeline was last attempted.
         * </p>
         * 
         * @param lastDeploymentAttemptedAt
         *        The time when a deployment of the service pipeline was last attempted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDeploymentAttemptedAt(Instant lastDeploymentAttemptedAt);

        /**
         * <p>
         * The time when the service pipeline was last deployed successfully.
         * </p>
         * 
         * @param lastDeploymentSucceededAt
         *        The time when the service pipeline was last deployed successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDeploymentSucceededAt(Instant lastDeploymentSucceededAt);

        /**
         * <p>
         * The service spec that was used to create the service pipeline.
         * </p>
         * 
         * @param spec
         *        The service spec that was used to create the service pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spec(String spec);

        /**
         * <p>
         * The major version of the service template that was used to create the service pipeline.
         * </p>
         * 
         * @param templateMajorVersion
         *        The major version of the service template that was used to create the service pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateMajorVersion(String templateMajorVersion);

        /**
         * <p>
         * The minor version of the service template that was used to create the service pipeline.
         * </p>
         * 
         * @param templateMinorVersion
         *        The minor version of the service template that was used to create the service pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateMinorVersion(String templateMinorVersion);

        /**
         * <p>
         * The name of the service template that was used to create the service pipeline.
         * </p>
         * 
         * @param templateName
         *        The name of the service template that was used to create the service pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Instant createdAt;

        private String deploymentStatus;

        private String deploymentStatusMessage;

        private Instant lastDeploymentAttemptedAt;

        private Instant lastDeploymentSucceededAt;

        private String spec;

        private String templateMajorVersion;

        private String templateMinorVersion;

        private String templateName;

        private BuilderImpl() {
        }

        private BuilderImpl(ServicePipeline model) {
            arn(model.arn);
            createdAt(model.createdAt);
            deploymentStatus(model.deploymentStatus);
            deploymentStatusMessage(model.deploymentStatusMessage);
            lastDeploymentAttemptedAt(model.lastDeploymentAttemptedAt);
            lastDeploymentSucceededAt(model.lastDeploymentSucceededAt);
            spec(model.spec);
            templateMajorVersion(model.templateMajorVersion);
            templateMinorVersion(model.templateMinorVersion);
            templateName(model.templateName);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDeploymentStatus() {
            return deploymentStatus;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        @Override
        @Transient
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder deploymentStatus(DeploymentStatus deploymentStatus) {
            this.deploymentStatus(deploymentStatus == null ? null : deploymentStatus.toString());
            return this;
        }

        public final String getDeploymentStatusMessage() {
            return deploymentStatusMessage;
        }

        public final void setDeploymentStatusMessage(String deploymentStatusMessage) {
            this.deploymentStatusMessage = deploymentStatusMessage;
        }

        @Override
        @Transient
        public final Builder deploymentStatusMessage(String deploymentStatusMessage) {
            this.deploymentStatusMessage = deploymentStatusMessage;
            return this;
        }

        public final Instant getLastDeploymentAttemptedAt() {
            return lastDeploymentAttemptedAt;
        }

        public final void setLastDeploymentAttemptedAt(Instant lastDeploymentAttemptedAt) {
            this.lastDeploymentAttemptedAt = lastDeploymentAttemptedAt;
        }

        @Override
        @Transient
        public final Builder lastDeploymentAttemptedAt(Instant lastDeploymentAttemptedAt) {
            this.lastDeploymentAttemptedAt = lastDeploymentAttemptedAt;
            return this;
        }

        public final Instant getLastDeploymentSucceededAt() {
            return lastDeploymentSucceededAt;
        }

        public final void setLastDeploymentSucceededAt(Instant lastDeploymentSucceededAt) {
            this.lastDeploymentSucceededAt = lastDeploymentSucceededAt;
        }

        @Override
        @Transient
        public final Builder lastDeploymentSucceededAt(Instant lastDeploymentSucceededAt) {
            this.lastDeploymentSucceededAt = lastDeploymentSucceededAt;
            return this;
        }

        public final String getSpec() {
            return spec;
        }

        public final void setSpec(String spec) {
            this.spec = spec;
        }

        @Override
        @Transient
        public final Builder spec(String spec) {
            this.spec = spec;
            return this;
        }

        public final String getTemplateMajorVersion() {
            return templateMajorVersion;
        }

        public final void setTemplateMajorVersion(String templateMajorVersion) {
            this.templateMajorVersion = templateMajorVersion;
        }

        @Override
        @Transient
        public final Builder templateMajorVersion(String templateMajorVersion) {
            this.templateMajorVersion = templateMajorVersion;
            return this;
        }

        public final String getTemplateMinorVersion() {
            return templateMinorVersion;
        }

        public final void setTemplateMinorVersion(String templateMinorVersion) {
            this.templateMinorVersion = templateMinorVersion;
        }

        @Override
        @Transient
        public final Builder templateMinorVersion(String templateMinorVersion) {
            this.templateMinorVersion = templateMinorVersion;
            return this;
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        @Transient
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        @Override
        public ServicePipeline build() {
            return new ServicePipeline(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
