/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The service template detail data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceTemplate implements SdkPojo, Serializable, ToCopyableBuilder<ServiceTemplate.Builder, ServiceTemplate> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ServiceTemplate::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(ServiceTemplate::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ServiceTemplate::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(ServiceTemplate::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> ENCRYPTION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("encryptionKey").getter(getter(ServiceTemplate::encryptionKey)).setter(setter(Builder::encryptionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKey").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedAt").getter(getter(ServiceTemplate::lastModifiedAt)).setter(setter(Builder::lastModifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedAt").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ServiceTemplate::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PIPELINE_PROVISIONING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pipelineProvisioning").getter(getter(ServiceTemplate::pipelineProvisioningAsString))
            .setter(setter(Builder::pipelineProvisioning))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineProvisioning").build())
            .build();

    private static final SdkField<String> RECOMMENDED_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recommendedVersion").getter(getter(ServiceTemplate::recommendedVersion))
            .setter(setter(Builder::recommendedVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD,
            DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, ENCRYPTION_KEY_FIELD, LAST_MODIFIED_AT_FIELD, NAME_FIELD,
            PIPELINE_PROVISIONING_FIELD, RECOMMENDED_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Instant createdAt;

    private final String description;

    private final String displayName;

    private final String encryptionKey;

    private final Instant lastModifiedAt;

    private final String name;

    private final String pipelineProvisioning;

    private final String recommendedVersion;

    private ServiceTemplate(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.encryptionKey = builder.encryptionKey;
        this.lastModifiedAt = builder.lastModifiedAt;
        this.name = builder.name;
        this.pipelineProvisioning = builder.pipelineProvisioning;
        this.recommendedVersion = builder.recommendedVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the service template.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the service template.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The time when the service template was created.
     * </p>
     * 
     * @return The time when the service template was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * A description of the service template.
     * </p>
     * 
     * @return A description of the service template.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The service template name as displayed in the developer interface.
     * </p>
     * 
     * @return The service template name as displayed in the developer interface.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The customer provided service template encryption key that's used to encrypt data.
     * </p>
     * 
     * @return The customer provided service template encryption key that's used to encrypt data.
     */
    public final String encryptionKey() {
        return encryptionKey;
    }

    /**
     * <p>
     * The time when the service template was last modified.
     * </p>
     * 
     * @return The time when the service template was last modified.
     */
    public final Instant lastModifiedAt() {
        return lastModifiedAt;
    }

    /**
     * <p>
     * The name of the service template.
     * </p>
     * 
     * @return The name of the service template.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * If <code>pipelineProvisioning</code> is <code>true</code>, a service pipeline is included in the service
     * template. Otherwise, a service pipeline <i>isn't</i> included in the service template.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #pipelineProvisioning} will return {@link Provisioning#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #pipelineProvisioningAsString}.
     * </p>
     * 
     * @return If <code>pipelineProvisioning</code> is <code>true</code>, a service pipeline is included in the service
     *         template. Otherwise, a service pipeline <i>isn't</i> included in the service template.
     * @see Provisioning
     */
    public final Provisioning pipelineProvisioning() {
        return Provisioning.fromValue(pipelineProvisioning);
    }

    /**
     * <p>
     * If <code>pipelineProvisioning</code> is <code>true</code>, a service pipeline is included in the service
     * template. Otherwise, a service pipeline <i>isn't</i> included in the service template.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #pipelineProvisioning} will return {@link Provisioning#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #pipelineProvisioningAsString}.
     * </p>
     * 
     * @return If <code>pipelineProvisioning</code> is <code>true</code>, a service pipeline is included in the service
     *         template. Otherwise, a service pipeline <i>isn't</i> included in the service template.
     * @see Provisioning
     */
    public final String pipelineProvisioningAsString() {
        return pipelineProvisioning;
    }

    /**
     * <p>
     * The recommended version of the service template.
     * </p>
     * 
     * @return The recommended version of the service template.
     */
    public final String recommendedVersion() {
        return recommendedVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineProvisioningAsString());
        hashCode = 31 * hashCode + Objects.hashCode(recommendedVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceTemplate)) {
            return false;
        }
        ServiceTemplate other = (ServiceTemplate) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(description(), other.description()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(encryptionKey(), other.encryptionKey())
                && Objects.equals(lastModifiedAt(), other.lastModifiedAt()) && Objects.equals(name(), other.name())
                && Objects.equals(pipelineProvisioningAsString(), other.pipelineProvisioningAsString())
                && Objects.equals(recommendedVersion(), other.recommendedVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceTemplate").add("Arn", arn()).add("CreatedAt", createdAt())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DisplayName", displayName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EncryptionKey", encryptionKey()).add("LastModifiedAt", lastModifiedAt()).add("Name", name())
                .add("PipelineProvisioning", pipelineProvisioningAsString()).add("RecommendedVersion", recommendedVersion())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "encryptionKey":
            return Optional.ofNullable(clazz.cast(encryptionKey()));
        case "lastModifiedAt":
            return Optional.ofNullable(clazz.cast(lastModifiedAt()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "pipelineProvisioning":
            return Optional.ofNullable(clazz.cast(pipelineProvisioningAsString()));
        case "recommendedVersion":
            return Optional.ofNullable(clazz.cast(recommendedVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceTemplate, T> g) {
        return obj -> g.apply((ServiceTemplate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceTemplate> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the service template.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the service template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The time when the service template was created.
         * </p>
         * 
         * @param createdAt
         *        The time when the service template was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * A description of the service template.
         * </p>
         * 
         * @param description
         *        A description of the service template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The service template name as displayed in the developer interface.
         * </p>
         * 
         * @param displayName
         *        The service template name as displayed in the developer interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The customer provided service template encryption key that's used to encrypt data.
         * </p>
         * 
         * @param encryptionKey
         *        The customer provided service template encryption key that's used to encrypt data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKey(String encryptionKey);

        /**
         * <p>
         * The time when the service template was last modified.
         * </p>
         * 
         * @param lastModifiedAt
         *        The time when the service template was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedAt(Instant lastModifiedAt);

        /**
         * <p>
         * The name of the service template.
         * </p>
         * 
         * @param name
         *        The name of the service template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * If <code>pipelineProvisioning</code> is <code>true</code>, a service pipeline is included in the service
         * template. Otherwise, a service pipeline <i>isn't</i> included in the service template.
         * </p>
         * 
         * @param pipelineProvisioning
         *        If <code>pipelineProvisioning</code> is <code>true</code>, a service pipeline is included in the
         *        service template. Otherwise, a service pipeline <i>isn't</i> included in the service template.
         * @see Provisioning
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Provisioning
         */
        Builder pipelineProvisioning(String pipelineProvisioning);

        /**
         * <p>
         * If <code>pipelineProvisioning</code> is <code>true</code>, a service pipeline is included in the service
         * template. Otherwise, a service pipeline <i>isn't</i> included in the service template.
         * </p>
         * 
         * @param pipelineProvisioning
         *        If <code>pipelineProvisioning</code> is <code>true</code>, a service pipeline is included in the
         *        service template. Otherwise, a service pipeline <i>isn't</i> included in the service template.
         * @see Provisioning
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Provisioning
         */
        Builder pipelineProvisioning(Provisioning pipelineProvisioning);

        /**
         * <p>
         * The recommended version of the service template.
         * </p>
         * 
         * @param recommendedVersion
         *        The recommended version of the service template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendedVersion(String recommendedVersion);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Instant createdAt;

        private String description;

        private String displayName;

        private String encryptionKey;

        private Instant lastModifiedAt;

        private String name;

        private String pipelineProvisioning;

        private String recommendedVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceTemplate model) {
            arn(model.arn);
            createdAt(model.createdAt);
            description(model.description);
            displayName(model.displayName);
            encryptionKey(model.encryptionKey);
            lastModifiedAt(model.lastModifiedAt);
            name(model.name);
            pipelineProvisioning(model.pipelineProvisioning);
            recommendedVersion(model.recommendedVersion);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        @Transient
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getEncryptionKey() {
            return encryptionKey;
        }

        public final void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        @Override
        @Transient
        public final Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final Instant getLastModifiedAt() {
            return lastModifiedAt;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        @Transient
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPipelineProvisioning() {
            return pipelineProvisioning;
        }

        public final void setPipelineProvisioning(String pipelineProvisioning) {
            this.pipelineProvisioning = pipelineProvisioning;
        }

        @Override
        @Transient
        public final Builder pipelineProvisioning(String pipelineProvisioning) {
            this.pipelineProvisioning = pipelineProvisioning;
            return this;
        }

        @Override
        @Transient
        public final Builder pipelineProvisioning(Provisioning pipelineProvisioning) {
            this.pipelineProvisioning(pipelineProvisioning == null ? null : pipelineProvisioning.toString());
            return this;
        }

        public final String getRecommendedVersion() {
            return recommendedVersion;
        }

        public final void setRecommendedVersion(String recommendedVersion) {
            this.recommendedVersion = recommendedVersion;
        }

        @Override
        @Transient
        public final Builder recommendedVersion(String recommendedVersion) {
            this.recommendedVersion = recommendedVersion;
            return this;
        }

        @Override
        public ServiceTemplate build() {
            return new ServiceTemplate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
