/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAccountSettingsResponse extends ProtonResponse implements
        ToCopyableBuilder<UpdateAccountSettingsResponse.Builder, UpdateAccountSettingsResponse> {
    private static final SdkField<AccountSettings> ACCOUNT_SETTINGS_FIELD = SdkField
            .<AccountSettings> builder(MarshallingType.SDK_POJO).memberName("accountSettings")
            .getter(getter(UpdateAccountSettingsResponse::accountSettings)).setter(setter(Builder::accountSettings))
            .constructor(AccountSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_SETTINGS_FIELD));

    private final AccountSettings accountSettings;

    private UpdateAccountSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.accountSettings = builder.accountSettings;
    }

    /**
     * <p>
     * The Proton pipeline service role repository detail data that's returned by Proton.
     * </p>
     * 
     * @return The Proton pipeline service role repository detail data that's returned by Proton.
     */
    public final AccountSettings accountSettings() {
        return accountSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccountSettingsResponse)) {
            return false;
        }
        UpdateAccountSettingsResponse other = (UpdateAccountSettingsResponse) obj;
        return Objects.equals(accountSettings(), other.accountSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAccountSettingsResponse").add("AccountSettings", accountSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountSettings":
            return Optional.ofNullable(clazz.cast(accountSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccountSettingsResponse, T> g) {
        return obj -> g.apply((UpdateAccountSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAccountSettingsResponse> {
        /**
         * <p>
         * The Proton pipeline service role repository detail data that's returned by Proton.
         * </p>
         * 
         * @param accountSettings
         *        The Proton pipeline service role repository detail data that's returned by Proton.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountSettings(AccountSettings accountSettings);

        /**
         * <p>
         * The Proton pipeline service role repository detail data that's returned by Proton.
         * </p>
         * This is a convenience that creates an instance of the {@link AccountSettings.Builder} avoiding the need to
         * create one manually via {@link AccountSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccountSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #accountSettings(AccountSettings)}.
         * 
         * @param accountSettings
         *        a consumer that will call methods on {@link AccountSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountSettings(AccountSettings)
         */
        default Builder accountSettings(Consumer<AccountSettings.Builder> accountSettings) {
            return accountSettings(AccountSettings.builder().applyMutation(accountSettings).build());
        }
    }

    static final class BuilderImpl extends ProtonResponse.BuilderImpl implements Builder {
        private AccountSettings accountSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccountSettingsResponse model) {
            super(model);
            accountSettings(model.accountSettings);
        }

        public final AccountSettings.Builder getAccountSettings() {
            return accountSettings != null ? accountSettings.toBuilder() : null;
        }

        public final void setAccountSettings(AccountSettings.BuilderImpl accountSettings) {
            this.accountSettings = accountSettings != null ? accountSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder accountSettings(AccountSettings accountSettings) {
            this.accountSettings = accountSettings;
            return this;
        }

        @Override
        public UpdateAccountSettingsResponse build() {
            return new UpdateAccountSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
